/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.reporting;

import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotation;

public class AnnotationObject {
    private boolean highlighted = false;
    private Point2D peak_point = null;
    private Vector<PeakAnnotation> peak_annotations = new Vector();
    private Vector<Glycan> structures = new Vector();

    public AnnotationObject() {
    }

    public AnnotationObject(double x, double y) {
        this.peak_point = new Point2D.Double(x, y);
    }

    public AnnotationObject(PeakAnnotation pa) {
        this.peak_point = new Point2D.Double(pa.getPeak().getMZ(), pa.getPeak().getIntensity());
        this.peak_annotations.add(pa);
        this.structures.add(pa.getFragment());
    }

    public AnnotationObject(double x, double y, PeakAnnotation pa) {
        this.peak_point = new Point2D.Double(x, y);
        this.peak_annotations.add(pa);
        this.structures.add(pa.getFragment());
    }

    public AnnotationObject(Point2D pp, PeakAnnotation pa) {
        this.peak_point = pp;
        this.peak_annotations.add(pa);
        this.structures.add(pa.getFragment());
    }

    public Point2D getPeakPoint() {
        return this.peak_point;
    }

    public Peak getPeak() {
        if (this.peak_annotations.size() == 0) {
            return null;
        }
        return this.peak_annotations.firstElement().getPeak();
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean f) {
        this.highlighted = f;
    }

    public void clear() {
        this.structures.clear();
        this.peak_annotations.clear();
    }

    public int size() {
        return this.peak_annotations.size();
    }

    public void add(PeakAnnotation pa) {
        if (this.peak_point == null) {
            this.peak_point = new Point2D.Double(pa.getPeak().getMZ(), pa.getPeak().getIntensity());
        }
        this.peak_annotations.add(pa);
        this.structures.add(pa.getFragment());
    }

    public void remove(PeakAnnotation pa) {
        if (pa != null) {
            this.peak_annotations.remove(pa);
            Iterator<Glycan> i = this.structures.iterator();
            while (i.hasNext()) {
                if (!i.next().equalsStructure(pa.getFragment())) continue;
                i.remove();
            }
        }
    }

    public boolean canGroup(AnnotationObject other) {
        return this.peak_point.equals(other.peak_point);
    }

    public boolean group(AnnotationObject other) {
        if (this.canGroup(other)) {
            this.peak_annotations.addAll(other.peak_annotations);
            this.structures.addAll(other.structures);
            return true;
        }
        return false;
    }

    public Vector<AnnotationObject> ungroup() {
        Vector<AnnotationObject> ret = new Vector<AnnotationObject>();
        for (PeakAnnotation pa : this.peak_annotations) {
            ret.add(new AnnotationObject(this.peak_point, pa));
        }
        return ret;
    }

    public Vector<PeakAnnotation> getPeakAnnotations() {
        return this.peak_annotations;
    }

    public Vector<Glycan> getStructures() {
        return this.structures;
    }

    public boolean hasAnnotations() {
        for (PeakAnnotation pa : this.peak_annotations) {
            if (!pa.isAnnotated()) continue;
            return true;
        }
        return false;
    }
}

