/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.grammar;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class GrammarTree
implements Comparable {
    static Pattern pattern = Pattern.compile("[1-9N\\?][abo\\?][1-3\\?]-[DL\\?]-[a-zA-Z]+");
    public static final String END = "+";
    String label = "";
    GrammarTree parent = null;
    Vector<GrammarTree> children = new Vector();

    public GrammarTree() {
    }

    public GrammarTree(String _label) {
        this.label = _label;
    }

    public String getLabel() {
        return this.label;
    }

    public GrammarTree getParent() {
        return this.parent;
    }

    public Collection<GrammarTree> getChildren() {
        return this.children;
    }

    public int getNoChildren() {
        return this.children.size();
    }

    public GrammarTree getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return this;
    }

    public void addChild(GrammarTree toadd) {
        if (toadd == null) {
            return;
        }
        this.children.add(toadd);
        toadd.parent = this;
    }

    public GrammarTree clone() {
        return this.clone(null, null);
    }

    public GrammarTree clone(GrammarTree stop_at, GrammarTree stop_el) {
        if (this == stop_at) {
            return stop_el;
        }
        GrammarTree ret = new GrammarTree(this.label);
        for (GrammarTree child : this.children) {
            ret.addChild(child.clone(stop_at, stop_el));
        }
        return ret;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof GrammarTree)) {
            return 1;
        }
        return this.toString(true).compareTo(((GrammarTree)o).toString(true));
    }

    public boolean hasChildrenTagged() {
        for (GrammarTree child : this.children) {
            if (!child.isTagged()) continue;
            return true;
        }
        return false;
    }

    public static void tag(GrammarTree gt, String tag, Collection<GrammarTree> to_be_tagged) {
        if (gt == null || to_be_tagged == null) {
            return;
        }
        if (to_be_tagged.contains(gt)) {
            gt.label = GrammarTree.addTag(gt.label, tag);
        }
        for (GrammarTree child : gt.children) {
            GrammarTree.tag(child, tag, to_be_tagged);
        }
    }

    public static String removeTag(String str) {
        if (str == null) {
            return null;
        }
        int ind = str.indexOf(35);
        if (ind != -1) {
            return str.substring(0, ind);
        }
        return str;
    }

    public static String addTag(String str, String tag) {
        if (str.equals(END)) {
            return str;
        }
        return GrammarTree.removeTag(str) + "#" + tag;
    }

    public boolean isTagged() {
        if (this.label == null) {
            return false;
        }
        return this.label.indexOf(35) != -1;
    }

    public static GrammarTree fromGlycan(Glycan structure, boolean add_info) throws Exception {
        if (structure.isFuzzy()) {
            throw new Exception("Cannot convert a fuzzy structure into grammar tree");
        }
        if (structure.isFragment()) {
            throw new Exception("Cannot convert a fragmented structure into grammar tree");
        }
        if (structure.hasRepetition()) {
            throw new Exception("Cannot convert a repeating structure into grammar tree");
        }
        return GrammarTree.toGrammarTree(structure.getRoot(), add_info);
    }

    public Glycan toGlycan(MassOptions default_mass_options) throws Exception {
        return new Glycan(GrammarTree.fromGrammarTree(this), true, default_mass_options);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean ordered) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.label);
        if (ordered) {
            LinkedList<String> sortedList = new LinkedList<String>();
            for (GrammarTree grammarTree : this.children) {
                String str_child = grammarTree.toString(ordered);
                int index = Collections.binarySearch(sortedList, str_child);
                if (index < 0) {
                    sortedList.add(-index - 1, str_child);
                    continue;
                }
                sortedList.add(index, str_child);
            }
            for (String string : sortedList) {
                sb.append(string);
            }
        } else {
            for (GrammarTree child : this.children) {
                sb.append(child.toString(ordered));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private static GrammarTree toGrammarTree(Residue current, boolean add_info) {
        if (current == null) {
            return null;
        }
        GrammarTree ret = new GrammarTree();
        ret.label = "";
        if (current.isReducingEnd() && !current.isSaccharide()) {
            ret.label = END;
        } else {
            if (add_info) {
                ret.label = ret.label + current.getParentLinkage().getParentPositionsSingle();
                ret.label = ret.label + current.getAnomericState();
                ret.label = ret.label + current.getAnomericCarbon();
                ret.label = ret.label + "-";
                ret.label = ret.label + current.getChirality();
                ret.label = ret.label + "-";
            }
            ret.label = ret.label + current.getTypeName();
        }
        for (Linkage l : current.getChildrenLinkages()) {
            ret.addChild(GrammarTree.toGrammarTree(l.getChildResidue(), add_info));
        }
        return ret;
    }

    private static int countOpenPar(String str) {
        int count = 0;
        char[] buf = str.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != '(') continue;
            ++count;
        }
        return count;
    }

    private static int countClosePar(String str) {
        int count = 0;
        char[] buf = str.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != ')') continue;
            ++count;
        }
        return count;
    }

    public static GrammarTree fromString(String str) throws Exception {
        if ((str = TextUtils.trim((String)str)) == null || str.length() == 0) {
            return null;
        }
        GrammarTree ret = new GrammarTree();
        if (str.charAt(0) != '(') {
            throw new Exception("Missing start parenthesis: " + str);
        }
        if (str.charAt(str.length() - 1) != ')') {
            throw new Exception("Missing end parenthesis: " + str);
        }
        int ind = (str = str.substring(1, str.length() - 1)).indexOf(40);
        if (ind == -1) {
            ind = str.length();
        }
        ret.label = str.substring(0, ind);
        str = str.substring(ind);
        while (str.length() > 0) {
            if (str.charAt(0) != '(') {
                throw new Exception("Missing start parenthesis: " + str);
            }
            int ind2 = TextUtils.findEnclosed((String)str);
            if (ind2 == -1) {
                throw new Exception("Missing end parenthesis: " + str);
            }
            ret.addChild(GrammarTree.fromString(str.substring(0, ind2 + 1)));
            str = str.substring(ind2 + 1);
        }
        return ret;
    }

    public static Residue fromGrammarTree(GrammarTree gt) throws Exception {
        Residue ret = null;
        if (gt.label.equals(END)) {
            ret = new Residue(ResidueType.createFreeReducingEnd());
        } else {
            String type = GrammarTree.removeTag(gt.label);
            Matcher m = pattern.matcher(type);
            if (m.matches()) {
                ret = ResidueDictionary.newResidue((String)type.substring(6));
                ret.setParentLinkage(new Linkage(null, ret, type.charAt(0)));
                ret.setAnomericState(type.charAt(1));
                ret.setAnomericCarbon(type.charAt(2));
                ret.setChirality(type.charAt(4));
            } else {
                ret = ResidueDictionary.newResidue((String)type);
                ret.setParentLinkage(new Linkage(null, ret));
            }
        }
        for (GrammarTree gtc : gt.children) {
            Residue child = GrammarTree.fromGrammarTree(gtc);
            ret.addChild(child, child.getParentLinkage().getParentPositionsSingle());
        }
        return ret;
    }
}

