/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.dialog;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.tools.spectrafiltering.om.SpectraFilterSettings;

public class SpectraAverageDialog
extends TitleAreaDialog {
    private Text m_txtAccuracyValue;
    private boolean m_bIsPPM;
    private SpectraFilterSettings m_filter;

    public SpectraAverageDialog(Shell parentShell, SpectraFilterSettings filter) {
        super(parentShell);
        this.m_filter = filter;
    }

    public SpectraFilterSettings getFilter() {
        return this.m_filter;
    }

    public void create() {
        super.create();
        this.setTitle("Spectra Average Settings");
        this.setMessage("Please specify the accuracy for averaging the spectra with the same precursor m/z values.", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(5, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        area.setSize(100, 100);
        container.setLayout((Layout)layout);
        this.createControls(container);
        return area;
    }

    private void createControls(Composite container) {
        Label lbl = new Label(container, 0);
        lbl.setText("Accuracy");
        lbl.setLayoutData((Object)new GridData(4, 4, false, false));
        this.m_txtAccuracyValue = new Text(container, 2048);
        this.m_txtAccuracyValue.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        final Combo c = new Combo(container, 12);
        String[] items = new String[]{"Dalton", "PPM"};
        c.setItems(items);
        c.setLayoutData((Object)new GridData(4, 4, false, false));
        c.select(1);
        this.m_bIsPPM = true;
        c.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (c.getText().equals("Dalton")) {
                    SpectraAverageDialog.this.m_bIsPPM = false;
                } else if (c.getText().equals("PPM")) {
                    SpectraAverageDialog.this.m_bIsPPM = true;
                }
            }
        });
    }

    private boolean validate() {
        try {
            Double.parseDouble(this.m_txtAccuracyValue.getText());
        }
        catch (Exception exception) {
            this.setErrorMessage("accuracyValue Value should be Double");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        this.m_filter.setAccuracy(Double.valueOf(Double.parseDouble(this.m_txtAccuracyValue.getText())));
        this.m_filter.setPPM(Boolean.valueOf(this.m_bIsPPM));
        super.okPressed();
    }
}

