/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eurocarbdb.application.glycanbuilder.CoreType;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TerminalType;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.GlycanRendererSWT;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.ResidueRendererSWT;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.CoreDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.ResidueDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.structure.dictionary.TerminalDictionary;
import org.grits.toolbox.tools.glycanbuilder.core.workspace.BuilderWorkspaceSWT;

public class GlycanIconProvider {
    private static final int ICON_SIZE_DEFAULT = 24;
    private static int iIconSize = 24;
    private static int iIconSizeOld = 24;
    private static BuilderWorkspaceSWT bws = new BuilderWorkspaceSWT((Device)Display.getDefault());
    private static String strOldNotation;
    private static Map<ResidueType, Image> mapResToIcon;
    private static Map<CoreType, Image> mapCoreToIcon;
    private static Map<TerminalType, Image> mapTerminalToIcon;
    private static List<IconUpdateListener> lListeners;

    static {
        bws.setNotation("snfg");
        bws.getGraphicOptions().initCustomDisplay("compact");
        GlycanIconProvider.bws.getGraphicOptions().MARGIN_TOP_CUSTOM = 12;
        GlycanIconProvider.bws.getGraphicOptions().MARGIN_BOTTOM_CUSTOM = 12;
        GlycanIconProvider.bws.getGraphicOptions().MARGIN_LEFT_CUSTOM = 12;
        GlycanIconProvider.bws.getGraphicOptions().MARGIN_RIGHT_CUSTOM = 12;
        bws.setDisplay("custom");
        GlycanIconProvider.updateImages();
    }

    public static void addIconUpdateListener(IconUpdateListener l) {
        if (l == null) {
            return;
        }
        if (lListeners == null) {
            lListeners = new LinkedList<IconUpdateListener>();
        }
        lListeners.add(l);
    }

    public static void removeIconUpdateListener(IconUpdateListener l) {
        if (lListeners == null) {
            return;
        }
        if (l == null) {
            return;
        }
        lListeners.remove(l);
    }

    public static void setIconSize(int size) {
        iIconSize = size;
        GlycanIconProvider.updateImages();
    }

    public static void setNotation(String notation) {
        if (notation != null) {
            bws.setNotation(notation);
        }
        GlycanIconProvider.updateImages();
    }

    public static Image getResidueIcon(ResidueType resType) {
        if (mapResToIcon == null) {
            return null;
        }
        return mapResToIcon.get(resType);
    }

    public static Image getGlycanCoreIcon(CoreType coreType) {
        if (mapCoreToIcon == null) {
            return null;
        }
        return mapCoreToIcon.get(coreType);
    }

    public static Image getGlycanTerminalIcon(TerminalType termType) {
        if (mapTerminalToIcon == null) {
            return null;
        }
        return mapTerminalToIcon.get(termType);
    }

    private static void updateImages() {
        boolean updateRes = true;
        boolean updateGlycan = true;
        if (strOldNotation != null && strOldNotation.equals(GlycanIconProvider.bws.getGraphicOptions().NOTATION)) {
            if (iIconSize == iIconSizeOld) {
                updateRes = false;
            }
            updateGlycan = false;
        }
        strOldNotation = GlycanIconProvider.bws.getGraphicOptions().NOTATION;
        iIconSizeOld = iIconSize;
        if (updateRes) {
            GlycanIconProvider.updateResidueIcons();
        }
        if (updateGlycan) {
            GlycanIconProvider.updateGlycanIcons();
        }
    }

    private static void updateResidueIcons() {
        if (mapResToIcon != null) {
            for (Image img : mapResToIcon.values()) {
                img.dispose();
            }
        }
        mapResToIcon = new HashMap<ResidueType, Image>();
        ResidueRendererSWT rr = bws.getGlycanRenderer().getResidueRenderer();
        for (ResidueType resType : ResidueDictionary.allResidues()) {
            mapResToIcon.put(resType, rr.getImage(resType, iIconSize));
        }
        if (lListeners != null) {
            for (IconUpdateListener l : lListeners) {
                l.residueIconUpdated();
            }
        }
    }

    private static void updateGlycanIcons() {
        GlycanIconProvider.updateGlycanCoreIcons();
        GlycanIconProvider.updateGlycanTerminalIcons();
        if (lListeners != null) {
            for (IconUpdateListener l : lListeners) {
                l.glycanIconUpdated();
            }
        }
    }

    private static void updateGlycanCoreIcons() {
        if (mapCoreToIcon != null) {
            for (Image img : mapCoreToIcon.values()) {
                img.dispose();
            }
        }
        mapCoreToIcon = new HashMap<CoreType, Image>();
        GlycanRendererSWT gr = bws.getGlycanRenderer();
        for (CoreType ct : CoreDictionary.getCores()) {
            Glycan g = Glycan.fromString((String)ct.getStructure());
            mapCoreToIcon.put(ct, gr.getImage(g, true, false, false, 0.25));
        }
    }

    private static void updateGlycanTerminalIcons() {
        if (mapTerminalToIcon != null) {
            for (Image img : mapTerminalToIcon.values()) {
                img.dispose();
            }
        }
        mapTerminalToIcon = new HashMap<TerminalType, Image>();
        GlycanRendererSWT gr = bws.getGlycanRenderer();
        for (TerminalType tt : TerminalDictionary.getTerminals()) {
            Glycan g = Glycan.fromString((String)tt.getStructure());
            mapTerminalToIcon.put(tt, gr.getImage(g, true, false, false, 0.25));
        }
    }

    public static interface IconUpdateListener {
        public void residueIconUpdated();

        public void glycanIconUpdated();
    }
}

