/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.canvas;

import java.util.ArrayList;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eurocarbdb.application.glycanbuilder.Bond;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.MultiSelectionCombo;

public class ResiduePropertyBarComposite
extends Composite {
    private GlycanCanvasComposite m_canvas;
    private Combo m_cmbAnom;
    private Combo m_cmbAnomPos;
    private MultiSelectionCombo m_mcmbPos;
    private Combo m_cmbChiral;
    private Combo m_cmbRing;
    private Button m_btnHasSecond;
    private Combo m_cmbAnomPos2;
    private MultiSelectionCombo m_mcmbPos2;

    public ResiduePropertyBarComposite(Composite parent, GlycanCanvasComposite canvas) {
        super(parent, 0);
        RowLayout layout = new RowLayout();
        layout.center = true;
        layout.fill = true;
        layout.wrap = true;
        layout.spacing = 10;
        this.setLayout((Layout)layout);
        this.createControls();
        this.setDefault();
        this.m_canvas = canvas;
        this.addMouseListnerToCanvas();
    }

    public void createControls() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctl = controlArray[n2];
            ctl.dispose();
            ++n2;
        }
        CLabel lbl = new CLabel((Composite)this, 0x1000000);
        lbl.setText("Linkage");
        this.m_cmbAnom = new Combo((Composite)this, 0);
        this.m_cmbAnomPos = new Combo((Composite)this, 0);
        lbl = new CLabel((Composite)this, 0x1000000);
        lbl.setText("->");
        this.m_mcmbPos = new MultiSelectionCombo(this, 2048);
        lbl = new CLabel((Composite)this, 0x1000000);
        lbl.setText("Chirality");
        this.m_cmbChiral = new Combo((Composite)this, 0);
        lbl = new CLabel((Composite)this, 0x1000000);
        lbl.setText("Ring");
        this.m_cmbRing = new Combo((Composite)this, 0);
        this.m_btnHasSecond = new Button((Composite)this, 16416);
        this.m_btnHasSecond.setText("2nd bond");
        this.m_cmbAnomPos2 = new Combo((Composite)this, 0);
        lbl = new CLabel((Composite)this, 0x1000000);
        lbl.setText("->");
        this.m_mcmbPos2 = new MultiSelectionCombo(this, 2048);
    }

    public void setDefault() {
        this.m_cmbAnom.setItems(new String[]{"?", "a", "b"});
        this.m_cmbAnom.select(0);
        this.m_cmbAnom.setEnabled(false);
        this.setDefaultPos(this.m_mcmbPos);
        this.m_mcmbPos.setEnabled(false);
        this.m_cmbAnomPos.setItems(new String[]{"?", "1", "2", "3"});
        this.m_cmbAnomPos.select(1);
        this.m_cmbAnomPos.setEnabled(false);
        this.m_cmbChiral.setItems(new String[]{"?", "D", "L"});
        this.m_cmbChiral.select(0);
        this.m_cmbChiral.setEnabled(false);
        this.m_cmbRing.setItems(new String[]{"?", "p", "f", "o"});
        this.m_cmbRing.select(0);
        this.m_cmbRing.setEnabled(false);
        this.m_btnHasSecond.setEnabled(false);
        this.m_cmbAnomPos2.setItems(new String[]{"?", "1", "2", "3"});
        this.m_cmbAnomPos2.select(0);
        this.m_cmbAnomPos2.setEnabled(false);
        this.setDefaultPos(this.m_mcmbPos2);
        this.m_mcmbPos2.setEnabled(false);
    }

    private void setDefaultPos(MultiSelectionCombo mcmb) {
        mcmb.setItems(new String[]{"?", "1", "2", "3", "4", "5", "6"});
        mcmb.select(0);
    }

    public void setResidue(final Residue res) {
        this.setDefault();
        SelectionAdapter selectionListenerSave = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResiduePropertyBarComposite.this.save(res);
                ResiduePropertyBarComposite.this.m_canvas.getCurrentGlycanLabel().saveDocument();
                ResiduePropertyBarComposite.this.m_canvas.updateView();
            }
        };
        MouseAdapter mouseListenerSave = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ResiduePropertyBarComposite.this.save(res);
                ResiduePropertyBarComposite.this.m_canvas.getCurrentGlycanLabel().saveDocument();
                ResiduePropertyBarComposite.this.m_canvas.updateView();
            }
        };
        Linkage linkParent = res.getParentLinkage();
        if (res.isSaccharide()) {
            this.m_cmbAnom.setEnabled(true);
            this.m_cmbAnom.select(this.getComboIndex(this.m_cmbAnom, res.getAnomericState()));
            this.removeOldSelectionListeners((Widget)this.m_cmbAnom);
            this.m_cmbAnom.addSelectionListener((SelectionListener)selectionListenerSave);
            this.m_cmbAnomPos.setEnabled(true);
            this.m_cmbAnomPos.select(this.getComboIndex(this.m_cmbAnomPos, res.getAnomericCarbon()));
            this.removeOldSelectionListeners((Widget)this.m_cmbAnomPos);
            this.m_cmbAnomPos.addSelectionListener((SelectionListener)selectionListenerSave);
            this.m_cmbChiral.setEnabled(true);
            this.m_cmbChiral.select(this.getComboIndex(this.m_cmbChiral, res.getChirality()));
            this.removeOldSelectionListeners((Widget)this.m_cmbChiral);
            this.m_cmbChiral.addSelectionListener((SelectionListener)selectionListenerSave);
            this.m_cmbRing.setEnabled(true);
            this.m_cmbRing.select(this.getComboIndex(this.m_cmbRing, res.getRingSize()));
            this.removeOldSelectionListeners((Widget)this.m_cmbRing);
            this.m_cmbRing.addSelectionListener((SelectionListener)selectionListenerSave);
        }
        this.removeOldSelectionListeners((Widget)this.m_btnHasSecond);
        this.m_btnHasSecond.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    ResiduePropertyBarComposite.this.m_cmbAnomPos2.setEnabled(true);
                    ResiduePropertyBarComposite.this.m_mcmbPos2.setEnabled(true);
                } else {
                    ResiduePropertyBarComposite.this.m_cmbAnomPos2.setEnabled(false);
                    ResiduePropertyBarComposite.this.m_mcmbPos2.setEnabled(false);
                }
            }
        });
        this.m_btnHasSecond.addSelectionListener((SelectionListener)selectionListenerSave);
        if (linkParent == null || linkParent.getParentResidue().isReducingEnd()) {
            this.setDefaultPos(this.m_mcmbPos);
            this.setDefaultPos(this.m_mcmbPos2);
            this.m_mcmbPos.setEnabled(false);
            this.m_mcmbPos2.setEnabled(false);
            this.m_btnHasSecond.setEnabled(false);
            return;
        }
        this.m_btnHasSecond.setEnabled(true);
        if (linkParent.hasMultipleBonds()) {
            this.m_btnHasSecond.setSelection(true);
        }
        char[] possDef = linkParent.getParentResidue().getType().getLinkagePositions();
        if (linkParent.getParentResidue().isBracket()) {
            possDef = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', 'N'};
        }
        if (possDef.length != 0) {
            ArrayList<String> lDefPoss = new ArrayList<String>();
            lDefPoss.add("?");
            char[] cArray = possDef;
            int n = possDef.length;
            int n2 = 0;
            while (n2 < n) {
                char posNew = cArray[n2];
                if (posNew != ' ') {
                    lDefPoss.add(String.valueOf(posNew));
                }
                ++n2;
            }
            this.m_mcmbPos.removeAll();
            this.m_mcmbPos.setItems(lDefPoss.toArray(new String[0]));
            this.m_mcmbPos2.removeAll();
            this.m_mcmbPos2.setItems(lDefPoss.toArray(new String[0]));
            this.m_mcmbPos.setEnabled(true);
            char[] poss = linkParent.glycosidicBond().getParentPositions();
            this.m_mcmbPos.setSelectionIndices(this.getMultiComboIndex(this.m_mcmbPos, poss));
            this.m_mcmbPos.resetMouseListener();
            this.m_mcmbPos.addMouseListener((MouseListener)mouseListenerSave);
            if (linkParent.hasMultipleBonds()) {
                poss = ((Bond)linkParent.getBonds().get(0)).getParentPositions();
                this.m_mcmbPos2.setSelectionIndices(this.getMultiComboIndex(this.m_mcmbPos2, poss));
            }
        } else {
            this.setDefaultPos(this.m_mcmbPos);
            this.setDefaultPos(this.m_mcmbPos2);
            this.m_mcmbPos.setEnabled(false);
            this.m_mcmbPos2.setEnabled(false);
            this.m_btnHasSecond.setEnabled(false);
            return;
        }
        this.m_mcmbPos2.resetMouseListener();
        this.m_mcmbPos2.addMouseListener((MouseListener)mouseListenerSave);
        if (this.m_btnHasSecond.getSelection()) {
            this.m_mcmbPos2.setEnabled(true);
            this.m_cmbAnomPos2.setEnabled(true);
        }
        this.m_cmbAnomPos2.select(this.getComboIndex(this.m_cmbAnomPos2, ((Bond)linkParent.getBonds().get(0)).getChildPosition()));
        this.removeOldSelectionListeners((Widget)this.m_cmbAnomPos2);
        this.m_cmbAnomPos2.addSelectionListener((SelectionListener)selectionListenerSave);
    }

    public void updateCurrentResidue() {
        if (this.m_canvas.getCurrentGlycanLabel() != null && this.m_canvas.getCurrentGlycanLabel().getCurrentResidue() != null) {
            this.setResidue(this.m_canvas.getCurrentGlycanLabel().getCurrentResidue());
        } else {
            this.setDefault();
        }
    }

    private void addMouseListnerToCanvas() {
        this.m_canvas.addCanvasMouseListner((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ResiduePropertyBarComposite.this.updateCurrentResidue();
            }
        });
    }

    private int getComboIndex(Combo cmb, char value) {
        int inx = 0;
        String[] stringArray = cmb.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(String.valueOf(value))) {
                inx = cmb.indexOf(String.valueOf(value));
            }
            ++n2;
        }
        return inx;
    }

    private int[] getMultiComboIndex(MultiSelectionCombo cmb, char[] values) {
        ArrayList<Integer> lInxs = new ArrayList<Integer>();
        int i = 0;
        while (i < cmb.getItemCount()) {
            String item = cmb.getItems()[i];
            char[] cArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                char value = cArray[n2];
                if (item.equals(String.valueOf(value))) {
                    lInxs.add(i);
                }
                ++n2;
            }
            ++i;
        }
        int[] inxs = new int[lInxs.size()];
        int i2 = 0;
        while (i2 < lInxs.size()) {
            inxs[i2] = (Integer)lInxs.get(i2);
            ++i2;
        }
        if (inxs.length == 0) {
            cmb.setSelectionIndices(new int[1]);
            return cmb.getSelectionIndices();
        }
        return inxs;
    }

    private char[] getSelectedPositions(MultiSelectionCombo cmb) {
        String[] texts = cmb.getSelections();
        char[] poss = new char[texts.length];
        int i = 0;
        while (i < texts.length) {
            poss[i] = texts[i].charAt(0);
            ++i;
        }
        if (poss.length == 0) {
            cmb.setSelectionIndices(new int[1]);
            return new char[]{'?'};
        }
        return poss;
    }

    private void save(Residue res) {
        Linkage linkParent = res.getParentLinkage();
        res.setAnomericState(this.m_cmbAnom.getText().charAt(0));
        res.setAnomericCarbon(this.m_cmbAnomPos.getText().charAt(0));
        res.setChirality(this.m_cmbChiral.getText().charAt(0));
        res.setRingSize(this.m_cmbRing.getText().charAt(0));
        if (linkParent == null) {
            return;
        }
        char[] poss = this.getSelectedPositions(this.m_mcmbPos);
        if (!this.m_btnHasSecond.getSelection()) {
            linkParent.setLinkagePositions(poss);
            return;
        }
        char[] poss2 = this.getSelectedPositions(this.m_mcmbPos2);
        linkParent.setLinkagePositions(poss, poss2, this.m_cmbAnomPos2.getText().charAt(0));
    }

    private void removeOldSelectionListeners(Widget widget) {
        Listener[] listenerArray = widget.getListeners(13);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener listener = listenerArray[n2];
            widget.removeListener(13, listener);
            ++n2;
        }
    }
}

