/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.preference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreferenceLoader;
import org.grits.toolbox.display.control.table.preference.TableViewerPreferenceReader;

@XmlRootElement(name="tableViewerPreference")
public class TableViewerPreference {
    private static final Logger logger = Logger.getLogger(TableViewerPreference.class);
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.display.control.table.preference.TableViewerPreference";
    private static final String CURRENT_VERSION = "1.1";
    private String columnSettings = "";
    private String columnHeaders = "";
    protected TableViewerColumnSettings preferenceSettings = null;

    public static String getPreferenceID() {
        return PREFERENCE_NAME_ALL;
    }

    public String getColumnSettings() {
        return this.columnSettings;
    }

    @XmlAttribute(name="columnSettings")
    public void setColumnSettings(String columnSettings) {
        this.columnSettings = columnSettings;
    }

    public String getColumnHeaders() {
        return this.columnHeaders;
    }

    @XmlAttribute(name="columnHeaders")
    public void setColumnHeaders(String columnHeaders) {
        this.columnHeaders = columnHeaders;
    }

    public void mergeSettings(TableViewerColumnSettings _newSettings) {
        for (GRITSColumnHeader colHeader : _newSettings.getHeaders()) {
            if (this.getPreferenceSettings().hasColumn(colHeader.getKeyValue())) continue;
            this.getPreferenceSettings().putColumn(colHeader, -1);
        }
    }

    public TableViewerColumnSettings getPreferenceSettings() {
        return this.preferenceSettings;
    }

    @XmlTransient
    public void setPreferenceSettings(TableViewerColumnSettings preferenceSettings) {
        this.preferenceSettings = preferenceSettings;
    }

    public boolean settingsNeedInitialization() {
        return this.preferenceSettings == null || this.preferenceSettings.getNumColumns() == 0;
    }

    protected TableViewerColumnSettings getNewTableSettings() {
        TableViewerColumnSettings spf = new TableViewerColumnSettings();
        return spf;
    }

    protected TableViewerPreferenceReader getNewReader() {
        return new TableViewerPreferenceReader();
    }

    public static TableViewerPreference readPreference() {
        return TableViewerPreferenceLoader.getTableViewerPreference();
    }

    private static TableViewerPreference getTableViewerPreferenceFromXML(String xmlString, Class<?> prefClass) {
        TableViewerPreference preferences = (TableViewerPreference)XMLUtils.getObjectFromXML((String)xmlString, prefClass);
        return preferences;
    }

    public static String marshalXML(TableViewerPreference object) {
        String xmlString = XMLUtils.marshalObjectXML((Object)object);
        return xmlString;
    }

    protected String marshalXML() {
        this.setColumnSettings(this.getPreferenceSettings().toColumnVisibilityString());
        this.setColumnHeaders(this.getPreferenceSettings().toColumnHeaderString());
        return TableViewerPreference.marshalXML(this);
    }

    public static TableViewerPreference getTableViewerPreference(PreferenceEntity preferenceEntity, Class<?> prefClass) throws UnsupportedVersionException {
        TableViewerPreference preferences = null;
        if (preferenceEntity != null) {
            preferences = TableViewerPreference.getTableViewerPreferenceFromXML(preferenceEntity.getValue(), prefClass);
            TableViewerPreference.initTableViewerColumnSettings(preferences);
        }
        return preferences;
    }

    public boolean writePreference() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(TableViewerPreference.getPreferenceID());
        preferenceEntity.setVersion(CURRENT_VERSION);
        preferenceEntity.setValue(this.marshalXML());
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }

    public static PreferenceEntity getPreferenceEntity() throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)TableViewerPreference.getPreferenceID());
        return preferenceEntity;
    }

    protected Map<Integer, List<String[]>> getPreferenceMapFromColumnSettings(String sColumnSettings) {
        HashMap<Integer, List<String[]>> mColNumToPrefs = new HashMap<Integer, List<String[]>>();
        if (sColumnSettings.length() != 0) {
            String[] sColHeaders = sColumnSettings.split(TableViewerColumnSettings.COL_DELIMITER);
            int i = 0;
            while (i < sColHeaders.length) {
                String[] sColAndVis = sColHeaders[i].split(TableViewerColumnSettings.TOK_DELIMITER);
                Integer iVisColInx = -1;
                try {
                    iVisColInx = Integer.parseInt(sColAndVis[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    iVisColInx = -1;
                }
                List<String[]> lPrefInfo = null;
                if (mColNumToPrefs.containsKey(iVisColInx)) {
                    lPrefInfo = (List)mColNumToPrefs.get(iVisColInx);
                } else {
                    lPrefInfo = new ArrayList();
                    mColNumToPrefs.put(iVisColInx, lPrefInfo);
                }
                lPrefInfo.add(sColAndVis);
                ++i;
            }
        }
        return mColNumToPrefs;
    }

    protected Map<String, String> getHeaderMapFromColumnSettings(String sColumnHeaders) {
        HashMap<String, String> mKeyToLabel = new HashMap<String, String>();
        if (sColumnHeaders.length() != 0) {
            String[] sColHeaders = sColumnHeaders.split(TableViewerColumnSettings.COL_DELIMITER);
            int i = 0;
            while (i < sColHeaders.length) {
                String[] sKeyToLabel = sColHeaders[i].split(TableViewerColumnSettings.TOK_DELIMITER);
                if (!this.excludeColumn(sKeyToLabel[0], sKeyToLabel[1])) {
                    mKeyToLabel.put(sKeyToLabel[0], sKeyToLabel[1]);
                }
                ++i;
            }
        }
        return mKeyToLabel;
    }

    protected boolean excludeColumn(String _sColumnKey, String _sColumnLabel) {
        return false;
    }

    private static List<Integer> getSortedCols(Set<Integer> _sCols) {
        ArrayList<Integer> lSortedCols = new ArrayList<Integer>();
        for (Integer iColNum : _sCols) {
            lSortedCols.add(iColNum);
        }
        Collections.sort(lSortedCols);
        return lSortedCols;
    }

    public GRITSColumnHeader getColumnHeader(String _sKey) {
        return null;
    }

    protected static void initTableViewerColumnSettings(TableViewerPreference preference) {
        try {
            if (preference == null || preference.getColumnSettings() == null) {
                return;
            }
            Map<Integer, List<String[]>> mColNumToPrefs = preference.getPreferenceMapFromColumnSettings(preference.getColumnSettings());
            if (mColNumToPrefs == null || mColNumToPrefs.isEmpty()) {
                return;
            }
            Map<String, String> mKeyToLabel = preference.getHeaderMapFromColumnSettings(preference.getColumnHeaders());
            List<Integer> lSortedCols = TableViewerPreference.getSortedCols(mColNumToPrefs.keySet());
            Iterator<Integer> itr = lSortedCols.iterator();
            int iVisColInx = 0;
            TableViewerColumnSettings spf = preference.getNewTableSettings();
            while (itr.hasNext()) {
                Integer iColNum = itr.next();
                List<String[]> lCols = mColNumToPrefs.get(iColNum);
                if (iColNum >= 0 && lCols.size() > 1) {
                    String errorMsg = "Invalid column preferences detected for column number " + iColNum;
                    logger.error((Object)errorMsg);
                }
                for (String[] sColAndVis : lCols) {
                    int iColInx;
                    GRITSColumnHeader header = preference.getColumnHeader(sColAndVis[0]);
                    if (header == null && mKeyToLabel != null && mKeyToLabel.containsKey(sColAndVis[0])) {
                        header = new GRITSColumnHeader(mKeyToLabel.get(sColAndVis[0]), sColAndVis[0]);
                    }
                    int n = iColInx = iColNum > 0 ? iVisColInx : iColNum;
                    if (header != null) {
                        spf.setVisColInx(header, iColInx);
                    } else {
                        logger.warn((Object)("Unrecognized column in preferences: " + sColAndVis[0]));
                        spf.getUnrecognizedHeaders().put(sColAndVis[0], new Integer(iColInx));
                    }
                    if (iColInx < 0) continue;
                    ++iVisColInx;
                }
            }
            if (spf.getNumColumns() > 0) {
                preference.setPreferenceSettings(spf);
            }
        }
        catch (Exception ex) {
            String errorMsg = "An error occurred loading preferences";
            logger.error((Object)errorMsg, (Throwable)ex);
        }
    }
}

