/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitor;
import org.glycoinfo.WURCSFramework.util.graph.visitor.WURCSVisitorException;
import org.glycoinfo.WURCSFramework.wurcs.graph.BackboneCarbon;
import org.glycoinfo.WURCSFramework.wurcs.graph.CarbonDescriptor;
import org.glycoinfo.WURCSFramework.wurcs.graph.InterfaceRepeat;
import org.glycoinfo.WURCSFramework.wurcs.graph.LinkagePosition;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSComponent;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class Backbone
extends WURCSComponent {
    private LinkedList<BackboneCarbon> m_aCarbons = new LinkedList();
    private BackboneCarbon m_objAnomericCarbon = null;

    public boolean addBackboneCarbon(BackboneCarbon bc) {
        if (this.m_aCarbons.contains(bc)) {
            return false;
        }
        this.checkAnomeric(bc);
        return this.m_aCarbons.add(bc);
    }

    public LinkedList<BackboneCarbon> getBackboneCarbons() {
        return this.m_aCarbons;
    }

    public int getLength() {
        return this.m_aCarbons.size();
    }

    public String getSkeletonCode() {
        String code = "";
        for (BackboneCarbon oBC : this.m_aCarbons) {
            code = code + oBC.getDesctriptor().getChar();
        }
        return code;
    }

    public int getAnomericPosition() {
        if (this.m_objAnomericCarbon == null) {
            return 0;
        }
        CarbonDescriptor CD = (CarbonDescriptor)this.m_objAnomericCarbon.getDesctriptor();
        if (!CD.isFootOfBridge()) {
            return 0;
        }
        return this.getBackboneCarbons().indexOf(this.m_objAnomericCarbon) + 1;
    }

    public char getAnomericSymbol() {
        int pos = this.getAnomericPosition();
        if (pos == 0) {
            return 'x';
        }
        int i = 0;
        BackboneCarbon bcConfig = null;
        for (BackboneCarbon bc : this.getBackboneCarbons()) {
            if (!bc.isChiral()) continue;
            bcConfig = bc;
            if (++i != 5) continue;
            break;
        }
        char anom = 'x';
        if (bcConfig == null) {
            return anom;
        }
        if (this.m_objAnomericCarbon == null) {
            return anom;
        }
        char cConfig = bcConfig.getDesctriptor().getChar();
        char cAnom = this.m_objAnomericCarbon.getDesctriptor().getChar();
        if (cConfig == 'x' || cConfig == 'X') {
            return cAnom == '3' || cAnom == '7' ? (char)'b' : (cAnom == '4' || cAnom == '8' ? (char)'a' : anom);
        }
        if (!Character.isDigit(cConfig)) {
            return anom;
        }
        int iConfig = Character.getNumericValue(cConfig);
        if (!Character.isDigit(cAnom)) {
            return anom;
        }
        int iAnom = Character.getNumericValue(cAnom);
        anom = iConfig % 2 == iAnom % 2 ? (char)'a' : 'b';
        return anom;
    }

    public WURCSEdge getAnomericEdge() {
        if (this.getAnomericPosition() == 0) {
            return null;
        }
        for (WURCSEdge edge : this.getEdges()) {
            if (edge.getLinkages().size() > 1 || edge.getLinkages().get(0).getBackbonePosition() != this.getAnomericPosition() || edge.getModification() == null || !edge.getModification().isGlycosidic() || edge.getModification() instanceof InterfaceRepeat) continue;
            return edge;
        }
        return null;
    }

    public boolean hasParent() {
        WURCSEdge t_objAnomEdge = this.getAnomericEdge();
        if (t_objAnomEdge == null) {
            return false;
        }
        if (t_objAnomEdge.getModification().isGlycosidic()) {
            return true;
        }
        return !t_objAnomEdge.getModification().isAglycone();
    }

    public boolean hasUnknownLength() {
        for (BackboneCarbon bc : this.m_aCarbons) {
            if (!bc.hasUnknownLength()) continue;
            return true;
        }
        return false;
    }

    public int getBackboneScore() {
        int score = 0;
        int length = this.m_aCarbons.size();
        for (int i = 0; i < length; ++i) {
            score += (i + 1) * this.m_aCarbons.get(i).getDesctriptor().getCarbonScore();
        }
        return score;
    }

    private void clear() {
        this.m_aCarbons.clear();
        this.m_objAnomericCarbon = null;
    }

    @Override
    public Backbone copy() {
        Backbone copy = new Backbone();
        for (BackboneCarbon bc : this.m_aCarbons) {
            copy.addBackboneCarbon(bc.copy(copy));
        }
        copy.removeAllEdges();
        return copy;
    }

    public void invert() {
        LinkedList<BackboneCarbon> inverts = new LinkedList<BackboneCarbon>();
        for (BackboneCarbon orig : this.m_aCarbons) {
            inverts.addFirst(orig.invert(this));
        }
        this.clear();
        for (BackboneCarbon inv : inverts) {
            this.m_aCarbons.add(inv);
            this.checkAnomeric(inv);
        }
        for (WURCSEdge edge : this.getEdges()) {
            for (LinkagePosition link : edge.getLinkages()) {
                link.invertBackbonePosition(this.m_aCarbons.size());
            }
        }
    }

    private void checkAnomeric(BackboneCarbon bc) {
        if (!bc.isAnomeric()) {
            return;
        }
        if (this.m_objAnomericCarbon == null) {
            this.m_objAnomericCarbon = bc;
        }
        if (this.m_objAnomericCarbon.getDesctriptor() == bc.getDesctriptor()) {
            return;
        }
        if (this.m_objAnomericCarbon.getDesctriptor().getCarbonScore() - bc.getDesctriptor().getCarbonScore() < 0) {
            this.m_objAnomericCarbon = bc;
        }
    }

    @Override
    public void accept(WURCSVisitor a_objVisitor) throws WURCSVisitorException {
        a_objVisitor.visit(this);
    }
}

