/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.dialog;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.annotation.dialog.MSAnnotationStandardQuantFileGrid;
import org.grits.toolbox.entry.ms.annotation.dialog.MSAnnotationStandardQuantModifyDialog;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.dialog.MassSpecStandardQuantApplyDialog;
import org.grits.toolbox.entry.ms.dialog.MassSpecStandardQuantFileGrid;
import org.grits.toolbox.entry.ms.dialog.MassSpecStandardQuantModifyDialog;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public class MSAnnotationStandardQuantApplyDialog
extends MassSpecStandardQuantApplyDialog {
    private static final Logger logger = Logger.getLogger(MSAnnotationStandardQuantApplyDialog.class);

    public MSAnnotationStandardQuantApplyDialog(Shell parentShell, MassSpecMultiPageViewer contextViewer) {
        super(parentShell, contextViewer);
    }

    public Property getEntryParentProperty() {
        try {
            Entry entry = this.getEntryForCurrentViewer();
            MSAnnotationEntityProperty msep = (MSAnnotationEntityProperty)entry.getProperty();
            MSAnnotationProperty msap = msep.getMSAnnotationParentProperty();
            return msap;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    protected MassSpecStandardQuantFileGrid getNewMassSpecStandardQuantFileGrid(Composite parent, MassSpecMultiPageViewer curView) {
        return new MSAnnotationStandardQuantFileGrid(parent, curView);
    }

    public MassSpecMultiPageViewer getCurrentViewer() {
        try {
            EPartService partService = this.getContextViewer().getPartService();
            for (MPart mPart : partService.getParts()) {
                MSAnnotationMultiPageViewer viewer;
                if (!(mPart.getObject() instanceof MSAnnotationMultiPageViewer) || !mPart.equals(mPart.getParent().getSelectedElement()) || (viewer = (MSAnnotationMultiPageViewer)((Object)mPart.getObject())) == null || viewer.getEntry().getProperty() == null || !(viewer.getEntry().getProperty() instanceof MSAnnotationEntityProperty)) continue;
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected void updateViewer(List<String> sKeyVals) {
        try {
            MSAnnotationMultiPageViewer viewer = (MSAnnotationMultiPageViewer)this.getCurrentViewer();
            viewer.reLoadStructureAnnotationTab(sKeyVals);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected MassSpecStandardQuantModifyDialog getNewQuantModifyDialog(Shell shell, MassSpecMultiPageViewer viewer) {
        return new MSAnnotationStandardQuantModifyDialog(shell, viewer);
    }

    protected void clearStdQuant() {
        MSAnnotationProperty prop = (MSAnnotationProperty)this.getEntryParentProperty();
        MSAnnotationMetaData msSettings = prop.getMSAnnotationMetaData();
        try {
            this.fileGrid.updateIntQuantFileSettings();
            if (msSettings.getStandardQuant().contains(this.selStandards)) {
                msSettings.getStandardQuant().remove(this.selStandards);
            }
            String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
            msSettings.updateStandardQuantData();
            MSAnnotationProperty.updateMSSettings(msSettings, sFileName);
            this.initLocalStandardQuant();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.updateViewer(null);
            this.initStoredStandardQuantList();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    protected void clearBeforeReApply() {
        MSAnnotationProperty prop = (MSAnnotationProperty)this.getEntryParentProperty();
        MSAnnotationMetaData msSettings = prop.getMSAnnotationMetaData();
        if (msSettings.getStandardQuant().contains(this.selStandards)) {
            try {
                msSettings.getStandardQuant().remove(this.selStandards);
                String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
                msSettings.updateStandardQuantData();
                MSAnnotationProperty.updateMSSettings(msSettings, sFileName);
                this.updateViewer(null);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
    }

    protected void performStdQuant() {
        this.clearBeforeReApply();
        MSAnnotationProperty prop = (MSAnnotationProperty)this.getEntryParentProperty();
        MSAnnotationMetaData msSettings = prop.getMSAnnotationMetaData();
        try {
            this.fileGrid.updateIntQuantFileSettings();
            if (this.selStandards != null) {
                msSettings.getStandardQuant().add(this.selStandards);
            }
            String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
            msSettings.updateStandardQuantData();
            MSAnnotationProperty.updateMSSettings(msSettings, sFileName);
            this.initLocalStandardQuant();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            List sKeyVals = this.getColumnKeyLabels();
            this.updateViewer(sKeyVals);
            this.initStoredStandardQuantList();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }
}

