/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.io.carbbank;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.io.StructureSpecialInformation;
import org.eurocarbdb.MolecularFramework.io.SugarImporter;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Linkage;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SugarImporterCarbbank
extends SugarImporter {
    private HashMap<String, Integer> m_hashRepeatCountMin = new HashMap();
    private HashMap<String, Integer> m_hashRepeatCountMax = new HashMap();
    private int m_iMinRepeatCount = -2;
    private int m_iMaxRepeatCount = -2;
    private ArrayList<StructureSpecialInformation> m_aSpecialList = new ArrayList();
    private String[] m_aLines;
    private int m_iLineCount = 0;
    private int m_iCharacterCounter = 0;
    private ArrayList<String> m_aWarnings = new ArrayList();

    @Override
    public Sugar parse(String a_strStream) throws SugarImporterException {
        int y;
        int i;
        this.m_aWarnings.clear();
        this.m_iCharacterCounter = 0;
        this.m_iLineCount = 0;
        this.m_objSugar = new Sugar();
        this.m_aSpecialList.clear();
        int t_iLongestLine = 0;
        int t_iLineLength = 0;
        String t_strStructure = a_strStream.replace('\r', ' ');
        t_strStructure = t_strStructure.replaceAll("\t", "    ");
        this.m_aLines = t_strStructure.split("\n");
        this.m_iLineCount = this.m_aLines.length;
        for (i = 0; i < this.m_iLineCount; ++i) {
            t_iLineLength = this.m_aLines[i].length();
            if (t_iLongestLine >= t_iLineLength) continue;
            t_iLongestLine = t_iLineLength;
        }
        for (i = 0; i < this.m_iLineCount; ++i) {
            int n = i;
            this.m_aLines[n] = this.m_aLines[n] + this.createFillString(t_iLongestLine - this.m_aLines[i].length());
        }
        for (int x = t_iLongestLine - 1; x > -1; --x) {
            for (y = 0; y < this.m_iLineCount; ++y) {
                if (this.m_aLines[y].charAt(x) == ' ') continue;
                if (this.m_aLines[y].charAt(x) == '-') {
                    if (x < 4) {
                        throw new SugarImporterException("IUPAC2D000", x, y);
                    }
                    if (this.isCyclic()) {
                        Linkage t_objLinkage = new Linkage();
                        StructureSpecialInformation t_objSpezialInfo = new StructureSpecialInformation(null, t_objLinkage, null, this.m_objSugar);
                        this.m_aSpecialList.add(t_objSpezialInfo);
                        this.parseLeftLinkage(x, y, null, null, t_objLinkage, t_objSpezialInfo, this.m_objSugar);
                    } else {
                        SugarUnitRepeat t_objRepeat = new SugarUnitRepeat();
                        try {
                            this.m_objSugar.addNode(t_objRepeat);
                        }
                        catch (GlycoconjugateException e) {
                            throw new SugarImporterException("COMMON013", x, y);
                        }
                        int t_iMin = this.m_iMinRepeatCount;
                        int t_iMax = this.m_iMaxRepeatCount;
                        if (t_iMax == -2) {
                            t_iMax = -1;
                            this.m_aWarnings.add("max. number of repeat interval for outer repeat not set");
                        }
                        if (t_iMin == -2) {
                            t_iMin = -1;
                            this.m_aWarnings.add("min. number of repeat interval for outer repeat not set");
                        }
                        t_objRepeat.setMaxRepeatCount(this.m_iMaxRepeatCount);
                        t_objRepeat.setMinRepeatCount(this.m_iMinRepeatCount);
                        Linkage t_objLinkage = new Linkage();
                        StructureSpecialInformation t_objSpezialInfo = new StructureSpecialInformation(null, t_objLinkage, t_iMin, t_iMax, t_objRepeat, null, this.m_objSugar);
                        this.m_aSpecialList.add(t_objSpezialInfo);
                        this.parseLeftLinkage(x, y, null, null, t_objLinkage, t_objSpezialInfo, t_objRepeat);
                    }
                } else {
                    this.lookAround(x, y, null, null, null, this.m_objSugar, false, "");
                }
                x = -1;
                y = this.m_iLineCount;
            }
        }
        int t_iChars = 0;
        for (y = 0; y < this.m_iLineCount; ++y) {
            for (int x = 0; x < t_iLongestLine; ++x) {
                if (this.m_aLines[y].charAt(x) == ' ') continue;
                ++t_iChars;
            }
        }
        if (t_iChars != this.m_iCharacterCounter) {
            throw new SugarImporterException("IUPAC2D011", -1, -1);
        }
        Iterator<StructureSpecialInformation> t_iterSpezials = this.m_aSpecialList.iterator();
        while (t_iterSpezials.hasNext()) {
            if (t_iterSpezials.next().isClosed()) continue;
            throw new SugarImporterException("IUPAC2D012", -1, -1);
        }
        return this.m_objSugar;
    }

    private void lookAround(int a_iPosX, int a_iPosY, GlycoNode a_objParent, Linkage a_objParentLinkage, StructureSpecialInformation a_objSpezialinfo, GlycoGraph a_objGraph, boolean a_bLookingForTarget, String a_strResidueNamePart) throws SugarImporterException {
        int t_iHelper = 0;
        int t_iLine = 0;
        int t_iNameEnd = this.findName(a_iPosX, a_iPosY);
        this.m_iCharacterCounter += a_iPosX - t_iNameEnd + 1;
        UnvalidatedGlycoNode t_objResidue = new UnvalidatedGlycoNode();
        try {
            t_objResidue.setName(a_strResidueNamePart + this.m_aLines[a_iPosY].substring(t_iNameEnd, a_iPosX + 1));
            String t_strTemp = t_objResidue.getName();
            int t_iMax = t_strTemp.length();
            for (int t_iCounter = 0; t_iCounter < t_iMax; ++t_iCounter) {
                if (t_strTemp.charAt(t_iCounter) != ' ') continue;
                --this.m_iCharacterCounter;
            }
            a_objGraph.addNode(t_objResidue);
            if (a_objParent != null && a_objParentLinkage != null) {
                GlycoEdge t_objEdge = new GlycoEdge();
                t_objEdge.addGlycosidicLinkage(a_objParentLinkage);
                a_objGraph.addEdge(a_objParent, t_objResidue, t_objEdge);
            }
            if (a_bLookingForTarget) {
                a_objSpezialinfo.setTarget(t_objResidue);
            }
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("IUPAC2D010", a_iPosX, a_iPosY);
        }
        if (t_iNameEnd > 7 && this.m_aLines[a_iPosY].charAt(t_iNameEnd - 1) != ' ') {
            this.followLinkageBefore(t_iNameEnd - 1, a_iPosY, t_objResidue, a_objSpezialinfo, a_objGraph);
        }
        if (a_iPosY > 0) {
            t_iLine = a_iPosY - 1;
            for (t_iHelper = t_iNameEnd; t_iHelper <= a_iPosX; ++t_iHelper) {
                if (this.m_aLines[t_iLine].charAt(t_iHelper) != '|') continue;
                this.followLinkageAbove(t_iHelper, t_iLine, t_objResidue, a_objSpezialinfo, a_objGraph);
            }
        }
        if (a_iPosY < this.m_iLineCount - 2) {
            t_iLine = a_iPosY + 1;
            for (t_iHelper = t_iNameEnd; t_iHelper <= a_iPosX; ++t_iHelper) {
                if (this.m_aLines[t_iLine].charAt(t_iHelper) != '|') continue;
                this.followLinkageBelow(t_iHelper, t_iLine, t_objResidue, a_objSpezialinfo, a_objGraph);
            }
        }
    }

    private String createFillString(int a_iCount) {
        String t_strResult = "";
        for (int i = 0; i < a_iCount; ++i) {
            t_strResult = t_strResult + " ";
        }
        return t_strResult;
    }

    private void followLinkageBefore(int a_iPosX, int a_iPosY, GlycoNode a_objParent, StructureSpecialInformation a_objSpezialinfo, GlycoGraph a_objGraph) throws SugarImporterException {
        int t_iX = a_iPosX;
        if (this.m_aLines[a_iPosY].charAt(t_iX) != '-') {
            throw new SugarImporterException("IUPAC2D001", t_iX, a_iPosY);
        }
        ++this.m_iCharacterCounter;
        this.parseStartLinkage(--t_iX, a_iPosY, a_objParent, a_objSpezialinfo, a_objGraph);
    }

    private void followLinkageAbove(int a_iPosX, int a_iPosY, GlycoNode a_objParent, StructureSpecialInformation a_objSpezialinfo, GlycoGraph a_objGraph) throws SugarImporterException {
        int t_iX = a_iPosX;
        int t_iY = a_iPosY;
        do {
            if (this.m_aLines[t_iY].charAt(t_iX) != '|') {
                throw new SugarImporterException("IUPAC2D002", t_iX, t_iY);
            }
            ++this.m_iCharacterCounter;
            if (--t_iY >= 0) continue;
            throw new SugarImporterException("IUPAC2D003", t_iX, t_iY);
        } while (this.m_aLines[t_iY].charAt(t_iX) != '+');
        if (--t_iX < 0) {
            throw new SugarImporterException("IUPAC2D004", t_iX, a_iPosY);
        }
        ++this.m_iCharacterCounter;
        this.parseStartLinkage(t_iX, t_iY, a_objParent, a_objSpezialinfo, a_objGraph);
    }

    private void followLinkageBelow(int a_iPosX, int a_iPosY, GlycoNode a_objParent, StructureSpecialInformation a_objSpezialinfo, GlycoGraph a_objGraph) throws SugarImporterException {
        int t_iX = a_iPosX;
        int t_iY = a_iPosY;
        do {
            if (this.m_aLines[t_iY].charAt(t_iX) != '|') {
                throw new SugarImporterException("IUPAC2D002", t_iX, t_iY);
            }
            ++this.m_iCharacterCounter;
            if (++t_iY < this.m_iLineCount) continue;
            throw new SugarImporterException("IUPAC2D003", t_iX, t_iY);
        } while (this.m_aLines[t_iY].charAt(t_iX) != '+');
        if (--t_iX < 0) {
            throw new SugarImporterException("IUPAC2D004", t_iX, t_iY);
        }
        ++this.m_iCharacterCounter;
        this.parseStartLinkage(t_iX, t_iY, a_objParent, a_objSpezialinfo, a_objGraph);
    }

    private int findName(int a_iPosX, int a_iPosY) {
        int t_iX = a_iPosX;
        boolean t_bCharakter = false;
        int t_cSign = 32;
        int t_iSign = 0;
        do {
            t_iSign = t_cSign = (int)this.m_aLines[a_iPosY].charAt(t_iX);
            t_bCharakter = false;
            if (t_cSign >= 65 && t_cSign <= 90) {
                t_bCharakter = true;
            } else if (t_cSign >= 97 && t_cSign <= 122) {
                t_bCharakter = true;
            } else if (t_iSign > 47 && t_iSign < 58) {
                t_bCharakter = true;
            } else if (t_cSign == 63 || t_cSign == 47) {
                t_bCharakter = true;
            } else if (t_cSign == 44 || t_cSign == 46) {
                t_bCharakter = true;
            } else if (t_cSign >= 48 && t_cSign <= 57) {
                t_bCharakter = true;
            } else if (t_cSign == 60 || t_cSign == 62) {
                t_bCharakter = true;
            } else if (t_cSign == 91 || t_cSign == 93) {
                t_bCharakter = true;
            } else if (t_cSign == 40 || t_cSign == 41) {
                t_bCharakter = true;
            } else if (t_cSign == 39 || t_cSign == 58) {
                t_bCharakter = true;
            } else if (t_cSign == 43 || t_cSign == 61) {
                t_bCharakter = true;
            } else if (t_cSign == 59 || t_cSign == 95) {
                t_bCharakter = true;
            } else if (t_cSign == 45) {
                if (t_iX < 1) {
                    t_bCharakter = true;
                } else if (this.m_aLines[a_iPosY].charAt(t_iX - 1) != ')') {
                    t_bCharakter = true;
                } else if (t_iX < 2) {
                    t_bCharakter = true;
                } else {
                    char t_iDigit = this.m_aLines[a_iPosY].charAt(t_iX - 2);
                    if (t_iDigit > '/' && t_iDigit < ':' || this.m_aLines[a_iPosY].charAt(t_iX - 2) == '?') {
                        if (t_iX < 3) {
                            t_bCharakter = true;
                        } else {
                            t_iDigit = this.m_aLines[a_iPosY].charAt(t_iX - 3);
                            t_bCharakter = this.m_aLines[a_iPosY].charAt(t_iX - 3) == '(' ? true : (t_iDigit > '/' && t_iDigit < ':' ? (t_iX < 4 ? false : this.m_aLines[a_iPosY].charAt(t_iX - 4) == '(') : false);
                        }
                    } else {
                        t_bCharakter = this.m_aLines[a_iPosY].charAt(t_iX - 2) == '\'' || this.m_aLines[a_iPosY].charAt(t_iX - 2) == '\"' ? false : (this.m_aLines[a_iPosY].charAt(t_iX - 2) == '?' || this.m_aLines[a_iPosY].charAt(t_iX - 2) == 'O' || this.m_aLines[a_iPosY].charAt(t_iX - 2) == 'N' || this.m_aLines[a_iPosY].charAt(t_iX - 2) == 'S' ? (t_iX < 3 ? true : this.m_aLines[a_iPosY].charAt(t_iX - 3) != '-' && (this.m_aLines[a_iPosY].charAt(t_iX - 2) != 'O' || this.m_aLines[a_iPosY].charAt(t_iX - 3) != '[')) : true);
                    }
                }
            } else if (t_cSign == 32 && t_iX > 0 && this.m_aLines[a_iPosY].charAt(t_iX - 1) != ' ' && this.m_aLines[a_iPosY].charAt(t_iX - 1) != '+' && this.m_aLines[a_iPosY].charAt(t_iX - 1) != '|') {
                t_bCharakter = true;
            }
            if (--t_iX != -1) continue;
            if (t_bCharakter) {
                --t_iX;
            }
            t_bCharakter = false;
        } while (t_bCharakter);
        return t_iX + 2;
    }

    private void parseStartLinkage(int a_iX, int a_iY, GlycoNode a_objParent, StructureSpecialInformation a_objSpezialinfo, GlycoGraph a_objGraph) throws SugarImporterException {
        int t_iY = a_iY;
        int t_iX = a_iX;
        if (this.m_aLines[t_iY].charAt(t_iX) != ')') {
            throw new SugarImporterException("IUPAC2D005", t_iX, t_iY);
        }
        if (--t_iX < 0) {
            throw new SugarImporterException("IUPAC2D004", t_iX, t_iY);
        }
        ++this.m_iCharacterCounter;
        this.parseRightLinkage(t_iX, t_iY, a_objParent, a_objSpezialinfo, a_objGraph);
    }

    private void parseEndLinkage(int a_iPosX, int a_iPosY, GlycoNode a_objParent, Linkage a_objParentLinkage, StructureSpecialInformation a_objSpezial, GlycoGraph a_objGraph, String a_strChildResidueNameEnd, boolean a_bLookingForTarget) throws SugarImporterException {
        if (a_iPosX < 0) {
            throw new SugarImporterException("IUPAC2D004", a_iPosX, a_iPosY);
        }
        if (this.m_aLines[a_iPosY].charAt(a_iPosX) != '(') {
            throw new SugarImporterException("IUPAC2D005", a_iPosX, a_iPosY);
        }
        if (--a_iPosX < 0) {
            throw new SugarImporterException("IUPAC2D004", a_iPosX, a_iPosY);
        }
        if (this.m_aLines[a_iPosY].charAt(a_iPosX) != '-') {
            throw new SugarImporterException("IUPAC2D005", a_iPosX, a_iPosY);
        }
        this.m_iCharacterCounter += 2;
        this.lookAround(--a_iPosX, a_iPosY, a_objParent, a_objParentLinkage, a_objSpezial, a_objGraph, a_bLookingForTarget, a_strChildResidueNameEnd);
    }

    private void parseLeftLinkage(int a_iPosX, int a_iPosY, GlycoNode a_objParent, Linkage a_objLinkageNormal, Linkage a_objLinkageStartRepeat, StructureSpecialInformation a_objSpezial, GlycoGraph a_objGraph) throws SugarImporterException {
        int t_iX = a_iPosX - 1;
        ++this.m_iCharacterCounter;
        int t_iY = a_iPosY;
        String t_strNamesRest = "";
        while (this.m_aLines[a_iPosY].charAt(t_iX) == '\'') {
            ++this.m_iCharacterCounter;
            if (--t_iX >= 0) continue;
            throw new SugarImporterException("IUPAC2D024", t_iX + 1, t_iY);
        }
        Linkage t_objLinkage = a_objLinkageStartRepeat;
        if (a_objLinkageStartRepeat == null) {
            t_objLinkage = a_objLinkageNormal;
        }
        try {
            if (t_iX < 1) {
                throw new SugarImporterException("IUPAC2D004", t_iX, t_iY);
            }
            if ((this.m_aLines[t_iY].charAt(t_iX) == 'O' || this.m_aLines[t_iY].charAt(t_iX) == 'S' || this.m_aLines[t_iY].charAt(t_iX) == 'N') && this.m_aLines[t_iY].charAt(t_iX - 1) == '(') {
                ++this.m_iCharacterCounter;
                t_objLinkage.addChildLinkage(1);
                String t_strAdd = "";
                if (this.m_aLines[t_iY].charAt(--t_iX) == 'O') {
                    t_strAdd = "O";
                }
                if (a_objLinkageStartRepeat == null) {
                    this.parseEndLinkage(t_iX, t_iY, a_objParent, t_objLinkage, a_objSpezial, a_objGraph, t_strAdd, false);
                } else {
                    this.parseEndLinkage(t_iX, t_iY, null, null, a_objSpezial, a_objGraph, t_strAdd, true);
                }
                return;
            }
            if ((this.m_aLines[t_iY].charAt(t_iX) == 't' || this.m_aLines[t_iY].charAt(t_iX) == 'c') && t_iX > 4) {
                String t_strPart = this.m_aLines[t_iY].substring(t_iX - 5, t_iX + 1);
                if (t_strPart.toLowerCase().equalsIgnoreCase("repeat")) {
                    if (a_objLinkageStartRepeat != null) {
                        throw new SugarImporterException("IUPAC2D023", t_iX, t_iY);
                    }
                    if (a_objSpezial == null) {
                        throw new SugarImporterException("IUPAC2D015", a_iPosX, a_iPosY);
                    }
                    if (a_objSpezial.getType() != 2) {
                        throw new SugarImporterException("IUPAC2D015", a_iPosX, a_iPosY);
                    }
                    this.m_iCharacterCounter += 6;
                    if ((t_iX -= 6) > -1 && this.m_aLines[t_iY].charAt(t_iX) != ' ') {
                        throw new SugarImporterException("IUPAC2D006", t_iX, t_iY);
                    }
                    Linkage t_objInternal = a_objSpezial.getIncomingLinkage();
                    t_objInternal.setParentLinkages(t_objLinkage.getParentLinkages());
                    GlycoEdge t_objEdge = new GlycoEdge();
                    t_objEdge.addGlycosidicLinkage(t_objInternal);
                    SugarUnitRepeat t_objRepeat = a_objSpezial.getRepeatBlock();
                    t_objRepeat.setRepeatLinkage(t_objEdge, a_objParent, a_objSpezial.getTarget());
                    t_objRepeat.setMinRepeatCount(a_objSpezial.getRepeatCountMin());
                    t_objRepeat.setMaxRepeatCount(a_objSpezial.getRepeatCountMax());
                    if (a_objSpezial.isClosed()) {
                        throw new SugarImporterException("IUPAC2D015", t_iX, t_iY);
                    }
                    a_objSpezial.close();
                    return;
                }
                if (t_strPart.toLowerCase().equalsIgnoreCase("cyclic")) {
                    if (a_objLinkageStartRepeat != null) {
                        throw new SugarImporterException("IUPAC2D023", t_iX, t_iY);
                    }
                    if (a_objSpezial == null) {
                        throw new SugarImporterException("IUPAC2D016", a_iPosX, a_iPosY);
                    }
                    if (a_objSpezial.getType() != 1) {
                        throw new SugarImporterException("IUPAC2D016", a_iPosX, a_iPosY);
                    }
                    this.m_iCharacterCounter += 6;
                    if ((t_iX -= 6) > -1 && this.m_aLines[t_iY].charAt(t_iX) != ' ') {
                        throw new SugarImporterException("IUPAC2D007", t_iX, t_iY);
                    }
                    GlycoEdge t_objEdge = new GlycoEdge();
                    Linkage t_objCyclic = a_objSpezial.getIncomingLinkage();
                    t_objCyclic.setParentLinkages(t_objLinkage.getParentLinkages());
                    t_objEdge.addGlycosidicLinkage(t_objCyclic);
                    a_objGraph.addEdge(a_objParent, a_objSpezial.getTarget(), t_objEdge);
                    if (a_objSpezial.isClosed()) {
                        throw new SugarImporterException("IUPAC2D016", t_iX, t_iY);
                    }
                    a_objSpezial.close();
                    return;
                }
            }
            if (this.m_aLines[t_iY].charAt(t_iX) == ']') {
                throw new SugarImporterException("IUPAC2D020", t_iX, t_iY);
            }
            char t_iDigit = this.m_aLines[t_iY].charAt(t_iX);
            boolean t_bRepeat = false;
            String t_strRepeatSymbol = "";
            if ((t_iDigit < '0' || t_iDigit > '9') && this.m_aLines[t_iY].charAt(t_iX) != '?') {
                t_bRepeat = true;
                while (this.m_aLines[t_iY].charAt(t_iX) != ']') {
                    t_strRepeatSymbol = this.m_aLines[t_iY].charAt(t_iX) + t_strRepeatSymbol;
                    ++this.m_iCharacterCounter;
                    if (--t_iX >= 1) continue;
                    throw new SugarImporterException("IUPAC2D019", t_iX, t_iY);
                }
                ++this.m_iCharacterCounter;
                t_iDigit = this.m_aLines[t_iY].charAt(--t_iX);
            }
            if (this.m_aLines[t_iY].charAt(t_iX) == '?') {
                t_objLinkage.addChildLinkage(-1);
                --t_iX;
                ++this.m_iCharacterCounter;
            } else if (this.m_aLines[t_iY].charAt(t_iX) == 'O') {
                t_objLinkage.addChildLinkage(1);
                --t_iX;
                ++this.m_iCharacterCounter;
                t_strNamesRest = "O";
            } else {
                if (t_iDigit < '0' || t_iDigit > '9') {
                    throw new SugarImporterException("IUPAC2D019", t_iX, t_iY);
                }
                int t_iNumber = 0;
                while (t_iDigit >= '0' && t_iDigit <= '9') {
                    t_iNumber = 10 * t_iNumber + (t_iDigit - 48);
                    ++this.m_iCharacterCounter;
                    if (--t_iX >= 0) {
                        t_iDigit = this.m_aLines[t_iY].charAt(t_iX);
                        continue;
                    }
                    t_iDigit = '\u0000';
                }
                t_objLinkage.addChildLinkage(t_iNumber);
                while (this.m_aLines[t_iY].charAt(t_iX) == '/') {
                    ++this.m_iCharacterCounter;
                    if (--t_iX < 0) {
                        throw new SugarImporterException("IUPAC2D009", t_iX + 1, t_iY);
                    }
                    t_iDigit = this.m_aLines[t_iY].charAt(t_iX);
                    if (t_iDigit < '0' || t_iDigit > '9') {
                        throw new SugarImporterException("IUPAC2D009", t_iX, t_iY);
                    }
                    t_iNumber = 0;
                    while (t_iDigit >= '0' && t_iDigit <= '9') {
                        t_iNumber = 10 * t_iNumber + (t_iDigit - 48);
                        ++this.m_iCharacterCounter;
                        if (--t_iX >= 0) {
                            t_iDigit = this.m_aLines[t_iY].charAt(t_iX);
                            continue;
                        }
                        t_iDigit = '\u0000';
                    }
                    t_objLinkage.addChildLinkage(t_iNumber);
                }
            }
            if (t_bRepeat) {
                Integer t_iRepCountMin;
                SugarUnitRepeat t_objRepeat = new SugarUnitRepeat();
                a_objGraph.addNode(t_objRepeat);
                if (a_objLinkageStartRepeat == null) {
                    GlycoEdge t_objEdge = new GlycoEdge();
                    t_objEdge.addGlycosidicLinkage(t_objLinkage);
                    a_objGraph.addEdge(a_objParent, t_objRepeat, t_objEdge);
                } else {
                    a_objSpezial.setTarget(t_objRepeat);
                }
                if (t_strRepeatSymbol.length() > 1 && t_strRepeatSymbol.charAt(t_strRepeatSymbol.length() - 1) == 'x') {
                    t_strRepeatSymbol = t_strRepeatSymbol.substring(0, t_strRepeatSymbol.length() - 1);
                }
                if ((t_iRepCountMin = this.m_hashRepeatCountMin.get(t_strRepeatSymbol)) == null) {
                    t_iRepCountMin = -1;
                    this.m_aWarnings.add("min. number of repeat interval for inter repeat '" + t_strRepeatSymbol + "' not set");
                }
                t_objRepeat.setMinRepeatCount(t_iRepCountMin);
                Integer t_iRepCountMax = this.m_hashRepeatCountMax.get(t_strRepeatSymbol);
                if (t_iRepCountMax == null) {
                    t_iRepCountMax = -1;
                    this.m_aWarnings.add("max. number of repeat interval for inter repeat '" + t_strRepeatSymbol + "' not set");
                }
                t_objRepeat.setMaxRepeatCount(t_iRepCountMax);
                Linkage t_objLinkageNew = new Linkage();
                t_objLinkageNew.setChildLinkages(t_objLinkage.getChildLinkages());
                StructureSpecialInformation t_objSpezialInfo = new StructureSpecialInformation(null, t_objLinkageNew, t_iRepCountMin, t_iRepCountMax, t_objRepeat, a_objSpezial, a_objGraph);
                this.m_aSpecialList.add(t_objSpezialInfo);
                this.parseEndLinkage(t_iX, t_iY, null, null, t_objSpezialInfo, t_objRepeat, t_strNamesRest, true);
            } else if (a_objLinkageStartRepeat == null) {
                this.parseEndLinkage(t_iX, t_iY, a_objParent, t_objLinkage, a_objSpezial, a_objGraph, t_strNamesRest, false);
            } else {
                this.parseEndLinkage(t_iX, t_iY, null, null, a_objSpezial, a_objGraph, t_strNamesRest, true);
            }
            return;
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("COMMON013", t_iX, t_iY);
        }
    }

    private void parseRightLinkage(int a_iPosX, int a_iPosY, GlycoNode a_objParent, StructureSpecialInformation a_objSpezial, GlycoGraph a_objGraph) throws SugarImporterException {
        int t_iX = a_iPosX;
        int t_iY = a_iPosY;
        while (this.m_aLines[a_iPosY].charAt(t_iX) == '\'') {
            ++this.m_iCharacterCounter;
            if (--t_iX >= 0) continue;
            throw new SugarImporterException("IUPAC2D024", t_iX + 1, t_iY);
        }
        char t_iDigit = this.m_aLines[a_iPosY].charAt(t_iX);
        try {
            if (t_iDigit >= '0' && t_iDigit <= '9') {
                Linkage t_objLinkage = new Linkage();
                int t_iNumber = 0;
                while (t_iDigit >= '0' && t_iDigit <= '9') {
                    t_iNumber = 10 * t_iNumber + (t_iDigit - 48);
                    ++this.m_iCharacterCounter;
                    if (--t_iX < 0) {
                        t_objLinkage.addParentLinkage(t_iNumber);
                        this.parseLeftLinkage(t_iX, a_iPosY, a_objParent, t_objLinkage, null, a_objSpezial, a_objGraph);
                        return;
                    }
                    t_iDigit = this.m_aLines[t_iY].charAt(t_iX);
                }
                t_objLinkage.addParentLinkage(t_iNumber);
                while (this.m_aLines[t_iY].charAt(t_iX) == '/') {
                    ++this.m_iCharacterCounter;
                    if (--t_iX < 0) {
                        throw new SugarImporterException("IUPAC2D009", t_iX + 1, t_iY);
                    }
                    t_iDigit = this.m_aLines[t_iY].charAt(t_iX);
                    if (t_iDigit < '0' || t_iDigit > '9') {
                        throw new SugarImporterException("IUPAC2D009", t_iX, t_iY);
                    }
                    t_iNumber = 0;
                    while (t_iDigit >= '0' && t_iDigit <= '9') {
                        t_iNumber = 10 * t_iNumber + (t_iDigit - 48);
                        ++this.m_iCharacterCounter;
                        if (--t_iX < 0) {
                            t_objLinkage.addParentLinkage(t_iNumber);
                            this.parseLeftLinkage(t_iX, a_iPosY, a_objParent, t_objLinkage, null, a_objSpezial, a_objGraph);
                            return;
                        }
                        t_iDigit = this.m_aLines[t_iY].charAt(t_iX);
                    }
                    t_objLinkage.addParentLinkage(t_iNumber);
                }
                if (this.m_aLines[t_iY].charAt(t_iX) == '[') {
                    --t_iX;
                    ++this.m_iCharacterCounter;
                    if (a_objSpezial == null) {
                        throw new SugarImporterException("IUPAC2D014", a_iPosX, a_iPosY);
                    }
                    if (a_objSpezial.getType() != 2) {
                        throw new SugarImporterException("IUPAC2D014", a_iPosX, a_iPosY);
                    }
                    Linkage t_objInternal = a_objSpezial.getIncomingLinkage();
                    t_objInternal.setParentLinkages(t_objLinkage.getParentLinkages());
                    GlycoEdge t_objEdge = new GlycoEdge();
                    t_objEdge.addGlycosidicLinkage(t_objInternal);
                    SugarUnitRepeat t_objRepeat = a_objSpezial.getRepeatBlock();
                    t_objRepeat.setRepeatLinkage(t_objEdge, a_objParent, a_objSpezial.getTarget());
                    t_objRepeat.setMinRepeatCount(a_objSpezial.getRepeatCountMin());
                    t_objRepeat.setMaxRepeatCount(a_objSpezial.getRepeatCountMax());
                    if (a_objSpezial.isClosed()) {
                        throw new SugarImporterException("IUPAC2D021", a_iPosX, a_iPosY);
                    }
                    a_objSpezial.close();
                    this.parseLeftLinkage(t_iX, a_iPosY, t_objRepeat, t_objLinkage, null, a_objSpezial.getParentInfo(), a_objSpezial.getParentUnit());
                    return;
                }
                this.parseLeftLinkage(t_iX, a_iPosY, a_objParent, t_objLinkage, null, a_objSpezial, a_objGraph);
                return;
            }
            if (this.m_aLines[t_iY].charAt(t_iX) == '?') {
                ++this.m_iCharacterCounter;
                Linkage t_objLinkage = new Linkage();
                t_objLinkage.addParentLinkage(-1);
                if (--t_iX < 0) {
                    this.parseLeftLinkage(t_iX, a_iPosY, a_objParent, t_objLinkage, null, a_objSpezial, a_objGraph);
                }
                if (this.m_aLines[t_iY].charAt(t_iX) == '[') {
                    --t_iX;
                    ++this.m_iCharacterCounter;
                    if (a_objSpezial == null) {
                        throw new SugarImporterException("IUPAC2D014", a_iPosX, a_iPosY);
                    }
                    if (a_objSpezial.getType() != 2) {
                        throw new SugarImporterException("IUPAC2D014", a_iPosX, a_iPosY);
                    }
                    Linkage t_objInternal = a_objSpezial.getIncomingLinkage();
                    t_objInternal.setParentLinkages(t_objLinkage.getParentLinkages());
                    GlycoEdge t_objEdge = new GlycoEdge();
                    t_objEdge.addGlycosidicLinkage(t_objInternal);
                    SugarUnitRepeat t_objRepeat = a_objSpezial.getRepeatBlock();
                    t_objRepeat.setRepeatLinkage(t_objEdge, a_objParent, a_objSpezial.getTarget());
                    t_objRepeat.setMinRepeatCount(a_objSpezial.getRepeatCountMin());
                    t_objRepeat.setMaxRepeatCount(a_objSpezial.getRepeatCountMax());
                    if (a_objSpezial.isClosed()) {
                        throw new SugarImporterException("IUPAC2D021", a_iPosX, a_iPosY);
                    }
                    a_objSpezial.close();
                    this.parseLeftLinkage(t_iX, a_iPosY, t_objRepeat, t_objLinkage, null, a_objSpezial.getParentInfo(), a_objSpezial.getParentUnit());
                    return;
                }
                this.parseLeftLinkage(t_iX, a_iPosY, a_objParent, t_objLinkage, null, a_objSpezial, a_objGraph);
                return;
            }
            if (this.m_aLines[t_iY].charAt(t_iX) == 'O' || this.m_aLines[t_iY].charAt(t_iX) == 'S' || this.m_aLines[t_iY].charAt(t_iX) == 'N') {
                --t_iX;
                ++this.m_iCharacterCounter;
                if (a_objParent.getClass() != UnvalidatedGlycoNode.class) {
                    throw new SugarImporterException("IUPAC2D013", a_iPosX, a_iPosY);
                }
                UnvalidatedGlycoNode t_objNode = (UnvalidatedGlycoNode)a_objParent;
                if (this.m_aLines[t_iY].charAt(t_iX) == 'O') {
                    t_objNode.setName("O" + t_objNode.getName());
                }
                Linkage t_objLinkage = new Linkage();
                t_objLinkage.addParentLinkage(1);
                if (t_iX < 0) {
                    this.parseLeftLinkage(t_iX, a_iPosY, a_objParent, t_objLinkage, null, a_objSpezial, a_objGraph);
                    return;
                }
                if (this.m_aLines[t_iY].charAt(t_iX) == '[') {
                    --t_iX;
                    ++this.m_iCharacterCounter;
                    if (a_objSpezial == null) {
                        throw new SugarImporterException("IUPAC2D014", a_iPosX, a_iPosY);
                    }
                    if (a_objSpezial.getType() != 2) {
                        throw new SugarImporterException("IUPAC2D014", a_iPosX, a_iPosY);
                    }
                    Linkage t_objInternal = a_objSpezial.getIncomingLinkage();
                    t_objInternal.setParentLinkages(t_objLinkage.getParentLinkages());
                    GlycoEdge t_objEdge = new GlycoEdge();
                    t_objEdge.addGlycosidicLinkage(t_objInternal);
                    SugarUnitRepeat t_objRepeat = a_objSpezial.getRepeatBlock();
                    t_objRepeat.setRepeatLinkage(t_objEdge, a_objParent, a_objSpezial.getTarget());
                    t_objRepeat.setMinRepeatCount(a_objSpezial.getRepeatCountMin());
                    t_objRepeat.setMaxRepeatCount(a_objSpezial.getRepeatCountMax());
                    if (a_objSpezial.isClosed()) {
                        throw new SugarImporterException("IUPAC2D021", a_iPosX, a_iPosY);
                    }
                    a_objSpezial.close();
                    this.parseLeftLinkage(t_iX, a_iPosY, t_objRepeat, t_objLinkage, null, a_objSpezial.getParentInfo(), a_objSpezial.getParentUnit());
                    return;
                }
                this.parseLeftLinkage(t_iX, a_iPosY, a_objParent, t_objLinkage, null, a_objSpezial, a_objGraph);
                return;
            }
            throw new SugarImporterException("IUPAC2D008", a_iPosX, a_iPosY);
        }
        catch (GlycoconjugateException e) {
            throw new SugarImporterException("COMMON013", a_iPosX, a_iPosY);
        }
    }

    public void setMinRepeatCount(String a_strSymbol, int a_iCount) {
        if (a_strSymbol == null) {
            this.m_iMinRepeatCount = a_iCount;
        } else {
            this.m_hashRepeatCountMin.put(a_strSymbol, a_iCount);
        }
    }

    public void setMaxRepeatCount(String a_strSymbol, int a_iCount) {
        if (a_strSymbol == null) {
            this.m_iMaxRepeatCount = a_iCount;
        } else {
            this.m_hashRepeatCountMax.put(a_strSymbol, a_iCount);
        }
    }

    private boolean isCyclic() {
        for (int i = 0; i < this.m_iLineCount; ++i) {
            String t_strTemp = this.m_aLines[i].toLowerCase();
            if (t_strTemp.indexOf("cyclic") == -1) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> getWarnings() {
        return this.m_aWarnings;
    }

    public void clearRepeatCounts() {
        this.m_hashRepeatCountMax.clear();
        this.m_hashRepeatCountMin.clear();
        this.m_iMaxRepeatCount = -2;
        this.m_iMinRepeatCount = -2;
    }
}

