/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.datamodel.ms.annotation.glycan.preference;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.dmtranslate.DMGlycanAnnotation;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMFeature;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;

@XmlRootElement(name="msGlycanAnnotationViewerPreference")
public class MSGlycanAnnotationViewerPreference
extends MSAnnotationViewerPreference {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationViewerPreference.class);
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.datamodel.ms.annotation.glycan.preference.MSGlycanAnnotationViewerPreference";
    private static final String CURRENT_VERSION = "1.1";
    protected boolean bShowExtraInfo = false;

    public MSGlycanAnnotationViewerPreference() {
        this(0, FillTypes.Scans);
    }

    public MSGlycanAnnotationViewerPreference(int _iMSLevel, FillTypes fillType) {
        super(_iMSLevel, fillType);
    }

    public boolean getShowExtraInfo() {
        return this.bShowExtraInfo;
    }

    @XmlAttribute(name="showExtraInfo")
    public void setShowExtraInfo(boolean _bVal) {
        this.bShowExtraInfo = _bVal;
    }

    protected boolean excludeColumn(String _sColumnKey, String _sColumnLabel) {
        if (_sColumnKey.equals("gg.gch")) {
            return true;
        }
        if (_sColumnKey.equals(DMFeature.feature_charge.name()) && _sColumnLabel.equals(DMFeature.feature_charge.getLabel())) {
            return true;
        }
        return _sColumnKey.equals(DMGlycanAnnotation.glycan_annotation_composition.name());
    }

    protected static String getPreferenceID(int _iMSLevel, FillTypes fillType) {
        String sAdder = "";
        String sName = PREFERENCE_NAME_ALL;
        if (fillType == FillTypes.Scans) {
            sAdder = ".Scans";
        } else if (fillType == FillTypes.PeakList) {
            sAdder = ".Peaks";
        } else if (fillType == FillTypes.PeaksWithFeatures) {
            sAdder = ".PeaksWithFeatures";
        } else if (fillType == FillTypes.Selection) {
            sAdder = ".Selection";
        }
        sName = String.valueOf(sName) + sAdder;
        sName = String.valueOf(sName) + ".MSLevel" + (_iMSLevel - 1);
        return sName;
    }

    public static PreferenceEntity getPreferenceEntity(int _iMSLevel, FillTypes fillType) throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)MSGlycanAnnotationViewerPreference.getPreferenceID(_iMSLevel, fillType));
        return preferenceEntity;
    }

    protected String getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public boolean writePreference() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(MSGlycanAnnotationViewerPreference.getPreferenceID(this.getMSLevel(), this.getFillType()));
        preferenceEntity.setVersion(this.getCurrentVersion());
        preferenceEntity.setValue(this.marshalXML());
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }

    public GRITSColumnHeader getColumnHeader(String _sKey) {
        if (_sKey.equals(DMGlycanAnnotation.glycan_annotation_glycanId.name())) {
            return new GRITSColumnHeader(DMGlycanAnnotation.glycan_annotation_glycanId.getLabel(), DMGlycanAnnotation.glycan_annotation_glycanId.name());
        }
        if (_sKey.equals(DMGlycanAnnotation.glycan_annotation_glytoucanid.name())) {
            return new GRITSColumnHeader(DMGlycanAnnotation.glycan_annotation_glytoucanid.getLabel(), DMGlycanAnnotation.glycan_annotation_glytoucanid.name());
        }
        if (_sKey.equals(DMGlycanAnnotation.glycan_annotation_perDerivatisationType.name())) {
            return new GRITSColumnHeader(DMGlycanAnnotation.glycan_annotation_perDerivatisationType.getLabel(), DMGlycanAnnotation.glycan_annotation_perDerivatisationType.name());
        }
        if (_sKey.equals(DMGlycanAnnotation.glycan_annotation_sequenceGWB.name())) {
            return new GRITSColumnHeader(DMGlycanAnnotation.glycan_annotation_sequenceGWB.getLabel(), DMGlycanAnnotation.glycan_annotation_sequenceGWB.name());
        }
        if (_sKey.equals(DMGlycanAnnotation.glycan_annotation_glycancartoon.name())) {
            return new GRITSColumnHeader(DMGlycanAnnotation.glycan_annotation_glycancartoon.getLabel(), DMGlycanAnnotation.glycan_annotation_glycancartoon.name());
        }
        if (_sKey.equals(DMGlycanAnnotation.glycan_annotation_fragmentcartoon.name())) {
            return new GRITSColumnHeader(DMGlycanAnnotation.glycan_annotation_fragmentcartoon.getLabel(), DMGlycanAnnotation.glycan_annotation_fragmentcartoon.name());
        }
        return super.getColumnHeader(_sKey);
    }
}

