/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.util.Utils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Config
implements Cloneable {
    private static final String msTemplatesXmlDefaultFilename = "basetype_templates.xml";
    private static final String substituentTemplatesXmlDefaultFilename = "substituent_templates.xml";
    private static final String trivialnameTemplatesXmlDefaultFilename = "trivialname_templates.xml";
    private static final String aglyconTemplatesXmlDefaultFilename = "aglycon_templates.xml";
    private static final String elementsXmlDefaultFilename = "elements.xml";
    private static final String msDictionaryDefaultFilename = "ms_dictionary.xml";
    private String msDictionaryFilename = null;
    private boolean useMsDictionaryFromFileSystem = false;
    private boolean allowTrivialNames = true;
    private boolean forceTrivialNames = false;
    private boolean carboxylGroupsDeprotonated = false;
    private boolean preserveAlditolOrientation = false;
    private boolean buildMsDerivedData = false;
    private int printErrorMsgLevel = 0;
    private boolean configRead = false;
    private static Config globalConfig;

    public Config() {
    }

    public Config(String filename) throws ResourcesDbException {
        this.readConfigFile(filename);
    }

    public static synchronized Config getGlobalConfig() {
        if (globalConfig == null) {
            globalConfig = new Config();
        }
        return globalConfig;
    }

    public static synchronized void setGlobalConfig(Config globalConfig) {
        Config.globalConfig = globalConfig;
    }

    public URL getMonosaccharideTemplatesXmlUrl() {
        return Config.getMonosaccharideTemplatesDefaultXmlUrl();
    }

    public static URL getMonosaccharideTemplatesDefaultXmlUrl() {
        return Config.class.getResource("/basetype_templates.xml");
    }

    public URL getSubstituentTemplatesXmlUrl() {
        return Config.getSubstituentTemplatesDefaultXmlUrl();
    }

    public static URL getSubstituentTemplatesDefaultXmlUrl() {
        return Config.class.getResource("/substituent_templates.xml");
    }

    public URL getAglyconTemplatesXmlUrl() {
        return Config.getAglyconTemplatesDefaultXmlUrl();
    }

    public static URL getAglyconTemplatesDefaultXmlUrl() {
        return Config.class.getResource("/aglycon_templates.xml");
    }

    public URL getTrivialnameTemplatesXmlUrl() {
        return Config.getTrivialnameTemplatesDefaultXmlUrl();
    }

    public static URL getTrivialnameTemplatesDefaultXmlUrl() {
        return Config.class.getResource("/trivialname_templates.xml");
    }

    public URL getElementsXmlUrl() {
        return Config.getElementsDefaultXmlUrl();
    }

    public static URL getElementsDefaultXmlUrl() {
        return Config.class.getResource("/elements.xml");
    }

    public URL getMsDictionaryUrl() {
        URL dictUrl = null;
        if (this.useMsDictionaryFromFileSystem) {
            try {
                File dictFile = new File(this.getMsDictionaryFilename());
                dictUrl = dictFile.toURI().toURL();
            }
            catch (MalformedURLException mex) {
                System.err.println(mex);
            }
        } else {
            dictUrl = Config.class.getResource("/ms_dictionary.xml");
        }
        return dictUrl;
    }

    public String getMsDictionaryFilename() {
        return this.msDictionaryFilename;
    }

    public void setMsDictionaryFilename(String filename) {
        this.msDictionaryFilename = filename;
    }

    public boolean isUseMsDictionaryFromFileSystem() {
        return this.useMsDictionaryFromFileSystem;
    }

    public void setUseMsDictionaryFromFileSystem(boolean flag) {
        this.useMsDictionaryFromFileSystem = flag;
    }

    public boolean isAllowTrivialNames() {
        return this.allowTrivialNames;
    }

    public void setAllowTrivialNames(boolean flag) {
        this.allowTrivialNames = flag;
        if (!flag) {
            this.setForceTrivialNames(false);
        }
    }

    public boolean isForceTrivialNames() {
        return this.forceTrivialNames;
    }

    public void setForceTrivialNames(boolean flag) {
        this.forceTrivialNames = flag;
        if (flag) {
            this.setAllowTrivialNames(true);
        }
    }

    public boolean isCarboxylGroupsDeprotonated() {
        return this.carboxylGroupsDeprotonated;
    }

    public void setCarboxylGroupsDeprotonated(boolean carboxylGroupsDeprotonated) {
        this.carboxylGroupsDeprotonated = carboxylGroupsDeprotonated;
    }

    public boolean isPreserveAlditolOrientation() {
        return this.preserveAlditolOrientation;
    }

    public void setPreserveAlditolOrientation(boolean preserveAlditolOri) {
        this.preserveAlditolOrientation = preserveAlditolOri;
    }

    public boolean isBuildMsDerivedData() {
        return this.buildMsDerivedData;
    }

    public void setBuildMsDerivedData(boolean flag) {
        this.buildMsDerivedData = flag;
    }

    public boolean isPrintErrorMsgs() {
        return this.printErrorMsgLevel > 0;
    }

    public boolean isPrintErrorMsgs(int level) {
        return this.printErrorMsgLevel >= level;
    }

    public int getPrintErrorMsgLevel() {
        return this.printErrorMsgLevel;
    }

    public void setPrintErrorMsgLevel(int value) {
        this.printErrorMsgLevel = value;
    }

    public Config clone() {
        Config confClone = new Config();
        confClone.setAllowTrivialNames(this.isAllowTrivialNames());
        return confClone;
    }

    public void readConfigFile() throws ResourcesDbException {
        if (!this.configRead) {
            String filename = System.getenv("org.eurocarbdb.resourcedb.configfile");
            if (filename != null) {
                this.readConfigFile(filename);
                this.configRead = true;
            } else {
                throw new ResourcesDbException("Cannot get config filename from environment variable org.eurocarbdb.resourcedb.configfile");
            }
        }
    }

    public void readConfigFile(String filename) throws ResourcesDbException {
        SAXBuilder parser = new SAXBuilder();
        try {
            Document doc = parser.build(filename);
            Element root = doc.getRootElement();
            List configList = root.getChildren();
            for (Element xmlElement : configList) {
                if (xmlElement.getName().equals("file_locations")) continue;
                if (xmlElement.getName().equals("residue_parsing")) {
                    this.parseResidueParsingPart(xmlElement);
                    continue;
                }
                if (!xmlElement.getName().equals("residue_name_generation")) continue;
                this.parseResidueNameGenerationPart(xmlElement);
            }
        }
        catch (JDOMException je) {
            System.out.println("JDOMException: " + je.getMessage());
            throw new ResourcesDbException("Error reading config file: " + je.getMessage());
        }
        catch (IOException ie) {
            System.out.println("IOException: " + ie.getMessage());
            throw new ResourcesDbException("Error reading config file: " + ie.getMessage());
        }
    }

    private void parseResidueNameGenerationPart(Element currentElement) {
        List childrenList = currentElement.getChildren();
        for (Element childTag : childrenList) {
            if (!childTag.getName().equals("allow_trivial_names")) continue;
            this.setAllowTrivialNames(Utils.parseTrueFalseString(childTag.getValue(), true));
        }
    }

    private void parseResidueParsingPart(Element currentElement) {
        List childrenList = currentElement.getChildren();
        Iterator childrenIter = childrenList.iterator();
        while (childrenIter.hasNext()) {
        }
    }
}

