/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.widgets.tools.GRITSProcessStatus;
import org.grits.toolbox.widgets.tools.GRITSWorker;

public class MassSpecMultiPageViewerTableRefreshWorker
extends GRITSWorker {
    private static final Logger logger = Logger.getLogger(MassSpecMultiPageViewerTableRefreshWorker.class);
    protected int iMajorCount = 0;
    private MassSpecMultiPageViewer parentEditor = null;
    protected List<String> columnKeys = null;

    public MassSpecMultiPageViewerTableRefreshWorker(MassSpecMultiPageViewer parentEditor, List<String> columnKeys) {
        this.setParentEditor(parentEditor);
        this.columnKeys = columnKeys;
    }

    public int doWork() {
        this.iMajorCount = 0;
        this.updateListeners("Starting MassSpec work!", 2);
        int iSuccess = this.updateMSScansTab(this.iMajorCount);
        ++this.iMajorCount;
        if (iSuccess != GRITSProcessStatus.OK) {
            return iSuccess;
        }
        this.updateListeners("Finished MassSpec work!", this.iMajorCount);
        logger.debug((Object)"Finished MassSpec work");
        return iSuccess;
    }

    public MassSpecMultiPageViewer getParentEditor() {
        return this.parentEditor;
    }

    public void setParentEditor(MassSpecMultiPageViewer parentEditor) {
        this.parentEditor = parentEditor;
    }

    public int updateMSScansTab(int iProcessCount) {
        try {
            this.updateListeners("Updating MS Scans tab (loading)", iProcessCount);
            this.getParentEditor().reInitScansView(this.columnKeys);
            this.updateListeners("Updating MS Scans tab (done)", iProcessCount + 1);
            return GRITSProcessStatus.OK;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to update MS Scans view", (Throwable)e);
            return GRITSProcessStatus.ERROR;
        }
    }
}

