/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandToLevelCommand;

public class TreeExpandToLevelCommandHandler
extends AbstractLayerCommandHandler<TreeExpandToLevelCommand> {
    private final TreeLayer treeLayer;

    public TreeExpandToLevelCommandHandler(TreeLayer treeLayer) {
        this.treeLayer = treeLayer;
    }

    @Override
    public boolean doCommand(TreeExpandToLevelCommand command) {
        if (command.getParentIndex() == null) {
            this.treeLayer.expandAllToLevel(command.getLevel());
        } else {
            this.treeLayer.expandTreeRowToLevel(command.getParentIndex(), command.getLevel());
        }
        return true;
    }

    @Override
    public Class<TreeExpandToLevelCommand> getCommandClass() {
        return TreeExpandToLevelCommand.class;
    }
}

