/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.entry.qrtpcr.Config;
import org.grits.toolbox.entry.qrtpcr.model.GeneList;
import org.grits.toolbox.entry.qrtpcr.model.PlateLayout;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRRun;
import org.grits.toolbox.entry.qrtpcr.util.GeneUtils;

public class FileUtils {
    @Inject
    @Named(value="workspace_location")
    private static String workspaceLocation;
    @Inject
    @Named(value="configuration_location")
    private static String configLocation;

    public static QrtPCRRun loadQrtPCRRun(Entry entry, String filename) throws FileNotFoundException, UnsupportedEncodingException, JAXBException {
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + entry.getParent().getParent().getDisplayName();
        String qrtPCRFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "qrtPCR";
        String fileLocation = String.valueOf(qrtPCRFolderLocation) + File.separator + filename;
        File qrtPCRFile = new File(fileLocation);
        FileInputStream inputStream = new FileInputStream(qrtPCRFile.getAbsolutePath());
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{QrtPCRRun.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        QrtPCRRun run = (QrtPCRRun)unmarshaller.unmarshal((Reader)reader);
        return run;
    }

    public static void saveQrtPCRRun(QrtPCRRun run, String fileLocation) throws IOException, JAXBException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{QrtPCRRun.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.marshal((Object)run, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(fileLocation);
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
    }

    public static String copyFileIntoWorkspace(Entry entry, String filename) throws IOException {
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project");
        String qrtPCRFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "qrtPCR";
        String fileFolderLocation = String.valueOf(qrtPCRFolderLocation) + File.separator + "files";
        File fileFolder = new File(fileFolderLocation);
        if (!fileFolder.exists()) {
            fileFolder.mkdirs();
        }
        File originalFile = new File(filename);
        File destinationFile = new File(String.valueOf(fileFolderLocation) + File.separator + originalFile.getName());
        while (destinationFile.exists()) {
            String file = FileUtils.generateUniqueFileName(destinationFile.getName(), fileFolder.list());
            destinationFile = new File(String.valueOf(fileFolderLocation) + File.separator + file);
        }
        FileOutputStream workspaceFile = new FileOutputStream(destinationFile);
        Files.copy(originalFile.toPath(), workspaceFile);
        workspaceFile.close();
        return destinationFile.getName();
    }

    public static String getFileFolder(Entry entry) {
        String projectFolderLocation = String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project");
        String qrtPCRFolderLocation = String.valueOf(projectFolderLocation) + File.separator + "qrtPCR";
        String fileFolderLocation = String.valueOf(qrtPCRFolderLocation) + File.separator + "files";
        return fileFolderLocation;
    }

    public static String generateUniqueFileName(String filename, String[] existingNames) {
        if (filename != null) {
            int i;
            String name = filename;
            String extension = "";
            if (filename.contains(".")) {
                extension = filename.substring(filename.lastIndexOf("."));
                name = filename.substring(0, filename.lastIndexOf("."));
            }
            if ((i = name.indexOf("(")) != -1) {
                String counter = name.substring(i + 1, name.indexOf(")"));
                int count = Integer.parseInt(counter);
                String newFilename = name.substring(0, name.indexOf("("));
                newFilename = String.valueOf(newFilename) + "(" + ++count + ")";
                newFilename = String.valueOf(newFilename) + extension;
                return newFilename;
            }
            String newFilename = "";
            int count = 1;
            do {
                newFilename = String.valueOf(name) + "(" + count + ")";
                newFilename = String.valueOf(newFilename) + extension;
                ++count;
            } while (Arrays.asList(existingNames).contains(newFilename));
            return newFilename;
        }
        return null;
    }

    public static void copyMasterGeneListsFromJar() throws IOException {
        URL resourceFileUrl;
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        File configFolder = new File(configFolderLocation);
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if ((resourceFileUrl = FileLocator.toFileURL((URL)Config.FILE_URL)) == null) {
            throw new IOException("There are no master gene lists defined in GRITS!");
        }
        String originalJarFilePath = resourceFileUrl.getPath();
        File originalJarFile = new File(originalJarFilePath);
        if (originalJarFile.isDirectory()) {
            File[] files;
            File[] fileArray = files = originalJarFile.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                FileOutputStream configFile = new FileOutputStream(String.valueOf(configFolderLocation) + File.separator + file.getName());
                Files.copy(file.toPath(), configFile);
                configFile.close();
                ++n2;
            }
        }
    }

    public static String saveGeneSubListFile(GeneList geneList) throws IOException, JAXBException {
        String sublistFolderLocation;
        File sublistFolder;
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        File configFolder = new File(configFolderLocation);
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(sublistFolder = new File(sublistFolderLocation = String.valueOf(configFolderLocation) + File.separator + "sub-lists")).exists()) {
            sublistFolder.mkdirs();
        }
        String filename = FileUtils.generateUniqueFileName(geneList.getListName(), sublistFolder.list());
        GeneUtils.cleanUpGenesForMasterGeneList(geneList);
        geneList.setFilename(filename);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneList.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)geneList, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(String.valueOf(sublistFolderLocation) + File.separator + filename + ".xml");
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
        return String.valueOf(filename) + ".xml";
    }

    public static String saveMasterGeneListFile(GeneList geneList) throws IOException, JAXBException {
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        File configFolder = new File(configFolderLocation);
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        String filename = FileUtils.generateUniqueFileName(geneList.getListName(), configFolder.list());
        GeneUtils.cleanUpGenesForMasterGeneList(geneList);
        geneList.setFilename(filename);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneList.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)geneList, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(String.valueOf(configFolderLocation) + File.separator + filename + ".xml");
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
        return String.valueOf(filename) + ".xml";
    }

    public static GeneList importAndLoadGeneListFile(String filePath, boolean sublist) throws IOException, JAXBException {
        File originalFile;
        File configFolder;
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        if (sublist) {
            configFolderLocation = String.valueOf(configFolderLocation) + File.separator + "sub-lists";
        }
        if (!(configFolder = new File(configFolderLocation)).exists()) {
            configFolder.mkdirs();
        }
        if (!(originalFile = new File(filePath)).exists()) {
            throw new IOException("The file path is not valid. The file " + filePath + " does not exists");
        }
        FileInputStream inputStream = new FileInputStream(originalFile.getAbsolutePath());
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneList.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        GeneList geneList = (GeneList)unmarshaller.unmarshal((Reader)reader);
        String newFileName = FileUtils.generateUniqueFileName(originalFile.getName(), configFolder.list());
        FileOutputStream configFile = new FileOutputStream(String.valueOf(configFolderLocation) + File.separator + newFileName);
        Files.copy(originalFile.toPath(), configFile);
        configFile.close();
        return geneList;
    }

    public static void downloadFile(String file, String newPath, boolean sublist) throws IOException {
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        if (sublist) {
            configFolderLocation = String.valueOf(configFolderLocation) + File.separator + "sub-lists";
        }
        File masterListFile = new File(String.valueOf(configFolderLocation) + File.separator + file);
        FileOutputStream out = new FileOutputStream(newPath);
        Files.copy(masterListFile.toPath(), out);
        out.close();
    }

    public static void deleteFile(String file, boolean sublist) throws IOException {
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        if (sublist) {
            configFolderLocation = String.valueOf(configFolderLocation) + File.separator + "sub-lists";
        }
        File masterListFile = new File(String.valueOf(configFolderLocation) + File.separator + file);
        masterListFile.delete();
    }

    public static List<GeneList> getAllGeneLists(boolean sublist) throws IOException, JAXBException {
        ArrayList<GeneList> allGeneLists = new ArrayList<GeneList>();
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        if (sublist) {
            configFolderLocation = String.valueOf(configFolderLocation) + File.separator + "sub-lists";
        }
        File configFolder = new File(configFolderLocation);
        ArrayList<File> masterGeneListFiles = new ArrayList<File>();
        if (configFolder.exists()) {
            masterGeneListFiles.addAll(Arrays.asList(configFolder.listFiles()));
        }
        for (File file : masterGeneListFiles) {
            if (file.isDirectory() || file.isHidden()) continue;
            FileInputStream inputStream = new FileInputStream(file.getAbsolutePath());
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneList.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            GeneList geneList = (GeneList)unmarshaller.unmarshal((Reader)reader);
            allGeneLists.add(geneList);
        }
        return allGeneLists;
    }

    public static GeneList loadGeneListFile(String masterListFile, boolean sublist) throws IOException, JAXBException {
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        if (sublist) {
            configFolderLocation = String.valueOf(configFolderLocation) + File.separator + "sub-lists";
        }
        File configFolder = new File(configFolderLocation);
        File originalFile = new File(configFolder + File.separator + masterListFile);
        FileInputStream inputStream = new FileInputStream(originalFile.getAbsolutePath());
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GeneList.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        GeneList geneList = (GeneList)unmarshaller.unmarshal((Reader)reader);
        return geneList;
    }

    public static List<String> getAllPlateLayoutNames() {
        ArrayList<String> plateLayoutNames = new ArrayList<String>();
        try {
            List<PlateLayout> allLayouts = FileUtils.getAllPlateLayouts();
            for (PlateLayout plateLayout : allLayouts) {
                plateLayoutNames.add(plateLayout.getName());
            }
        }
        catch (IOException e) {
            Logger.getLogger(FileUtils.class).error((Object)"Error loading plate layout file", (Throwable)e);
        }
        return plateLayoutNames;
    }

    public static List<PlateLayout> getAllPlateLayouts() throws IOException {
        ArrayList<PlateLayout> allPlateLayouts = new ArrayList<PlateLayout>();
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr" + File.separator + "layouts";
        File configFolder = new File(configFolderLocation);
        ArrayList<File> plateLayoutFiles = new ArrayList<File>();
        if (configFolder.exists()) {
            plateLayoutFiles.addAll(Arrays.asList(configFolder.listFiles()));
        }
        for (File file : plateLayoutFiles) {
            if (file.isDirectory() || file.isHidden()) continue;
            try {
                FileInputStream inputStream = new FileInputStream(file.getAbsolutePath());
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PlateLayout.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                PlateLayout layout = (PlateLayout)unmarshaller.unmarshal((Reader)reader);
                allPlateLayouts.add(layout);
            }
            catch (JAXBException e) {
                Logger.getLogger(FileUtils.class).error((Object)"Invalid Plate Layout file. Skipping!", (Throwable)e);
            }
        }
        return allPlateLayouts;
    }

    public static String savePlateLayoutFile(PlateLayout layout) throws JAXBException, IOException {
        String configSubFolderLocation;
        File configSubFolder;
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        File configFolder = new File(configFolderLocation);
        if (!configFolder.exists()) {
            configFolder.mkdirs();
        }
        if (!(configSubFolder = new File(configSubFolderLocation = String.valueOf(configFolderLocation) + File.separator + "layouts")).exists()) {
            configSubFolder.mkdirs();
        }
        if (layout.getFilename() == null) {
            String filename = FileUtils.generateUniqueFileName(layout.getName(), configSubFolder.list());
            layout.setFilename(String.valueOf(filename) + ".xml");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PlateLayout.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)layout, (OutputStream)os);
        FileWriter fileWriter = new FileWriter(String.valueOf(configSubFolderLocation) + File.separator + layout.getFilename());
        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
        fileWriter.close();
        os.close();
        return layout.getFilename();
    }

    public static String getPlateLayoutFolder() {
        String configFolderLocation = String.valueOf(configLocation) + File.separator + "org.grits.toolbox.entry.qrtpcr";
        String configSubFolderLocation = String.valueOf(configFolderLocation) + File.separator + "layouts";
        return configSubFolderLocation;
    }
}

