/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.grits.toolbox.entry.qrtpcr.model.CtHistory;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.model.merge.MergeTableData;

public class PlateTableConfigLabelAccumulator
implements IConfigLabelAccumulator {
    private ListDataProvider<TableData> bodyDataProvider;
    Boolean rawData;
    Double lowerThreshold;
    Double stDevCutOff;
    Boolean masterTable = false;
    private IColumnPropertyAccessor<TableData> columnPropertyAccessor;

    public PlateTableConfigLabelAccumulator(ListDataProvider<TableData> bodyDataProvider2, IColumnPropertyAccessor<TableData> columnPropertyAccessor, Boolean rawData, Boolean masterTable, Double lowerThreshold, Double stDevCutOff) {
        this.bodyDataProvider = bodyDataProvider2;
        this.rawData = rawData;
        this.lowerThreshold = lowerThreshold;
        this.stDevCutOff = stDevCutOff;
        this.columnPropertyAccessor = columnPropertyAccessor;
        this.masterTable = masterTable;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnIndex, int rowIndex) {
        TableData element = (TableData)this.bodyDataProvider.getRowObject(rowIndex);
        String columnName = this.getColumnProperty(columnIndex);
        if (columnName == null) {
            return;
        }
        switch (columnName) {
            case "Gene Identifier": {
                if (element instanceof Gene && !this.rawData.booleanValue()) {
                    if (this.masterTable.booleanValue()) {
                        if (((Gene)element).getRunId() > 0) {
                            configLabels.addLabel("greenBackground");
                        }
                    } else if (((Gene)element).getShouldRerun().booleanValue()) {
                        configLabels.addLabel("redBackground");
                    }
                }
                if (element instanceof Gene && ((Gene)element).getIsControl().booleanValue()) {
                    configLabels.addLabel("boldFont");
                }
                if (!(element instanceof MergeTableData) || ((MergeTableData)element).getGene().getRunId() <= 0) break;
                configLabels.addLabel("greenBackground");
                break;
            }
            case "ct0": {
                List<CtHistory> prev;
                Double ct0;
                if (element instanceof GeneData && !this.rawData.booleanValue()) {
                    if (((GeneData)element).isEliminated().booleanValue()) {
                        configLabels.addLabel("strikeThrough");
                    } else {
                        configLabels.addLabel("editable");
                    }
                }
                if (element instanceof GeneData && !this.rawData.booleanValue() && (ct0 = ((GeneData)element).getCt()) != null) {
                    List<CtHistory> prev2 = ((GeneData)element).getPreviousValues();
                    if (prev2 != null && !prev2.isEmpty() && prev2.get(0) != null && prev2.get(0).getCt() == null) {
                        configLabels.addLabel("darkRedForeground");
                    } else if (ct0 >= this.lowerThreshold) {
                        configLabels.addLabel("redForeground");
                    }
                }
                if (!(element instanceof GeneData) || this.rawData.booleanValue() || ((GeneData)element).getPreviousValues() == null || ((GeneData)element).getPreviousValues().isEmpty() || (prev = ((GeneData)element).getPreviousValues()).size() == 1 && (prev.get(0) != null && prev.get(0).getCt() != null && prev.get(0).getCt() >= this.lowerThreshold || prev.get(0) != null && prev.get(0).getCt() == null)) break;
                configLabels.addLabel("magentaBackground");
                break;
            }
            case "StDev": {
                double stDev;
                if (!(element instanceof Gene) || this.rawData.booleanValue() || !((stDev = ((Gene)element).getStandardDeviation(0, this.lowerThreshold, false)) >= this.stDevCutOff)) break;
                configLabels.addLabel("redForeground");
                break;
            }
            case "Scaler": {
                configLabels.addLabel("listBackground");
                break;
            }
            case "Normalized": {
                configLabels.addLabel("yellowBackground");
            }
        }
    }

    public String getColumnProperty(int columnIndex) {
        return this.columnPropertyAccessor.getColumnProperty(columnIndex);
    }
}

