/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.LinearCode;

import java.util.ArrayList;
import java.util.HashMap;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.ExporterInterface;
import org.glycoinfo.GlycanFormatconverter.io.GlyCoExporterException;
import org.glycoinfo.GlycanFormatconverter.io.IUPAC.IUPACExporterUtility;
import org.glycoinfo.GlycanFormatconverter.io.LinearCode.LinearCodeNodeConverter;
import org.glycoinfo.GlycanFormatconverter.util.similarity.LinearCodeNodeSimilarity;
import org.glycoinfo.WURCSFramework.util.oldUtil.ConverterExchangeException;

public class LinearCodeExporter
extends IUPACExporterUtility
implements ExporterInterface {
    LinearCodeNodeSimilarity lcSim = new LinearCodeNodeSimilarity();
    HashMap<Node, String> LCMap = new HashMap();

    public String start(GlyContainer _glyCo) throws GlyCoExporterException, GlycanException, ConverterExchangeException {
        StringBuilder ret = new StringBuilder();
        for (Node node : _glyCo.getAllNodes()) {
            this.makeMonosaccharideNotation(node);
            this.makeLinkageNotation(node);
        }
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            if (!(und.getNodes().get(0) instanceof Substituent)) continue;
            this.makeSubstituentNotation(und);
        }
        this.makeFragmentsAnchor(_glyCo);
        ret.insert(0, this.makeSequence(this.lcSim.sortAllNode(_glyCo.getRootNodes().get(0))));
        String[] fragments = this.makeFragmentsSequence(_glyCo.getUndefinedUnit()).split("\\+");
        if (fragments.length > 0) {
            if (fragments[0].length() != 0) {
                ret.insert(0, fragments[0]);
            }
            if (fragments.length > 1) {
                ret.append(fragments[1]);
            }
        }
        return ret.toString();
    }

    @Override
    public String makeFragmentsSequence(ArrayList<GlycanUndefinedUnit> _fragments) throws GlycanException, GlyCoExporterException, ConverterExchangeException {
        StringBuilder ret = new StringBuilder();
        StringBuilder unknownLink = new StringBuilder();
        for (GlycanUndefinedUnit und : _fragments) {
            for (Node antennae : und.getRootNodes()) {
                ArrayList<Node> sortedFragments = this.lcSim.sortAllNode(antennae);
                String fragment = this.makeSequence(sortedFragments);
                if (fragment.indexOf("%") != -1) {
                    ret.insert(0, String.valueOf(fragment) + "|");
                    continue;
                }
                if (unknownLink.length() != 0) {
                    unknownLink.append(",");
                }
                fragment = fragment.replaceFirst("[ab?][\\d?]$", "");
                unknownLink.append(fragment);
            }
        }
        if (unknownLink.length() != 0) {
            unknownLink.insert(0, "&");
            unknownLink.append("&");
        }
        ret.append("+" + unknownLink);
        return ret.toString();
    }

    @Override
    public String makeSequence(ArrayList<Node> _nodes) throws GlyCoExporterException, GlycanException, ConverterExchangeException {
        int branch = 0;
        StringBuilder encode = new StringBuilder();
        for (Node skey : _nodes) {
            int numOfChildren;
            StringBuilder notation = new StringBuilder(this.LCMap.get(skey));
            if (this.lcSim.isSubBranch(skey)) {
                notation.append(")");
                ++branch;
            }
            if ((numOfChildren = this.lcSim.countChildren(skey)) == 0 && branch > 0) {
                notation.insert(0, "(");
                --branch;
            }
            encode.insert(0, notation);
        }
        return encode.toString();
    }

    @Override
    public void makeMonosaccharideNotation(Node _node) throws GlyCoExporterException, ConverterExchangeException, GlycanException {
        LinearCodeNodeConverter lcConv = new LinearCodeNodeConverter();
        this.LCMap.put(_node, lcConv.makeLCNotation(_node));
    }

    @Override
    public void makeLinkageNotation(Node _node) {
        for (Edge parentEdge : this.lcSim.sortParentSideEdges(_node.getParentEdges())) {
            if (parentEdge.isRepeat()) {
                this.LCMap.put(_node, String.valueOf(this.LCMap.get(_node)) + "}");
                continue;
            }
            if (parentEdge.isCyclic()) continue;
            for (Linkage lin : parentEdge.getGlycosidicLinkages()) {
                this.LCMap.put(_node, String.valueOf(this.LCMap.get(_node)) + this.makeLinkagePosition(lin.getParentLinkages()));
            }
        }
        for (Edge childEdge : _node.getChildEdges()) {
            Substituent sub = (Substituent)childEdge.getSubstituent();
            if (sub == null || !(sub instanceof GlycanRepeatModification)) continue;
            GlycanRepeatModification repMod = (GlycanRepeatModification)sub;
            this.LCMap.put(_node, "{" + this.makeRepeatingCount(repMod) + this.LCMap.get(_node));
        }
    }

    @Override
    public void makeFragmentsAnchor(GlyContainer _glyCo) throws GlycanException {
        for (GlycanUndefinedUnit und : _glyCo.getUndefinedUnit()) {
            String notation;
            if (this.extractPosition(und.getRootNodes().get(0).getParentEdge()).equals("?")) continue;
            int index = _glyCo.getUndefinedUnit().indexOf(und) + 1;
            for (Node antennae : und.getRootNodes()) {
                notation = this.LCMap.get(antennae);
                this.LCMap.put(antennae, String.valueOf(notation) + "=" + index + "%");
            }
            for (Node parent : und.getParents()) {
                notation = this.LCMap.get(parent);
                this.LCMap.put(parent, String.valueOf(index) + "%" + (index > 1 ? "/" : "") + notation);
            }
        }
    }

    @Override
    public String makeComposition(GlyContainer _glyCo) {
        return null;
    }

    @Override
    public void makeSubstituentNotation(GlycanUndefinedUnit _und) {
        Node sub = _und.getNodes().get(0);
        if (!(sub instanceof Substituent)) {
            return;
        }
        if (!this.LCMap.containsKey(sub)) {
            String subNotation = ((Substituent)sub).getSubstituent().getIUPACnotation();
            subNotation = String.valueOf(this.extractPosition(_und.getConnection().getGlycosidicLinkages().get(0).getParentLinkages())) + subNotation;
            this.LCMap.put(sub, subNotation);
        }
    }
}

