/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.GlycanFormatconverter.Glycan.AnomericStateDescriptor;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.SuperClass;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONEdgeParser;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONFragmentsParser;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONModificationParser;
import org.json.JSONArray;
import org.json.JSONObject;

public class GCJSONImporter {
    public GlyContainer start(String _json) throws GlycanException {
        JSONObject glycan = new JSONObject(_json);
        JSONObject monosaccharides = glycan.getJSONObject("Monosaccharides");
        HashMap<String, Node> nodeIndex = this.openMonosaccharides(monosaccharides);
        GCJSONEdgeParser gcEdgeParser = new GCJSONEdgeParser(nodeIndex);
        GlyContainer ret = gcEdgeParser.parseEdge(monosaccharides);
        GCJSONFragmentsParser gcFragParser = new GCJSONFragmentsParser(nodeIndex);
        for (GlycanUndefinedUnit und : gcFragParser.parseSubFragments(glycan.getJSONObject("SubFragments"))) {
            ret.addGlycanUndefinedUnit(und);
        }
        return ret;
    }

    public HashMap<String, Node> openMonosaccharides(JSONObject _monosaccharides) throws GlycanException {
        HashMap<String, Node> ret = new HashMap<String, Node>();
        for (String unit : _monosaccharides.keySet()) {
            JSONObject monosaccharide = _monosaccharides.getJSONObject(unit);
            ret.put(unit, this.parseMonosaccharide(monosaccharide));
        }
        return ret;
    }

    public Node parseMonosaccharide(JSONObject _monosaccharide) throws GlycanException {
        Monosaccharide ret = new Monosaccharide();
        GCJSONModificationParser gcModParser = new GCJSONModificationParser();
        Iterator iterator = _monosaccharide.keySet().iterator();
        block20: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "AnomericPosition": {
                    ret.setAnomericPosition(_monosaccharide.getInt(key));
                    break;
                }
                case "AnomericSymbol": {
                    ret.setAnomer(this.parseAnomericState(_monosaccharide.getString(key)));
                    break;
                }
                case "Modifications": {
                    ret.setModification(gcModParser.parseModifications(_monosaccharide.getJSONArray(key)));
                    break;
                }
                case "RingEnd": {
                    ret.setRingEnd(_monosaccharide.getInt(key));
                    break;
                }
                case "RingStart": {
                    ret.setRingStart(_monosaccharide.getInt(key));
                    break;
                }
                case "SuperClass": {
                    ret.setSuperClass(this.parseSuperClass(_monosaccharide.getString(key)));
                    break;
                }
                case "Substituents": {
                    for (Edge edge : gcModParser.parseSubstituents(_monosaccharide.getJSONArray(key))) {
                        edge.setParent(ret);
                        ret.addChildEdge(edge);
                    }
                    continue block20;
                }
                case "TrivialName": {
                    ret.setStereos(this.parseTrivialNames(_monosaccharide.getJSONArray(key)));
                }
            }
        }
        return ret;
    }

    private AnomericStateDescriptor parseAnomericState(String _anomState) {
        AnomericStateDescriptor[] anomericStateDescriptorArray = AnomericStateDescriptor.values();
        int n = anomericStateDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnomericStateDescriptor value = anomericStateDescriptorArray[n2];
            if (_anomState.equals(value.toString())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    private SuperClass parseSuperClass(String _key) {
        SuperClass[] superClassArray = SuperClass.values();
        int n = superClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SuperClass value = superClassArray[n2];
            if (_key.equals(value.toString())) {
                return value;
            }
            ++n2;
        }
        return null;
    }

    private LinkedList<String> parseTrivialNames(JSONArray _trivialName) {
        LinkedList<String> ret = new LinkedList<String>();
        for (Object stereo : _trivialName) {
            ret.add(((String)stereo).toLowerCase());
        }
        return ret;
    }
}

