/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycanFeature;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.ms.om.data.GlycolipidAnnotation;
import org.grits.toolbox.ms.om.data.GlycolipidFeature;
import org.grits.toolbox.ms.om.data.LipidAnnotation;
import org.grits.toolbox.ms.om.data.LipidFeature;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.tools.gsl.dango.GlycanAnnotationUtils;
import org.grits.toolbox.tools.gsl.dango.GlycanMSAnnotator;
import org.grits.toolbox.tools.gsl.dango.IonCombinationGenerator;
import org.grits.toolbox.tools.gsl.dango.LipidAnnotationUtils;
import org.grits.toolbox.tools.gsl.dango.LipidMSAnnotator;
import org.grits.toolbox.tools.gsl.dango.MSAnnotatorAbstract;
import org.grits.toolbox.tools.gsl.dango.ScanReader;
import org.grits.toolbox.tools.gsl.structure.IonCombination;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;

public class GlycolipidMSAnnotator
extends MSAnnotatorAbstract {
    private static final Logger logger = Logger.getLogger(GlycolipidMSAnnotator.class);
    private static String GLYCAN = "Glycan";
    private static String LIPID = "Lipid";
    private static String GLYCOLIPID = "Glycolipid";
    private static final BigDecimal bdMassH2O = new BigDecimal(ChemicalComposition.parseFormula("H2O").getMonoisotopicMass());
    private static final BigDecimal bdMassCH2 = new BigDecimal(ChemicalComposition.parseFormula("CH2").getMonoisotopicMass());
    private GlycanMSAnnotator m_gAnnotor;
    private LipidMSAnnotator m_lAnnotor;

    public GlycolipidMSAnnotator(boolean a_bTrustMzCharge, boolean a_bIsMonoIsotopic, GlycanSettings a_gSet) {
        super(a_bTrustMzCharge, a_bIsMonoIsotopic);
        this.m_gAnnotor = new GlycanMSAnnotator(a_bTrustMzCharge, a_bIsMonoIsotopic, a_gSet);
        this.m_lAnnotor = new LipidMSAnnotator(a_bTrustMzCharge, a_bIsMonoIsotopic);
    }

    public void setIonCombinationsForGlycanFragments(List<IonCombination> a_lIonCombo) {
        this.m_gAnnotor.setIonCombinationsForFragments(a_lIonCombo);
    }

    public void setIonCombinationsForLipidFragments(List<IonCombination> a_lIonCombo) {
        this.m_lAnnotor.setIonCombinationsForFragments(a_lIonCombo);
    }

    @Override
    protected List<IonCombination> getIonCombinationsForFragments(String[] a_strFragInfo) {
        if (a_strFragInfo[0].equals(GLYCAN)) {
            return this.m_gAnnotor.getIonCombinationsForFragments(a_strFragInfo);
        }
        if (a_strFragInfo[0].equals(LIPID)) {
            return this.m_lAnnotor.getIonCombinationsForFragments(a_strFragInfo);
        }
        if (a_strFragInfo[0].equals(GLYCOLIPID)) {
            return super.getIonCombinationsForFragments(a_strFragInfo);
        }
        return new ArrayList<IonCombination>();
    }

    @Override
    protected BigDecimal calculateMass(Feature a_feature, String a_strPerDeriv) {
        if (a_feature instanceof GlycanFeature) {
            return this.calculateGlycanMass((GlycanFeature)a_feature, a_strPerDeriv);
        }
        if (a_feature instanceof LipidFeature) {
            return this.calculateLipidMass((LipidFeature)a_feature, a_strPerDeriv);
        }
        if (a_feature instanceof GlycolipidFeature) {
            GlycolipidFeature t_feature = (GlycolipidFeature)a_feature;
            GlycanFeature t_gFeature = new GlycanFeature();
            t_gFeature.setSequence(t_feature.getSequence());
            t_gFeature.setAnnotationId(a_feature.getAnnotationId());
            BigDecimal t_bdGMass = this.calculateGlycanMass(t_gFeature, a_strPerDeriv);
            if (GlycanAnnotationUtils.isPermethylated(a_strPerDeriv)) {
                t_bdGMass = t_bdGMass.subtract(bdMassCH2);
            }
            LipidFeature t_lFeature = new LipidFeature();
            t_lFeature.setLipidName(t_feature.getLipidName());
            t_lFeature.setAnnotationId(a_feature.getAnnotationId());
            t_lFeature.setFragmentType("Z");
            BigDecimal t_bdLMass = this.calculateLipidMass(t_lFeature, a_strPerDeriv);
            return t_bdGMass.add(t_bdLMass);
        }
        logger.error((Object)"Undefined Feature is specified in calculateMass");
        return null;
    }

    private BigDecimal calculateGlycanMass(GlycanFeature a_feature, String a_strPerDeriv) {
        BigDecimal t_bdMass = this.m_gAnnotor.calculateMass((Feature)a_feature, a_strPerDeriv);
        if (t_bdMass == null) {
            logger.warn((Object)("Glycan mass cannot be calculated: " + a_feature.getSequence()));
            return BigDecimal.ZERO;
        }
        return t_bdMass;
    }

    private BigDecimal calculateLipidMass(LipidFeature a_feature, String a_strPerDeriv) {
        BigDecimal t_bdMass = this.m_lAnnotor.calculateMass((Feature)a_feature, a_strPerDeriv);
        if (t_bdMass == null) {
            logger.warn((Object)("Lipid mass cannot be calculated: " + a_feature.getLipidName()));
            return BigDecimal.ZERO;
        }
        Annotation t_annotOrig = (Annotation)this.m_mapIDToAnnotation.get(a_feature.getAnnotationId());
        if (t_annotOrig != null && t_annotOrig instanceof GlycolipidAnnotation) {
            if (!LipidAnnotationUtils.canConnectToGlycan(a_feature.getLipidName())) {
                return t_bdMass;
            }
            if (a_feature.getFragmentType().startsWith("Z")) {
                t_bdMass = t_bdMass.subtract(bdMassH2O);
            }
            if (GlycanAnnotationUtils.isPermethylated(a_strPerDeriv)) {
                t_bdMass = t_bdMass.subtract(bdMassCH2);
            }
        }
        return t_bdMass;
    }

    @Override
    protected boolean findKeyFragments(ScanReader a_scanR, Annotation a_annot, IonCombination a_ionCombo) {
        if (a_annot instanceof GlycanAnnotation) {
            return this.m_gAnnotor.findKeyFragments(a_scanR, a_annot, a_ionCombo);
        }
        if (a_annot instanceof LipidAnnotation) {
            return this.m_lAnnotor.findKeyFragments(a_scanR, a_annot, a_ionCombo);
        }
        if (!(a_annot instanceof GlycolipidAnnotation)) {
            return false;
        }
        GlycolipidAnnotation t_annot = (GlycolipidAnnotation)a_annot;
        if (!t_annot.getPerDerivatisationType().equals(GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED)) {
            return true;
        }
        String[] t_strFragInfo = new String[]{"Glycan", t_annot.getGlycanAnnotation().getSequence(), "C"};
        GlycanFeature t_gFeature = (GlycanFeature)this.getFragmentFeature(t_annot.getId(), t_strFragInfo);
        BigDecimal t_bdGMass = this.calculateMass((Feature)t_gFeature, t_annot.getPerDerivatisationType());
        IonCombinationGenerator t_ionComboGen = new IonCombinationGenerator(a_ionCombo);
        t_ionComboGen.generate();
        for (IonCombination t_ionCombo : t_ionComboGen.getPossibleIonCombinations()) {
            BigDecimal t_bdMz = this.calculateIonizedMz(t_bdGMass, t_ionCombo);
            Peak t_peakMatchedG = a_scanR.getMatchedPeakForKeyFragment(t_bdMz);
            if (t_peakMatchedG == null) continue;
            return true;
        }
        String[] t_strFragInfoL = new String[]{"Lipid", t_annot.getLipidAnnotation().getSequence(), "Z"};
        LipidFeature t_lFeature = (LipidFeature)this.getFragmentFeature(t_annot.getId(), t_strFragInfoL);
        BigDecimal t_bdLMass = this.calculateMass((Feature)t_lFeature, t_annot.getPerDerivatisationType());
        IonCombination t_ionComboH = IonCombinationGenerator.getHydrogenIon();
        Peak t_peakMatchedL = a_scanR.getMatchedPeakForKeyFragment(t_bdLMass = this.calculateIonizedMz(t_bdLMass, t_ionComboH));
        return t_peakMatchedL != null;
    }

    @Override
    protected Feature getAnnotationFeature(Annotation a_annot) {
        if (a_annot instanceof GlycanAnnotation) {
            return this.m_gAnnotor.getAnnotationFeature(a_annot);
        }
        if (a_annot instanceof LipidAnnotation) {
            return this.m_lAnnotor.getAnnotationFeature(a_annot);
        }
        if (!(a_annot instanceof GlycolipidAnnotation)) {
            return null;
        }
        GlycolipidAnnotation t_annot = (GlycolipidAnnotation)a_annot;
        String[] t_strFragInfo = new String[]{GLYCOLIPID, t_annot.getGlycanAnnotation().getSequence(), t_annot.getLipidAnnotation().getSequence(), ""};
        return this.getFragmentFeature(a_annot.getId(), t_strFragInfo);
    }

    @Override
    protected List<String[]> getFragments(Feature a_featureParent, String a_strPerDeriv, int a_iMSLevel, String a_strActivationMethod) {
        if (a_featureParent instanceof GlycanFeature) {
            return this.getGlycanFragments((GlycanFeature)a_featureParent, a_strPerDeriv, a_iMSLevel, a_strActivationMethod);
        }
        if (a_featureParent instanceof LipidFeature) {
            return this.getLipidFragments((LipidFeature)a_featureParent, a_strPerDeriv, a_iMSLevel, a_strActivationMethod);
        }
        if (!(a_featureParent instanceof GlycolipidFeature)) {
            return null;
        }
        GlycolipidFeature t_featureParent = (GlycolipidFeature)a_featureParent;
        ArrayList<String[]> t_lFragInfo = new ArrayList<String[]>();
        GlycanFeature t_gFeature = new GlycanFeature();
        t_gFeature.setSequence(t_featureParent.getSequence());
        List<String[]> t_lGFragInfo = this.getGlycanFragments(t_gFeature, a_strPerDeriv, a_iMSLevel, a_strActivationMethod);
        LipidFeature t_lFeature = new LipidFeature();
        t_lFeature.setLipidName(t_featureParent.getLipidName());
        List<String[]> t_lLFragInfo = this.getLipidFragments(t_lFeature, a_strPerDeriv, a_iMSLevel, a_strActivationMethod);
        ArrayList<String[]> t_lFiltered = new ArrayList<String[]>();
        for (String[] t_LFragInfo : t_lLFragInfo) {
            if (!LipidAnnotationUtils.canConnectToGlycan(t_LFragInfo[1])) continue;
            t_lFiltered.add(t_LFragInfo);
        }
        t_lLFragInfo = t_lFiltered;
        if (this.m_gAnnotor.hasFragmentType("B", a_iMSLevel, a_strActivationMethod) || this.m_gAnnotor.hasFragmentType("C", a_iMSLevel, a_strActivationMethod)) {
            t_lFragInfo.addAll(t_lGFragInfo);
            t_lFragInfo.addAll(t_lLFragInfo);
        }
        ArrayList<String> t_lUsedGSeqs = new ArrayList<String>();
        for (String[] t_strGFragInfo0 : t_lGFragInfo) {
            if (!GlycanAnnotationUtils.canConnectReducingEnd(t_strGFragInfo0[1]) || t_lUsedGSeqs.contains(t_strGFragInfo0[1])) continue;
            String t_strGSeq = t_strGFragInfo0[1];
            t_lUsedGSeqs.add(t_strGSeq);
            String t_strGFragType = t_strGFragInfo0[2].substring(0, t_strGFragInfo0[2].length() - 1);
            ArrayList<String> t_lUsedLNames = new ArrayList<String>();
            for (String[] t_strLFragInfo0 : t_lLFragInfo) {
                if (!LipidAnnotationUtils.canConnectToGlycan(t_strLFragInfo0[1]) || t_lUsedLNames.contains(t_strLFragInfo0[1])) continue;
                String t_strLName = t_strLFragInfo0[1];
                t_lUsedLNames.add(t_strLName);
                String t_strLFragType = t_strLFragInfo0[2].substring(1, t_strLFragInfo0[2].length());
                String t_strGLFragType = String.valueOf(t_strGFragType) + t_strLFragType;
                String[] t_strGLFragInfo = new String[]{GLYCOLIPID, t_strGSeq, t_strLName, t_strGLFragType};
                t_lFragInfo.add(t_strGLFragInfo);
            }
        }
        return t_lFragInfo;
    }

    private List<String[]> getGlycanFragments(GlycanFeature a_featureParent, String a_strPerDeriv, int a_iMSLevel, String a_strActivationMethod) {
        Annotation t_annot = (Annotation)this.m_mapIDToAnnotation.get(a_featureParent.getAnnotationId());
        ArrayList<String[]> t_lFragInfo = new ArrayList<String[]>();
        for (String[] t_strGFragInfo0 : this.m_gAnnotor.getFragments((Feature)a_featureParent, a_strPerDeriv, a_iMSLevel, a_strActivationMethod)) {
            String t_strFragSeq = t_strGFragInfo0[0];
            String t_strFragType = t_strGFragInfo0[1];
            if (!GlycanAnnotationUtils.canConnectReducingEnd(t_strFragSeq)) {
                String[] t_strGFragInfo = new String[]{GLYCAN, t_strFragSeq, t_strFragType};
                t_lFragInfo.add(t_strGFragInfo);
                continue;
            }
            if (t_annot instanceof GlycanAnnotation) continue;
            if (this.m_gAnnotor.hasFragmentType("C", a_iMSLevel, a_strActivationMethod)) {
                String t_strFragTypeC = String.valueOf(t_strFragType) + "C";
                String[] t_strGFragInfoC = new String[]{GLYCAN, t_strFragSeq, t_strFragTypeC};
                t_lFragInfo.add(t_strGFragInfoC);
            }
            if (!this.m_gAnnotor.hasFragmentType("B", a_iMSLevel, a_strActivationMethod)) continue;
            String t_strFragTypeB = String.valueOf(t_strFragType) + "B";
            String[] t_strGFragInfoB = new String[]{GLYCAN, t_strFragSeq, t_strFragTypeB};
            t_lFragInfo.add(t_strGFragInfoB);
        }
        return t_lFragInfo;
    }

    private List<String[]> getLipidFragments(LipidFeature a_featureParent, String a_strPerDeriv, int a_iMSLevel, String a_strActivationMethod) {
        Annotation t_annot = (Annotation)this.m_mapIDToAnnotation.get(a_featureParent.getAnnotationId());
        ArrayList<String[]> t_lFragInfo = new ArrayList<String[]>();
        for (String[] t_strLFragInfo0 : this.m_lAnnotor.getFragments((Feature)a_featureParent, a_strPerDeriv, a_iMSLevel, a_strActivationMethod)) {
            String t_strFragSeq = t_strLFragInfo0[0];
            String t_strFragType = t_strLFragInfo0[1];
            if (!LipidAnnotationUtils.canConnectToGlycan(t_strFragSeq)) {
                String[] t_strLFragInfo = new String[]{LIPID, t_strFragSeq, t_strFragType};
                t_lFragInfo.add(t_strLFragInfo);
                continue;
            }
            if (t_annot instanceof LipidAnnotation) continue;
            if (this.m_gAnnotor.hasFragmentType("C", a_iMSLevel, a_strActivationMethod)) {
                String t_strFragTypeZ = "Z" + t_strFragType;
                String[] t_strLFragInfoZ = new String[]{LIPID, t_strFragSeq, t_strFragTypeZ};
                t_lFragInfo.add(t_strLFragInfoZ);
            }
            if (!this.m_gAnnotor.hasFragmentType("B", a_iMSLevel, a_strActivationMethod)) continue;
            String t_strFragTypeY = "Y" + t_strFragType;
            String[] t_strLFragInfoY = new String[]{LIPID, t_strFragSeq, t_strFragTypeY};
            t_lFragInfo.add(t_strLFragInfoY);
        }
        return t_lFragInfo;
    }

    @Override
    protected Feature getFragmentFeature(Integer a_iAnnotID, String[] a_strFragInfo) {
        String[] t_strFragInfo;
        Annotation t_annot = (Annotation)this.m_mapIDToAnnotation.get(a_iAnnotID);
        Feature t_feature = null;
        if (a_strFragInfo[0].equals(GLYCAN)) {
            t_strFragInfo = new String[]{a_strFragInfo[1], a_strFragInfo[2]};
            t_feature = this.m_gAnnotor.getFragmentFeature(a_iAnnotID, t_strFragInfo);
            if (t_annot instanceof GlycolipidAnnotation) {
                String t_strGSeq = a_strFragInfo[1];
                if (a_strFragInfo[2].endsWith("C")) {
                    t_strGSeq = t_strGSeq.replace("freeEnd--", "freeEnd/#ccleavage--");
                }
                if (a_strFragInfo[2].endsWith("B")) {
                    t_strGSeq = t_strGSeq.replace("freeEnd--", "freeEnd/#bcleavage--");
                }
                t_feature.setSequence(t_strGSeq);
            }
        }
        if (a_strFragInfo[0].equals(LIPID)) {
            t_strFragInfo = new String[]{a_strFragInfo[1], a_strFragInfo[2]};
            t_feature = this.m_lAnnotor.getFragmentFeature(a_iAnnotID, t_strFragInfo);
            if (t_annot instanceof GlycolipidAnnotation) {
                GlycolipidAnnotation t_glAnnot = (GlycolipidAnnotation)t_annot;
                String t_strLName = a_strFragInfo[1];
                String[] t_strGSeqSep = t_glAnnot.getGlycanAnnotation().getSequence().split("\\$");
                String[] t_strGSeqSep2 = t_strGSeqSep[0].split("--");
                String t_strLSeq = t_strGSeqSep[1].replace(",freeEnd", "," + t_strLName + "=0.0000u");
                String t_strCleavage = "";
                if (a_strFragInfo[2].startsWith("Z")) {
                    t_strCleavage = "/#zcleavage";
                }
                if (a_strFragInfo[2].startsWith("Y")) {
                    t_strCleavage = "/#ycleavage";
                }
                t_strLSeq = String.valueOf(t_strGSeqSep2[0]) + "--" + t_strGSeqSep2[1] + t_strCleavage + "$" + t_strLSeq;
                t_feature.setSequence(t_strLSeq);
            }
        }
        if (a_strFragInfo[0].equals(GLYCOLIPID)) {
            GlycolipidFeature t_glFeature = new GlycolipidFeature();
            String t_strGLSeq = a_strFragInfo[1].replace(",freeEnd", "," + a_strFragInfo[2] + "=0.0000u");
            t_glFeature.setSequence(t_strGLSeq);
            t_glFeature.setLipidName(a_strFragInfo[2]);
            t_glFeature.setFragmentType(a_strFragInfo[3]);
            t_glFeature.setGlycanFragments(new ArrayList());
            t_glFeature.setLipidFragments(new ArrayList());
            t_glFeature.setGlycolipidFragments(new ArrayList());
            t_glFeature.setAnnotationId(a_iAnnotID);
            t_feature = t_glFeature;
        }
        return t_feature;
    }

    @Override
    protected void setFragmentFeatures(Feature a_featureParent, List<Feature> a_lFragFeatures) {
        if (a_featureParent instanceof GlycanFeature) {
            this.m_gAnnotor.setFragmentFeatures(a_featureParent, a_lFragFeatures);
        }
        if (a_featureParent instanceof LipidFeature) {
            this.m_lAnnotor.setFragmentFeatures(a_featureParent, a_lFragFeatures);
        }
        if (!(a_featureParent instanceof GlycolipidFeature)) {
            return;
        }
        GlycolipidFeature t_featureParent = (GlycolipidFeature)a_featureParent;
        for (Feature t_featureFrag : a_lFragFeatures) {
            if (t_featureFrag instanceof GlycanFeature) {
                t_featureParent.getGlycanFragments().add((GlycanFeature)t_featureFrag);
            }
            if (t_featureFrag instanceof LipidFeature) {
                t_featureParent.getLipidFragments().add((LipidFeature)t_featureFrag);
            }
            if (!(t_featureFrag instanceof GlycolipidFeature)) continue;
            t_featureParent.getGlycolipidFragments().add((GlycolipidFeature)t_featureFrag);
        }
    }

    @Override
    protected String[] getFeatureFragmentInfo(Feature a_feature) {
        if (a_feature instanceof GlycanFeature || a_feature instanceof LipidFeature) {
            String t_sStructure = a_feature instanceof GlycanFeature ? GLYCAN : LIPID;
            String[] t_lFragInfo = new String[]{t_sStructure, a_feature.getSequence(), a_feature.getType()};
            return t_lFragInfo;
        }
        if (a_feature instanceof GlycolipidFeature) {
            GlycolipidFeature t_feature = (GlycolipidFeature)a_feature;
            String[] t_lFragInfo = new String[]{GLYCOLIPID, t_feature.getSequence(), t_feature.getLipidName(), t_feature.getType()};
            return t_lFragInfo;
        }
        return null;
    }
}

