/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.wordgeneration;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.model.XWPFHeaderFooterPolicy;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.editor.ViewInput;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.handler.ExperimentDesignReportHandler;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.Paper;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.wordgeneration.ProjectReportWordPage;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.property.SampleProperty;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFldChar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;

public class ExperimentDesignerWordReport {
    private static final Logger logger = Logger.getLogger(ExperimentDesignerWordReport.class);
    private static final float PAGEWIDTH = 452.0f;
    private static final float PAGEHEIGHT = 622.0f;
    private XWPFDocument document = null;

    public void generateReport(ExperimentDesignReportHandler.Options options, GraphEditor editor) {
        this.document = new XWPFDocument();
        try {
            IEditorInput input = editor.getEditorInput();
            if (input instanceof ViewInput) {
                Entry entry = ((ViewInput)input).getEntry();
                Entry projectEntry = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project");
                if (options != null && options.getProject().booleanValue()) {
                    ProjectReportWordPage.addProjectPage(projectEntry, (ProjectProperty)projectEntry.getProperty(), this.document);
                    if (options.getExpDesign().booleanValue() || options.getSample().booleanValue()) {
                        this.pageBreak();
                    }
                }
                Sample sample = SampleProperty.loadAnalyte((Entry)DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.sample"));
                if (options != null && options.getSample().booleanValue()) {
                    this.addSampleInformation(sample);
                    if (options.getExpDesign().booleanValue()) {
                        this.pageBreak();
                    }
                }
                ExperimentGraph model = editor.getModel();
                if (options != null && options.getExpDesign().booleanValue()) {
                    this.addExperimentDesignInformation(editor, model);
                }
                this.addHeader();
                this.addFooter();
                FileDialog fileDialog = new FileDialog(editor.getSite().getShell(), 8192);
                fileDialog.setText("Select File");
                fileDialog.setFilterExtensions(new String[]{"*.docx"});
                fileDialog.setFilterNames(new String[]{"Word (*.docx)"});
                fileDialog.setFileName(String.valueOf(model.getName()) + "-experimentdesign.docx");
                fileDialog.setOverwrite(true);
                String selected = fileDialog.open();
                if (selected != null) {
                    FileOutputStream outStream = new FileOutputStream(selected);
                    this.document.write((OutputStream)outStream);
                    outStream.close();
                }
            }
        }
        catch (IOException | JAXBException e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot generate report!", e);
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)"Word Document cannot be generated! Please check the log file");
        }
        catch (InvalidFormatException e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot generate report!", (Throwable)e);
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)"Word Document cannot be generated! Please check the log file");
        }
        catch (XmlException e) {
            logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot generate report!", (Throwable)e);
            MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Error", (String)"Word Document cannot be generated! Please check the log file");
        }
    }

    private void pageBreak() {
        XWPFParagraph pEmpty = this.document.createParagraph();
        pEmpty.createRun().addBreak(BreakType.PAGE);
    }

    private void addExperimentDesignInformation(GraphEditor editor, ExperimentGraph model) throws IOException, InvalidFormatException {
        this.writeHeadlineLevel("Experiment Graph", 1);
        XWPFParagraph p2 = this.document.createParagraph();
        p2.setAlignment(ParagraphAlignment.LEFT);
        XWPFRun r1 = p2.createRun();
        r1.setUnderline(UnderlinePatterns.SINGLE);
        r1.setText("Name: ");
        XWPFRun r2 = p2.createRun();
        r2.addTab();
        r2.addTab();
        r2.addTab();
        r2.setText(model.getName());
        r2.addCarriageReturn();
        XWPFRun r3 = p2.createRun();
        r3.setUnderline(UnderlinePatterns.SINGLE);
        r3.setText("Date Created: ");
        XWPFRun r4 = p2.createRun();
        r4.addTab();
        r4.setText(model.getDateCreated().toString());
        r4.addCarriageReturn();
        if (model.getDescription() != null && model.getDescription().length() > 0) {
            XWPFRun r5 = p2.createRun();
            r5.setUnderline(UnderlinePatterns.SINGLE);
            r5.setText("Description: ");
            r5.addTab();
            XWPFRun r6 = p2.createRun();
            r6.setText(model.getDescription());
            r6.addCarriageReturn();
        }
        XWPFRun r7 = p2.createRun();
        r7.addCarriageReturn();
        Dimension size = model.calculateSize();
        float xscale = 452.0f / (float)size.width;
        float yscale = 622.0f / (float)size.height;
        float scale = Math.min(xscale, yscale);
        if (scale > 1.0f) {
            scale = 1.0f;
        }
        BufferedImage imageForPDF = editor.getBufferedImage();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imageForPDF, "gif", os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        r7.addPicture((InputStream)is, 8, null, Units.toEMU((double)(scale * (float)size.width)), Units.toEMU((double)(scale * (float)size.height)));
        if (model.getChildren() != null) {
            for (GraphNode node : model.getChildren()) {
                XWPFRun r9;
                XWPFRun r8;
                if (!(node instanceof ProtocolNode)) continue;
                XWPFParagraph protocolP = this.document.createParagraph();
                protocolP.setAlignment(ParagraphAlignment.LEFT);
                XWPFRun r = protocolP.createRun();
                r.addBreak(BreakType.PAGE);
                r.setBold(true);
                r.setText("Protocol - ");
                r.setText(((ProtocolNode)node).getLabel());
                r.addCarriageReturn();
                if (((ProtocolNode)node).getCreator() != null) {
                    r8 = protocolP.createRun();
                    r8.setUnderline(UnderlinePatterns.SINGLE);
                    r8.setText("Created By: ");
                    r9 = protocolP.createRun();
                    r9.addTab();
                    r9.setText(((ProtocolNode)node).getCreator());
                    r9.addCarriageReturn();
                }
                if (node.getDescription() != null && node.getDescription().length() > 0) {
                    r8 = protocolP.createRun();
                    r8.setUnderline(UnderlinePatterns.SINGLE);
                    r8.setText("Description: ");
                    r9 = protocolP.createRun();
                    r9.addTab();
                    r9.setText(node.getDescription());
                    r9.addCarriageReturn();
                }
                this.addParameterTable((ProtocolNode)node);
                this.addPapers((ProtocolNode)node);
            }
        }
    }

    private void addHeader() throws IOException, XmlException {
        CTP ctp = CTP.Factory.newInstance();
        CTR ctr = ctp.addNewR();
        ctr.addNewRPr();
        CTText textt = ctr.addNewT();
        textt.setStringValue(new Date().toString());
        XWPFParagraph codePara = new XWPFParagraph(ctp, (IBody)this.document);
        XWPFParagraph[] newparagraphs = new XWPFParagraph[]{codePara};
        CTSectPr sectPr = this.document.getDocument().getBody().addNewSectPr();
        XWPFHeaderFooterPolicy headerFooterPolicy = new XWPFHeaderFooterPolicy(this.document, sectPr);
        headerFooterPolicy.createHeader(STHdrFtr.DEFAULT, newparagraphs);
    }

    private void addFooter() throws IOException, XmlException {
        CTP ctp = CTP.Factory.newInstance();
        CTPPr ctppr = ctp.addNewPPr();
        CTString pst = ctppr.addNewPStyle();
        pst.setVal("style21");
        CTJc ctjc = ctppr.addNewJc();
        ctjc.setVal(STJc.RIGHT);
        ctppr.addNewRPr();
        CTR ctr = ctp.addNewR();
        ctr.addNewRPr();
        CTFldChar fch = ctr.addNewFldChar();
        fch.setFldCharType(STFldCharType.BEGIN);
        ctr = ctp.addNewR();
        ctr.addNewInstrText().setStringValue(" PAGE ");
        ctp.addNewR().addNewFldChar().setFldCharType(STFldCharType.SEPARATE);
        ctp.addNewR().addNewT().setStringValue("1");
        ctp.addNewR().addNewFldChar().setFldCharType(STFldCharType.END);
        XWPFParagraph codePara = new XWPFParagraph(ctp, (IBody)this.document);
        XWPFParagraph[] newparagraphs = new XWPFParagraph[]{codePara};
        CTSectPr sectPr = this.document.getDocument().getBody().addNewSectPr();
        XWPFHeaderFooterPolicy headerFooterPolicy = new XWPFHeaderFooterPolicy(this.document, sectPr);
        headerFooterPolicy.createFooter(STHdrFtr.DEFAULT, newparagraphs);
    }

    private void addPapers(ProtocolNode node) {
        if (node.getPapers() != null && node.getPapers().size() > 0) {
            XWPFParagraph pageP = this.document.createParagraph();
            pageP.setAlignment(ParagraphAlignment.LEFT);
            XWPFRun r = pageP.createRun();
            r.setBold(true);
            r.addCarriageReturn();
            r.setText("Papers");
            r.addCarriageReturn();
            for (Paper paper : node.getPapers()) {
                XWPFRun r1 = pageP.createRun();
                r1.setText(paper.toString());
                r1.addCarriageReturn();
                r1.addCarriageReturn();
            }
        }
    }

    private void addParameterTable(ProtocolNode node) {
        if (!(node.getParameters() != null && node.getParameters().size() != 0 || node.getParameterGroups() != null && node.getParameterGroups().size() != 0)) {
            return;
        }
        XWPFTable t_table = this.createTable();
        XWPFTableRow t_row = t_table.getRow(0);
        this.tableHeadlineCell(t_row.getCell(0), "Parameter/Parameter Group");
        this.tableHeadlineCell(t_row.addNewTableCell(), "Value");
        this.tableHeadlineCell(t_row.addNewTableCell(), "Unit");
        if (node.getParameterGroups() != null) {
            for (ParameterGroup group : node.getParameterGroups()) {
                t_row = t_table.createRow();
                this.tableCell(t_row.getCell(0), group.getLabel());
                this.tableCell(t_row.getCell(1), "");
                this.tableCell(t_row.getCell(2), "");
                group.getParameters();
                for (Parameter parameter : group.getParameters()) {
                    t_row = t_table.createRow();
                    this.tableCell(t_row.getCell(0), "     " + parameter.getName());
                    if (parameter.getValue() != null) {
                        this.tableCell(t_row.getCell(1), parameter.getValue());
                    } else {
                        this.tableCell(t_row.getCell(1), "");
                    }
                    if (parameter.getUnit() != null) {
                        this.tableCell(t_row.getCell(2), parameter.getUnit().getLabel());
                        continue;
                    }
                    this.tableCell(t_row.getCell(2), "");
                }
            }
        }
        if (node.getParameters() != null) {
            for (Parameter parameter : node.getParameters()) {
                t_row = t_table.createRow();
                this.tableCell(t_row.getCell(0), parameter.getName());
                if (parameter.getValue() != null) {
                    this.tableCell(t_row.getCell(1), parameter.getValue());
                } else {
                    this.tableCell(t_row.getCell(1), "");
                }
                if (parameter.getUnit() != null) {
                    this.tableCell(t_row.getCell(2), parameter.getUnit().getLabel());
                    continue;
                }
                this.tableCell(t_row.getCell(2), "");
            }
        }
    }

    private void addSampleInformation(Sample sample) {
        this.writeHeadlineLevel("Analyte", 1);
        XWPFParagraph p = this.document.createParagraph();
        p.setAlignment(ParagraphAlignment.LEFT);
        XWPFRun r1 = p.createRun();
        r1.setUnderline(UnderlinePatterns.SINGLE);
        r1.setText("Name: ");
        XWPFRun r2 = p.createRun();
        r2.addTab();
        r2.addTab();
        r2.setText(sample.getName());
        r2.addCarriageReturn();
        if (sample.getDescription() != null && !sample.getDescription().isEmpty()) {
            XWPFRun r3 = p.createRun();
            r3.setUnderline(UnderlinePatterns.SINGLE);
            r3.setText("Description: ");
            XWPFRun r4 = p.createRun();
            r4.addTab();
            r4.setText(sample.getDescription());
            r4.addCarriageReturn();
        }
        XWPFRun rr3 = p.createRun();
        rr3.setBold(true);
        rr3.addCarriageReturn();
        rr3.setText("List of Components:");
        rr3.addCarriageReturn();
        int componentNumber = 1;
        for (Component comp : sample.getComponents()) {
            XWPFRun r4 = p.createRun();
            r4.setText(String.valueOf(componentNumber++) + ". " + comp.getLabel());
            r4.addCarriageReturn();
        }
        p.createRun().addBreak(BreakType.PAGE);
        componentNumber = 1;
        for (Component comp : sample.getComponents()) {
            XWPFRun r7;
            XWPFRun r6;
            this.writeHeadlineLevel("Component" + componentNumber++, 2);
            XWPFParagraph p2 = this.document.createParagraph();
            p2.setAlignment(ParagraphAlignment.LEFT);
            XWPFRun rr4 = p2.createRun();
            rr4.setUnderline(UnderlinePatterns.SINGLE);
            rr4.setText("Name: ");
            XWPFRun rr5 = p2.createRun();
            rr5.addTab();
            rr5.addTab();
            rr5.addTab();
            rr5.setText(comp.getLabel());
            rr5.addCarriageReturn();
            if (comp.getDescription() != null && !comp.getDescription().isEmpty()) {
                r6 = p2.createRun();
                r6.setUnderline(UnderlinePatterns.SINGLE);
                r6.setText("Description: ");
                r7 = p2.createRun();
                r7.addTab();
                r7.setText(comp.getDescription());
            }
            if (comp.getTemplateUri() != null) {
                r6 = p2.createRun();
                r6.setUnderline(UnderlinePatterns.SINGLE);
                r6.setText("Template: ");
                r7 = p2.createRun();
                r7.addTab();
                r7.setText(comp.getTemplateUri());
            }
            Category sampleInformation = comp.getSampleInformation();
            this.writeCategoryInComponentPage(sampleInformation);
            Category tracking = comp.getTracking();
            this.writeCategoryInComponentPage(tracking);
            Category amount = comp.getAmount();
            this.writeCategoryInComponentPage(amount);
            Category purityQC = comp.getPurityQC();
            this.writeCategoryInComponentPage(purityQC);
        }
    }

    private String getCategoryLabel(String uri) {
        switch (uri) {
            case "http://www.grits-toolbox.org/ontology/sample#category_sample": {
                return "Sample Information";
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_sample_tracking": {
                return "Sample Tracking";
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_amount": {
                return "Amount";
            }
            case "http://www.grits-toolbox.org/ontology/sample#category_qc": {
                return "Purity Q.C.";
            }
        }
        return null;
    }

    private void writeCategoryInComponentPage(Category category) {
        if (!(category.getDescriptors() != null && category.getDescriptors().size() != 0 || category.getDescriptorGroups() != null && category.getDescriptorGroups().size() != 0)) {
            return;
        }
        XWPFParagraph p3 = this.document.createParagraph();
        p3.setAlignment(ParagraphAlignment.LEFT);
        XWPFRun r3 = p3.createRun();
        r3.setText("Category: " + this.getCategoryLabel(category.getUri()));
        r3.addCarriageReturn();
        XWPFTable t_table = this.createTable();
        XWPFTableRow t_row = t_table.getRow(0);
        this.tableHeadlineCell(t_row.getCell(0), "Descriptor/Descriptor Group");
        this.tableHeadlineCell(t_row.addNewTableCell(), "Value");
        this.tableHeadlineCell(t_row.addNewTableCell(), "Unit");
        for (Descriptor desc : category.getDescriptors()) {
            t_row = t_table.createRow();
            this.writeDescriptorRow(desc, t_row);
        }
        for (DescriptorGroup dg : category.getDescriptorGroups()) {
            t_row = t_table.createRow();
            this.tableCell(t_row.getCell(0), dg.getLabel());
            this.tableCell(t_row.getCell(1), "");
            this.tableCell(t_row.getCell(2), "");
            for (Descriptor desc : dg.getMandatoryDescriptors()) {
                t_row = t_table.createRow();
                this.writeDescriptorRow(desc, t_row);
            }
            for (Descriptor desc : dg.getOptionalDescriptors()) {
                t_row = t_table.createRow();
                this.writeDescriptorRow(desc, t_row);
            }
        }
    }

    private void writeDescriptorRow(Descriptor desc, XWPFTableRow t_row) {
        this.tableCell(t_row.getCell(0), desc.getLabel());
        if (desc.getValue() != null) {
            this.tableCell(t_row.getCell(1), desc.getValue());
        }
        if (desc.getSelectedMeasurementUnit() != null) {
            String selectedUnitLabel = desc.getUnitLabelFromUri(desc.getSelectedMeasurementUnit());
            this.tableCell(t_row.getCell(2), selectedUnitLabel);
        }
    }

    private void writeHeadlineLevel(String a_class, Integer a_level) {
        this.document.createParagraph().createRun().addBreak();
        XWPFParagraph t_paragraphOne = this.document.createParagraph();
        t_paragraphOne.setAlignment(ParagraphAlignment.LEFT);
        XWPFRun paragraphOneRunOne = t_paragraphOne.createRun();
        switch (a_level) {
            case 1: {
                paragraphOneRunOne.setBold(true);
                paragraphOneRunOne.setFontSize(14);
                break;
            }
            case 2: {
                paragraphOneRunOne.setBold(true);
                paragraphOneRunOne.setFontSize(12);
            }
        }
        paragraphOneRunOne.setText(a_class);
    }

    private void tableCell(XWPFTableCell a_cell, String a_text) {
        List t_paragraphCell = a_cell.getParagraphs();
        for (XWPFParagraph t_xwpfParagraph : t_paragraphCell) {
            t_xwpfParagraph.setAlignment(ParagraphAlignment.LEFT);
            XWPFRun runCell = t_xwpfParagraph.createRun();
            runCell.setText(a_text);
        }
    }

    private void tableHeadlineCell(XWPFTableCell a_cell, String a_text) {
        a_cell.setColor("C8C8C8");
        List t_paragraphCell = a_cell.getParagraphs();
        for (XWPFParagraph t_xwpfParagraph : t_paragraphCell) {
            t_xwpfParagraph.setAlignment(ParagraphAlignment.CENTER);
            XWPFRun runCell = t_xwpfParagraph.createRun();
            runCell.setBold(true);
            runCell.setText(a_text);
        }
    }

    private XWPFTable createTable() {
        return this.document.createTable();
    }
}

