/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.editor.content;

import java.util.Iterator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;

public class PlateTableViewerSorter
extends ViewerSorter {
    private Boolean rawData;
    private int propertyIndex;
    private static final int DESCENDING = 1;
    private int direction = 1;
    Double lowerThreshold;
    Double stDevCutOff;

    public PlateTableViewerSorter(Boolean rawData) {
        this.rawData = rawData;
        this.propertyIndex = 0;
        this.direction = 1;
    }

    public void setLowerThreshold(Double lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public void setStDevCutOff(Double stDevCutOff) {
        this.stDevCutOff = stDevCutOff;
    }

    public int category(Object element) {
        if (element instanceof Gene) {
            return 0;
        }
        if (element instanceof GeneData) {
            return 1;
        }
        return 2;
    }

    public int getDirection() {
        return this.direction == 1 ? 1024 : 128;
    }

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction *= -1;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int c = 0;
        switch (this.propertyIndex) {
            case 0: {
                if (e1 instanceof Gene && e2 instanceof Gene) {
                    int i = 0;
                    Iterator<GeneData> iterator = ((Gene)e1).getDataMap().get(0).iterator();
                    if (iterator.hasNext()) {
                        GeneData geneData = iterator.next();
                        return this.compare(viewer, geneData, ((Gene)e2).getDataMap().get(0).get(i++));
                    }
                }
                if (e1 instanceof GeneData && e2 instanceof GeneData && (c = ((GeneData)e1).getPosition().getX().compareTo(((GeneData)e2).getPosition().getX())) == 0) {
                    c = ((GeneData)e1).getPosition().getY().compareTo(((GeneData)e2).getPosition().getY());
                }
            }
            case 1: {
                if (!(e1 instanceof Gene) || !(e2 instanceof Gene)) break;
                c = ((Gene)e1).getGeneIdentifier().compareTo(((Gene)e2).getGeneIdentifier());
                break;
            }
            case 3: {
                if (!(e1 instanceof Gene) || !(e2 instanceof Gene)) break;
                Double d1 = this.rawData != false ? Double.valueOf(((Gene)e1).getStandardDeviation(0, this.lowerThreshold, true)) : Double.valueOf(((Gene)e1).getStandardDeviation(0, this.lowerThreshold, false));
                Double d2 = this.rawData != false ? Double.valueOf(((Gene)e2).getStandardDeviation(0, this.lowerThreshold, true)) : Double.valueOf(((Gene)e2).getStandardDeviation(0, this.lowerThreshold, false));
                c = d1.compareTo(d2);
                break;
            }
            case 9: {
                if (!(e1 instanceof Gene) || !(e2 instanceof Gene)) break;
                Double d1 = this.rawData != false ? ((Gene)e1).getAdjustedAverage(0, true, this.lowerThreshold, ((Gene)e1).getNormValue(0)) : ((Gene)e1).getAdjustedAverage(0, false, this.lowerThreshold, ((Gene)e1).getNormValue(0));
                Double d2 = this.rawData != false ? ((Gene)e2).getAdjustedAverage(0, true, this.lowerThreshold, ((Gene)e1).getNormValue(0)) : ((Gene)e2).getAdjustedAverage(0, false, this.lowerThreshold, ((Gene)e1).getNormValue(0));
                c = d1.compareTo(d2);
                break;
            }
            case 10: {
                if (!(e1 instanceof Gene) || !(e2 instanceof Gene)) break;
                Double d1 = this.rawData != false ? ((Gene)e1).getStDevForAdjusted(0, true, this.lowerThreshold, ((Gene)e1).getNormValue(0)) : ((Gene)e1).getStDevForAdjusted(0, false, this.lowerThreshold, ((Gene)e1).getNormValue(0));
                Double d2 = this.rawData != false ? ((Gene)e2).getStDevForAdjusted(0, true, this.lowerThreshold, ((Gene)e1).getNormValue(0)) : ((Gene)e2).getStDevForAdjusted(0, false, this.lowerThreshold, ((Gene)e1).getNormValue(0));
                c = d1.compareTo(d2);
            }
        }
        return this.direction == 1 ? c : -c;
    }
}

