/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.dialogs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.qrtpcr.dialogs.DataReviewDialog;
import org.grits.toolbox.entry.qrtpcr.dialogs.UploadDataWizard;
import org.grits.toolbox.entry.qrtpcr.dialogs.UploadqrtPCRDataDialogPageOne;
import org.grits.toolbox.entry.qrtpcr.model.CtHistory;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRTable;
import org.grits.toolbox.entry.qrtpcr.model.Well;
import org.grits.toolbox.entry.qrtpcr.preference.QrtPCRPreferencePage;
import org.grits.toolbox.entry.qrtpcr.util.FileUtils;

public class UploadqrtPCRDataDialogPageTwo
extends WizardPage {
    private static final Logger logger = Logger.getLogger(UploadqrtPCRDataDialogPageTwo.class);
    private Table table;
    String[] plateIds = new String[]{"Plate 1"};
    QrtPCRTable qrtPCRTable = new QrtPCRTable();
    Entry sampleEntry = null;
    private Button reviewButton;

    protected UploadqrtPCRDataDialogPageTwo(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.setTitle("Upload Data Files");
        this.setMessage("Please upload data files for each plate and review data");
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        content.setLayout((Layout)new GridLayout(4, false));
        this.table = new Table(content, 67584);
        GridData gd_table = new GridData(4, 4, true, true, 1, 1);
        gd_table.horizontalSpan = 4;
        this.table.setLayoutData((Object)gd_table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tblclmnPlateid = new TableColumn(this.table, 0);
        tblclmnPlateid.setWidth(100);
        tblclmnPlateid.setText("PlateID");
        TableColumn tblclmnDataFile = new TableColumn(this.table, 0);
        tblclmnDataFile.setWidth(328);
        tblclmnDataFile.setText("Data File");
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(150);
        this.setPageComplete(false);
    }

    protected boolean processFile(String plateId, String filename, Shell shell) {
        if (filename != null && filename.endsWith(".asy")) {
            return this.readAsyFile(plateId, filename, shell);
        }
        if (filename != null && (filename.endsWith(".xls") || filename.endsWith(".xlsx"))) {
            return this.readExcelFile(plateId, filename, shell);
        }
        return false;
    }

    private boolean readExcelFile(String plateId, String filename, Shell shell) {
        QrtPCRData data;
        XSSFWorkbook exampleWb;
        FileInputStream fileReader;
        block26: {
            try {
                String fileFolder = FileUtils.getFileFolder(this.sampleEntry);
                fileReader = new FileInputStream(new File(String.valueOf(fileFolder) + File.separator + filename));
                exampleWb = new XSSFWorkbook((InputStream)fileReader);
                this.qrtPCRTable = ((UploadqrtPCRDataDialogPageOne)this.getWizard().getPreviousPage((IWizardPage)this)).getTable();
                data = this.qrtPCRTable.getData(plateId);
                this.qrtPCRTable.addInstrumentFile(plateId, filename);
                boolean sheetFound = false;
                int i = 0;
                while (i < exampleWb.getNumberOfSheets()) {
                    Sheet sheet = exampleWb.getSheetAt(i);
                    Double ct0 = null;
                    Well pos = null;
                    if (sheet.getSheetName().toLowerCase().startsWith(plateId.toLowerCase()) || sheet.getSheetName().toLowerCase().startsWith(plateId.toLowerCase().replace(" ", ""))) {
                        sheetFound = true;
                        for (Row row : sheet) {
                            if (row.getRowNum() == 0) continue;
                            int columnNumber = 0;
                            while (columnNumber < 2) {
                                Cell cell = row.getCell(columnNumber);
                                if (!(cell == null || cell.getCellType() == CellType.BLANK || cell.getCellType() == CellType.STRING && cell.getRichStringCellValue().equals(""))) {
                                    String name;
                                    if (cell.getColumnIndex() == 0 && cell.getCellType() == CellType.STRING && !(name = cell.getRichStringCellValue().getString()).equals("")) {
                                        pos = new Well();
                                        pos.setX(Character.valueOf(name.trim().charAt(0)));
                                        pos.setY(Integer.parseInt(name.trim().substring(1)));
                                    }
                                    if (cell.getColumnIndex() == 1) {
                                        if (cell.getCellType() == CellType.STRING) {
                                            name = cell.getRichStringCellValue().getString();
                                            if (!name.equals("") && (name.equalsIgnoreCase("N/A") || name.equalsIgnoreCase("none"))) {
                                                ct0 = null;
                                            } else if (!name.equals("")) {
                                                try {
                                                    ct0 = Double.parseDouble(name);
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    ct0 = null;
                                                }
                                            }
                                        } else if (cell.getCellType() == CellType.NUMERIC) {
                                            ct0 = cell.getNumericCellValue();
                                        }
                                    }
                                }
                                ++columnNumber;
                            }
                            GeneData geneData = this.findGeneDataForWell(pos, data);
                            if (geneData == null) {
                                logger.info((Object)("Error locating the genedata for position: " + pos + " Position must be empty!"));
                            } else {
                                if (ct0 == null) {
                                    geneData.addPreviousValue(null, CtHistory.Reason.NULL.getReason());
                                    geneData.setCt((double)QrtPCRPreferencePage.THRESHOLD_PREFERENCE);
                                } else if (ct0 > QrtPCRPreferencePage.THRESHOLD_PREFERENCE) {
                                    geneData.addPreviousValue(ct0, CtHistory.Reason.ABOVETHRESHOLD.getReason());
                                    geneData.setCt((double)QrtPCRPreferencePage.THRESHOLD_PREFERENCE);
                                } else {
                                    geneData.setCt(ct0);
                                }
                                geneData.setPlateId(plateId);
                                geneData.setPosition(pos);
                            }
                            ct0 = null;
                            pos = null;
                        }
                        break;
                    }
                    ++i;
                }
                if (sheetFound) break block26;
                logger.error((Object)("Cannot find matching sheet for plateid: " + plateId));
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Cannot find matching sheet for plateid: " + plateId));
                fileReader.close();
                exampleWb.close();
                return false;
            }
            catch (IOException e) {
                logger.error((Object)("Error reading the file: " + filename), (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)"Error", (String)("Error reading the file: " + filename + ". Reason: " + e.getMessage()));
                return false;
            }
        }
        if (filename.indexOf(".") != -1) {
            String name = filename.substring(0, filename.indexOf("."));
            data.setName(name);
        } else {
            data.setName(filename);
        }
        data.calculateNormValue();
        fileReader.close();
        exampleWb.close();
        return true;
    }

    private boolean readAsyFile(String plateId, String filename, Shell shell) {
        try {
            String line;
            String fileFolder = FileUtils.getFileFolder(this.sampleEntry);
            FileInputStream file = new FileInputStream(new File(String.valueOf(fileFolder) + File.separator + filename));
            BufferedReader lines = new BufferedReader(new InputStreamReader(file));
            this.qrtPCRTable = ((UploadqrtPCRDataDialogPageOne)this.getWizard().getPreviousPage((IWizardPage)this)).getTable();
            QrtPCRData data = this.qrtPCRTable.getData(plateId);
            this.qrtPCRTable.addInstrumentFile(plateId, filename);
            Double ct0 = null;
            Double ctMean0 = null;
            Double ctDev0 = null;
            Well pos = null;
            String name = null;
            String createdDate = null;
            boolean ctFound = false;
            while ((line = lines.readLine()) != null) {
                String dye;
                if (line.startsWith("Name=")) {
                    name = line.substring(line.indexOf("Name=") + 5).trim();
                }
                if (line.startsWith("CREATEDDATE=")) {
                    createdDate = line.substring(line.indexOf("=") + 1).trim();
                }
                if (line.startsWith("RUN_DYE") && (dye = line.substring(line.indexOf("=") + 1).trim()).length() > 0) {
                    data.addDye(dye);
                }
                if (line.startsWith("CT0=")) {
                    ctFound = true;
                    String ct0String = line.substring(line.indexOf("CT0=") + 4);
                    if (!ct0String.trim().isEmpty()) {
                        ct0 = Double.parseDouble(ct0String);
                    }
                }
                if (line.startsWith("CTMEAN0=")) {
                    String ctMean0String = line.substring(line.indexOf("CTMEAN0=") + 8);
                    ctMean0 = ctMean0String.trim().isEmpty() ? Double.valueOf(35.0) : Double.valueOf(Double.parseDouble(ctMean0String));
                }
                if (line.startsWith("CTDEV0=")) {
                    String ctDev0String = line.substring(line.indexOf("CTDEV0=") + 7);
                    ctDev0 = ctDev0String.trim().isEmpty() ? Double.valueOf(0.0) : Double.valueOf(Double.parseDouble(ctDev0String));
                }
                if (line.startsWith("POS=")) {
                    pos = new Well();
                    pos.setX(Character.valueOf(line.substring(line.indexOf("=") + 1).charAt(0)));
                    pos.setY(Integer.parseInt(line.substring(line.indexOf("=") + 2)));
                }
                if (line.contains("<<Kinetic Data>>")) break;
                if (!ctFound || ctMean0 == null || ctDev0 == null || pos == null) continue;
                GeneData geneData = this.findGeneDataForWell(pos, data);
                if (geneData == null) {
                    logger.info((Object)("Error locating the genedata for position: " + pos + " Position must be empty!"));
                } else {
                    if (ct0 == null) {
                        geneData.addPreviousValue(null, CtHistory.Reason.NULL.getReason());
                        geneData.setCt((double)QrtPCRPreferencePage.THRESHOLD_PREFERENCE);
                    } else if (ct0 > QrtPCRPreferencePage.THRESHOLD_PREFERENCE) {
                        geneData.addPreviousValue(ct0, CtHistory.Reason.ABOVETHRESHOLD.getReason());
                        geneData.setCt((double)QrtPCRPreferencePage.THRESHOLD_PREFERENCE);
                    } else {
                        geneData.setCt(ct0);
                    }
                    geneData.setCtDev((double)ctDev0);
                    geneData.setCtMean((double)ctMean0);
                    geneData.setPlateId(plateId);
                    geneData.setPosition(pos);
                }
                ct0 = null;
                ctMean0 = null;
                ctDev0 = null;
                ctFound = false;
                pos = null;
            }
            if (name != null && name.length() > 0) {
                data.setName(name);
            }
            if (createdDate != null && createdDate.length() > 0) {
                try {
                    data.setDateCreated(DateFormat.getDateTimeInstance(3, 3).parse(createdDate));
                }
                catch (ParseException e) {
                    logger.warn((Object)"Could not parse the date from the file", (Throwable)e);
                }
            }
            data.calculateNormValue();
            lines.close();
            file.close();
        }
        catch (IOException e) {
            logger.error((Object)"Error processing raw instrument file. ", (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error processing raw instrument file.", (Exception)e);
            return false;
        }
        catch (NumberFormatException e) {
            logger.error((Object)"Error processing raw instrument file. ", (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Error processing raw instrument file.", (Exception)e);
            return false;
        }
        return true;
    }

    GeneData findGeneDataForWell(Well pos, QrtPCRData data) {
        List<Gene> genes = data.getGenes();
        if (genes != null) {
            for (Gene gene : genes) {
                List<GeneData> geneDataList = gene.getDataMap().get(0);
                for (GeneData geneData : geneDataList) {
                    if (!geneData.getPosition().equals(pos)) continue;
                    return geneData;
                }
            }
        }
        return null;
    }

    protected void addTableRow(final Shell parent, final String plateId) {
        TableItem[] previuousItems;
        TableItem[] tableItemArray = previuousItems = this.table.getItems();
        int n = previuousItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getText(0) != null && tableItem.getText(0).equals(plateId)) {
                return;
            }
            ++n2;
        }
        final TableItem item = new TableItem(this.table, 8);
        item.setText(0, plateId);
        Button browseButton = new Button((Composite)this.table, 8);
        browseButton.setText("...");
        browseButton.pack();
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parent.getShell(), 4098);
                String filename = dialog.open();
                if (filename != null) {
                    String[] otherFiles = dialog.getFileNames();
                    try {
                        TableItem[] previuousItems;
                        TableItem tableItem;
                        int n;
                        int n2;
                        TableItem[] tableItemArray;
                        UploadqrtPCRDataDialogPageTwo.this.sampleEntry = ((UploadDataWizard)UploadqrtPCRDataDialogPageTwo.this.getWizard()).getSampleEntry();
                        filename = FileUtils.copyFileIntoWorkspace(UploadqrtPCRDataDialogPageTwo.this.sampleEntry, filename);
                        if (UploadqrtPCRDataDialogPageTwo.this.processFile(plateId, filename, parent.getShell())) {
                            item.setText(1, filename);
                            if (otherFiles.length == UploadqrtPCRDataDialogPageTwo.this.table.getItemCount()) {
                                TableItem[] previuousItems2 = UploadqrtPCRDataDialogPageTwo.this.table.getItems();
                                int i = 1;
                                tableItemArray = previuousItems2;
                                n2 = previuousItems2.length;
                                n = 0;
                                while (n < n2) {
                                    tableItem = tableItemArray[n];
                                    if (!tableItem.equals(item)) {
                                        String path = otherFiles[i];
                                        if (!path.contains(File.separator)) {
                                            path = String.valueOf(dialog.getFilterPath()) + File.separator + path;
                                        }
                                        String other = FileUtils.copyFileIntoWorkspace(UploadqrtPCRDataDialogPageTwo.this.sampleEntry, path);
                                        if (UploadqrtPCRDataDialogPageTwo.this.processFile(tableItem.getText(0), other, parent.getShell())) {
                                            tableItem.setText(1, other);
                                        }
                                        ++i;
                                    }
                                    ++n;
                                }
                            }
                        }
                        boolean finished = true;
                        tableItemArray = previuousItems = UploadqrtPCRDataDialogPageTwo.this.table.getItems();
                        n2 = previuousItems.length;
                        n = 0;
                        while (n < n2) {
                            tableItem = tableItemArray[n];
                            if (tableItem.getText(1) == null) {
                                finished = false;
                            }
                            ++n;
                        }
                        if (finished) {
                            UploadqrtPCRDataDialogPageTwo.this.setPageComplete(true);
                        }
                    }
                    catch (IOException e1) {
                        logger.error((Object)"Error processing raw instrument file. ", (Throwable)e1);
                        ErrorUtils.createErrorMessageBox((Shell)parent.getShell(), (String)"Error processing raw instrument file.", (Exception)e1);
                    }
                }
            }
        });
        TableEditor editor = new TableEditor(this.table);
        this.reviewButton = new Button((Composite)this.table, 8);
        this.reviewButton.setText("Review Layout");
        this.reviewButton.pack();
        this.reviewButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (UploadqrtPCRDataDialogPageTwo.this.qrtPCRTable.getData(plateId) == null) {
                    return;
                }
                DataReviewDialog dialog = new DataReviewDialog(parent);
                dialog.setData(UploadqrtPCRDataDialogPageTwo.this.qrtPCRTable.getData(plateId));
                dialog.setLowerThreshold(((UploadDataWizard)UploadqrtPCRDataDialogPageTwo.this.getWizard()).getThresholdSetting());
                dialog.setStDevCutOff(((UploadDataWizard)UploadqrtPCRDataDialogPageTwo.this.getWizard()).getCutOffSetting());
                if (dialog.open() == 0 && dialog.isChanged()) {
                    QrtPCRData newData = dialog.getData();
                    UploadqrtPCRDataDialogPageTwo.this.qrtPCRTable.remove(plateId);
                    UploadqrtPCRDataDialogPageTwo.this.qrtPCRTable.addData(plateId, newData);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        editor.minimumWidth = this.reviewButton.getSize().x;
        editor.horizontalAlignment = 0x1000000;
        editor.setEditor((Control)this.reviewButton, item, 2);
        TableEditor editor2 = new TableEditor(this.table);
        editor2.minimumWidth = browseButton.getSize().x;
        editor2.horizontalAlignment = 131072;
        editor2.setEditor((Control)browseButton, item, 1);
    }

    public void setPlateIds(String[] plateIds) {
        if (plateIds != null && plateIds.length > 0) {
            String[] stringArray = plateIds;
            int n = plateIds.length;
            int n2 = 0;
            while (n2 < n) {
                String plateId = stringArray[n2];
                this.addTableRow(this.getShell(), plateId);
                ++n2;
            }
        }
    }

    public QrtPCRTable getQrtPCRTable() {
        return this.qrtPCRTable;
    }
}

