/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.annotation.entry.process.loader;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.dmtranslate.DMGlycanAnnotation;
import org.grits.toolbox.datamodel.ms.annotation.glycan.tablemodel.dmtranslate.DMGlycanFeature;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMFeature;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessorUtil;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycolipidAnnotation;
import org.grits.toolbox.ms.om.data.GlycolipidFeature;
import org.grits.toolbox.ms.om.data.LipidAnnotation;
import org.grits.toolbox.ms.om.data.LipidFeature;
import org.grits.toolbox.tools.gsl.annotation.datamodel.tablemodel.dmtranslate.DMGlycolipidFeature;
import org.grits.toolbox.tools.gsl.annotation.datamodel.tablemodel.dmtranslate.DMLipidAnnotation;

public class MSGlycolipidAnnotationTableDataProcessorUtil {
    private static final Logger logger = Logger.getLogger(MSGlycolipidAnnotationTableDataProcessorUtil.class);

    public static int fillMSGlycolipidAnnotationColumnSettingsLipidAnnotation(TableViewerColumnSettings _columnSettings) {
        _columnSettings.addColumn(DMLipidAnnotation.lipid_annotation_name.getLabel(), DMLipidAnnotation.lipid_annotation_name.name());
        return 1;
    }

    public static void postProcessColumnSettings(TableViewerPreference preference) {
        TableViewerColumnSettings columnSettings = preference.getPreferenceSettings();
        MSGlycolipidAnnotationTableDataProcessorUtil.replaceColumnHeaderLabel(columnSettings, DMFeature.feature_charge.name(), DMGlycanFeature.glycan_feature_charge.getLabel(), DMGlycolipidFeature.glycolipid_feature_charge.getLabel());
        MSGlycolipidAnnotationTableDataProcessorUtil.replaceColumnHeaderLabel(columnSettings, DMFeature.feature_id.name(), DMGlycanFeature.glycan_feature_id.getLabel(), DMGlycolipidFeature.glycolipid_feature_id.getLabel());
        MSGlycolipidAnnotationTableDataProcessorUtil.replaceColumnHeaderLabel(columnSettings, DMFeature.feature_type.name(), DMGlycanFeature.glycan_feature_type.getLabel(), DMGlycolipidFeature.glycolipid_feature_type.getLabel());
        MSGlycolipidAnnotationTableDataProcessorUtil.replaceColumnHeaderLabel(columnSettings, DMFeature.feature_sequence.name(), DMGlycanFeature.glycan_feature_sequence.getLabel(), DMGlycolipidFeature.glycolipid_feature_sequence.getLabel());
        MSGlycolipidAnnotationTableDataProcessorUtil.replaceColumnHeaderLabel(columnSettings, DMFeature.feature_mz.name(), DMGlycanFeature.glycan_feature_mz.getLabel(), DMGlycolipidFeature.glycolipid_feature_mz.getLabel());
        MSGlycolipidAnnotationTableDataProcessorUtil.replaceColumnHeaderLabel(columnSettings, DMFeature.feature_deviation.name(), DMGlycanFeature.glycan_feature_deviation.getLabel(), DMGlycolipidFeature.glycolipid_feature_deviation.getLabel());
    }

    private static void replaceColumnHeaderLabel(TableViewerColumnSettings columnSettings, String oldName, String oldLabel, String newLabel) {
        GRITSColumnHeader oldHeader = columnSettings.getColumnHeader(oldName);
        if (oldHeader != null && oldHeader.getLabel().equals(oldLabel)) {
            int iFeatureDeviationCol = columnSettings.getColumnPosition(oldName);
            columnSettings.getHeaders().remove(oldHeader);
            GRITSColumnHeader header = new GRITSColumnHeader(newLabel, oldName);
            columnSettings.putColumn(header, iFeatureDeviationCol);
        }
    }

    public static void fillMSGlycanAnnotationData(GlycanAnnotation a_annotation, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        if (a_annotation == null) {
            return;
        }
        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMGlycanAnnotation.glycan_annotation_glycanId.name()), (Object)a_annotation.getStringId(), _tableRow);
        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMGlycanAnnotation.glycan_annotation_glytoucanid.name()), (Object)a_annotation.getGlytoucanId(), _tableRow);
        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMGlycanAnnotation.glycan_annotation_perDerivatisationType.name()), (Object)a_annotation.getPerDerivatisationType(), _tableRow);
        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMGlycanAnnotation.glycan_annotation_sequenceGWB.name()), (Object)a_annotation.getSequenceGWB(), _tableRow);
    }

    public static void fillMSLipidAnnotationData(LipidAnnotation a_annotation, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        if (a_annotation == null) {
            return;
        }
        MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMLipidAnnotation.lipid_annotation_name.name()), (Object)a_annotation.getSequence(), _tableRow);
    }

    public static void fillMSGlycolipidAnnotationData(GlycolipidAnnotation a_annotation, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        MSGlycolipidAnnotationTableDataProcessorUtil.fillMSGlycanAnnotationData(a_annotation.getGlycanAnnotation(), _tableRow, _columnSettings);
        MSGlycolipidAnnotationTableDataProcessorUtil.fillMSLipidAnnotationData(a_annotation.getLipidAnnotation(), _tableRow, _columnSettings);
    }

    public static void fillMSAnnotationData(Annotation a_annotation, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        if (a_annotation instanceof GlycolipidAnnotation) {
            MSGlycolipidAnnotationTableDataProcessorUtil.fillMSGlycolipidAnnotationData((GlycolipidAnnotation)a_annotation, _tableRow, _columnSettings);
        } else if (a_annotation instanceof GlycanAnnotation) {
            MSGlycolipidAnnotationTableDataProcessorUtil.fillMSGlycanAnnotationData((GlycanAnnotation)a_annotation, _tableRow, _columnSettings);
            LipidAnnotation t_lipAnnot = new LipidAnnotation();
            t_lipAnnot.setSequence("");
            MSGlycolipidAnnotationTableDataProcessorUtil.fillMSLipidAnnotationData(t_lipAnnot, _tableRow, _columnSettings);
        }
    }

    public static void fillMSGlycolipidFeatureData(Feature a_feature, ArrayList<Object> _tableRow, TableViewerColumnSettings _columnSettings) {
        if (a_feature == null) {
            return;
        }
        MSAnnotationTableDataProcessorUtil.fillFeatureData((Feature)a_feature, _tableRow, (TableViewerColumnSettings)_columnSettings);
        String t_strLipidName = null;
        if (a_feature instanceof GlycolipidFeature) {
            t_strLipidName = ((GlycolipidFeature)a_feature).getLipidName();
        } else if (a_feature instanceof LipidFeature) {
            t_strLipidName = ((LipidFeature)a_feature).getLipidName();
        }
        if (t_strLipidName == null) {
            return;
        }
        try {
            MassSpecTableDataProcessorUtil.setRowValue((int)_columnSettings.getColumnPosition(DMGlycolipidFeature.glycolipid_feature_lipidname.name()), (Object)t_strLipidName, _tableRow);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }
}

