/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class MassOptions {
    public static final String ISOTOPE_MONO = "MONO";
    public static final String ISOTOPE_AVG = "AVG";
    public String ISOTOPE = "MONO";
    public static final String NO_DERIVATIZATION = "Und";
    public static final String PERMETHYLATED = "perMe";
    public static final String HEAVYPERMETHYLATION = "perMe(C^13)";
    public static final String PERDMETHYLATED = "perDMe";
    public static final String PERACETYLATED = "perAc";
    public static final String PERDACETYLATED = "perDAc";
    public static final String[] DERIVATIZATIONS = new String[]{"Und", "perMe", "perMe(C^13)", "perDMe", "perAc", "perDAc"};
    public String DERIVATIZATION = "perMe";
    public ResidueType REDUCING_END_TYPE = ResidueType.createFreeReducingEnd();
    public IonCloud ION_CLOUD = new IonCloud("Na");
    public IonCloud NEUTRAL_EXCHANGES = new IonCloud();
    public static final String NO_ION = "0";
    public static final String ION_H = "H";
    public static final String ION_LI = "Li";
    public static final String ION_NA = "Na";
    public static final String ION_K = "K";
    public static final String ION_CL = "Cl";
    public static final String ION_H2PO4 = "H2PO4";

    public String getIsotope() {
        return this.ISOTOPE;
    }

    public void setIsotope(String s) {
        this.ISOTOPE = s;
    }

    public String getDerivatization() {
        return this.DERIVATIZATION;
    }

    public void setDerivatization(String s) {
        this.DERIVATIZATION = s;
    }

    public ResidueType getReducingEndType() {
        return this.REDUCING_END_TYPE;
    }

    public void setReducingEndType(ResidueType redend) {
        this.REDUCING_END_TYPE = redend;
    }

    public void setReducingEndTypeString(String type) throws Exception {
        this.REDUCING_END_TYPE = ResidueDictionary.getResidueType(type);
    }

    public String getReducingEndTypeString() {
        return this.REDUCING_END_TYPE.getName();
    }

    public MassOptions() {
    }

    public MassOptions(String deriv) {
        this.DERIVATIZATION = deriv;
        this.REDUCING_END_TYPE = ResidueType.createFreeReducingEnd();
    }

    public MassOptions(String deriv, String marker) {
        this.DERIVATIZATION = deriv;
        this.REDUCING_END_TYPE = ResidueDictionary.findResidueType(marker);
        if (this.REDUCING_END_TYPE == null) {
            this.REDUCING_END_TYPE = ResidueType.createFreeReducingEnd();
        }
    }

    public MassOptions(String deriv, ResidueType marker) {
        this.DERIVATIZATION = deriv;
        this.REDUCING_END_TYPE = marker;
        if (this.REDUCING_END_TYPE == null) {
            this.REDUCING_END_TYPE = ResidueType.createFreeReducingEnd();
        }
    }

    public MassOptions(boolean undetermined) {
        if (undetermined) {
            this.ISOTOPE = "---";
            this.DERIVATIZATION = "---";
            this.REDUCING_END_TYPE = null;
            this.ION_CLOUD.set(ION_H, 999);
            this.ION_CLOUD.set(ION_NA, 999);
            this.ION_CLOUD.set(ION_LI, 999);
            this.ION_CLOUD.set(ION_K, 999);
            this.ION_CLOUD.set(ION_CL, 999);
            this.ION_CLOUD.set(ION_H2PO4, 999);
            this.NEUTRAL_EXCHANGES.set(ION_H, 999);
            this.NEUTRAL_EXCHANGES.set(ION_NA, 999);
            this.NEUTRAL_EXCHANGES.set(ION_LI, 999);
            this.NEUTRAL_EXCHANGES.set(ION_K, 999);
            this.NEUTRAL_EXCHANGES.set(ION_H2PO4, 999);
        }
    }

    public static MassOptions empty() {
        MassOptions ret = new MassOptions();
        ret.DERIVATIZATION = NO_DERIVATIZATION;
        ret.REDUCING_END_TYPE = ResidueType.createFreeReducingEnd();
        ret.ION_CLOUD = new IonCloud();
        ret.NEUTRAL_EXCHANGES = new IonCloud();
        return ret;
    }

    public boolean isUndetermined() {
        return this.ISOTOPE.equals("---") || this.DERIVATIZATION.equals("---") || this.REDUCING_END_TYPE == null || this.ION_CLOUD.isUndetermined() || this.NEUTRAL_EXCHANGES.isUndetermined();
    }

    public MassOptions clone() {
        MassOptions ret = new MassOptions();
        ret.ISOTOPE = this.ISOTOPE;
        ret.DERIVATIZATION = this.DERIVATIZATION;
        ret.REDUCING_END_TYPE = this.REDUCING_END_TYPE;
        ret.ION_CLOUD = this.ION_CLOUD.clone();
        ret.NEUTRAL_EXCHANGES = this.NEUTRAL_EXCHANGES.clone();
        return ret;
    }

    public MassOptions removeExchanges() {
        MassOptions ret = this.clone();
        ret.NEUTRAL_EXCHANGES = new IonCloud();
        return ret;
    }

    public void merge(MassOptions other) {
        if (!other.ISOTOPE.equals(this.ISOTOPE)) {
            this.ISOTOPE = "---";
        }
        if (!other.DERIVATIZATION.equals(this.DERIVATIZATION)) {
            this.DERIVATIZATION = "---";
        }
        if (other.REDUCING_END_TYPE == null || this.REDUCING_END_TYPE != null && !other.REDUCING_END_TYPE.getName().equals(this.REDUCING_END_TYPE.getName())) {
            this.REDUCING_END_TYPE = null;
        }
        this.ION_CLOUD.merge(other.ION_CLOUD);
        this.NEUTRAL_EXCHANGES.merge(other.NEUTRAL_EXCHANGES);
    }

    public void synchronize(Glycan structure) {
        Residue redend = structure.getRoot();
        if (redend != null && redend.isReducingEnd() && !redend.isCleavage()) {
            this.REDUCING_END_TYPE = redend.getType();
        }
    }

    public boolean setValues(MassOptions options) {
        if (options == null) {
            return false;
        }
        boolean changed = false;
        if (!options.ISOTOPE.equals("---")) {
            this.ISOTOPE = options.ISOTOPE;
            changed = true;
        }
        if (!options.DERIVATIZATION.equals("---")) {
            this.DERIVATIZATION = options.DERIVATIZATION;
            changed = true;
        }
        if (options.REDUCING_END_TYPE != null) {
            this.REDUCING_END_TYPE = options.REDUCING_END_TYPE;
            changed = true;
        }
        changed |= this.ION_CLOUD.set(options.ION_CLOUD, true);
        return changed |= this.NEUTRAL_EXCHANGES.set(options.NEUTRAL_EXCHANGES, true);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof MassOptions)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.ISOTOPE + "," + this.DERIVATIZATION + "," + this.ION_CLOUD + "," + this.NEUTRAL_EXCHANGES + "," + this.REDUCING_END_TYPE.getName();
    }

    public static MassOptions fromString(String str) throws Exception {
        Vector<String> tokens = TextUtils.tokenize(str, ",");
        MassOptions ret = new MassOptions();
        ret.ISOTOPE = tokens.elementAt(0);
        ret.DERIVATIZATION = tokens.elementAt(1);
        ret.ION_CLOUD = IonCloud.fromString(tokens.elementAt(2));
        ret.NEUTRAL_EXCHANGES = IonCloud.fromString(tokens.elementAt(3));
        if (tokens.size() > 4) {
            ret.REDUCING_END_TYPE = ResidueDictionary.findResidueType(tokens.elementAt(4));
        }
        return ret;
    }

    public void store(Configuration config) {
        config.put("MassOptions", "isotope", this.ISOTOPE);
        config.put("MassOptions", "derivatization", this.DERIVATIZATION);
        config.put("MassOptions", "reducing_end_type", this.REDUCING_END_TYPE.getName());
        config.put("MassOptions", "ion_cloud", this.ION_CLOUD.toString());
        config.put("MassOptions", "neutral_exchanges", this.NEUTRAL_EXCHANGES.toString());
    }

    public void retrieve(Configuration config) {
        try {
            this.ISOTOPE = config.get("MassOptions", "isotope", this.ISOTOPE);
            this.DERIVATIZATION = config.get("MassOptions", "derivatization", this.DERIVATIZATION);
            this.REDUCING_END_TYPE = ResidueDictionary.findResidueType(config.get("MassOptions", "reducing_end_type", this.REDUCING_END_TYPE.getName()));
            this.ION_CLOUD.initFromString(config.get("MassOptions", "ion_cloud", this.ION_CLOUD.toString()));
            this.NEUTRAL_EXCHANGES.initFromString(config.get("MassOptions", "neutral_exchanges", this.NEUTRAL_EXCHANGES.toString()));
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }
}

