/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.Glycan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanGraph;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanRepeatModification;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Monosaccharide;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;

public class GlyContainer
implements GlycanGraph {
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<GlycanUndefinedUnit> antennae = new ArrayList();
    private Node aglycone;
    private ArrayList<GlycanUndefinedUnit> undefinedSubstituent = new ArrayList();
    private int nUndefinedLinkage = 0;

    public void setNumberOfUndefinedLinkages(int _nUndefinedLinkages) {
        this.nUndefinedLinkage = _nUndefinedLinkages;
    }

    public int getNumberOfUndefinedLinkages() {
        return this.nUndefinedLinkage;
    }

    @Override
    public ArrayList<Node> getRootNodes() throws GlycanException {
        ArrayList<Node> ret = new ArrayList<Node>();
        Iterator<Node> iterator = this.getNodes().iterator();
        while (iterator.hasNext()) {
            Node unit;
            Node root = unit = iterator.next();
            ArrayList<Edge> parentEdges = root.getParentEdges();
            boolean isRootRepeat = false;
            if (parentEdges.isEmpty()) {
                ret.add(root);
            }
            for (Edge parentEdge : parentEdges) {
                if (parentEdge.isReverseEdge()) {
                    isRootRepeat = false;
                    break;
                }
                if (parentEdge.isRepeat()) {
                    isRootRepeat = true;
                }
                if (!parentEdge.isCyclic()) continue;
                ret.add(root);
            }
            if (!isRootRepeat || !ret.isEmpty()) continue;
            ret.add(root);
        }
        if (ret.size() == 1) {
            return ret;
        }
        throw new GlycanException("Node seems not to have at least one root residue");
    }

    @Override
    public Iterator<Node> getNodeIterator() {
        return this.nodes.iterator();
    }

    @Override
    public boolean isConnected() throws GlycanException {
        ArrayList<Node> roots = this.getRootNodes();
        return roots.size() <= 1;
    }

    @Override
    public boolean removeNode(Node _node) throws GlycanException {
        Node residue;
        if (_node == null) {
            throw new GlycanException("Invalid residue.");
        }
        Edge linkage2 = _node.getParentEdge();
        if (linkage2 != null) {
            residue = linkage2.getParent();
            if (residue == null) {
                throw new GlycanException("A linkage with a null parent exists.");
            }
            residue.removeChildEdge(linkage2);
        }
        for (Edge linkage2 : _node.getChildEdges()) {
            residue = linkage2.getChild();
            if (residue == null) {
                throw new GlycanException("A linkage with a null child exists.");
            }
            residue.removeParentEdge(linkage2);
        }
        return this.nodes.remove(_node);
    }

    public ArrayList<Node> getAllNodes() {
        ArrayList<Node> ret = new ArrayList<Node>();
        ret.addAll(this.getNodes());
        for (GlycanUndefinedUnit und : this.antennae) {
            for (Node root : und.getNodes()) {
                if (!(root instanceof Monosaccharide) || ret.contains(root)) continue;
                ret.add(root);
            }
        }
        return ret;
    }

    @Override
    public ArrayList<Node> getNodes() {
        ArrayList<Node> ret = new ArrayList<Node>();
        Iterator<Node> iterNode = this.getNodeIterator();
        while (iterNode.hasNext()) {
            Node node = iterNode.next();
            ret.add(node);
        }
        return ret;
    }

    @Override
    public ArrayList<Edge> getEdges() {
        ArrayList<Edge> ret = new ArrayList<Edge>();
        Iterator<Node> iterNode = this.getNodeIterator();
        while (iterNode.hasNext()) {
            Node node = iterNode.next();
            for (Edge edge : node.getChildEdges()) {
                ret.add(edge);
            }
        }
        return ret;
    }

    @Override
    public boolean addNode(Node _node) throws GlycanException {
        if (_node == null) {
            throw new GlycanException("Invalid residue.");
        }
        if (!this.nodes.contains(_node)) {
            return this.nodes.add(_node);
        }
        return false;
    }

    @Override
    public boolean addNode(Node _parent, Edge _linkage, Node _child) throws GlycanException {
        if (_parent == null || _child == null) {
            throw new GlycanException("Invalid residue");
        }
        if (_linkage == null) {
            throw new GlycanException("Invalid linkage");
        }
        if (!this.containsNode(_parent) && !this.containsAntennae(_parent)) {
            this.addNode(_parent);
        }
        if (!this.containsNode(_child) && !this.containsAntennae(_child)) {
            this.addNode(_child);
        }
        _child.addParentEdge(_linkage);
        _parent.addChildEdge(_linkage);
        _linkage.setChild(_child);
        _linkage.setParent(_parent);
        return true;
    }

    @Override
    public boolean addNodeWithSubstituent(Node _parent, Edge _linkage, Substituent _child) throws GlycanException {
        if (_parent == null || _child == null) {
            throw new GlycanException("Invalid residue");
        }
        if (_linkage == null) {
            throw new GlycanException("Invalid residue");
        }
        if (!this.containsNode(_parent) && !this.containsAntennae(_parent)) {
            this.addNode(_parent);
        }
        if (!this.containsNode(_parent)) {
            throw new GlycanException("Critical error imposible to add residue.");
        }
        _parent.addChildEdge(_linkage);
        _linkage.setSubstituent(_child);
        return true;
    }

    @Override
    public boolean addEdge(Node _parent, Node _child, Edge _linkage) throws GlycanException {
        return this.addNode(_parent, _linkage, _child);
    }

    @Override
    public boolean containsNode(Node _node) {
        return this.nodes.contains(_node);
    }

    public boolean containsAntennae(Node _node) {
        boolean ret = false;
        for (GlycanUndefinedUnit und : this.antennae) {
            if (!und.getNodes().contains(_node)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    @Override
    public boolean isParent(Node _parent, Node _current) {
        Node parent = _current.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent == _parent) {
            return true;
        }
        return this.isParent(_parent, parent);
    }

    @Override
    public boolean removeEdge(Edge _edge) throws GlycanException {
        if (_edge == null) {
            return false;
        }
        Node child = _edge.getChild();
        Node parent = _edge.getParent();
        if (child == null || parent == null) {
            throw new GlycanException("The edge contains null values");
        }
        if (child.getParentEdge() != _edge) {
            throw new GlycanException("The child attachement is not correct");
        }
        ArrayList<Edge> edges = parent.getChildEdges();
        if (!edges.contains(_edge)) {
            throw new GlycanException("The parent attachement is not correct");
        }
        if (this.containsCyclicBelow(_edge)) {
            throw new GlycanException("");
        }
        child.removeParentEdge(_edge);
        parent.removeChildEdge(_edge);
        return true;
    }

    private boolean containsCyclicBelow(Edge _edge) throws GlycanException {
        if (_edge == null) {
            throw new GlycanException("Edge is null");
        }
        if (_edge.getParent() == null) {
            return false;
        }
        if (_edge.getSubstituent() == null) {
            return false;
        }
        Substituent sub = (Substituent)_edge.getSubstituent();
        if (!(sub instanceof GlycanRepeatModification)) {
            return false;
        }
        return ((GlycanRepeatModification)sub).getMaxRepeatCount() == 1 && ((GlycanRepeatModification)sub).getMinRepeatCount() == 1;
    }

    public void setUndefinedUnit(ArrayList<GlycanUndefinedUnit> _und) throws GlycanException {
        if (_und == null) {
            throw new GlycanException("null is not a validate set of antennae");
        }
        this.antennae.clear();
        Iterator<GlycanUndefinedUnit> iterUnd = _und.iterator();
        while (iterUnd.hasNext()) {
            this.addGlycanUndefinedUnit(iterUnd.next());
        }
    }

    public ArrayList<GlycanUndefinedUnit> getUndefinedUnit() {
        return this.antennae;
    }

    public GlycanUndefinedUnit getUndefinedUnitWithIndex(Node _node) {
        GlycanUndefinedUnit ret = null;
        for (GlycanUndefinedUnit und : this.antennae) {
            if (!und.containsNode(_node)) continue;
            ret = und;
        }
        return ret;
    }

    public boolean addGlycanUndefinedUnit(GlycanUndefinedUnit _und, Node _parent) throws GlycanException {
        if (!this.antennae.contains(_parent)) {
            throw new GlycanException("Parent is not part of the glycan");
        }
        if (!this.antennae.contains(_und)) {
            throw new GlycanException("Undefined unit is not part of the glycan");
        }
        return _und.addParentNode(_parent);
    }

    public boolean addGlycanUndefinedUnit(GlycanUndefinedUnit _und) throws GlycanException {
        if (_und == null) {
            throw new GlycanException("Null is not validate for undefined unit");
        }
        if (!this.antennae.contains(_und)) {
            return this.antennae.add(_und);
        }
        return false;
    }

    public ArrayList<GlycanUndefinedUnit> getUndefinedUnitsForSubstituent() {
        return this.undefinedSubstituent;
    }

    public boolean addGlycanUndefinedUnitForSubstituent(GlycanUndefinedUnit _und, Node _parent) throws GlycanException {
        if (!this.containsNode(_parent)) {
            throw new GlycanException("Parent is not part of the glycan");
        }
        if (!this.antennae.contains(_und)) {
            throw new GlycanException("Undefined unit is not part of the glycan");
        }
        return _und.addParentNode(_parent);
    }

    public boolean addGlycanUndefinedUnitForSubstituent(GlycanUndefinedUnit _und) throws GlycanException {
        if (_und == null) {
            throw new GlycanException("Null is not validate for undefined unit");
        }
        if (!this.undefinedSubstituent.contains(_und)) {
            return this.undefinedSubstituent.add(_und);
        }
        return false;
    }

    @Override
    public boolean isComposition() {
        return this.getAllNodes().size() == this.getUndefinedUnit().size();
    }

    public void setAglycone(Node _aglycone) {
        this.aglycone = _aglycone;
    }

    public Node getAglycone() {
        return this.aglycone;
    }

    public GlyContainer copy() throws GlycanException {
        GlyContainer copy = new GlyContainer();
        HashMap<Node, Object> copyIndex = new HashMap<Node, Object>();
        if (this.getAglycone() != null) {
            copy.setAglycone(this.getAglycone().copy());
        }
        if (this.getNodes().size() == 1 && this.getNodes().get(0).getParentEdges().isEmpty()) {
            Node current = this.getNodes().get(0);
            Node copyCurrent = current.copy();
            copy.addNode(copyCurrent);
            return copy;
        }
        for (Node node : this.getNodes()) {
            for (Edge parentEdge : node.getParentEdges()) {
                if (parentEdge.getChild() == null || parentEdge.getParent() == null) continue;
                if (!copyIndex.containsKey(parentEdge.getChild())) {
                    Node copyChild = parentEdge.getChild().copy();
                    copyIndex.put(parentEdge.getChild(), copyChild);
                }
                if (copyIndex.containsKey(parentEdge.getParent())) continue;
                Node copyParent = parentEdge.getParent().copy();
                copyIndex.put(parentEdge.getParent(), copyParent);
            }
        }
        for (GlycanUndefinedUnit und : this.getUndefinedUnit()) {
            GlycanUndefinedUnit copyUnd = und.copy();
            copy.addGlycanUndefinedUnit(copyUnd);
            ArrayList<Node> acceptorNodes = new ArrayList<Node>();
            for (Node acceptor : und.getParents()) {
                acceptorNodes.add((Node)copyIndex.get(acceptor));
            }
            copyUnd.setParentNodes(acceptorNodes);
        }
        for (Node node : this.getNodes()) {
            for (Edge parentEdge : node.getParentEdges()) {
                Edge copyEdge = parentEdge.copy();
                if (this.containsAntennae(node)) continue;
                Node copyChild = copyIndex.containsKey(parentEdge.getChild()) ? (Node)copyIndex.get(parentEdge.getChild()) : parentEdge.getChild().copy();
                Node copyParent = copyIndex.containsKey(parentEdge.getParent()) ? (Node)copyIndex.get(parentEdge.getParent()) : parentEdge.getParent().copy();
                if (parentEdge.getChild() != null && parentEdge.getSubstituent() != null) {
                    Node copySub = parentEdge.getSubstituent().copy();
                    copyEdge.setSubstituent(copySub);
                }
                copy.addNode(copyParent, copyEdge, copyChild);
            }
        }
        return copy;
    }
}

