/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.subsumption;

import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.array.WURCSExporter;
import org.glycoinfo.WURCSFramework.util.subsumption.MSStateDeterminationUtility;
import org.glycoinfo.WURCSFramework.util.subsumption.WURCSSubsumptionConverter;
import org.glycoinfo.WURCSFramework.wurcs.array.LIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.MOD;
import org.glycoinfo.WURCSFramework.wurcs.array.MS;

public class WURCSSubsumptionIntegrator {
    private MSStateDeterminationUtility m_oMSStateUtil = new MSStateDeterminationUtility();

    public String getSubsumption(MS msRES) {
        LinkedList<Object> msList = new LinkedList<MS>();
        this.m_oMSStateUtil.generateMSwithCoreMod(msRES);
        if (!this.m_oMSStateUtil.haveOtherMod(msRES)) {
            msList.add(msRES);
        } else {
            msList = this.m_oMSStateUtil.generateMSlist(msRES);
        }
        for (MS mS : msList) {
            if (mS.getAnomericSymbol() != ' ') {
                if (!this.m_oMSStateUtil.hasRing(mS)) {
                    this.supersumeRing(mS);
                    this.removeRing(mS);
                } else {
                    this.supersumeAnomer(mS);
                    this.removeRing(mS);
                }
            } else if (!this.m_oMSStateUtil.hasRing(mS)) {
                this.getOpenChain(mS);
            }
            if (!this.m_oMSStateUtil.haveMOD(mS)) continue;
            this.supersumeMOD(mS);
            if (this.m_oMSStateUtil.haveOtherMod(mS)) {
                this.supersumeCoreMOD(mS);
            }
            this.supersumeChilarity(mS);
            this.removeAnomer(mS);
        }
        return "";
    }

    public MS getOpenChain(MS a_oMS) {
        int t_iAnomPos = a_oMS.getAnomericPosition();
        if (t_iAnomPos == MS.OPEN_CHAIN && !this.m_oMSStateUtil.hasUncertainAnomericCarbon(a_oMS)) {
            return a_oMS;
        }
        if (t_iAnomPos == MS.UNKNOWN_POSITION) {
            MS t_oNewMS = new MS(a_oMS.getSkeletonCode(), 0, 'o');
            for (MOD mod : a_oMS.getMODs()) {
                t_oNewMS.addMOD(mod);
            }
            return t_oNewMS;
        }
        String t_strOpenCD = "o";
        if (t_iAnomPos != 1 && t_iAnomPos != a_oMS.getSkeletonCode().length()) {
            t_strOpenCD = "O";
        }
        StringBuilder t_sbSC = new StringBuilder(a_oMS.getSkeletonCode());
        t_sbSC.replace(t_iAnomPos - 1, t_iAnomPos, t_strOpenCD);
        MS t_oOpenMS = new MS(t_sbSC.toString(), 0, 'o');
        MOD t_oRingMod = this.m_oMSStateUtil.getRingMOD(a_oMS);
        for (MOD mod : a_oMS.getMODs()) {
            if (mod.equals(t_oRingMod)) continue;
            t_oOpenMS.addMOD(mod);
        }
        return t_oOpenMS;
    }

    public MS supersumeAnomer(MS msRES) {
        if (msRES.getAnomericSymbol() == 'x') {
            return msRES;
        }
        MS ret = new MS(msRES.getSkeletonCode(), msRES.getAnomericPosition(), 'x');
        if (this.m_oMSStateUtil.hasRing(msRES)) {
            ret.addMOD(this.m_oMSStateUtil.generateRingPos(msRES, false));
        }
        for (MOD mod : this.m_oMSStateUtil.selectCoreMOD(msRES, msRES.getMODs(), false)) {
            ret.addMOD(mod);
        }
        return ret;
    }

    public MS supersumeRing(MS msRES) {
        String stereo = msRES.getSkeletonCode();
        MS ret = new MS(stereo, msRES.getAnomericPosition(), msRES.getAnomericSymbol());
        if (this.m_oMSStateUtil.hasRing(msRES)) {
            ret.addMOD(this.m_oMSStateUtil.generateRingPos(msRES, true));
        }
        for (MOD mod : this.m_oMSStateUtil.selectCoreMOD(msRES, msRES.getMODs(), false)) {
            ret.addMOD(mod);
        }
        return ret;
    }

    public MS supersumeChilarity(MS msRES) {
        String stereo = msRES.getSkeletonCode();
        stereo = stereo.replaceAll("1", "3");
        stereo = stereo.replaceAll("2", "4");
        stereo = stereo.replaceAll("5", "7");
        stereo = stereo.replaceAll("6", "8");
        MS ret = new MS(stereo, msRES.getAnomericPosition(), msRES.getAnomericSymbol());
        if (this.m_oMSStateUtil.hasRing(msRES)) {
            ret.addMOD(this.m_oMSStateUtil.generateRingPos(msRES, false));
        }
        for (MOD mod : this.m_oMSStateUtil.selectCoreMOD(msRES, msRES.getMODs(), false)) {
            ret.addMOD(mod);
        }
        return ret;
    }

    public MS supersumeMOD(MS msRES) {
        MS ret = new MS(msRES.getSkeletonCode(), msRES.getAnomericPosition(), msRES.getAnomericSymbol());
        if (this.m_oMSStateUtil.hasRing(msRES)) {
            ret.addMOD(this.m_oMSStateUtil.generateRingPos(msRES, false));
        }
        for (MOD mod : this.m_oMSStateUtil.selectCoreMOD(msRES, msRES.getMODs(), true)) {
            ret.addMOD(mod);
        }
        return ret;
    }

    public MS supersumeCoreMOD(MS msRES) {
        MS ret;
        block2: {
            Iterator iterator;
            ret = new MS(msRES.getSkeletonCode(), msRES.getAnomericPosition(), msRES.getAnomericSymbol());
            if (this.m_oMSStateUtil.hasRing(msRES)) {
                ret.addMOD(this.m_oMSStateUtil.generateRingPos(msRES, false));
            }
            if (!(iterator = this.m_oMSStateUtil.selectCoreMOD(msRES, msRES.getMODs(), false).iterator()).hasNext()) break block2;
            MOD mod = (MOD)iterator.next();
            if (this.m_oMSStateUtil.generateMSwithCoreMod(msRES).contains(mod.getMAPCode())) {
                ret.addMOD(mod);
            }
        }
        return ret;
    }

    public MS removeRing(MS msRES) {
        MS ret = new MS(msRES.getSkeletonCode(), 0, ' ');
        for (MOD mod : this.m_oMSStateUtil.selectCoreMOD(msRES, msRES.getMODs(), false)) {
            ret.addMOD(mod);
        }
        return ret;
    }

    public MS removeAnomer(MS msRES) {
        String stereo = msRES.getSkeletonCode();
        MS ret = new MS(stereo, 0, ' ');
        for (MOD mod : this.m_oMSStateUtil.selectCoreMOD(msRES, msRES.getMODs(), false)) {
            ret.addMOD(mod);
        }
        return ret;
    }

    public MS supersume(MS msRES) {
        String stereo = msRES.getSkeletonCode();
        stereo = stereo.replaceAll("1", "3");
        stereo = stereo.replaceAll("2", "4");
        stereo = stereo.replaceAll("5", "7");
        stereo = stereo.replaceAll("6", "8");
        MS ret = new MS(stereo, 0, ' ');
        for (MOD mod : this.m_oMSStateUtil.selectCoreMOD(msRES, msRES.getMODs(), false)) {
            ret.addMOD(mod);
        }
        return ret;
    }

    public LinkedList<MS> standardizeStereoToFuzzy(MS a_oMS) {
        LinkedList<MS> t_aMSs = new LinkedList<MS>();
        t_aMSs.add(a_oMS);
        MSStateDeterminationUtility t_oState = new MSStateDeterminationUtility();
        if (t_oState.hasNoStereo(a_oMS)) {
            return t_aMSs;
        }
        if (!t_oState.hasRelativeConfiguration(a_oMS) || !t_oState.hasAbsoluteConfiguration(a_oMS)) {
            return t_aMSs;
        }
        WURCSSubsumptionConverter t_oConv = new WURCSSubsumptionConverter();
        t_aMSs = new LinkedList();
        MS t_oAbsD = t_oConv.convertConfigurationRelativeToD(a_oMS);
        MS t_oAbsL = t_oConv.convertConfigurationRelativeToL(a_oMS);
        t_aMSs.add(t_oConv.convertConfigurationAbsoluteToRelative(t_oAbsD));
        t_aMSs.add(t_oConv.convertConfigurationAbsoluteToRelative(t_oAbsL));
        return t_aMSs;
    }

    public LinkedList<MS> standardizeStereoToExact(MS a_oMS) {
        MSStateDeterminationUtility t_oState = new MSStateDeterminationUtility();
        LinkedList<MS> t_aMSs = new LinkedList<MS>();
        t_aMSs.add(a_oMS);
        if (t_oState.hasNoStereo(a_oMS)) {
            return t_aMSs;
        }
        WURCSSubsumptionConverter t_oConv = new WURCSSubsumptionConverter();
        if (t_oState.hasAbsoluteConfiguration(a_oMS)) {
            if (!t_oState.hasRelativeConfiguration(a_oMS) && !t_oState.hasUnknownConfiguration(a_oMS)) {
                return t_aMSs;
            }
            if (t_oState.hasRelativeConfiguration(a_oMS)) {
                t_aMSs = new LinkedList();
                t_aMSs.add(t_oConv.convertConfigurationRelativeToD(a_oMS));
                t_aMSs.add(t_oConv.convertConfigurationRelativeToL(a_oMS));
            }
            if (!t_oState.hasUnknownConfiguration(a_oMS)) {
                return t_aMSs;
            }
            LinkedList<MS> t_aTmpMSs = new LinkedList<MS>();
            for (MS t_oMS : t_aMSs) {
                t_aTmpMSs.addAll(t_oConv.convertConfigurationUnknownToAbsolutes(t_oMS));
            }
            return t_aTmpMSs;
        }
        if (!t_oState.hasUnknownConfiguration(a_oMS)) {
            return this.standardizeStereoToFuzzy(a_oMS);
        }
        t_aMSs = new LinkedList();
        WURCSExporter t_oExport = new WURCSExporter();
        LinkedList<String> t_aMSStrings = new LinkedList<String>();
        for (MS t_oMS : t_oConv.convertConfigurationUnknownToAbsolutes(a_oMS)) {
            for (MS t_oStandardMS : this.standardizeStereoToFuzzy(t_oMS)) {
                if (t_aMSStrings.contains(t_oExport.getMSString(t_oStandardMS))) continue;
                t_aMSStrings.add(t_oExport.getMSString(t_oStandardMS));
                t_aMSs.add(t_oStandardMS);
            }
        }
        return t_aMSs;
    }

    public LinkedList<MS> makeSupersumedAllMSs(MS a_oMS) {
        String t_strSuperMS;
        MS t_oSuperMS;
        WURCSSubsumptionConverter t_oConv = new WURCSSubsumptionConverter();
        MS t_oCorrectMS = t_oConv.correctRelativeConfiguration(a_oMS);
        if (t_oCorrectMS == null) {
            t_oCorrectMS = a_oMS;
        }
        LinkedList<Object> t_aSubsumedMSs = new LinkedList<MS>();
        t_aSubsumedMSs.add(t_oCorrectMS);
        LinkedList<MS> t_aStanderdMSs = this.standardizeStereoToFuzzy(t_oCorrectMS);
        if (t_aStanderdMSs != null) {
            t_aSubsumedMSs = t_aStanderdMSs;
        }
        WURCSExporter t_oExport = new WURCSExporter();
        LinkedList<String> t_aSubsumedMSStrings = new LinkedList<String>();
        for (MS mS : t_aSubsumedMSs) {
            t_aSubsumedMSStrings.add(t_oExport.getMSString(mS));
        }
        LinkedList<MS> t_aNewMSs = new LinkedList<MS>();
        for (MS mS : t_aSubsumedMSs) {
            t_oSuperMS = t_oConv.convertUnknownRingSize(mS);
            if (t_oSuperMS == null || t_aSubsumedMSStrings.contains(t_strSuperMS = t_oExport.getMSString(t_oSuperMS))) continue;
            t_aNewMSs.add(t_oSuperMS);
            t_aSubsumedMSStrings.add(t_strSuperMS);
        }
        t_aSubsumedMSs.addAll(t_aNewMSs);
        t_aNewMSs = new LinkedList();
        for (MS mS : t_aSubsumedMSs) {
            t_oSuperMS = t_oConv.convertUnknownAnomer(mS);
            if (t_oSuperMS == null || t_aSubsumedMSStrings.contains(t_strSuperMS = t_oExport.getMSString(t_oSuperMS))) continue;
            t_aNewMSs.add(t_oSuperMS);
            t_aSubsumedMSStrings.add(t_strSuperMS);
        }
        t_aSubsumedMSs.addAll(t_aNewMSs);
        t_aNewMSs = new LinkedList();
        for (MS mS : t_aSubsumedMSs) {
            t_oSuperMS = t_oConv.convertAnomericCarbonToUncertain(mS);
            if (t_oSuperMS == null || t_aSubsumedMSStrings.contains(t_strSuperMS = t_oExport.getMSString(t_oSuperMS))) continue;
            t_aNewMSs.add(t_oSuperMS);
            t_aSubsumedMSStrings.add(t_strSuperMS);
        }
        t_aSubsumedMSs.addAll(t_aNewMSs);
        t_aNewMSs = new LinkedList();
        for (MS mS : t_aSubsumedMSs) {
            t_oSuperMS = t_oConv.convertConfigurationAbsoluteToRelative(mS);
            if (t_oSuperMS == null || t_aSubsumedMSStrings.contains(t_strSuperMS = t_oExport.getMSString(t_oSuperMS))) continue;
            t_aNewMSs.add(t_oSuperMS);
            t_aSubsumedMSStrings.add(t_strSuperMS);
        }
        t_aSubsumedMSs.addAll(t_aNewMSs);
        t_aNewMSs = new LinkedList();
        for (MS mS : t_aSubsumedMSs) {
            t_oSuperMS = t_oConv.convertConfigurationToUnknown(mS);
            if (t_oSuperMS == null || t_aSubsumedMSStrings.contains(t_strSuperMS = t_oExport.getMSString(t_oSuperMS))) continue;
            t_aNewMSs.add(t_oSuperMS);
            t_aSubsumedMSStrings.add(t_strSuperMS);
        }
        t_aSubsumedMSs.addAll(t_aNewMSs);
        return t_aSubsumedMSs;
    }

    public LinkedList<MS> makeSubsumedMSs(MS a_oMS) {
        LinkedList<MS> t_aSubsumedMSs = new LinkedList<MS>();
        t_aSubsumedMSs.add(a_oMS);
        WURCSExporter t_oExport = new WURCSExporter();
        LinkedList<String> t_aSubsumedMSStrings = new LinkedList<String>();
        t_aSubsumedMSStrings.add(t_oExport.getMSString(a_oMS));
        WURCSSubsumptionConverter t_oConv = new WURCSSubsumptionConverter();
        LinkedList<MS> t_aNewMSs = new LinkedList<MS>();
        for (MS t_oTargetMS : t_aSubsumedMSs) {
            String t_strSuperMS;
            MS t_oSuperMS = t_oConv.convertConfigurationToUnknown(t_oTargetMS);
            if (t_oSuperMS == null || t_aSubsumedMSStrings.contains(t_strSuperMS = t_oExport.getMSString(t_oSuperMS))) continue;
            t_aNewMSs.add(t_oSuperMS);
            t_aSubsumedMSStrings.add(t_strSuperMS);
        }
        t_aSubsumedMSs.addAll(t_aNewMSs);
        return t_aSubsumedMSs;
    }

    public MS makeMSComposition(MS a_oMS) {
        MS t_oComposition = a_oMS;
        WURCSSubsumptionConverter t_oConv = new WURCSSubsumptionConverter();
        if ((t_oComposition = t_oConv.convertConfigurationToUnknown(t_oComposition)) == null) {
            return null;
        }
        if (this.m_oMSStateUtil.hasDeoxy(t_oComposition)) {
            t_oComposition = t_oConv.moveDeoxyToMOD(t_oComposition);
            t_oComposition = t_oConv.convertMODPositionToUnknown(t_oComposition);
        }
        return t_oComposition;
    }

    public static MS convertAnobase(MS a_oURES) {
        String t_strSkeletonCode = a_oURES.getSkeletonCode();
        int t_iAnomPos = a_oURES.getAnomericPosition();
        char t_cAnomSymbol = a_oURES.getAnomericSymbol();
        if (t_iAnomPos != 0) {
            t_strSkeletonCode = WURCSSubsumptionIntegrator.replaceAnomericCarbonDescriptorToUndef(t_strSkeletonCode, t_iAnomPos);
        }
        MS t_oAnobaseURES = new MS(t_strSkeletonCode, t_iAnomPos, t_cAnomSymbol);
        for (MOD t_oMOD : WURCSSubsumptionIntegrator.extractCoreModifications(a_oURES)) {
            t_oAnobaseURES.addMOD(t_oMOD);
        }
        return t_oAnobaseURES;
    }

    public static MS supersumes(MS a_oMS) {
        String t_strSkeletonCode = a_oMS.getSkeletonCode();
        int t_iAnomPos = a_oMS.getAnomericPosition();
        char t_cAnomSymbol = a_oMS.getAnomericSymbol();
        if (t_iAnomPos == 0) {
            t_strSkeletonCode = WURCSSubsumptionIntegrator.replaceAnomericCarbonDescriptorToUndef(t_strSkeletonCode, t_iAnomPos);
        } else if (t_cAnomSymbol == 'x') {
            t_strSkeletonCode = WURCSSubsumptionIntegrator.replaceAnomericCarbonDescriptorToUndef(t_strSkeletonCode, t_iAnomPos);
            t_iAnomPos = 0;
        } else {
            t_strSkeletonCode = WURCSSubsumptionIntegrator.replaceAnomericCarbonDescriptorToUnknown(t_strSkeletonCode, t_iAnomPos);
        }
        MS t_oSupersumedMS = new MS(t_strSkeletonCode, t_iAnomPos, 'x');
        for (MOD t_oMOD : a_oMS.getMODs()) {
            boolean isAnomRing = false;
            for (LIPs t_oLIPs : t_oMOD.getListOfLIPs()) {
                if (t_oLIPs.getLIPs().size() != 1 || t_oLIPs.getLIPs().getFirst().getBackbonePosition() != a_oMS.getAnomericPosition()) continue;
                isAnomRing = true;
                break;
            }
            if (t_oMOD.getListOfLIPs().size() == 2 && isAnomRing && t_cAnomSymbol == 'x') continue;
            t_oSupersumedMS.addMOD(t_oMOD);
        }
        return t_oSupersumedMS;
    }

    public static MS convertBasetype(MS a_oURES) {
        String t_strSkeletonCode = a_oURES.getSkeletonCode();
        int t_iAnomPos = a_oURES.getAnomericPosition();
        if (t_iAnomPos != -1) {
            t_strSkeletonCode = WURCSSubsumptionIntegrator.replaceAnomericCarbonDescriptorToUndef(t_strSkeletonCode, t_iAnomPos);
        }
        MS t_oBasetypeURES = new MS(t_strSkeletonCode, 0, 'x');
        for (MOD t_oMOD : WURCSSubsumptionIntegrator.extractCoreModifications(a_oURES)) {
            t_oBasetypeURES.addMOD(t_oMOD);
        }
        return t_oBasetypeURES;
    }

    public static MS convertReducedForm(MS a_oURES) {
        String t_strSkeletonCode = a_oURES.getSkeletonCode();
        int t_iAnomPos = a_oURES.getAnomericPosition();
        t_strSkeletonCode = WURCSSubsumptionIntegrator.replaceAnomericCarbonDescriptorToUndef(t_strSkeletonCode, t_iAnomPos);
        int pos = t_iAnomPos > 0 ? t_iAnomPos - 1 : (t_strSkeletonCode.contains("u") ? t_strSkeletonCode.indexOf("u") : (t_strSkeletonCode.contains("U") ? t_strSkeletonCode.indexOf("U") : 0));
        StringBuilder t_sbReducedForm = new StringBuilder(t_strSkeletonCode);
        t_sbReducedForm.replace(pos, pos + 1, pos == 0 ? "h" : "X");
        MS t_oReducedForm = new MS(t_strSkeletonCode, 0, 'x');
        for (MOD t_oMOD : a_oURES.getMODs()) {
            t_oReducedForm.addMOD(t_oMOD);
        }
        return t_oReducedForm;
    }

    private static LinkedList<MOD> extractCoreModifications(MS a_oURES) {
        LinkedList<MOD> t_aCoreModifs = new LinkedList<MOD>();
        for (MOD mod : a_oURES.getMODs()) {
            if (!mod.getMAPCode().startsWith("*") || mod.getMAPCode().startsWith("*O") || mod.getMAPCode().startsWith("*=O")) continue;
            t_aCoreModifs.add(mod);
        }
        return t_aCoreModifs;
    }

    private static String replaceAnomericCarbonDescriptorToUndef(String a_strSkeletonCode, int a_iAnomPos) {
        if (a_strSkeletonCode.contains("u") || a_strSkeletonCode.contains("U")) {
            return a_strSkeletonCode;
        }
        StringBuilder t_sbBasetype = new StringBuilder(a_strSkeletonCode);
        if (a_iAnomPos == -1) {
            a_iAnomPos = 0;
        }
        if (a_iAnomPos != 0) {
            t_sbBasetype.replace(a_iAnomPos - 1, a_iAnomPos, a_iAnomPos == 1 ? "u" : "U");
            return t_sbBasetype.toString();
        }
        if (a_strSkeletonCode.contains("o") || a_strSkeletonCode.contains("O")) {
            int pos = a_strSkeletonCode.indexOf(111);
            if (pos == -1) {
                pos = a_strSkeletonCode.indexOf(79);
            }
            t_sbBasetype.replace(pos, pos + 1, pos == 0 ? "u" : "U");
            return t_sbBasetype.toString();
        }
        return a_strSkeletonCode;
    }

    private static String replaceAnomericCarbonDescriptorToUnknown(String a_strSkeletonCode, int a_iAnomPos) {
        if (a_strSkeletonCode.contains("u") || a_strSkeletonCode.contains("U")) {
            return a_strSkeletonCode;
        }
        StringBuilder t_sbBasetype = new StringBuilder(a_strSkeletonCode);
        if (a_iAnomPos == -1) {
            a_iAnomPos = 0;
        }
        if (a_iAnomPos != 0) {
            t_sbBasetype.replace(a_iAnomPos - 1, a_iAnomPos, a_iAnomPos == 1 ? "x" : "X");
            return t_sbBasetype.toString();
        }
        return a_strSkeletonCode;
    }
}

