/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.array.mass;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.array.WURCSExporter;
import org.glycoinfo.WURCSFramework.util.array.mass.CarbonDescriptorPropaties;
import org.glycoinfo.WURCSFramework.util.array.mass.WURCSMassException;
import org.glycoinfo.WURCSFramework.util.property.AtomicProperties;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIP;
import org.glycoinfo.WURCSFramework.wurcs.array.GLIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.LIN;
import org.glycoinfo.WURCSFramework.wurcs.array.MOD;
import org.glycoinfo.WURCSFramework.wurcs.array.RES;
import org.glycoinfo.WURCSFramework.wurcs.array.UniqueRES;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;

public class WURCSMassCalculator {
    private static int m_iPrecisionMax = 0;
    private static int m_iPrecisionMin = 999;

    public static BigDecimal calcMassWURCS(WURCSArray a_objWURCS) throws WURCSMassException {
        if (a_objWURCS.isComposition()) {
            throw new WURCSMassException("Cannot calculate mass of compositions.");
        }
        m_iPrecisionMax = 0;
        WURCSExporter t_oExporter = new WURCSExporter();
        HashMap<UniqueRES, Double> t_hashUniqREStoMass = new HashMap<UniqueRES, Double>();
        HashMap<UniqueRES, BigDecimal> t_hashUniqREStoMassBD = new HashMap<UniqueRES, BigDecimal>();
        LinkedList<UniqueRES> uRESList = a_objWURCS.getUniqueRESs();
        for (UniqueRES ures : uRESList) {
            double t_dMass = 0.0;
            BigDecimal t_bdMass = new BigDecimal("0");
            String skCode = ures.getSkeletonCode();
            if (skCode.contains("<0>") || skCode.contains("<Q>")) {
                throw new WURCSMassException("Cannot calculate unknown carbon length. : " + t_oExporter.getUniqueRESString(ures));
            }
            BigDecimal t_bdSCMass = WURCSMassCalculator.getMassSkeletonCode(skCode);
            t_bdMass = t_bdMass.add(t_bdSCMass);
            for (MOD mod : ures.getMODs()) {
                BigDecimal t_dMassMOD = WURCSMassCalculator.calcMassLinkage(mod.getMAPCode(), mod.getListOfLIPs().size());
                t_bdMass = t_bdMass.add(t_dMassMOD);
            }
            t_hashUniqREStoMass.put(ures, t_dMass);
            t_hashUniqREStoMassBD.put(ures, t_bdMass);
        }
        BigDecimal t_bdMass = new BigDecimal("0");
        for (RES res : a_objWURCS.getRESs()) {
            UniqueRES ures = uRESList.get(res.getUniqueRESID() - 1);
            t_bdMass = t_bdMass.add((BigDecimal)t_hashUniqREStoMassBD.get(ures));
        }
        for (LIN lin : a_objWURCS.getLINs()) {
            if (lin.isRepeatingUnit()) {
                throw new WURCSMassException("Cannot calculate repeating unit. : " + t_oExporter.getLINString(lin));
            }
            for (GLIPs glips : lin.getListOfGLIPs()) {
                GLIP glip0 = glips.getGLIPs().getFirst();
                if (glip0.getBackboneProbabilityLower() == 1.0 && glip0.getModificationProbabilityLower() == 1.0) continue;
                throw new WURCSMassException("Cannot calculate linkage with probability. : " + t_oExporter.getLINString(lin));
            }
            BigDecimal t_bdMassLIN = WURCSMassCalculator.calcMassLinkage(lin.getMAPCode(), lin.getListOfGLIPs().size());
            t_bdMass = t_bdMass.add(t_bdMassLIN);
        }
        System.out.println(t_bdMass);
        t_bdMass = t_bdMass.round(new MathContext(m_iPrecisionMax, RoundingMode.HALF_UP));
        return t_bdMass;
    }

    public static BigDecimal calcMassLinkage(String a_strMAPCode, int nLink) {
        BigDecimal t_bdOHMass = WURCSMassCalculator.getMassMAP("*O");
        BigDecimal t_bdHMass = WURCSMassCalculator.getMassMAP("*H");
        BigDecimal t_bdHydrateMass = t_bdOHMass.add(t_bdHMass);
        BigDecimal t_bdMass = new BigDecimal("0");
        int nDehydration = 0;
        if (nLink > 1) {
            nDehydration = nLink - 1;
            t_bdMass = t_bdMass.subtract(t_bdHydrateMass.multiply(new BigDecimal(nDehydration)));
        }
        if (a_strMAPCode.length() == 0) {
            return t_bdMass;
        }
        if (a_strMAPCode.length() > 1 && a_strMAPCode.charAt(1) == '=') {
            t_bdMass = t_bdMass.add(t_bdHMass);
        }
        t_bdMass = t_bdMass.subtract(t_bdOHMass.subtract(t_bdHMass.multiply(new BigDecimal(nDehydration))));
        BigDecimal t_bdMAPMass = WURCSMassCalculator.getMassMAP(a_strMAPCode);
        t_bdMass = t_bdMass.add(t_bdMAPMass);
        return t_bdMass;
    }

    public static BigDecimal getMassSkeletonCode(String a_strSkeleton) {
        BigDecimal t_bdMass = new BigDecimal("0");
        int l = a_strSkeleton.length();
        for (int i = 0; i < l; ++i) {
            char c = a_strSkeleton.charAt(i);
            CarbonDescriptorPropaties t_enumCDP = CarbonDescriptorPropaties.forCharacter(c, i == 0 || i == l - 1);
            t_bdMass = t_bdMass.add(t_enumCDP.getDefaultMass());
            WURCSMassCalculator.updatePrecisionMax(t_enumCDP.getMaxSignificantDigit());
        }
        return t_bdMass;
    }

    public static BigDecimal getMassMAP(String a_strMAP) {
        BigDecimal t_bdMass = new BigDecimal("0");
        if (a_strMAP.equals("*S")) {
            t_bdMass = t_bdMass.add(AtomicProperties.S.getMass());
            t_bdMass = t_bdMass.add(AtomicProperties.H.getMass());
            WURCSMassCalculator.updatePrecisionMax(AtomicProperties.S.getMassPrecision());
            WURCSMassCalculator.updatePrecisionMax(AtomicProperties.H.getMassPrecision());
            return t_bdMass;
        }
        int nTotalValence = 0;
        int nConnection = -1;
        for (int i = 0; i < a_strMAP.length(); ++i) {
            AtomicProperties prop;
            char second;
            char c = a_strMAP.charAt(i);
            if (c == '(' || c == ')') continue;
            if (c == '^') {
                if ((c = a_strMAP.charAt(++i)) != 'E' && c != 'Z') continue;
                ++nConnection;
                continue;
            }
            if (c == '/') {
                ++i;
                continue;
            }
            ++nConnection;
            if (c == '=') {
                if (a_strMAP.charAt(i + 1) != '^') continue;
                ++i;
                ++i;
                continue;
            }
            if (c == '#') {
                ++nConnection;
                continue;
            }
            if (c == '*') {
                while (i + 1 != a_strMAP.length() && Character.isDigit(a_strMAP.charAt(i + 1))) {
                    ++i;
                }
                ++nTotalValence;
                if (i + 1 == a_strMAP.length()) continue;
                if (a_strMAP.charAt(i + 1) == '=') {
                    ++nTotalValence;
                }
                if (a_strMAP.charAt(i + 1) != '#') continue;
                nTotalValence += 2;
                continue;
            }
            if (c == '$') {
                ++i;
                continue;
            }
            String symbol = "" + c;
            if (i + 1 != a_strMAP.length() && Character.isLowerCase(second = a_strMAP.charAt(i + 1))) {
                ++i;
                symbol = symbol + second;
            }
            if ((prop = AtomicProperties.forSymbol(symbol)) == null) {
                return new BigDecimal("0");
            }
            nTotalValence += prop.getValence();
            t_bdMass = t_bdMass.add(prop.getMass());
            WURCSMassCalculator.updatePrecisionMax(prop.getMassPrecision());
        }
        int nH = nTotalValence - 2 * nConnection;
        t_bdMass = t_bdMass.add(AtomicProperties.H.getMass().multiply(new BigDecimal(nH)));
        if (nH > 0) {
            WURCSMassCalculator.updatePrecisionMax(AtomicProperties.H.getMassPrecision());
        }
        return t_bdMass;
    }

    private static void updatePrecisionMax(int a_iPrecision) {
        if (m_iPrecisionMax < a_iPrecision) {
            m_iPrecisionMax = a_iPrecision;
        }
    }
}

