/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.spectrum.datamodel;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;

public class AnnotationGrid {
    protected AnnotationCell gridBounds = null;
    protected HashMap<AnnotationCell, Object> htCellToAnnotation;
    protected XYPlot plot = null;
    protected Rectangle2D dataArea = null;
    protected ValueAxis domainAxis = null;
    protected ValueAxis rangeAxis = null;
    protected double dCellHeight;
    protected double dCellWidth;
    protected int iMaxCellsHoriz;
    protected int iMaxCellVert;
    protected double dScaleX = 1.0;
    protected double dScaleY = 1.0;

    public AnnotationGrid(XYPlot plot, Rectangle2D dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, double dScaleX, double dScaleY) {
        this.plot = plot;
        this.dataArea = dataArea;
        this.domainAxis = domainAxis;
        this.rangeAxis = rangeAxis;
        this.htCellToAnnotation = new HashMap();
        this.dScaleX = dScaleX;
        this.dScaleY = dScaleY;
        this.gridBounds = this.getNewCell(this.domainAxis.getLowerBound(), this.rangeAxis.getLowerBound(), this.domainAxis.getUpperBound(), this.rangeAxis.getUpperBound());
    }

    public void initializeGrid(double dCellWidth, double dCellHeight) {
        if (this.gridBounds == null) {
            return;
        }
        this.dCellWidth = dCellWidth / this.dScaleX;
        this.dCellHeight = dCellHeight / this.dScaleY;
        this.iMaxCellsHoriz = (int)Math.floor((double)this.gridBounds.getScreenWidth() / dCellWidth);
        this.iMaxCellVert = (int)Math.floor((double)this.gridBounds.getScreenHeight() / dCellHeight);
    }

    public double getScaleX() {
        return this.dScaleX;
    }

    public double getScaleY() {
        return this.dScaleY;
    }

    public int[] getGridCoords(double x1, double y1) {
        double relX = x1 - (double)this.gridBounds.getScreenLowX();
        double relY = y1 - (double)this.gridBounds.getScreenLowY();
        int iCellHoriz1 = (int)Math.floor(relX / this.dCellWidth);
        int iCellVert1 = (int)Math.floor(relY / this.dCellHeight) - 1;
        if (iCellVert1 < 0) {
            iCellVert1 = 0;
        }
        return new int[]{iCellHoriz1, iCellVert1};
    }

    private AnnotationCell getPutAnnotationCell(double screenX, double screenY, int iAdder, int iPrefX) {
        int y = 0;
        while (y <= iAdder) {
            double dYAdd = -1.0 * ((double)y * this.dCellHeight);
            int iCnt = 1;
            if (y != iAdder) {
                iCnt = 2 * iAdder;
            }
            int x = iAdder;
            while (x >= -1 * iAdder) {
                double dXAdd = (double)x * this.dCellWidth;
                AnnotationCell cell2 = new AnnotationCell((float)(screenX + dXAdd), (float)(screenX + dXAdd + this.dCellWidth), (float)(screenY + dYAdd - this.dCellHeight), (float)(screenY + dYAdd));
                if ((iPrefX == -1 || (int)cell2.getScreenLowX() == iPrefX) && this.isVisible(cell2.getScreenLowX(), cell2.getScreenLowY()) && this.isVisible(cell2.getScreenHighX(), cell2.getScreenHighY()) && !this.htCellToAnnotation.containsKey(cell2)) {
                    return cell2;
                }
                x -= iCnt;
            }
            ++y;
        }
        if (iAdder > this.iMaxCellVert && iAdder > this.iMaxCellsHoriz) {
            return null;
        }
        return this.getPutAnnotationCell(screenX, screenY, iAdder + 1, iPrefX);
    }

    public void fillCell(int iCol, int iRow) {
        double gridScreenY;
        double gridScreenX = (double)iCol * this.dCellWidth + (double)this.gridBounds.getScreenLowX();
        AnnotationCell cell = this.getPutAnnotationCell(gridScreenX, gridScreenY = (double)(iRow - 1) * this.dCellHeight + (double)this.gridBounds.getScreenLowY(), 0, -1);
        if (cell != null) {
            this.htCellToAnnotation.put(cell, Boolean.TRUE);
        }
    }

    public AnnotationCell putAnnotation(Object obj, double domainX, double rangeY, int iPrefX) {
        double gridScreenY;
        AnnotationCell origCell = this.getNewCell(domainX, rangeY);
        if (origCell == null) {
            return null;
        }
        int[] iGridCoords = this.getGridCoords(origCell.getScreenLowX(), origCell.getScreenHighY());
        double gridScreenX = (double)iGridCoords[0] * this.dCellWidth + (double)this.gridBounds.getScreenLowX();
        AnnotationCell cell = this.getPutAnnotationCell(gridScreenX, gridScreenY = (double)(iGridCoords[1] - 1) * this.dCellHeight + (double)this.gridBounds.getScreenLowY(), 0, iPrefX);
        if (cell != null) {
            this.htCellToAnnotation.put(cell, obj);
        }
        return cell;
    }

    public AnnotationCell getNewCell(double domainX, double rangeY) {
        float screenLowX = 0.0f;
        float screenHighX = 0.0f;
        float screenHighY = 0.0f;
        float screenLowY = 0.0f;
        PlotOrientation orientation = this.plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation((AxisLocation)this.plot.getDomainAxisLocation(), (PlotOrientation)orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation((AxisLocation)this.plot.getRangeAxisLocation(), (PlotOrientation)orientation);
        if (orientation == PlotOrientation.VERTICAL) {
            screenLowX = (float)this.domainAxis.valueToJava2D(domainX, this.dataArea, domainEdge);
            screenLowY = (float)this.rangeAxis.valueToJava2D(rangeY, this.dataArea, rangeEdge);
            screenHighX = screenLowX;
            screenHighY = screenLowY;
        } else if (orientation == PlotOrientation.HORIZONTAL) {
            screenLowY = (float)this.domainAxis.valueToJava2D(domainX, this.dataArea, domainEdge);
            screenLowX = (float)this.rangeAxis.valueToJava2D(rangeY, this.dataArea, rangeEdge);
            screenHighY = screenLowY;
            screenHighX = screenLowX;
        }
        if (this.isVisible(screenLowX, screenLowY) && this.isVisible(screenHighX, screenHighY)) {
            return new AnnotationCell(screenLowX, screenHighX, screenLowY, screenHighY);
        }
        return null;
    }

    public boolean isVisible(float screenX, float screenY) {
        if (this.gridBounds == null) {
            return true;
        }
        return screenX >= this.gridBounds.getScreenLowX() && screenX <= this.gridBounds.getScreenHighX() && screenY >= this.gridBounds.getScreenLowY() && screenY <= this.gridBounds.getScreenHighY();
    }

    public double[] convertToDataValue(float dScreenX, float dScreenY) {
        float dataX = 0.0f;
        float dataY = 0.0f;
        PlotOrientation orientation = this.plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation((AxisLocation)this.plot.getDomainAxisLocation(), (PlotOrientation)orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation((AxisLocation)this.plot.getRangeAxisLocation(), (PlotOrientation)orientation);
        dataX = (float)this.domainAxis.java2DToValue((double)dScreenX, this.dataArea, domainEdge);
        dataY = (float)this.rangeAxis.java2DToValue((double)dScreenY, this.dataArea, rangeEdge);
        return new double[]{dataX, dataY};
    }

    private AnnotationCell getNewCell(double domainLow, double rangeLow, double domainHigh, double rangeHigh) {
        float screenLowX = 0.0f;
        float screenHighX = 0.0f;
        float screenHighY = 0.0f;
        float screenLowY = 0.0f;
        PlotOrientation orientation = this.plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation((AxisLocation)this.plot.getDomainAxisLocation(), (PlotOrientation)orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation((AxisLocation)this.plot.getRangeAxisLocation(), (PlotOrientation)orientation);
        if (orientation == PlotOrientation.VERTICAL) {
            screenLowX = (float)this.domainAxis.valueToJava2D(domainLow, this.dataArea, domainEdge);
            screenHighY = (float)this.rangeAxis.valueToJava2D(rangeLow, this.dataArea, rangeEdge);
            screenHighX = (float)this.domainAxis.valueToJava2D(domainHigh, this.dataArea, domainEdge);
            screenLowY = (float)this.rangeAxis.valueToJava2D(rangeHigh, this.dataArea, rangeEdge);
        } else if (orientation == PlotOrientation.HORIZONTAL) {
            screenHighY = (float)this.domainAxis.valueToJava2D(domainLow, this.dataArea, domainEdge);
            screenLowX = (float)this.rangeAxis.valueToJava2D(rangeLow, this.dataArea, rangeEdge);
            screenLowY = (float)this.domainAxis.valueToJava2D(domainHigh, this.dataArea, domainEdge);
            screenHighX = (float)this.rangeAxis.valueToJava2D(rangeHigh, this.dataArea, rangeEdge);
        }
        if (this.isVisible(screenLowX, screenLowY) && this.isVisible(screenHighX, screenHighY)) {
            return new AnnotationCell(screenLowX, screenHighX, screenLowY, screenHighY);
        }
        return null;
    }

    public double getCellHeight() {
        return this.dCellHeight;
    }

    public double getCellWidth() {
        return this.dCellWidth;
    }

    public class AnnotationCell {
        float dScreenLowX = 0.0f;
        float dScreenHighX = 0.0f;
        float dScreenHighY = 0.0f;
        float dScreenLowY = 0.0f;
        private int dHashCode = -1;

        public AnnotationCell() {
        }

        public AnnotationCell(float dScreenLowX, float dScreenHighX, float dScreenLowY, float dScreenHighY) {
            this.dScreenLowX = dScreenLowX;
            this.dScreenHighX = dScreenHighX;
            this.dScreenLowY = dScreenLowY;
            this.dScreenHighY = dScreenHighY;
        }

        public boolean equals(Object arg0) {
            if (!(arg0 instanceof AnnotationCell)) {
                return false;
            }
            return this.hashCode() == arg0.hashCode();
        }

        public int hashCode() {
            if (this.dHashCode != -1) {
                return this.dHashCode;
            }
            int hash = 5;
            hash = hash * 17 + (int)this.dScreenLowX;
            hash = hash * 31 + (int)this.dScreenHighX;
            hash = hash * 13 + (int)this.dScreenHighY;
            this.dHashCode = hash = hash * 89 + (int)this.dScreenLowY;
            return this.hashCode();
        }

        public float getScreenLowX() {
            return this.dScreenLowX;
        }

        public float getScreenHighX() {
            return this.dScreenHighX;
        }

        public float getScreenHighY() {
            return this.dScreenHighY;
        }

        public float getScreenLowY() {
            return this.dScreenLowY;
        }

        public float getScreenWidth() {
            return this.getScreenHighX() - this.getScreenLowX();
        }

        public float getScreenHeight() {
            return this.getScreenHighY() - this.getScreenLowY();
        }

        public String toString() {
            return "[ [" + this.getScreenLowX() + ":" + this.getScreenHighY() + "], [" + this.getScreenHighX() + ":" + this.getScreenLowY() + "] ]";
        }
    }
}

