/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;
import org.grits.toolbox.core.utilShare.TextFieldUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddEditIonDialog;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.AddIonExchangeForm;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.GridUtils;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.om.data.IonSettings;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Molecule;

public class AddAdductsForm
extends WizardPage {
    private Method method;
    private Text txtMaxCharge;
    private List<GridItem> adductGridItems = new ArrayList<GridItem>();
    private Map<String, Object> adducts = new HashMap<String, Object>();
    private Grid gridAdduct;
    private Button btnDeleteAdduct;
    private Button btnEditAdduct;
    private boolean canFlip = false;
    private List<Molecule> allPossibleAdducts;
    private ModifyListener txtMaxChargeModifyListener;
    private static final String ADD_DIALOG_TITLE = "Add/Edit Adduct Dialog";

    public AddAdductsForm(Method method) {
        super("wizardPage");
        this.setTitle("Ion Settings");
        this.setDescription("Add different ion settings");
        this.setMethod(method);
        if (method.getIons() == null || method.getIons().isEmpty()) {
            IonSettings defaultAdduct = new IonSettings(GlycanPreDefinedOptions.ION_ADDUCT_SODIUM);
            defaultAdduct.getCounts().add(4);
            this.adducts.put(GlycanPreDefinedOptions.ION_ADDUCT_SODIUM.getLabel(), defaultAdduct);
        }
    }

    private List<Molecule> getPossibleAdducts() {
        ArrayList<Molecule> adductList = new ArrayList<Molecule>();
        adductList.add((Molecule)new IonSettings(GlycanPreDefinedOptions.ION_ADDUCT_SODIUM));
        adductList.add((Molecule)new IonSettings(GlycanPreDefinedOptions.ION_ADDUCT_HYDROGEN));
        adductList.add((Molecule)new IonSettings(GlycanPreDefinedOptions.ION_ADDUCT_CHLORINE));
        adductList.add((Molecule)new IonSettings(GlycanPreDefinedOptions.ION_ADDUCT_LITHIUM));
        adductList.add((Molecule)new IonSettings(GlycanPreDefinedOptions.ION_ADDUCT_POTASSIUM));
        adductList.add((Molecule)new IonSettings(GlycanPreDefinedOptions.ION_ADDUCT_NEGHYDROGEN));
        adductList.add((Molecule)new IonSettings(GlycanPreDefinedOptions.ION_ADDUCT_CALCIUM));
        return adductList;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.allPossibleAdducts = this.getPossibleAdducts();
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblMaxCharge = new Label(container, 0);
        lblMaxCharge.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        lblMaxCharge.setText("Max Charge*");
        this.txtMaxCharge = new Text(container, 2048);
        this.txtMaxCharge.setText("4");
        this.txtMaxChargeModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AddAdductsForm.this.validateInput()) {
                    AddAdductsForm.this.setPageComplete(true);
                } else {
                    AddAdductsForm.this.setPageComplete(false);
                }
            }
        };
        this.txtMaxCharge.addModifyListener(this.txtMaxChargeModifyListener);
        this.txtMaxCharge.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblAdductSettings = new Label(container, 0);
        lblAdductSettings.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        lblAdductSettings.setText("Adduct Settings*");
        Button btnAddAdduct = new Button(container, 0);
        btnAddAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridUtils.addButtonPressed(AddAdductsForm.ADD_DIALOG_TITLE, AddAdductsForm.this.gridAdduct, AddAdductsForm.this.adductGridItems, AddAdductsForm.this.adducts, AddAdductsForm.this.allPossibleAdducts, true, AddEditIonDialog.DialogType.ION_SETTINGS, AddAdductsForm.this.getShell());
                if (AddAdductsForm.this.validateInput()) {
                    AddAdductsForm.this.setPageComplete(true);
                } else {
                    AddAdductsForm.this.setPageComplete(false);
                }
            }
        });
        btnAddAdduct.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAddAdduct.setText(" Add Adduct");
        new Label(container, 0);
        this.btnDeleteAdduct = new Button(container, 0);
        this.btnDeleteAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridUtils.deleteAdductsFromGrid(AddAdductsForm.this.gridAdduct, AddAdductsForm.this.adductGridItems, AddAdductsForm.this.adducts);
                if (AddAdductsForm.this.validateInput()) {
                    AddAdductsForm.this.setPageComplete(true);
                } else {
                    AddAdductsForm.this.setPageComplete(false);
                }
            }
        });
        this.btnDeleteAdduct.setEnabled(false);
        this.btnDeleteAdduct.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDeleteAdduct.setText("Delete Adduct");
        new Label(container, 0);
        this.btnEditAdduct = new Button(container, 0);
        this.btnEditAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddAdductsForm.this.handleEdit();
            }
        });
        this.btnEditAdduct.setEnabled(false);
        this.btnEditAdduct.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnEditAdduct.setText("Edit Adduct");
        new Label(container, 0);
        this.gridAdduct = new Grid(container, 2048);
        this.gridAdduct.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AddAdductsForm.this.gridAdduct.getSelection().length != 0) {
                    AddAdductsForm.this.btnDeleteAdduct.setEnabled(true);
                    AddAdductsForm.this.btnEditAdduct.setEnabled(true);
                }
            }
        });
        this.gridAdduct.setHeaderVisible(true);
        GridData gd_gridAdduct = new GridData(4, 4, true, true, 1, 1);
        gd_gridAdduct.heightHint = 20;
        this.gridAdduct.setLayoutData((Object)gd_gridAdduct);
        GridColumn gridColumn = new GridColumn(this.gridAdduct, 0);
        gridColumn.setWidth(150);
        gridColumn.setText("Name");
        GridColumn gridColumn_0 = new GridColumn(this.gridAdduct, 0);
        gridColumn_0.setWidth(50);
        gridColumn_0.setText("Label");
        GridColumn gridColumn_1 = new GridColumn(this.gridAdduct, 0);
        gridColumn_1.setWidth(100);
        gridColumn_1.setText("Polarity");
        GridColumn gridColumn_2 = new GridColumn(this.gridAdduct, 0);
        gridColumn_2.setWidth(50);
        gridColumn_2.setText("Charge");
        GridColumn gridColumn_3 = new GridColumn(this.gridAdduct, 0);
        gridColumn_3.setWidth(100);
        gridColumn_3.setText("Mass");
        GridColumn gridColumn_4 = new GridColumn(this.gridAdduct, 0);
        gridColumn_4.setWidth(100);
        gridColumn_4.setText("Number");
        if (this.gridAdduct.getItemCount() == 0 && this.adducts.keySet().size() == 1) {
            GridUtils.addToAdductGrid(this.gridAdduct, this.adductGridItems, this.adducts, (Molecule)this.adducts.get(GlycanPreDefinedOptions.ION_ADDUCT_SODIUM.getLabel()));
        }
        this.gridAdduct.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                AddAdductsForm.this.handleEdit();
            }
        });
        this.setControl((Control)container);
        this.updateControlsFromPreferences();
        if (this.validateInput()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public void handleEdit() {
        if (this.gridAdduct.getSelectionIndices().length == 0) {
            this.setErrorMessage("You must select an adduct to edit.");
            return;
        }
        if (this.gridAdduct.getSelectionIndices().length > 1) {
            this.setErrorMessage("You can edit only one adduct at a time");
            return;
        }
        GridUtils.editButtonPressed(ADD_DIALOG_TITLE, this.gridAdduct, this.adductGridItems, this.adducts, this.allPossibleAdducts, true, AddEditIonDialog.DialogType.ION_SETTINGS, this.getShell());
        if (this.validateInput()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    public boolean canFlipToNextPage() {
        return this.canFlip;
    }

    public boolean validateInput() {
        if (this.adductGridItems.isEmpty() || this.gridAdduct.getSelectionCount() == 0) {
            this.btnDeleteAdduct.setEnabled(false);
            this.btnEditAdduct.setEnabled(false);
        }
        if (TextFieldUtils.isEmpty((Text)this.txtMaxCharge) || !TextFieldUtils.isInteger((Text)this.txtMaxCharge) || !TextFieldUtils.isNonZero((Text)this.txtMaxCharge)) {
            this.setErrorMessage("Please enter a valid number for charge");
            this.canFlip = false;
            return false;
        }
        if (this.adducts.keySet().size() == 0) {
            this.setErrorMessage("Please add a valid adduct");
            this.canFlip = false;
            return false;
        }
        this.setErrorMessage(null);
        this.save();
        this.canFlip = true;
        return true;
    }

    public boolean checkAdduct() {
        return this.adductGridItems.size() != 0;
    }

    public void save() {
        if (!this.isPageComplete()) {
            return;
        }
        this.method.setMaxIonCount(Integer.valueOf(Integer.parseInt(this.txtMaxCharge.getText())));
        ArrayList<IonSettings> adductsFinalList = new ArrayList<IonSettings>();
        for (Object adduct : this.adducts.values()) {
            adductsFinalList.add((IonSettings)adduct);
        }
        this.method.setIons(adductsFinalList);
        IWizardPage nextPage = this.getNextPage();
        if (nextPage != null && nextPage instanceof AddIonExchangeForm) {
            ((AddIonExchangeForm)nextPage).updatePossibleIons();
            ((AddIonExchangeForm)nextPage).setTraversedTo(true);
            if (!((AddIonExchangeForm)nextPage).canFlipToNextPage()) {
                this.setErrorMessage("Error on Ion Exchange page. Please fix the next page.");
                this.setPageComplete(false);
                return;
            }
        }
        this.setErrorMessage(null);
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void updateControlsFromPreferences() {
        if (!(this.getWizard() instanceof MSGlycanAnnotationWizard)) {
            return;
        }
        this.removeListeners();
        MSGlycanAnnotationWizard myWizard = (MSGlycanAnnotationWizard)this.getWizard();
        if (myWizard.getPreferences() != null && myWizard.getPreferences().getMethod() != null) {
            Integer ionCount = myWizard.getPreferences().getMethod().getMaxIonCount();
            this.txtMaxCharge.setText("" + ionCount);
            this.adducts.clear();
            this.gridAdduct.disposeAllItems();
            List ionSettings = myWizard.getPreferences().getMethod().getIons();
            for (IonSettings adduct : ionSettings) {
                if (GridUtils.getDuplicateAdduct(this.adducts, (Molecule)adduct) != null) continue;
                GridUtils.addToAdductGrid(this.gridAdduct, this.adductGridItems, this.adducts, (Molecule)adduct);
            }
        }
        this.addListeners();
    }

    private void addListeners() {
        this.txtMaxCharge.addModifyListener(this.txtMaxChargeModifyListener);
    }

    private void removeListeners() {
        this.txtMaxCharge.removeModifyListener(this.txtMaxChargeModifyListener);
    }
}

