/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.heatmap.clustering;

import com.apporiented.algorithm.clustering.Cluster;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.widgets.heatmap.clustering.Paintable;
import org.grits.toolbox.widgets.heatmap.clustering.VCoord;

public class ClusterComponent
implements Paintable {
    private Cluster cluster;
    private VCoord linkPoint;
    private VCoord initPoint;
    private boolean printName;
    private int dotRadius = 2;
    private int namePadding = 6;
    private List<ClusterComponent> children;
    private Font labelFont;

    public List<ClusterComponent> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<ClusterComponent>();
        }
        return this.children;
    }

    public int getNamePadding() {
        return this.namePadding;
    }

    public void setNamePadding(int namePadding) {
        this.namePadding = namePadding;
    }

    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(int dotRadius) {
        this.dotRadius = dotRadius;
    }

    public void setChildren(List<ClusterComponent> children) {
        this.children = children;
    }

    public VCoord getLinkPoint() {
        return this.linkPoint;
    }

    public void setLinkPoint(VCoord linkPoint) {
        this.linkPoint = linkPoint;
    }

    public VCoord getInitPoint() {
        return this.initPoint;
    }

    public void setInitPoint(VCoord initPoint) {
        this.initPoint = initPoint;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public boolean isPrintName() {
        return this.printName;
    }

    public void setPrintName(boolean printName) {
        this.printName = printName;
    }

    public ClusterComponent(Cluster cluster, boolean printName, VCoord initPoint) {
        this.printName = printName;
        this.cluster = cluster;
        this.initPoint = initPoint;
        this.linkPoint = initPoint;
        Font sysFont = Display.getCurrent().getSystemFont();
        this.labelFont = XYGraphMediaFactory.getInstance().getFont(new FontData(sysFont.getFontData()[0].getName(), 8, 0));
    }

    @Override
    public void paint(Graphics g, int xDisplayOffset, int yDisplayOffset, double xDisplayFactor, double yDisplayFactor, boolean decorated, boolean horizontal) {
        this.paint(g, xDisplayOffset, yDisplayOffset, xDisplayFactor, yDisplayFactor, decorated, true);
    }

    @Override
    public void paint(Graphics g, int xDisplayOffset, int yDisplayOffset, double xDisplayFactor, double yDisplayFactor, boolean decorated, boolean horizontal, boolean primarySide) {
        int y2;
        int x2;
        int y1;
        int x1;
        if (!horizontal) {
            x1 = (int)(this.initPoint.getX() * xDisplayFactor + (double)xDisplayOffset);
            y1 = (int)(this.initPoint.getY() * yDisplayFactor + (double)yDisplayOffset);
            x2 = (int)(this.linkPoint.getX() * xDisplayFactor + (double)xDisplayOffset);
            y2 = y1;
            g.fillOval(x1 - this.dotRadius, y1 - this.dotRadius, this.dotRadius * 2, this.dotRadius * 2);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
            y2 = (int)(this.linkPoint.getY() * yDisplayFactor + (double)yDisplayOffset);
            g.drawLine(x1, y1, x2, y2);
        } else {
            x1 = (int)(this.initPoint.getX() * xDisplayFactor + (double)xDisplayOffset);
            y1 = (int)(this.initPoint.getY() * yDisplayFactor + (double)yDisplayOffset);
            x2 = x1;
            y2 = (int)(this.linkPoint.getY() * yDisplayFactor + (double)yDisplayOffset);
            g.fillOval(x1 - this.dotRadius, y1 - this.dotRadius, this.dotRadius * 2, this.dotRadius * 2);
            g.drawLine(x1, y1, x2, y2);
            x1 = x2;
            y1 = y2;
            x2 = (int)(this.linkPoint.getX() * xDisplayFactor + (double)xDisplayOffset);
            g.fillOval(x1 - this.dotRadius, y1 - this.dotRadius, this.dotRadius * 2, this.dotRadius * 2);
            g.drawLine(x1, y1, x2, y2);
        }
        for (ClusterComponent child : this.children) {
            child.paint(g, xDisplayOffset, yDisplayOffset, xDisplayFactor, yDisplayFactor, decorated, horizontal, primarySide);
        }
    }

    public double getRectMinX() {
        assert (this.initPoint != null && this.linkPoint != null);
        double val = Math.min(this.initPoint.getX(), this.linkPoint.getX());
        for (ClusterComponent child : this.getChildren()) {
            val = Math.min(val, child.getRectMinX());
        }
        return val;
    }

    public double getRectMinY() {
        assert (this.initPoint != null && this.linkPoint != null);
        double val = Math.min(this.initPoint.getY(), this.linkPoint.getY());
        for (ClusterComponent child : this.getChildren()) {
            val = Math.min(val, child.getRectMinY());
        }
        return val;
    }

    public double getRectMaxX() {
        assert (this.initPoint != null && this.linkPoint != null);
        double val = Math.max(this.initPoint.getX(), this.linkPoint.getX());
        for (ClusterComponent child : this.getChildren()) {
            val = Math.max(val, child.getRectMaxX());
        }
        return val;
    }

    public double getRectMaxY() {
        assert (this.initPoint != null && this.linkPoint != null);
        double val = Math.max(this.initPoint.getY(), this.linkPoint.getY());
        for (ClusterComponent child : this.getChildren()) {
            val = Math.max(val, child.getRectMaxY());
        }
        return val;
    }

    public int getNameWidth(Graphics g, boolean includeNonLeafs) {
        int width = 0;
        if (includeNonLeafs || this.cluster.isLeaf()) {
            Dimension rect = FigureUtilities.getTextExtents((String)this.cluster.getName(), (Font)this.labelFont);
            width = rect.width;
        }
        return width;
    }

    public int getMaxNameWidth(Graphics g, boolean includeNonLeafs) {
        int width = this.getNameWidth(g, includeNonLeafs);
        for (ClusterComponent comp : this.getChildren()) {
            int childWidth = comp.getMaxNameWidth(g, includeNonLeafs);
            if (childWidth <= width) continue;
            width = childWidth;
        }
        return width;
    }
}

