/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.datamodel.ms.annotation.tablemodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreferenceLoader;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.ms.om.data.Feature;

public class MSAnnotationTableDataObject
extends MassSpecTableDataObject {
    private static final Logger logger = Logger.getLogger(MSAnnotationTableDataObject.class);
    protected ArrayList<Integer> alFeatureChargeCols;
    protected ArrayList<Integer> alFeatureIdCols;
    protected ArrayList<Integer> alAnnotationIdCols = new ArrayList();
    protected ArrayList<Integer> alAnnotationStringIdCols;
    protected ArrayList<Integer> alSequenceCols;
    protected ArrayList<Integer> alUnAnnotatedRows = null;
    protected ArrayList<Integer> filterCols = null;
    protected ArrayList<Integer> commentCols = null;
    protected ArrayList<Integer> ratioCols = null;
    protected boolean usesComplexRowId = false;

    public MSAnnotationTableDataObject(int _iMSLevel, FillTypes fillType) {
        super(_iMSLevel, fillType);
        this.alFeatureIdCols = new ArrayList();
        this.alFeatureChargeCols = new ArrayList();
        this.alSequenceCols = new ArrayList();
        this.filterCols = new ArrayList();
        this.commentCols = new ArrayList();
        this.ratioCols = new ArrayList();
        this.alAnnotationStringIdCols = new ArrayList();
    }

    public void setUsesComplexRowId(boolean usesComplexRowId) {
        this.usesComplexRowId = usesComplexRowId;
    }

    public boolean getUsesComplexRowId() {
        return this.usesComplexRowId;
    }

    public void initializePreferences() {
        this.setTablePreferences((TableViewerPreference)MSAnnotationViewerPreferenceLoader.getTableViewerPreference(this.getMSLevel(), this.getFillType()));
    }

    public void setUnAnnotatedRows(ArrayList<Integer> alUnAnnotatedRows) {
        this.alUnAnnotatedRows = alUnAnnotatedRows;
        Collections.sort(this.alUnAnnotatedRows);
    }

    public boolean isUnannotatedRow(int iRowNum) {
        return this.alUnAnnotatedRows != null && this.alUnAnnotatedRows.contains(iRowNum);
    }

    public List<Integer> getUnAnnotatedRows() {
        return this.alUnAnnotatedRows;
    }

    public void addFeatureChargeCol(int iFeatureIdCol) {
        this.alFeatureChargeCols.add(iFeatureIdCol);
    }

    public ArrayList<Integer> getFeatureChargeCols() {
        return this.alFeatureChargeCols;
    }

    public void addFeatureIdCol(int iFeatureIdCol) {
        this.alFeatureIdCols.add(iFeatureIdCol);
    }

    public ArrayList<Integer> getFeatureIdCols() {
        return this.alFeatureIdCols;
    }

    public void addAnnotationIdCol(int iAnnotationId) {
        this.alAnnotationIdCols.add(iAnnotationId);
    }

    public ArrayList<Integer> getAnnotationIdCols() {
        return this.alAnnotationIdCols;
    }

    public ArrayList<Integer> getAnnotationStringIdCols() {
        return this.alAnnotationStringIdCols;
    }

    public void addAnnotationStringIdCol(int iAnnotationStringId) {
        this.alAnnotationStringIdCols.add(iAnnotationStringId);
    }

    public ArrayList<Integer> getSequenceCols() {
        return this.alSequenceCols;
    }

    public void addSequenceCol(int iSequenceCol) {
        this.alSequenceCols.add(iSequenceCol);
    }

    public ArrayList<Integer> getFilterCols() {
        return this.filterCols;
    }

    public void addFilterCol(int filterCol) {
        this.filterCols.add(filterCol);
    }

    public ArrayList<Integer> getCommentCols() {
        return this.commentCols;
    }

    public void addCommentCol(int commentCol) {
        this.commentCols.add(commentCol);
    }

    public ArrayList<Integer> getRatioCols() {
        return this.ratioCols;
    }

    public void addRatioCol(int index) {
        this.ratioCols.add(index);
    }

    protected void cloneHeaderLineForSubsetTable(MSAnnotationTableDataObject subsetSimianTableData) {
        int iTableSize = this.getTableHeader().size();
        ArrayList alHeader = (ArrayList)((ArrayList)this.getTableHeader().get(iTableSize - 1)).clone();
        alHeader.add(0, TableDataProcessor.selColHeader);
        subsetSimianTableData.getTableHeader().add(alHeader);
    }

    protected void cloneDataForSubsetTable(MSAnnotationTableDataObject subsetSimianTableData, Integer _iParentScanNum, String _sParentRowId, boolean _bCheckParentScan) {
        ArrayList<String> alShown = new ArrayList<String>();
        try {
            int i = 0;
            while (i < this.getTableData().size()) {
                GRITSListDataRow alData = (GRITSListDataRow)this.getTableData().get(i);
                if (alData.getDataRow().get((Integer)this.getPeakIdCols().get(0)) == null) {
                    GRITSListDataRow alNewData = (GRITSListDataRow)alData.clone();
                    alNewData.getDataRow().add(0, null);
                    subsetSimianTableData.getTableData().add(alNewData);
                } else if (!this.getPeakIdCols().isEmpty() && !this.getFeatureIdCols().isEmpty() && alData.getDataRow().get((Integer)this.getPeakIdCols().get(0)) != null && alData.getDataRow().get(this.getFeatureIdCols().get(0)) != null) {
                    int iParentScanNum = -1;
                    if (this.getParentNoCol() != null && !this.getParentNoCol().isEmpty() && alData.getDataRow().get((Integer)this.getParentNoCol().get(0)) != null) {
                        iParentScanNum = (Integer)alData.getDataRow().get((Integer)this.getParentNoCol().get(0));
                    }
                    if (!_bCheckParentScan || _iParentScanNum == -1 || _iParentScanNum == iParentScanNum) {
                        String sFeatureId;
                        String sRowId;
                        Integer iPeakId = (Integer)alData.getDataRow().get((Integer)this.getPeakIdCols().get(0));
                        Integer iScanNum = null;
                        if (alData.getDataRow().get((Integer)this.getScanNoCols().get(0)) != null) {
                            iScanNum = (Integer)alData.getDataRow().get((Integer)this.getScanNoCols().get(0));
                        }
                        if (_sParentRowId.equals(sRowId = Feature.getRowId((Integer)iPeakId, iScanNum, (boolean)this.getUsesComplexRowId())) && !alShown.contains(sFeatureId = alData.getDataRow().get(this.getFeatureIdCols().get(0)).toString())) {
                            boolean bHidden;
                            GRITSListDataRow alNewData = (GRITSListDataRow)alData.clone();
                            boolean bl = bHidden = this.isHiddenRow(_iParentScanNum, sRowId, sFeatureId) || this.isInvisibleRow(_iParentScanNum, sRowId);
                            if (sFeatureId == null) {
                                alNewData.getDataRow().add(0, null);
                            } else if (bHidden || sFeatureId == null) {
                                alNewData.getDataRow().add(0, Boolean.FALSE);
                            } else {
                                alNewData.getDataRow().add(0, Boolean.TRUE);
                            }
                            subsetSimianTableData.getTableData().add(alNewData);
                            alShown.add(sFeatureId);
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.log((Priority)Level.ERROR, (Object)"Exception in cloneDataForSubsetTable", (Throwable)e);
            e.printStackTrace();
        }
        subsetSimianTableData.getTableData().add(TableDataProcessor.getNewRow((int)(((GRITSListDataRow)this.getTableData().get(0)).getDataRow().size() + 1), (int)this.getTableData().size()));
        subsetSimianTableData.getTableData().add(TableDataProcessor.getNewRow((int)(((GRITSListDataRow)this.getTableData().get(0)).getDataRow().size() + 1), (int)this.getTableData().size()));
    }

    protected void setColIdSettingsForSubsetObject(MSAnnotationTableDataObject subsetSimianTableData) {
        if (this.getFeatureIdCols() != null && !this.getFeatureIdCols().isEmpty()) {
            subsetSimianTableData.addFeatureIdCol(this.getFeatureIdCols().get(0) + 1);
        }
        if (this.getFeatureChargeCols() != null && !this.getFeatureChargeCols().isEmpty()) {
            subsetSimianTableData.addFeatureChargeCol(this.getFeatureChargeCols().get(0) + 1);
        }
        if (this.getScanNoCols() != null && !this.getScanNoCols().isEmpty()) {
            subsetSimianTableData.addScanNoCol((Integer)this.getScanNoCols().get(0) + 1);
        }
        if (this.getParentNoCol() != null && !this.getParentNoCol().isEmpty()) {
            subsetSimianTableData.addParentNoCol((Integer)this.getParentNoCol().get(0) + 1);
        }
        if (this.getPeakIdCols() != null && !this.getPeakIdCols().isEmpty()) {
            subsetSimianTableData.addPeakIdCol((Integer)this.getPeakIdCols().get(0) + 1);
        }
        if (this.getMzCols() != null && !this.getMzCols().isEmpty()) {
            subsetSimianTableData.addMzCol((Integer)this.getMzCols().get(0) + 1);
        }
        if (this.getSequenceCols() != null && !this.getSequenceCols().isEmpty()) {
            int i = 0;
            while (i < this.getSequenceCols().size()) {
                subsetSimianTableData.addSequenceCol(this.getSequenceCols().get(i) + 1);
                ++i;
            }
        }
        if (this.getAnnotationIdCols() != null && !this.getAnnotationIdCols().isEmpty()) {
            subsetSimianTableData.addAnnotationIdCol(this.getAnnotationIdCols().get(0) + 1);
        }
        if (this.getAnnotationStringIdCols() != null && !this.getAnnotationStringIdCols().isEmpty()) {
            subsetSimianTableData.addAnnotationStringIdCol(this.getAnnotationStringIdCols().get(0) + 1);
        }
        if (this.getFilterCols() != null && !this.getFilterCols().isEmpty()) {
            subsetSimianTableData.addFilterCol(this.getFilterCols().get(0) + 1);
        }
        if (this.getCommentCols() != null && !this.getCommentCols().isEmpty()) {
            subsetSimianTableData.addCommentCol(this.getCommentCols().get(0) + 1);
        }
        if (this.getRatioCols() != null && !this.getRatioCols().isEmpty()) {
            subsetSimianTableData.addRatioCol(this.getRatioCols().get(0) + 1);
        }
    }

    public MSAnnotationTableDataObject getSubsetSimianTableDataObject(int _iParentScanNum, String _sParentRowId, boolean _bCheckParentScan) {
        MSAnnotationTableDataObject subsetSimianTableData = new MSAnnotationTableDataObject(this.getMSLevel(), this.getFillType());
        return this.getSubsetSimianTableDataObject(_iParentScanNum, _sParentRowId, subsetSimianTableData, _bCheckParentScan);
    }

    protected MSAnnotationTableDataObject getSubsetSimianTableDataObject(int _iParentScanNum, String _sParentRowId, MSAnnotationTableDataObject subsetSimianTableData, boolean _bCheckParentScan) {
        subsetSimianTableData.setUsesComplexRowId(this.getUsesComplexRowId());
        this.setColIdSettingsForSubsetObject(subsetSimianTableData);
        this.cloneHeaderLineForSubsetTable(subsetSimianTableData);
        this.cloneDataForSubsetTable(subsetSimianTableData, _iParentScanNum, _sParentRowId, _bCheckParentScan);
        return subsetSimianTableData;
    }
}

