/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.wurcs.graph;

import java.util.Collections;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.graph.comparator.WURCSEdgeComparator;
import org.glycoinfo.WURCSFramework.wurcs.graph.Modification;
import org.glycoinfo.WURCSFramework.wurcs.graph.WURCSEdge;

public class ModificationAlternative
extends Modification {
    private LinkedList<WURCSEdge> m_aLeadInEdges = new LinkedList();
    private LinkedList<WURCSEdge> m_aLeadOutEdges = new LinkedList();

    public ModificationAlternative(String MAPCode) {
        super(MAPCode);
    }

    public void addLeadInEdge(WURCSEdge a_oInEdge) {
        this.m_aLeadInEdges.addLast(a_oInEdge);
    }

    public LinkedList<WURCSEdge> getLeadInEdges() {
        return this.m_aLeadInEdges;
    }

    public void addLeadOutEdge(WURCSEdge a_oOutEdge) {
        this.m_aLeadOutEdges.addLast(a_oOutEdge);
    }

    public LinkedList<WURCSEdge> getLeadOutEdges() {
        return this.m_aLeadOutEdges;
    }

    public boolean isGlycosidicLinkageForComposition() {
        if (this.m_aLeadInEdges.isEmpty() || this.m_aLeadOutEdges.isEmpty()) {
            return false;
        }
        if (this.m_aLeadInEdges.size() != this.m_aLeadOutEdges.size()) {
            return false;
        }
        LinkedList<WURCSEdge> t_lInEdges = this.m_aLeadInEdges;
        LinkedList<WURCSEdge> t_lOutEdges = this.m_aLeadOutEdges;
        int nEdges = t_lInEdges.size();
        WURCSEdgeComparator t_compEdges = new WURCSEdgeComparator();
        Collections.sort(t_lInEdges, t_compEdges);
        Collections.sort(t_lOutEdges, t_compEdges);
        for (int i = 0; i < nEdges; ++i) {
            WURCSEdge t_edgeOut;
            WURCSEdge t_edgeIn = t_lInEdges.get(i);
            int t_iComp = t_compEdges.compare(t_edgeIn, t_edgeOut = t_lOutEdges.get(i));
            if (t_iComp == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isUnderdeteminedSubstituent() {
        if (this.m_aLeadInEdges.isEmpty() || !this.m_aLeadOutEdges.isEmpty()) {
            return false;
        }
        return !this.getMAPCode().isEmpty();
    }

    @Override
    public boolean isRing() {
        return false;
    }

    @Override
    public ModificationAlternative copy() {
        return new ModificationAlternative(this.getMAPCode());
    }
}

