/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.util.subsumption;

import java.util.Iterator;
import java.util.LinkedList;
import org.glycoinfo.WURCSFramework.util.subsumption.StereoBasetype;
import org.glycoinfo.WURCSFramework.util.subsumption.WURCSSubsumptionConverter;
import org.glycoinfo.WURCSFramework.wurcs.array.LIP;
import org.glycoinfo.WURCSFramework.wurcs.array.LIPs;
import org.glycoinfo.WURCSFramework.wurcs.array.MOD;
import org.glycoinfo.WURCSFramework.wurcs.array.MS;

public class MSStateDeterminationUtility {
    public LinkedList<Integer> getPossiblePositions(MS a_oMS) {
        LinkedList<Integer> t_aPossiblePos = new LinkedList<Integer>();
        String t_strSkeletonCode = a_oMS.getSkeletonCode();
        LinkedList<Integer> t_aOnePosList = this.getOneSubstitutionPositionForSkeletonCode(t_strSkeletonCode);
        LinkedList<Integer> t_aTwoPosList = this.getTwoSubstitutionPositionForSkeletonCode(t_strSkeletonCode);
        LinkedList<Integer> t_aThreePosList = this.getTwoSubstitutionPositionForSkeletonCode(t_strSkeletonCode);
        for (MOD t_oMOD : a_oMS.getMODs()) {
            for (LIPs t_oLIPS : t_oMOD.getListOfLIPs()) {
                if (t_oLIPS.getLIPs().size() > 1) continue;
                Integer t_iPos = t_oLIPS.getLIPs().getFirst().getBackbonePosition();
                if (t_aOnePosList.contains(t_iPos)) {
                    t_aOnePosList.remove(t_iPos);
                }
                if (t_aTwoPosList.contains(t_iPos)) {
                    t_aTwoPosList.remove(t_iPos);
                    t_aOnePosList.add(t_iPos);
                }
                if (!t_aThreePosList.contains(t_iPos)) continue;
                t_aThreePosList.remove(t_iPos);
                t_aTwoPosList.add(t_iPos);
            }
        }
        t_aPossiblePos.addAll(t_aOnePosList);
        t_aPossiblePos.addAll(t_aTwoPosList);
        t_aPossiblePos.addAll(t_aThreePosList);
        return t_aPossiblePos;
    }

    private LinkedList<Integer> getOneSubstitutionPositionForSkeletonCode(String a_strSC) {
        LinkedList<Integer> t_aPosList = new LinkedList<Integer>();
        for (int i = 0; i < a_strSC.length(); ++i) {
            char t_cCD = a_strSC.charAt(i);
            if (i == 0 || i == a_strSC.length() - 1) {
                if (t_cCD != 'h' && t_cCD != 'A' && t_cCD != 'e' && t_cCD != 'z' && t_cCD != 'T') continue;
                t_aPosList.add(i + 1);
                continue;
            }
            if (t_cCD != '1' && t_cCD != '2' && t_cCD != '3' && t_cCD != '4' && t_cCD != 'x' && t_cCD != 'E' && t_cCD != 'Z' && t_cCD != 'F') continue;
            t_aPosList.add(i + 1);
        }
        return t_aPosList;
    }

    private LinkedList<Integer> getTwoSubstitutionPositionForSkeletonCode(String a_strSC) {
        LinkedList<Integer> t_aPosList = new LinkedList<Integer>();
        for (int i = 0; i < a_strSC.length(); ++i) {
            char t_cCD = a_strSC.charAt(i);
            if (i == 0 || i == a_strSC.length() - 1) {
                if (t_cCD != 'c' && t_cCD != '1' && t_cCD != '2' && t_cCD != '3' && t_cCD != '4' && t_cCD != 'x' && t_cCD != 'N' && t_cCD != 'E' && t_cCD != 'Z' && t_cCD != 'F') continue;
                t_aPosList.add(i + 1);
                continue;
            }
            if (t_cCD != '5' && t_cCD != '6' && t_cCD != '7' && t_cCD != '8' && t_cCD != 'X') continue;
            t_aPosList.add(i + 1);
        }
        return t_aPosList;
    }

    private LinkedList<Integer> getThreeSubstitutionPositionForSkeletonCode(String a_strSC) {
        LinkedList<Integer> t_aPosList = new LinkedList<Integer>();
        for (int i = 0; i < a_strSC.length(); ++i) {
            char t_cCD;
            if (i != 0 && i != a_strSC.length() - 1 || (t_cCD = a_strSC.charAt(i)) != 'M' && t_cCD != 'C' && t_cCD != '5' && t_cCD != '6' && t_cCD != '7' && t_cCD != '8' && t_cCD != 'X') continue;
            t_aPosList.add(i + 1);
        }
        return t_aPosList;
    }

    protected boolean hasUncertainAnomericCarbon(MS a_oMS) {
        return a_oMS.getSkeletonCode().contains("u") || a_oMS.getSkeletonCode().contains("U");
    }

    protected boolean isOpenChain(MS a_oMS) {
        if (this.hasUncertainAnomericCarbon(a_oMS)) {
            return false;
        }
        return a_oMS.getAnomericPosition() == MS.OPEN_CHAIN;
    }

    protected boolean hasPotentialCarbonylGroup(MS a_oMS) {
        if (this.hasUncertainAnomericCarbon(a_oMS)) {
            return true;
        }
        String t_strSkeletonCode = a_oMS.getSkeletonCode();
        return t_strSkeletonCode.contains("a") || t_strSkeletonCode.contains("o") || t_strSkeletonCode.contains("O");
    }

    protected int getPotentialCarbonylPosition(MS a_oMS) {
        if (!this.hasPotentialCarbonylGroup(a_oMS)) {
            return 0;
        }
        if (a_oMS.getAnomericPosition() > 0) {
            return a_oMS.getAnomericPosition();
        }
        String t_strSkeletonCode = a_oMS.getSkeletonCode();
        if (t_strSkeletonCode.contains("o")) {
            return t_strSkeletonCode.indexOf("o") + 1;
        }
        if (t_strSkeletonCode.contains("O")) {
            return t_strSkeletonCode.indexOf("O") + 1;
        }
        if (t_strSkeletonCode.contains("u")) {
            return t_strSkeletonCode.indexOf("u") + 1;
        }
        if (t_strSkeletonCode.contains("U")) {
            return t_strSkeletonCode.indexOf("U") + 1;
        }
        return -1;
    }

    protected boolean isAnomerUnknown(MS a_oMS) {
        if (this.isOpenChain(a_oMS)) {
            return false;
        }
        return a_oMS.getAnomericSymbol() == 'x';
    }

    protected MOD getRingMOD(MS a_oMS) {
        if (this.isOpenChain(a_oMS)) {
            return null;
        }
        if (this.hasUncertainAnomericCarbon(a_oMS)) {
            return null;
        }
        for (MOD t_oMOD : a_oMS.getMODs()) {
            if (t_oMOD.getListOfLIPs().size() != 2) continue;
            for (LIPs t_oLIPs : t_oMOD.getListOfLIPs()) {
                if (t_oLIPs.getLIPs().size() != 1 || t_oLIPs.getLIPs().get(0).getBackbonePosition() != a_oMS.getAnomericPosition()) continue;
                return t_oMOD;
            }
        }
        return null;
    }

    protected boolean hasRing(MS a_oMS) {
        return this.getRingMOD(a_oMS) != null;
    }

    protected boolean isRingSizeUnknown(MS a_oMS) {
        if (!this.hasRing(a_oMS)) {
            return false;
        }
        for (LIPs t_oRingLIPs : this.getRingMOD(a_oMS).getListOfLIPs()) {
            for (LIP t_oLIP : t_oRingLIPs.getLIPs()) {
                if (t_oLIP.getBackbonePosition() != -1) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasNoStereo(MS a_oMS) {
        if (this.hasUnknownConfiguration(a_oMS)) {
            return false;
        }
        if (this.hasRelativeConfiguration(a_oMS)) {
            return false;
        }
        return !this.hasAbsoluteConfiguration(a_oMS);
    }

    protected boolean hasUnknownConfiguration(MS a_oMS) {
        String t_oSkeletonCode = a_oMS.getSkeletonCode();
        for (int i = 0; i < t_oSkeletonCode.length(); ++i) {
            char t_cCD = t_oSkeletonCode.charAt(i);
            if (t_cCD != 'x' && t_cCD != 'X') continue;
            return true;
        }
        return false;
    }

    protected boolean hasRelativeConfiguration(MS a_oMS) {
        String t_oSkeletonCode = a_oMS.getSkeletonCode();
        for (int i = 0; i < t_oSkeletonCode.length(); ++i) {
            char t_cCD = t_oSkeletonCode.charAt(i);
            if (t_cCD != '3' && t_cCD != '4' && t_cCD != '7' && t_cCD != '8') continue;
            return true;
        }
        return false;
    }

    protected int countRelativeConfiguration(MS a_oMS) {
        int t_nRelative = 0;
        String t_oSkeletonCode = a_oMS.getSkeletonCode();
        for (int i = 0; i < t_oSkeletonCode.length(); ++i) {
            char t_cCD = t_oSkeletonCode.charAt(i);
            if (t_cCD != '3' && t_cCD != '4' && t_cCD != '7' && t_cCD != '8') continue;
            ++t_nRelative;
        }
        return t_nRelative;
    }

    protected boolean hasAbsoluteConfiguration(MS a_oMS) {
        String t_oSkeletonCode = a_oMS.getSkeletonCode();
        for (int i = 0; i < t_oSkeletonCode.length(); ++i) {
            char t_cCD = t_oSkeletonCode.charAt(i);
            if (t_cCD != '1' && t_cCD != '2' && t_cCD != '5' && t_cCD != '6') continue;
            return true;
        }
        return false;
    }

    protected boolean isDConfiguration(MS a_oMS) {
        if (!this.hasAbsoluteConfiguration(a_oMS)) {
            return false;
        }
        if (this.isFuzzyConfigurationForSC(a_oMS.getSkeletonCode())) {
            return false;
        }
        return this.isDConfigurationForSC(a_oMS.getSkeletonCode());
    }

    protected boolean isFuzzyConfigurationForSC(String a_strSC) {
        boolean t_bIsD = false;
        for (int i = 0; i < a_strSC.length(); ++i) {
            char t_cCD = a_strSC.charAt(i);
            if (t_cCD == '2' || t_cCD == '6' || t_cCD == '1' || t_cCD == '5') {
                t_bIsD = false;
            }
            if (t_cCD != '3' && t_cCD != '4' && t_cCD != '7' && t_cCD != 'x' && t_cCD != 'X') continue;
            t_bIsD = true;
        }
        return t_bIsD;
    }

    protected boolean isDConfigurationForSC(String a_strSC) {
        boolean t_bIsD = false;
        for (int i = 0; i < a_strSC.length(); ++i) {
            char t_cCD = a_strSC.charAt(i);
            if (t_cCD == '2' || t_cCD == '6') {
                t_bIsD = true;
            }
            if (t_cCD != '1' && t_cCD != '5') continue;
            t_bIsD = false;
        }
        return t_bIsD;
    }

    protected boolean hasDeoxy(MS a_oMS) {
        String t_oSkeletonCode = a_oMS.getSkeletonCode();
        if (t_oSkeletonCode.contains("d") || t_oSkeletonCode.contains("m")) {
            return true;
        }
        return t_oSkeletonCode.contains("e") || t_oSkeletonCode.contains("z") || t_oSkeletonCode.contains("f");
    }

    public boolean isCoreMOD(MOD a_oMOD) {
        int t_iPos;
        String t_strMAP = a_oMOD.getMAPCode();
        if (t_strMAP.equals("")) {
            return a_oMOD.getListOfLIPs().size() == 2;
        }
        int t_iMAPPos = a_oMOD.getListOfLIPs().getFirst().getLIPs().getFirst().getModificationPosition();
        if (t_iMAPPos == 0) {
            if (t_strMAP.length() < 2) {
                return true;
            }
            return t_strMAP.charAt(1) != 'O';
        }
        int n = t_iPos = t_iMAPPos == 1 ? 1 : t_strMAP.lastIndexOf("*") - 1;
        if (t_strMAP.charAt(t_iPos) != 'O') {
            return true;
        }
        if (a_oMOD.getListOfLIPs().size() == 1) {
            return false;
        }
        t_iMAPPos = a_oMOD.getListOfLIPs().getLast().getLIPs().getFirst().getModificationPosition();
        int n2 = t_iPos = t_iMAPPos == 1 ? 1 : t_strMAP.lastIndexOf("*") - 1;
        return t_strMAP.charAt(t_iPos) != 'O';
    }

    public LinkedList<String> extractStereo(MS a_oMS) {
        LinkedList<StereoBasetype> t_aStereoBasetypes;
        LinkedList<String> t_aStereos = new LinkedList<String>();
        if (this.hasNoStereo(a_oMS) || this.hasUnknownConfiguration(a_oMS)) {
            return t_aStereos;
        }
        Boolean t_bIsD = null;
        MS t_oRelativeMS = a_oMS;
        if (this.hasAbsoluteConfiguration(a_oMS)) {
            if (this.hasRelativeConfiguration(a_oMS)) {
                return t_aStereos;
            }
            t_bIsD = this.isDConfiguration(a_oMS);
            t_oRelativeMS = new WURCSSubsumptionConverter().convertConfigurationAbsoluteToRelative(a_oMS);
        }
        if ((t_aStereoBasetypes = this.extractStereoBasetype(t_oRelativeMS.getSkeletonCode())) == null) {
            return null;
        }
        for (StereoBasetype t_oBasetype : t_aStereoBasetypes) {
            String t_strStereo;
            String string = t_strStereo = t_oBasetype.isOpposite() ? "l/d-" : "d/l-";
            if (t_bIsD != null) {
                String string2 = t_strStereo = t_bIsD != false ? "d" : "l";
                if (t_oBasetype.isOpposite()) {
                    t_strStereo = t_bIsD != false ? "l" : "d";
                }
            }
            t_strStereo = t_strStereo + t_oBasetype.getThreeLetterCode();
            t_aStereos.addFirst(t_strStereo);
        }
        return t_aStereos;
    }

    public LinkedList<StereoBasetype> extractStereoBasetype(String a_strSC) {
        LinkedList<StereoBasetype> t_aBasetypes = new LinkedList<StereoBasetype>();
        String t_strBasetype = "";
        for (int i = 0; i < a_strSC.length(); ++i) {
            char t_cCD = a_strSC.charAt(i);
            char c = t_cCD == '7' ? (char)'3' : (t_cCD = t_cCD == '8' ? (char)'4' : t_cCD);
            if (t_cCD == '3' || t_cCD == '4') {
                t_strBasetype = t_strBasetype + t_cCD;
            }
            if (t_strBasetype.length() != 4) continue;
            StereoBasetype t_enumStereo = StereoBasetype.forStereoCode(t_strBasetype);
            if (t_enumStereo == null) {
                return null;
            }
            t_aBasetypes.add(t_enumStereo);
            t_strBasetype = "";
        }
        if (!t_strBasetype.equals("")) {
            StereoBasetype t_enumStereo = StereoBasetype.forStereoCode(t_strBasetype);
            if (t_enumStereo == null) {
                return null;
            }
            t_aBasetypes.add(t_enumStereo);
        }
        return t_aBasetypes;
    }

    protected boolean haveOtherMod(MS msRES) {
        boolean haveMod = false;
        for (MOD mod : msRES.getMODs()) {
            if (mod.getMAPCode().equals("") || this.generateMSwithCoreMod(msRES).contains(mod.getMAPCode())) continue;
            return true;
        }
        return haveMod;
    }

    protected boolean haveMOD(MS msRES) {
        for (MOD mod : msRES.getMODs()) {
            if (mod.getMAPCode().equals("") && !this.hasRing(msRES)) {
                return true;
            }
            if (mod.getMAPCode().equals("")) continue;
            return true;
        }
        return false;
    }

    protected LinkedList<MOD> selectCoreMOD(MS msRES, LinkedList<MOD> lst_Mod, boolean unknownPos) {
        LinkedList<MOD> ret = new LinkedList<MOD>();
        for (MOD mod : lst_Mod) {
            LinkedList<LIP> lnk_lips = new LinkedList<LIP>();
            if (mod.getMAPCode().equals("")) {
                if (this.hasRing(msRES)) continue;
                lnk_lips.add(mod.getListOfLIPs().getFirst().getLIPs().getFirst());
                lnk_lips.add(mod.getListOfLIPs().getLast().getLIPs().getFirst());
            }
            if (!mod.getMAPCode().equals("")) {
                if (unknownPos) {
                    lnk_lips.addLast(new LIP(-1, ' ', 0));
                } else {
                    lnk_lips.addLast(mod.getListOfLIPs().getFirst().getLIPs().getFirst());
                }
            }
            MOD modItem = new MOD(mod.getMAPCode());
            modItem.addLIPs(new LIPs(lnk_lips));
            ret.add(modItem);
        }
        return ret;
    }

    protected MOD generateRingPos(MS msRES, boolean un_pos) {
        LinkedList<LIP> lip = new LinkedList<LIP>();
        boolean isRing = false;
        MOD ret = new MOD("");
        for (LIPs pos : msRES.getMODs().getFirst().getListOfLIPs()) {
            if (!isRing && (pos.getLIPs().size() != 1 || pos.getLIPs().getFirst().getBackbonePosition() != msRES.getAnomericPosition())) continue;
            isRing = true;
            if (pos.getLIPs().getFirst().getBackbonePosition() > 2 && un_pos) {
                lip.add(new LIP(-1, ' ', 0));
                continue;
            }
            lip.add(new LIP(pos.getLIPs().getFirst().getBackbonePosition(), ' ', 0));
        }
        ret.addLIPs(new LIPs(lip));
        return ret;
    }

    protected String generateMSwithCoreMod(MS msRES) {
        String ret = msRES.getSkeletonCode();
        if (this.haveMOD(msRES)) {
            for (MOD mod : msRES.getMODs()) {
                if (!mod.getMAPCode().startsWith("*N")) continue;
                ret = ret + "_" + mod.getMAPCode();
            }
        }
        return ret;
    }

    protected LinkedList<MS> generateMSlist(MS msRES) {
        LinkedList<MS> ret = new LinkedList<MS>();
        char anomerCymbol = msRES.getAnomericSymbol();
        int anomerPos = msRES.getAnomericPosition();
        String skeletonCode = msRES.getSkeletonCode();
        LinkedList<MOD> modList = new LinkedList<MOD>();
        for (MOD coreMOD : msRES.getMODs()) {
            if (coreMOD.getMAPCode().equals("")) {
                modList.add(coreMOD);
                continue;
            }
            if (!this.generateMSwithCoreMod(msRES).contains(coreMOD.getMAPCode())) break;
            modList.add(coreMOD);
            break;
        }
        for (MOD mod : msRES.getMODs()) {
            if (mod.getMAPCode().equals("") && this.hasRing(msRES)) continue;
            MS unqItem = new MS(skeletonCode, anomerPos, anomerCymbol);
            Iterator i = modList.iterator();
            while (i.hasNext()) {
                unqItem.addMOD((MOD)i.next());
            }
            if (!this.generateMSwithCoreMod(msRES).contains(mod.getMAPCode())) {
                unqItem.addMOD(mod);
            }
            ret.add(unqItem);
        }
        return ret;
    }
}

