/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.util.PreferenceUtils;

@XmlRootElement(name="msGlycanAnnotationSettings")
public class MSGlycanAnnotationSettingsPreference {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationSettingsPreference.class);
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.entry.ms.annotation.glycan.settings";
    private static final String CURRENT_VERSION = "1.0";
    List<MSGlycanAnnotationPreference> preferenceList = new ArrayList<MSGlycanAnnotationPreference>();

    public List<MSGlycanAnnotationPreference> getPreferenceList() {
        return this.preferenceList;
    }

    public void setPreferenceList(List<MSGlycanAnnotationPreference> preferenceList) {
        this.preferenceList = preferenceList;
    }

    public boolean saveValues() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(PREFERENCE_NAME_ALL);
        preferenceEntity.setVersion(CURRENT_VERSION);
        try {
            preferenceEntity.setValue(PreferenceUtils.marshalXML(this));
            return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
        }
        catch (JAXBException e) {
            logger.error((Object)"Could not serialize the preference to the preferences file", (Throwable)e);
            return false;
        }
    }

    public static PreferenceEntity getPreferenceEntity() throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_ALL);
        return preferenceEntity;
    }

    private void processPreferenceFile(File file) {
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String xmlString = "";
            while ((line = bufferedReader.readLine()) != null) {
                xmlString = String.valueOf(xmlString) + line + "\n";
            }
            bufferedReader.close();
            MSGlycanAnnotationPreference pref = (MSGlycanAnnotationPreference)PreferenceUtils.unmarshallFromXML(xmlString, MSGlycanAnnotationPreference.class);
            this.preferenceList.add(pref);
        }
        catch (JAXBException jAXBException) {
            logger.warn((Object)(String.valueOf(file.getName()) + " is not a valid preference file"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warn((Object)(String.valueOf(file.getName()) + " is not a valid preference file"));
        }
        catch (IOException iOException) {
            logger.warn((Object)(String.valueOf(file.getName()) + " is not a valid preference file"));
        }
    }

    public void loadDefaults() {
        try {
            URL resourceURL = FileLocator.toFileURL((URL)Platform.getBundle((String)"org.grits.toolbox.entry.ms.annotation.glycan").getResource("preference"));
            File preferenceDir = new File(resourceURL.getPath());
            if (preferenceDir.exists() && preferenceDir.isDirectory()) {
                File[] prefSubDirs;
                File[] fileArray = prefSubDirs = preferenceDir.listFiles();
                int n = prefSubDirs.length;
                int n2 = 0;
                while (n2 < n) {
                    File subDir = fileArray[n2];
                    if (subDir.isDirectory() && subDir.getName().equals("glycanAnnotation")) {
                        File[] files;
                        File[] fileArray2 = files = subDir.listFiles();
                        int n3 = files.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File file = fileArray2[n4];
                            if (file.getName().endsWith(".xml")) {
                                this.processPreferenceFile(file);
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not load default preference files", (Throwable)e);
        }
    }

    public void remove(MSGlycanAnnotationPreference setting) {
        this.preferenceList.remove(setting);
    }
}

