/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.print;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.Paper;
import org.grits.toolbox.editor.experimentdesigner.model.Parameter;
import org.grits.toolbox.editor.experimentdesigner.model.ParameterGroup;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;

public class PrintExperimentGraph {
    private GC printerGC;
    private Insets printMargin = new Insets(0, 0, 0, 0);
    private Printer printer;
    private PrinterGraphics printerGraphics;
    private SWTGraphics g;
    public static final int TILE = 1;
    public static final int FIT_PAGE = 2;
    public static final int FIT_WIDTH = 3;
    public static final int FIT_HEIGHT = 4;
    ExperimentGraph model;
    GraphicalViewer viewer;
    private List selectedEditParts;
    private IFigure printSource;
    private Color oldBGColor;
    private int printMode = 1;
    int lineHeight = 0;
    int tabWidth = 0;
    int leftMargin;
    int rightMargin;
    int topMargin;
    int bottomMargin;
    int x;
    int y;
    int index;
    int end;
    String tabs;
    StringBuffer wordBuffer;

    public PrintExperimentGraph(Printer p, GraphicalViewer g, ExperimentGraph model) {
        this.setPrinter(p);
        this.viewer = g;
        this.model = model;
        LayerManager lm = (LayerManager)this.viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure f = lm.getLayer((Object)"Printable Layers");
        this.setPrintSource(f);
    }

    protected void cleanup() {
        if (this.g != null) {
            this.printerGraphics.dispose();
            this.g.dispose();
        }
        if (this.printerGC != null) {
            this.printerGC.dispose();
        }
    }

    protected PrinterGraphics getFreshPrinterGraphics() {
        if (this.printerGraphics != null) {
            this.printerGraphics.dispose();
            this.g.dispose();
            this.printerGraphics = null;
            this.g = null;
        }
        this.g = new SWTGraphics(this.printerGC);
        this.printerGraphics = new PrinterGraphics((Graphics)this.g, this.printer);
        this.setupGraphicsForPage(this.printerGraphics);
        return this.printerGraphics;
    }

    int getGraphicsOrientation() {
        return this.getPrintSource().isMirrored() ? 0x4000000 : 0x2000000;
    }

    protected int getPrintMode() {
        return this.printMode;
    }

    public Printer getPrinter() {
        return this.printer;
    }

    public Rectangle getPrintRegion() {
        org.eclipse.swt.graphics.Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
        Point printerDPI = this.printer.getDPI();
        Insets notAvailable = new Insets(-trim.y, -trim.x, trim.height + trim.y, trim.width + trim.x);
        Insets userPreferred = new Insets(this.printMargin.top * printerDPI.x / 72, this.printMargin.left * printerDPI.x / 72, this.printMargin.bottom * printerDPI.x / 72, this.printMargin.right * printerDPI.x / 72);
        Rectangle paperBounds = new Rectangle(this.printer.getBounds());
        Rectangle printRegion = paperBounds.getCropped(notAvailable);
        printRegion.intersect(paperBounds.getCropped(userPreferred));
        printRegion.translate(trim.x, trim.y);
        return printRegion;
    }

    public void run(String jobName) {
        this.preparePrintSource();
        if (this.printer.startJob(jobName)) {
            this.printerGC = new GC((Drawable)this.getPrinter(), this.getGraphicsOrientation());
            this.printPages();
            this.printer.endJob();
        }
        this.restorePrintSource();
        this.cleanup();
    }

    public void setPrinter(Printer printer) {
        this.printer = printer;
    }

    public void setPrintMargin(Insets margin) {
        this.printMargin = margin;
    }

    public void setPrintMode(int mode) {
        this.printMode = mode;
    }

    protected void setPrintSource(IFigure printSource) {
        this.printSource = printSource;
    }

    protected void setupPrinterGraphicsFor(Graphics graphics, IFigure figure) {
        double dpiScale = (double)this.getPrinter().getDPI().x / (double)Display.getCurrent().getDPI().x;
        Rectangle printRegion = this.getPrintRegion();
        printRegion.width = (int)((double)printRegion.width / dpiScale);
        printRegion.height = (int)((double)printRegion.height / dpiScale);
        Rectangle bounds = figure.getBounds();
        double xScale = (double)printRegion.width / (double)bounds.width;
        double yScale = (double)printRegion.height / (double)bounds.height;
        switch (this.getPrintMode()) {
            case 2: {
                graphics.scale(Math.min(xScale, yScale) * dpiScale);
                break;
            }
            case 3: {
                graphics.scale(xScale * dpiScale);
                break;
            }
            case 4: {
                graphics.scale(yScale * dpiScale);
                break;
            }
            default: {
                graphics.scale(dpiScale);
            }
        }
        graphics.setForegroundColor(figure.getForegroundColor());
        graphics.setBackgroundColor(figure.getBackgroundColor());
        graphics.setFont(figure.getFont());
    }

    protected void setupGraphicsForPage(PrinterGraphics pg) {
        Rectangle printRegion = this.getPrintRegion();
        pg.clipRect(printRegion);
        pg.translate(printRegion.getTopLeft());
    }

    protected IFigure getPrintSource() {
        return this.printSource;
    }

    protected void preparePrintSource() {
        this.oldBGColor = this.getPrintSource().getLocalBackgroundColor();
        this.getPrintSource().setBackgroundColor(ColorConstants.white);
        this.selectedEditParts = new ArrayList(this.viewer.getSelectedEditParts());
        this.viewer.deselectAll();
    }

    protected void restorePrintSource() {
        this.getPrintSource().setBackgroundColor(this.oldBGColor);
        this.oldBGColor = null;
        this.viewer.setSelection((ISelection)new StructuredSelection(this.selectedEditParts));
    }

    /*
     * Unable to fully structure code
     */
    void printGraphicalViewer() {
        graphics = this.getFreshPrinterGraphics();
        figure = this.getPrintSource();
        this.setupPrinterGraphicsFor((Graphics)graphics, figure);
        bounds = figure.getBounds();
        x = bounds.x;
        y = bounds.y;
        clipRect = new Rectangle();
        ** GOTO lbl26
        {
            graphics.pushState();
            this.getPrinter().startPage();
            graphics.translate(-x, -y);
            graphics.getClip(clipRect);
            clipRect.setLocation(x, y);
            graphics.clipRect(clipRect);
            figure.paint((Graphics)graphics);
            this.getPrinter().endPage();
            graphics.popState();
            x += clipRect.width;
            do {
                if (x < bounds.x + bounds.width) continue block0;
                x = bounds.x;
                y += clipRect.height;
lbl26:
                // 2 sources

            } while (y < bounds.y + bounds.height);
        }
    }

    protected void printPages() {
        this.printGraphicalViewer();
        this.print(this.printer);
    }

    void print(Printer printer) {
        org.eclipse.swt.graphics.Rectangle clientArea = printer.getClientArea();
        org.eclipse.swt.graphics.Rectangle trim = printer.computeTrim(0, 0, 0, 0);
        Point dpi = printer.getDPI();
        this.leftMargin = dpi.x + trim.x;
        this.rightMargin = clientArea.width - dpi.x + trim.x + trim.width;
        this.topMargin = dpi.y + trim.y;
        this.bottomMargin = clientArea.height - dpi.y + trim.y + trim.height;
        int tabSize = 4;
        StringBuffer tabBuffer = new StringBuffer(tabSize);
        int i = 0;
        while (i < tabSize) {
            tabBuffer.append(' ');
            ++i;
        }
        this.tabs = tabBuffer.toString();
        RGB printerForeground = new RGB(0, 0, 0);
        RGB printerBackground = new RGB(255, 255, 255);
        Font printerFont = new Font((Device)printer, "Tahoma", 11, 0);
        Font boldFont = new Font((Device)printer, "Tahoma", 11, 1);
        Color printerForegroundColor = new Color((Device)printer, printerForeground);
        Color printerBackgroundColor = new Color((Device)printer, printerBackground);
        this.printerGC.setForeground(printerForegroundColor);
        this.printerGC.setBackground(printerBackgroundColor);
        this.tabWidth = this.printerGC.stringExtent((String)this.tabs).x;
        this.lineHeight = this.printerGC.getFontMetrics().getHeight();
        this.printerGC.setFont(boldFont);
        printer.startPage();
        this.x = this.leftMargin;
        this.y = this.topMargin;
        this.printText("Experiment Design " + this.model.getName() + "\n");
        this.printLine();
        this.printText("\nCreated By: ");
        if (this.model.getCreatedBy() != null) {
            this.printerGC.setFont(printerFont);
            this.printText(this.model.getCreatedBy());
        }
        this.printerGC.setFont(boldFont);
        this.printText("\nCreated: ");
        this.printerGC.setFont(printerFont);
        this.printText(this.model.getDateCreated().toString());
        if (this.model.getDescription() != null && this.model.getDescription().trim().length() > 0) {
            this.printText("\nDescription: ");
            this.printText(this.model.getDescription());
        }
        if (this.model.getUri() != null && this.model.getUri().trim().length() > 0) {
            this.printText("\nURI: ");
            this.printText(this.model.getUri());
        }
        for (GraphNode childNode : this.model.getChildren()) {
            List<ParameterGroup> parameterGroups;
            if (!(childNode instanceof ProtocolNode)) continue;
            this.printerGC.setFont(boldFont);
            this.printText("\n\nProtocol " + childNode.getLabel() + "\n");
            this.printLine();
            this.printText("\nDescription: ");
            if (childNode.getDescription() != null) {
                this.printerGC.setFont(printerFont);
                this.printText(childNode.getDescription());
            }
            this.printerGC.setFont(boldFont);
            this.printText("\nCreator: ");
            if (((ProtocolNode)childNode).getCreator() != null) {
                this.printerGC.setFont(printerFont);
                this.printText(((ProtocolNode)childNode).getCreator());
            }
            this.printerGC.setFont(boldFont);
            this.printText("\nTemplate: ");
            this.printerGC.setFont(printerFont);
            this.printText(((ProtocolNode)childNode).getTemplate());
            this.printerGC.setFont(boldFont);
            this.printText("\nURI: ");
            this.printerGC.setFont(printerFont);
            this.printText(((ProtocolNode)childNode).getUri());
            List<Paper> papers = ((ProtocolNode)childNode).getPapers();
            this.printerGC.setFont(boldFont);
            this.printText("\n\nPapers");
            this.printerGC.setFont(printerFont);
            if (papers != null) {
                for (Paper paper : papers) {
                    this.printText("\n\n" + paper.toString());
                }
            }
            this.printerGC.setFont(boldFont);
            this.printText("\n\nParameters/Parameter Groups ");
            this.printText("\nName\t\t\tValue\t\t\tUnit ");
            List<Parameter> parameters = ((ProtocolNode)childNode).getParameters();
            if (parameters != null) {
                this.printerGC.setFont(printerFont);
                for (Parameter parameter : parameters) {
                    String text = "\n" + parameter.getName() + "\t\t" + parameter.getValue();
                    if (parameter.getUnit() != null) {
                        text = String.valueOf(text) + "\t\t" + parameter.getUnit().getLabel();
                    }
                    this.printText(text);
                }
            }
            if ((parameterGroups = ((ProtocolNode)childNode).getParameterGroups()) == null) continue;
            for (ParameterGroup parameterGroup : parameterGroups) {
                this.printText("\n" + parameterGroup.getLabel());
                List<Parameter> params = parameterGroup.getParameters();
                for (Parameter parameter : params) {
                    String text = "\n" + parameter.getName() + "\t\t" + parameter.getValue();
                    if (parameter.getUnit() != null) {
                        text = String.valueOf(text) + "\t\t" + parameter.getUnit().getLabel();
                    }
                    this.printText(text);
                }
            }
        }
        printerFont.dispose();
        boldFont.dispose();
    }

    void printText(String textToPrint) {
        this.wordBuffer = new StringBuffer();
        this.index = 0;
        this.end = textToPrint.length();
        while (this.index < this.end) {
            char c = textToPrint.charAt(this.index);
            ++this.index;
            if (c == '\u0000') continue;
            if (c == '\n' || c == '\r') {
                if (c == '\r' && this.index < this.end && textToPrint.charAt(this.index) == '\n') {
                    ++this.index;
                }
                this.printWordBuffer();
                this.newline();
                continue;
            }
            if (c != '\t') {
                this.wordBuffer.append(c);
            }
            if (!Character.isWhitespace(c)) continue;
            this.printWordBuffer();
            if (c != '\t') continue;
            this.x += this.tabWidth;
        }
        if (this.wordBuffer.length() != 0) {
            this.printWordBuffer();
        }
        if (this.y + this.lineHeight > this.bottomMargin) {
            this.printer.endPage();
            this.x = this.leftMargin;
            this.y = this.topMargin;
            this.printer.startPage();
        }
    }

    void printLine() {
        this.printerGC.drawLine(this.leftMargin + 1, this.y, this.rightMargin - 1, this.y);
        this.y += this.lineHeight;
    }

    void printWordBuffer() {
        if (this.wordBuffer.length() > 0) {
            String word = this.wordBuffer.toString();
            int wordWidth = this.printerGC.stringExtent((String)word).x;
            if (this.x + wordWidth > this.rightMargin) {
                this.newline();
            }
            this.printerGC.drawString(word, this.x, this.y, false);
            this.x += wordWidth;
            this.wordBuffer = new StringBuffer();
        }
    }

    void newline() {
        this.x = this.leftMargin;
        this.y += this.lineHeight;
        if (this.y + this.lineHeight > this.bottomMargin) {
            this.printer.endPage();
            if (this.index + 1 < this.end) {
                this.y = this.topMargin;
                this.printer.startPage();
            }
        }
    }
}

