/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.preference;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;

public class TableViewerColumnSettings {
    protected LinkedHashMap<GRITSColumnHeader, Integer> htColumnHeaderVisible;
    public static String TOK_DELIMITER = "~~~";
    public static String COL_DELIMITER = "===";
    public static String COL_VIS_ATTR = "columnVisibility";
    protected HashMap<String, Integer> htUnrecognizedHeaders = new HashMap();

    public TableViewerColumnSettings() {
        this.htColumnHeaderVisible = new LinkedHashMap();
    }

    public boolean hasUnrecognizedHeaders() {
        return !this.htUnrecognizedHeaders.isEmpty();
    }

    public HashMap<String, Integer> getUnrecognizedHeaders() {
        return this.htUnrecognizedHeaders;
    }

    public int getNumColumns() {
        return this.htColumnHeaderVisible.size();
    }

    public GRITSColumnHeader getColumnHeader(String _sKey) {
        for (GRITSColumnHeader header : this.keySet()) {
            if (!header.getKeyValue().equals(_sKey)) continue;
            return header;
        }
        return null;
    }

    public int getColumnPosition(String _sKey) {
        for (GRITSColumnHeader header : this.keySet()) {
            if (!header.getKeyValue().equals(_sKey)) continue;
            return this.getColumnPosition(header);
        }
        return -1;
    }

    public int getColumnPosition(GRITSColumnHeader _headerObj) {
        if (this.htColumnHeaderVisible.containsKey(_headerObj)) {
            return this.htColumnHeaderVisible.get(_headerObj);
        }
        return -1;
    }

    public void putColumn(GRITSColumnHeader _colHeader, int _iPosition) {
        this.htColumnHeaderVisible.put(_colHeader, _iPosition);
    }

    public void putColumn(String _sLabel, String _sKey, int _iPosition) {
        this.htColumnHeaderVisible.put(new GRITSColumnHeader(_sLabel, _sKey), _iPosition);
    }

    public void addColumn(String _sLabel, String _sKey) {
        this.htColumnHeaderVisible.put(new GRITSColumnHeader(_sLabel, _sKey), this.getNumColumns());
    }

    public void addColumn(GRITSColumnHeader _colHeader) {
        this.htColumnHeaderVisible.put(_colHeader, this.getNumColumns());
    }

    public Set<GRITSColumnHeader> keySet() {
        return this.htColumnHeaderVisible.keySet();
    }

    public Object clone() {
        TableViewerColumnSettings newSettings = new TableViewerColumnSettings();
        newSettings.htColumnHeaderVisible = this.htColumnHeaderVisible;
        return newSettings;
    }

    public Set<GRITSColumnHeader> getHeaders() {
        return this.htColumnHeaderVisible.keySet();
    }

    public void setVisColInx(GRITSColumnHeader header, Integer _iVal) {
        this.htColumnHeaderVisible.put(header, _iVal);
    }

    public boolean hasColumn(String _sKey) {
        GRITSColumnHeader header = this.getColumnHeader(_sKey);
        return header != null;
    }

    public boolean isVisible(String _sKey) {
        GRITSColumnHeader header = this.getColumnHeader(_sKey);
        if (header != null) {
            return this.htColumnHeaderVisible.get(header) != -1;
        }
        return false;
    }

    public int getVisColInx(String _sKey) {
        GRITSColumnHeader header = this.getColumnHeader(_sKey);
        if (header != null) {
            return this.htColumnHeaderVisible.get(header);
        }
        return -1;
    }

    public GRITSColumnHeader getColumnAtVisColInx(Integer _iInx) {
        for (GRITSColumnHeader header : this.keySet()) {
            Integer iInx = this.htColumnHeaderVisible.get(header);
            if (iInx != _iInx) continue;
            return header;
        }
        return null;
    }

    public String toColumnVisibilityString() {
        StringBuilder sb = new StringBuilder();
        for (GRITSColumnHeader header : this.keySet()) {
            if (!sb.toString().equals("")) {
                sb.append(COL_DELIMITER);
            }
            Integer iVal = this.htColumnHeaderVisible.get(header);
            String sVal = String.valueOf(header.getKeyValue()) + TOK_DELIMITER + Integer.toString(iVal);
            sb.append(sVal);
        }
        return sb.toString();
    }

    public String toColumnHeaderString() {
        StringBuilder sb = new StringBuilder();
        for (GRITSColumnHeader header : this.keySet()) {
            if (!sb.toString().equals("")) {
                sb.append(COL_DELIMITER);
            }
            String sVal = String.valueOf(header.getKeyValue()) + TOK_DELIMITER + header.getLabel();
            sb.append(sVal);
        }
        return sb.toString();
    }
}

