/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.grits.toolbox.entry.qrtpcr.editor.QrtPCRTableEditor;
import org.grits.toolbox.entry.qrtpcr.editor.dialogs.ShowPreviousValuesDialog;
import org.grits.toolbox.entry.qrtpcr.model.CtHistory;
import org.grits.toolbox.entry.qrtpcr.model.Gene;
import org.grits.toolbox.entry.qrtpcr.model.GeneData;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.TableData;
import org.grits.toolbox.entry.qrtpcr.table.CellPopupMenuAction;
import org.grits.toolbox.entry.qrtpcr.table.QrtPCRNatTable;

class ValueMenuConfiguration
extends AbstractUiBindingConfiguration {
    private Menu bodyMenu;
    private QrtPCRTableEditor editor;
    private QrtPCRData data;
    private DataLayer bodyLayer;
    boolean raw = false;

    public ValueMenuConfiguration(QrtPCRTableEditor editor, QrtPCRData data, NatTable natTable, DataLayer bodyLayer, boolean raw) {
        this.editor = editor;
        this.data = data;
        this.bodyLayer = bodyLayer;
        this.bodyMenu = this.createBodyMenu(natTable).build();
        this.raw = raw;
        natTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ValueMenuConfiguration.this.bodyMenu.dispose();
            }
        });
    }

    private PopupMenuBuilder createBodyMenu(final NatTable natTable) {
        Menu menu = new Menu((Control)natTable);
        final MenuItem item2 = new MenuItem(menu, 8);
        item2.setText("Show Previous Values");
        item2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneData clickedGeneData = (GeneData)item2.getData();
                if (clickedGeneData != null) {
                    Point pt = Display.getCurrent().getCursorLocation();
                    ValueMenuConfiguration.this.showPreviousValues(ValueMenuConfiguration.this.data, clickedGeneData, pt);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final MenuItem item1_2 = new MenuItem(menu, 8);
        item1_2.setText("Eliminate/Consider This Value");
        item1_2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneData clickedGeneData = (GeneData)item1_2.getData();
                if (clickedGeneData != null) {
                    ValueMenuConfiguration.this.eliminateThisDataPoint(ValueMenuConfiguration.this.data, natTable, clickedGeneData);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return new PopupMenuBuilder(natTable, menu);
    }

    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        MouseEventMatcher matcher = new MouseEventMatcher(0, "BODY", 3){

            public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
                if (super.matches(natTable, event, regionLabels)) {
                    int columnPosition = natTable.getColumnPositionByX(event.x);
                    int columnIndex = LayerUtil.convertColumnPosition((ILayer)natTable, (int)columnPosition, (IUniqueIndexLayer)ValueMenuConfiguration.this.bodyLayer);
                    String column = ((QrtPCRNatTable)natTable).getColumnPropertyAccessor().getColumnProperty(columnIndex);
                    if (column.equals("ct0") && !ValueMenuConfiguration.this.raw) {
                        int rowPosition = natTable.getRowPositionByY(event.y);
                        int bodyRowPos = LayerUtil.convertRowPosition((ILayer)natTable, (int)rowPosition, (IUniqueIndexLayer)ValueMenuConfiguration.this.bodyLayer);
                        TableData row = (TableData)((ListDataProvider)ValueMenuConfiguration.this.bodyLayer.getDataProvider()).getRowObject(bodyRowPos);
                        if (row instanceof GeneData) {
                            ValueMenuConfiguration.this.bodyMenu.getItems()[0].setData((Object)row);
                            ValueMenuConfiguration.this.bodyMenu.getItems()[1].setData((Object)row);
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)matcher, (IMouseAction)new CellPopupMenuAction(this.bodyMenu));
    }

    protected void eliminateThisDataPoint(QrtPCRData data, NatTable natTable, GeneData clickedGeneData) {
        List<Gene> genes = data.getGenes();
        for (Gene gene : genes) {
            if (!gene.equals(clickedGeneData.getGene())) continue;
            block1: for (Integer runId : gene.getDataMap().keySet()) {
                List<GeneData> values = gene.getDataMap().get(runId);
                for (GeneData geneData : values) {
                    if (!geneData.equals(clickedGeneData)) continue;
                    if (geneData.isEliminated().booleanValue()) {
                        geneData.setEliminated(false);
                    } else {
                        geneData.setEliminated(true);
                        if (gene.getIsControl().booleanValue()) {
                            data.calculateNormValue();
                        }
                    }
                    natTable.refresh();
                    this.editor.markDirty();
                    continue block1;
                }
            }
        }
    }

    protected void showPreviousValues(QrtPCRData data, GeneData clickedGeneData, Point curLoc) {
        HashMap<Integer, List<CtHistory>> previousValuesMap = new HashMap<Integer, List<CtHistory>>();
        List<Gene> genes = data.getGenes();
        int position = -1;
        for (Gene gene : genes) {
            if (!gene.equals(clickedGeneData.getGene())) continue;
            for (Integer runId : gene.getDataMap().keySet()) {
                List<GeneData> values = gene.getDataMap().get(runId);
                int i = 0;
                for (GeneData geneData : values) {
                    if (geneData.equals(clickedGeneData) || i == position) {
                        CtHistory current;
                        position = i;
                        ArrayList<CtHistory> previousValues = new ArrayList<CtHistory>();
                        if (geneData.getCt() == null) {
                            current = new CtHistory();
                            current.setCt(null);
                            current.setReasonCode(CtHistory.Reason.NULL.getReason());
                            previousValues.add(current);
                        } else {
                            current = new CtHistory();
                            current.setCt(geneData.getCt());
                            current.setReasonCode(CtHistory.Reason.CURRENT.getReason());
                            previousValues.add(current);
                        }
                        if (geneData.getPreviousValues() != null) {
                            List<CtHistory> existingPreviousValues = geneData.getPreviousValues();
                            int k = existingPreviousValues.size() - 1;
                            while (k >= 0) {
                                previousValues.add(existingPreviousValues.get(k));
                                --k;
                            }
                        }
                        previousValuesMap.put(runId, previousValues);
                    }
                    ++i;
                }
            }
        }
        ShowPreviousValuesDialog dialog = new ShowPreviousValuesDialog(Display.getCurrent().getActiveShell(), curLoc, previousValuesMap);
        dialog.open();
    }
}

