/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedemail.actions;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.entry.archive.editor.pages.archivedemail.EmailArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedBasicEmail;
import org.grits.toolbox.entry.archive.model.ArchivedEmail;
import org.grits.toolbox.entry.archive.model.ArchivedEmailTopic;

public class DeleteEmail
extends Action {
    private Logger logger = Logger.getLogger(DeleteEmail.class);
    private EmailArchivePage page = null;

    public DeleteEmail(EmailArchivePage fileArchivePage) {
        this.page = fileArchivePage;
        this.setText("Delete");
        this.setToolTipText("Delete Email");
        this.setImageDescriptor(ImageShare.DELETE_ICON);
    }

    public void run() {
        TreeViewer treeViewer = this.page.getLeftSideTreeViewer();
        TreeSelection treeSelection = (TreeSelection)treeViewer.getSelection();
        if (treeSelection.isEmpty()) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No email Selected", (String)"Please select an email to delete.");
        } else if (treeSelection.getFirstElement() instanceof ArchivedEmail) {
            int selectionIndex = treeViewer.getTree().indexOf(treeViewer.getTree().getSelection()[0]);
            List inputArchivedEmails = (List)treeViewer.getInput();
            ArchivedEmail archivedEmailToDelete = (ArchivedEmail)treeSelection.getFirstElement();
            boolean delete = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Delete Archive", (String)("Are you sure you want to delete this email \"" + archivedEmailToDelete.getDisplayTitle() + "\" from the archive?"));
            if (delete) {
                try {
                    if (inputArchivedEmails.contains(archivedEmailToDelete)) {
                        inputArchivedEmails.remove(archivedEmailToDelete);
                    } else if (archivedEmailToDelete instanceof ArchivedBasicEmail) {
                        ArchivedBasicEmail basicEmailtoDelete = (ArchivedBasicEmail)archivedEmailToDelete;
                        ArchivedEmailTopic selectedTopic = basicEmailtoDelete.getArchivedEmailTopic();
                        if (selectedTopic.getReplyEmails().size() == 1) {
                            inputArchivedEmails.remove(selectedTopic);
                        } else if (selectedTopic.getReplyEmails().size() > 1) {
                            selectedTopic.getReplyEmails().remove(basicEmailtoDelete);
                        }
                    }
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Error removing email from archive.\n" + ex.getMessage()), (Throwable)ex);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Delete Error", (String)"Error removing email from archive. Please report this error to the development team");
                }
                treeViewer.refresh();
                selectionIndex = Math.max(0, selectionIndex - 1);
                if (selectionIndex >= 0 && selectionIndex < inputArchivedEmails.size()) {
                    treeViewer.getTree().select(treeViewer.getTree().getItem(selectionIndex));
                    treeViewer.setSelection(treeViewer.getSelection());
                } else {
                    this.page.setSelection(null);
                }
                this.page.getEditor().markDirty();
            }
        }
        this.logger.debug((Object)"End - Deleting  Archived Email");
    }
}

