/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property.datamodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.entry.ms.extquantfiles.process.CorrectedQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExternalQuantColumnInfo;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuant;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.InternalStandardQuantFileList;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.QuantFileToCorrectedPeaks;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.MSFileInfo;
import org.grits.toolbox.ms.om.data.CustomExtraData;

public abstract class MassSpecUISettings {
    private static final Logger logger = Logger.getLogger(MassSpecUISettings.class);
    private List<MassSpecCustomAnnotation> customAnnotations = new ArrayList<MassSpecCustomAnnotation>();
    private String customAnnotationsText = null;
    private List<MassSpecStandardQuant> standardQuant = new ArrayList<MassSpecStandardQuant>();
    private String standardQuantText = null;
    private List<MSPropertyDataFile> fileList;
    private List<MSPropertyDataFile> sourceDataFileList;
    private HashMap<String, ExternalQuantFileToAlias> quantTypeToExternalQuant = new HashMap();
    private HashMap<String, InternalStandardQuantFileList> internalStandardQuantFiles = null;
    private HashMap<String, QuantFileToCorrectedPeaks> quantFileToCorrectedPeaks = null;

    public static ExternalQuantAlias getNewExternalQuantAlias(String sAlias) {
        ExternalQuantAlias eqa = new ExternalQuantAlias();
        eqa.setAlias(sAlias);
        return eqa;
    }

    public void addExternalQuantFile(MSPropertyDataFile mspdf, ExternalQuantAlias eqa) {
        String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
        ExternalQuantFileToAlias mAliases = this.getExternalQuantToAliasByQuantType(sExtQuantType);
        if (this.getQuantTypeToExternalQuant() == null) {
            this.setQuantTypeToExternalQuant(new HashMap<String, ExternalQuantFileToAlias>());
        }
        if (mAliases == null) {
            mAliases = new ExternalQuantFileToAlias();
            this.getQuantTypeToExternalQuant().put(sExtQuantType, mAliases);
        }
        mAliases.getSourceDataFileNameToAlias().put(mspdf.getName(), eqa);
    }

    public static CustomExtraData getDefaultExternalQuantCED(String sExtQuantType, String _sPrevFullKey) {
        String sDefaultKey = null;
        String sDefaultLabel = null;
        if (sExtQuantType.equals("ThermoExtract")) {
            sDefaultKey = "extract";
            sDefaultLabel = "Extract";
        } else if (sExtQuantType.equals("Converted")) {
            sDefaultKey = "full_ms";
            sDefaultLabel = "Full MS";
        }
        CustomExtraData ced = null;
        ced = _sPrevFullKey.endsWith(CorrectedQuantColumnInfo.CORRECTED_QUANT_KEY_PREFIX) ? CorrectedQuantColumnInfo.getDefaultExternalQuantCEDFromKey(sDefaultKey, sDefaultLabel, _sPrevFullKey) : ExternalQuantColumnInfo.getDefaultExternalQuantCEDFromKey(sDefaultKey, sDefaultLabel, _sPrevFullKey);
        if (ced == null) {
            logger.error((Object)("Unsupported quant type: " + sExtQuantType));
        }
        return ced;
    }

    public void updateQuantAliasKeyInfo(MSPropertyDataFile mspdf, ExternalQuantFileToAlias mAliases, String sPrefix) {
        String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
        if (mAliases == null) {
            return;
        }
        int iCnt = 0;
        for (String sFileName : mAliases.getSourceDataFileNameToAlias().keySet()) {
            ExternalQuantAlias cureqa = mAliases.getSourceDataFileNameToAlias().get(sFileName);
            if (cureqa == null) continue;
            String sKeyPrefix = "";
            if (sExtQuantType.equals("ThermoExtract")) {
                sKeyPrefix = iCnt > 0 ? "extract_" + iCnt : "extract";
            } else if (sExtQuantType.equals("Converted")) {
                sKeyPrefix = iCnt > 0 ? "full_ms_" + iCnt : "full_ms";
            } else {
                logger.error((Object)("Unsupported quant type: " + sExtQuantType));
            }
            if (sPrefix != null) {
                cureqa.setKey(String.valueOf(sKeyPrefix) + "_" + sPrefix);
            } else {
                cureqa.setKey(sKeyPrefix);
            }
            cureqa.setId(iCnt++);
        }
    }

    public HashMap<String, QuantFileToCorrectedPeaks> getQuantFileToCorrectedPeaks() {
        return this.quantFileToCorrectedPeaks;
    }

    public void setQuantFileToCorrectedPeaks(HashMap<String, QuantFileToCorrectedPeaks> quantFileToCorrectedPeaks) {
        this.quantFileToCorrectedPeaks = quantFileToCorrectedPeaks;
    }

    public HashMap<String, InternalStandardQuantFileList> getInternalStandardQuantFiles() {
        return this.internalStandardQuantFiles;
    }

    public void setInternalStandardQuantFiles(HashMap<String, InternalStandardQuantFileList> internalStandardQuantFiles) {
        this.internalStandardQuantFiles = internalStandardQuantFiles;
    }

    public void addInternalStandardQuantFile(String sStdQuantName, MSPropertyDataFile mspdf, ExternalQuantAlias eqa) {
        ExternalQuantFileToAlias mAliases;
        InternalStandardQuantFileList quantFileList;
        String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
        if (this.getInternalStandardQuantFiles() == null) {
            this.setInternalStandardQuantFiles(new HashMap<String, InternalStandardQuantFileList>());
        }
        if ((quantFileList = this.getInternalStandardQuantFiles().get(sExtQuantType)) == null) {
            quantFileList = new InternalStandardQuantFileList();
            this.getInternalStandardQuantFiles().put(sExtQuantType, quantFileList);
        }
        if (quantFileList.getQuantNameToFileAlias() == null) {
            quantFileList.setQuantNameToFileAlias(new HashMap<String, ExternalQuantFileToAlias>());
        }
        if ((mAliases = quantFileList.getQuantNameToFileAlias().get(sStdQuantName)) == null) {
            mAliases = new ExternalQuantFileToAlias();
            quantFileList.getQuantNameToFileAlias().put(sStdQuantName, mAliases);
        }
        mAliases.getSourceDataFileNameToAlias().put(mspdf.getName(), eqa);
    }

    public void removeInternalStandardQuantFile(String sStdQuantName, MSPropertyDataFile mspdf) {
        if (this.getInternalStandardQuantFiles() == null) {
            return;
        }
        String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
        InternalStandardQuantFileList quantFileList = this.getInternalStandardQuantFiles().get(sExtQuantType);
        if (quantFileList == null || quantFileList.getQuantNameToFileAlias() == null) {
            return;
        }
        ExternalQuantFileToAlias mAliases = quantFileList.getQuantNameToFileAlias().get(sStdQuantName);
        if (mAliases == null) {
            return;
        }
        mAliases.getSourceDataFileNameToAlias().remove(mspdf.getName());
    }

    public boolean containsInternalStandardQuantFile(String sStdQuantName, MSPropertyDataFile mspdf) {
        if (this.getInternalStandardQuantFiles() == null) {
            return false;
        }
        String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
        InternalStandardQuantFileList quantFileList = this.getInternalStandardQuantFiles().get(sExtQuantType);
        if (quantFileList == null || quantFileList.getQuantNameToFileAlias() == null) {
            return false;
        }
        ExternalQuantFileToAlias mAliases = quantFileList.getQuantNameToFileAlias().get(sStdQuantName);
        if (mAliases == null) {
            return false;
        }
        return mAliases.getSourceDataFileNameToAlias().containsKey(mspdf.getName());
    }

    public ExternalQuantFileToAlias getInternalQuantFileToAlias(String sStdQuantName, MSPropertyDataFile mspdf) {
        if (this.getInternalStandardQuantFiles() == null) {
            return null;
        }
        String sExtQuantType = MassSpecUISettings.getExternalQuantType(mspdf);
        InternalStandardQuantFileList quantFileList = this.getInternalStandardQuantFiles().get(sExtQuantType);
        if (quantFileList == null || quantFileList.getQuantNameToFileAlias() == null) {
            return null;
        }
        ExternalQuantFileToAlias mAliases = quantFileList.getQuantNameToFileAlias().get(sStdQuantName);
        return mAliases;
    }

    public void cloneSettings(MassSpecUISettings settings) {
        this.cloneSourceDataFileNameToAlias(settings);
        this.cloneInternalStandardQuant(settings);
        this.cloneFileList(settings);
        this.cloneSourceFileList(settings);
        this.cloneCustomAnnotations(settings);
    }

    private void cloneCustomAnnotations(MassSpecUISettings settings) {
        settings.setCustomAnnotations(new ArrayList<MassSpecCustomAnnotation>());
        for (MassSpecCustomAnnotation msca : this.getCustomAnnotations()) {
            settings.getCustomAnnotations().add(msca);
        }
        settings.setCustomAnnotationText(this.getCustomAnnotationText());
    }

    private void cloneInternalStandardQuant(MassSpecUISettings settings) {
        if (this.getInternalStandardQuantFiles() == null) {
            return;
        }
        HashMap<String, InternalStandardQuantFileList> mLev1 = new HashMap<String, InternalStandardQuantFileList>();
        for (String sKey1 : this.getInternalStandardQuantFiles().keySet()) {
            InternalStandardQuantFileList mSourceLev2 = this.getInternalStandardQuantFiles().get(sKey1);
            if (mSourceLev2 == null) continue;
            InternalStandardQuantFileList mLev2 = new InternalStandardQuantFileList();
            mLev1.put(sKey1, mLev2);
            for (String sKey2 : mSourceLev2.getQuantNameToFileAlias().keySet()) {
                ExternalQuantFileToAlias mSourceLev3 = mSourceLev2.getQuantNameToFileAlias().get(sKey2);
                if (mSourceLev3 == null) continue;
                ExternalQuantFileToAlias mLev3 = new ExternalQuantFileToAlias();
                mLev2.getQuantNameToFileAlias().put(sKey2, mLev3);
                for (String sKey3 : mSourceLev3.getSourceDataFileNameToAlias().keySet()) {
                    mLev3.getSourceDataFileNameToAlias().put(sKey3, mSourceLev3.getSourceDataFileNameToAlias().get(sKey2));
                }
            }
        }
        settings.setInternalStandardQuantFiles(mLev1);
    }

    private void cloneSourceDataFileNameToAlias(MassSpecUISettings settings) {
        if (this.getQuantTypeToExternalQuant() == null) {
            return;
        }
        HashMap<String, ExternalQuantFileToAlias> mLev1 = new HashMap<String, ExternalQuantFileToAlias>();
        for (String sKey1 : this.getQuantTypeToExternalQuant().keySet()) {
            ExternalQuantFileToAlias mSourceLev2 = this.getQuantTypeToExternalQuant().get(sKey1);
            if (mSourceLev2 == null) continue;
            ExternalQuantFileToAlias alias2 = new ExternalQuantFileToAlias();
            HashMap<String, ExternalQuantAlias> mLev2 = new HashMap<String, ExternalQuantAlias>();
            alias2.setSourceDataFileNameToAlias(mLev2);
            mLev1.put(sKey1, alias2);
            for (String sKey2 : mSourceLev2.getSourceDataFileNameToAlias().keySet()) {
                mLev2.put(sKey2, mSourceLev2.getSourceDataFileNameToAlias().get(sKey2));
            }
        }
        settings.setQuantTypeToExternalQuant(mLev1);
    }

    private void cloneFileList(MassSpecUISettings settings) {
        settings.setFileList(new ArrayList<MSPropertyDataFile>());
        if (this.fileList != null) {
            for (MSPropertyDataFile pdf : this.getFileList()) {
                settings.addFile((MSPropertyDataFile)((Object)pdf.clone()));
            }
        }
    }

    private void cloneSourceFileList(MassSpecUISettings settings) {
        settings.setSourceDataFileList(new ArrayList<MSPropertyDataFile>());
        if (this.getSourceDataFileList() != null) {
            for (MSPropertyDataFile pdf : this.getSourceDataFileList()) {
                settings.addSourceFile(pdf);
            }
        }
    }

    public HashMap<String, ExternalQuantFileToAlias> getQuantTypeToExternalQuant() {
        return this.quantTypeToExternalQuant;
    }

    public void setQuantTypeToExternalQuant(HashMap<String, ExternalQuantFileToAlias> quantTypeToExternalQuant) {
        this.quantTypeToExternalQuant = quantTypeToExternalQuant;
    }

    public ExternalQuantFileToAlias getExternalQuantToAliasByQuantType(String sQuantType) {
        if (this.getQuantTypeToExternalQuant() == null) {
            return null;
        }
        return this.getQuantTypeToExternalQuant().get(sQuantType);
    }

    public static String getExternalQuantType(MSPropertyDataFile mspdf) {
        if (mspdf.getType().equals("mzXML") || mspdf.getType().equals("mzML")) {
            return "Converted";
        }
        return mspdf.getType();
    }

    @XmlTransient
    public List<MassSpecCustomAnnotation> getCustomAnnotations() {
        return this.customAnnotations;
    }

    public void setCustomAnnotations(List<MassSpecCustomAnnotation> customAnnotations) {
        this.customAnnotations = customAnnotations;
    }

    @XmlElement(name="customAnnotationsText")
    public String getCustomAnnotationText() {
        return this.customAnnotationsText;
    }

    public void setCustomAnnotationText(String customAnnotationsText) {
        this.customAnnotationsText = customAnnotationsText;
    }

    @XmlTransient
    public List<MassSpecStandardQuant> getStandardQuant() {
        return this.standardQuant;
    }

    public void setStandardQuant(List<MassSpecStandardQuant> standardQuant) {
        this.standardQuant = standardQuant;
    }

    @XmlElement(name="standardQuantText")
    public String getStandardQuantText() {
        return this.standardQuantText;
    }

    public void setStandardQuantText(String standardQuantText) {
        this.standardQuantText = standardQuantText;
    }

    @XmlElement(name="fileList")
    public List<MSPropertyDataFile> getFileList() {
        return this.fileList;
    }

    public void setFileList(List<MSPropertyDataFile> fileList) {
        this.fileList = fileList;
    }

    public List<MSPropertyDataFile> getSourceDataFileList() {
        return this.sourceDataFileList;
    }

    public void setSourceDataFileList(List<MSPropertyDataFile> sourceDataFileList) {
        this.sourceDataFileList = sourceDataFileList;
    }

    public void addSourceFile(MSPropertyDataFile newDataFile) {
        if (this.getSourceDataFileList() == null) {
            this.setSourceDataFileList(new ArrayList<MSPropertyDataFile>());
        }
        ArrayList<MSPropertyDataFile> toRemove = new ArrayList<MSPropertyDataFile>();
        for (MSPropertyDataFile file : this.getSourceDataFileList()) {
            if (!file.getName().equals(newDataFile.getName()) || !file.getCategory().equals((Object)newDataFile.getCategory()) || !file.getMSFileType().equals(newDataFile.getMSFileType())) continue;
            toRemove.add(file);
        }
        if (!toRemove.isEmpty()) {
            for (MSPropertyDataFile file : toRemove) {
                this.getSourceDataFileList().remove((Object)file);
            }
        }
        this.getSourceDataFileList().add(newDataFile);
    }

    public MassSpecCustomAnnotation lookupCustomAnnotation(String annotationName) {
        if (this.getCustomAnnotations() != null && !this.getCustomAnnotations().isEmpty()) {
            int i = 0;
            while (i < this.getCustomAnnotations().size()) {
                MassSpecCustomAnnotation annotation = this.getCustomAnnotations().get(i);
                if (annotation.getAnnotationName().equalsIgnoreCase(annotationName)) {
                    return annotation;
                }
                ++i;
            }
        }
        return null;
    }

    public void updateCustomAnotationData() {
        this.setCustomAnnotationText(MassSpecPreference.createCustomAnnotationsText(this.getCustomAnnotations()));
    }

    public MassSpecStandardQuant lookupStandardQuant(String standardQuantName) {
        if (this.getStandardQuant() != null && !this.getStandardQuant().isEmpty()) {
            int i = 0;
            while (i < this.getStandardQuant().size()) {
                MassSpecStandardQuant standardQuant = this.getStandardQuant().get(i);
                if (standardQuant.getStandardQuantName().equalsIgnoreCase(standardQuantName)) {
                    return standardQuant;
                }
                ++i;
            }
        }
        return null;
    }

    public void updateStandardQuantData() {
        this.setStandardQuantText(MassSpecPreference.createStandardQuantText(this.getStandardQuant()));
    }

    public MSPropertyDataFile addFile(MSPropertyDataFile newDataFile) {
        if (this.getFileList() == null) {
            this.setFileList(new ArrayList<MSPropertyDataFile>());
        }
        MSPropertyDataFile existing = null;
        for (MSPropertyDataFile file : this.getFileList()) {
            if (!file.getName().equals(newDataFile.getName()) || !file.getCategory().equals((Object)newDataFile.getCategory()) || !file.getMSFileType().equals(newDataFile.getMSFileType())) continue;
            existing = file;
        }
        if (existing == null) {
            this.getFileList().add(newDataFile);
        }
        return existing;
    }

    private List<MSPropertyDataFile> getPeakListFile() {
        ArrayList<MSPropertyDataFile> peakListFiles = new ArrayList<MSPropertyDataFile>();
        if (this.getFileList() == null) {
            return peakListFiles;
        }
        for (MSPropertyDataFile file : this.getFileList()) {
            if (!file.getType().equals("TabDelimited") && !file.getType().equals("ThermoExtract") && !file.getType().equals("MascotGeneric")) continue;
            peakListFiles.add(file);
        }
        return peakListFiles;
    }

    public List<MSPropertyDataFile> getQuantificationFiles() {
        ArrayList<MSPropertyDataFile> fileList = new ArrayList<MSPropertyDataFile>();
        if (this.getFileList() == null) {
            return fileList;
        }
        for (PropertyDataFile propertyDataFile : this.getFileList()) {
            if (!(propertyDataFile instanceof MSPropertyDataFile) || ((MSPropertyDataFile)propertyDataFile).getChildren() == null) continue;
            for (MSPropertyDataFile child : ((MSPropertyDataFile)propertyDataFile).getChildren()) {
                if (!child.getCategory().equals((Object)FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY) || child.getMSFileType().equals("Instrument") || fileList.contains((Object)child)) continue;
                fileList.add(child);
            }
        }
        return fileList;
    }

    public List<MSPropertyDataFile> getAnnotationFiles() {
        ArrayList<MSPropertyDataFile> fileList = new ArrayList<MSPropertyDataFile>();
        if (this.getFileList() == null) {
            return fileList;
        }
        for (PropertyDataFile propertyDataFile : this.getFileList()) {
            if (!(propertyDataFile instanceof MSPropertyDataFile) || ((MSPropertyDataFile)propertyDataFile).getChildren() == null) continue;
            for (MSPropertyDataFile child : ((MSPropertyDataFile)propertyDataFile).getChildren()) {
                if (!child.getCategory().equals((Object)FileCategory.ANNOTATION_CATEGORY) || child.getMSFileType().equals("Instrument") || fileList.contains((Object)child)) continue;
                fileList.add(child);
            }
        }
        return fileList;
    }

    public void adjustPropertyFilePaths() {
        if (this.getFileList() != null) {
            for (MSPropertyDataFile file : this.getFileList()) {
                if (file.getName().contains("\\") && !File.separator.equals("\\")) {
                    file.setName(file.getName().replace("\\", File.separator));
                } else if (file.getName().contains("/") && !File.separator.equals("/")) {
                    file.setName(file.getName().replace("/", File.separator));
                }
                if (file.getChildren() == null) continue;
                for (MSPropertyDataFile child : file.getChildren()) {
                    if (child.getName().contains("\\") && !File.separator.equals("\\")) {
                        child.setName(child.getName().replace("\\", File.separator));
                        continue;
                    }
                    if (!file.getName().contains("/") || File.separator.equals("/")) continue;
                    child.setName(child.getName().replace("/", File.separator));
                }
            }
        }
    }

    public static MSPropertyDataFile getLegacyVersionRawPropertyDataFile(String sRawFileName, String originalFileName, boolean isFull) {
        MSPropertyDataFile msFile = null;
        if (sRawFileName != null) {
            String sType = isFull ? MSFileInfo.getType((String)"MSFULL", (String)"RAW") : MSFileInfo.getType((String)"MS", (String)"RAW");
            msFile = new MSPropertyDataFile(sRawFileName, "1.0", sType, FileCategory.ANNOTATION_CATEGORY, "Instrument", originalFileName, Arrays.asList(FileCategory.ANNOTATION_CATEGORY.getLabel()), true);
        }
        return msFile;
    }

    public static MSPropertyDataFile getLegacyVersionMzPropertyDataFile(String sMzFileName, String originalFileName, boolean isFull) {
        MSPropertyDataFile msFile = null;
        if (sMzFileName != null) {
            int iLastDot = sMzFileName.lastIndexOf(".");
            String sExtension = ".mzXML";
            if (iLastDot >= 0) {
                sExtension = sMzFileName.substring(iLastDot + 1);
            }
            String sMsType = sExtension.toUpperCase().startsWith("mzXML".toUpperCase()) ? "mzXML" : "mzML";
            String sType = isFull ? MSFileInfo.getType((String)"MSFULL", (String)sMsType) : MSFileInfo.getType((String)"MS", (String)sMsType);
            String sVersion = sExtension.toUpperCase().startsWith("mzXML".toUpperCase()) ? "1.0" : "1.0";
            msFile = isFull ? new MSPropertyDataFile(sMzFileName, sVersion, sType, FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY, "Converted", originalFileName, Arrays.asList(FileCategory.ANNOTATION_CATEGORY.getLabel())) : new MSPropertyDataFile(sMzFileName, sVersion, sType, FileCategory.ANNOTATION_CATEGORY, "Converted", originalFileName, Arrays.asList(FileCategory.ANNOTATION_CATEGORY.getLabel()));
        }
        return msFile;
    }

    public static MSPropertyDataFile getLegacyVersionPeakListPropertyDataFile(String peakListFileName, String originalFileName, String peakListFileFormat) {
        MSPropertyDataFile peakList = null;
        if (peakListFileName != null && peakListFileFormat != null) {
            String sVersion = null;
            String sType = null;
            if (peakListFileFormat.equals("ThermoExtract")) {
                sVersion = "1.0";
                sType = "ThermoExtract";
            } else if (peakListFileFormat.equals("TabDelimited")) {
                sVersion = "1.0";
                sType = "TabDelimited";
            } else if (peakListFileFormat.equals("MascotGeneric")) {
                sVersion = "1.0";
                sType = "MascotGeneric";
            } else {
                return null;
            }
            peakList = new MSPropertyDataFile(peakListFileName, sVersion, sType, FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY, "Processed", originalFileName, Arrays.asList(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY.getLabel()));
        }
        return peakList;
    }

    @Deprecated
    public String getMsPeakListFileFormat() {
        if (this.getPeakListFile().isEmpty()) {
            return null;
        }
        PropertyDataFile file = this.getPeakListFile().get(0);
        return file != null ? file.getType() : null;
    }

    @Deprecated
    public String getMsPeakListFileName() {
        if (this.getPeakListFile().isEmpty()) {
            return null;
        }
        PropertyDataFile file = this.getPeakListFile().get(0);
        return file != null ? file.getName() : null;
    }

    @Deprecated
    private List<PropertyDataFile> getMzXMLFile(boolean isFull) {
        ArrayList<PropertyDataFile> fileList = new ArrayList<PropertyDataFile>();
        if (this.getFileList() == null) {
            return fileList;
        }
        for (MSPropertyDataFile file : this.getFileList()) {
            if (isFull && file.getCategory().equals((Object)FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY)) {
                if (file.getType().equals("mzXML") || file.getType().equals("mzML")) {
                    fileList.add(file);
                }
            } else if (!isFull && file.getCategory().equals((Object)FileCategory.ANNOTATION_CATEGORY) && (file.getType().equals("mzXML") || file.getType().equals("mzML"))) {
                fileList.add(file);
            }
            if (!(file instanceof MSPropertyDataFile) || file.getChildren() == null) continue;
            for (MSPropertyDataFile child : file.getChildren()) {
                if (isFull && child.getCategory().equals((Object)FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY)) {
                    if (!child.getType().equals("mzXML") && !child.getType().equals("mzML")) continue;
                    fileList.add(child);
                    continue;
                }
                if (isFull || !file.getCategory().equals((Object)FileCategory.ANNOTATION_CATEGORY) || !child.getType().equals("mzXML") && !child.getType().equals("mzML")) continue;
                fileList.add(child);
            }
        }
        return fileList;
    }

    @Deprecated
    public String getMzXMLFullFileName() {
        List<PropertyDataFile> fileList = this.getMzXMLFile(true);
        PropertyDataFile file = null;
        if (!fileList.isEmpty()) {
            file = fileList.get(0);
        }
        return file != null ? file.getName() : null;
    }

    @Deprecated
    public String getMzXMLFileName() {
        List<PropertyDataFile> fileList = this.getMzXMLFile(false);
        PropertyDataFile file = null;
        if (!fileList.isEmpty()) {
            file = fileList.get(0);
        }
        return file != null ? file.getName() : null;
    }
}

