/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.property;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;

public class MassSpecEntityProperty
extends Property {
    public static final String TYPE = MassSpecProperty.class.getName();
    protected Integer scanNum = null;
    protected Integer parentScanNum = null;
    protected Double dMz = null;
    protected Double dParentMz = null;
    protected Integer msLevel = null;
    private String id = null;
    protected String description = null;
    private MassSpecProperty parentProperty = null;
    private Integer iPeakListNumber = 1;

    public MassSpecEntityProperty(MassSpecProperty parentProperty) {
        this.parentProperty = parentProperty;
        this.iPeakListNumber = 1;
    }

    public Object clone() {
        MassSpecEntityProperty newProp = new MassSpecEntityProperty(this.parentProperty);
        newProp.setDescription(this.getDescription());
        newProp.setId(this.getId());
        newProp.setScanNum(this.getScanNum());
        newProp.setMsLevel(this.msLevel);
        newProp.setParentScanNum(this.getParentScanNum());
        newProp.setPeakListNumber(this.iPeakListNumber);
        newProp.setMz(this.dMz);
        newProp.setParentMz(this.dParentMz);
        newProp.setDataFile(this.getDataFile());
        return newProp;
    }

    public Integer getPeakListNumber() {
        return this.iPeakListNumber;
    }

    public void setPeakListNumber(Integer iPeakListNumber) {
        this.iPeakListNumber = iPeakListNumber;
    }

    public Double getMz() {
        return this.dMz;
    }

    public Double getParentMz() {
        return this.dParentMz;
    }

    public void setMz(Double dMz) {
        this.dMz = dMz;
    }

    public void setParentMz(Double dParentMz) {
        this.dParentMz = dParentMz;
    }

    public MSPropertyDataFile getDataFile() {
        if (!this.getDataFiles().isEmpty()) {
            return (MSPropertyDataFile)((Object)this.getDataFiles().get(0));
        }
        return null;
    }

    public void setDataFile(MSPropertyDataFile file) {
        if (this.dataFiles == null) {
            this.dataFiles = new ArrayList();
        }
        this.dataFiles.clear();
        this.dataFiles.add(file);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MassSpecEntityProperty)) {
            return false;
        }
        MassSpecEntityProperty castObj = (MassSpecEntityProperty)((Object)obj);
        boolean bRes = this.getDescription() != null && this.getDescription().equals(castObj.getDescription());
        bRes &= this.getId() != null && this.getId().equals(castObj.getId());
        bRes &= this.getScanNum() != null && this.getScanNum().equals(castObj.getScanNum());
        return bRes &= this.getMsLevel() != null && this.getMsLevel().equals(castObj.getMsLevel());
    }

    public static Entry getTableCompatibleEntry(Entry parentEntry) {
        Entry msEntry = MassSpecProperty.getMSParentEntry(parentEntry);
        MassSpecProperty msProp = null;
        if (msEntry == null) {
            return null;
        }
        msProp = (MassSpecProperty)msEntry.getProperty();
        MassSpecEntityProperty msEntityProp = new MassSpecEntityProperty(msProp);
        Entry newEntry = new Entry();
        newEntry.setProperty((Property)msEntityProp);
        newEntry.setDisplayName(parentEntry.getDisplayName());
        newEntry.setParent(parentEntry);
        return newEntry;
    }

    public Integer getParentScanNum() {
        return this.parentScanNum;
    }

    public void setParentScanNum(Integer parentScanNum) {
        this.parentScanNum = parentScanNum;
    }

    public Property getParentProperty() {
        return this.parentProperty;
    }

    public MassSpecProperty getMassSpecParentProperty() {
        return this.parentProperty;
    }

    public void setMassSpecParentProperty(MassSpecProperty parentProperty) {
        this.parentProperty = parentProperty;
    }

    public Integer getScanNum() {
        return this.scanNum;
    }

    public void setScanNum(Integer scanNum) {
        this.scanNum = scanNum;
    }

    public Integer getMsLevel() {
        return this.msLevel;
    }

    public void setMsLevel(Integer msLevel) {
        this.msLevel = msLevel;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return null;
    }

    public ImageDescriptor getImage() {
        return null;
    }

    public void delete(Entry entry) throws IOException {
    }

    public MassSpecUISettings getMassSpecUISettings() {
        return this.getMassSpecParentProperty().getMassSpecMetaData();
    }
}

