/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.mass;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.tools.gsl.database.IonizationType;
import org.grits.toolbox.tools.gsl.util.mass.AtomicMass;
import org.grits.toolbox.tools.gsl.util.mass.IMass;
import org.grits.toolbox.tools.gsl.util.mass.QuantumMass;

public class ChemicalComposition {
    private Map<IMass, Integer> m_mapAtomToNumber = new HashMap<IMass, Integer>();
    private boolean m_bIsPermethylated = false;
    protected String m_strDerivatizationType = GlycanPreDefinedOptions.DERIVITIZATION_NO_DERIVATIZATION;

    public String toString() {
        return this.getFormula();
    }

    public void clear() {
        this.m_mapAtomToNumber = new HashMap<IMass, Integer>();
    }

    public Map<IMass, Integer> getNumberOfElements() {
        return this.m_mapAtomToNumber;
    }

    public void derivatize(String a_strDerivatizationType) {
        this.m_bIsPermethylated = true;
        this.m_strDerivatizationType = a_strDerivatizationType;
        this.start();
    }

    public void derivatize() {
        this.m_strDerivatizationType = GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED;
        this.m_bIsPermethylated = true;
        this.start();
    }

    public boolean isDerivatized() {
        return this.m_bIsPermethylated;
    }

    protected void start() {
    }

    public void addNumberOfElements(IMass a_enumAM, int a_nAtom) {
        int t_nAtom = a_nAtom;
        if (this.m_mapAtomToNumber.containsKey(a_enumAM) && (t_nAtom += this.m_mapAtomToNumber.get(a_enumAM).intValue()) == 0) {
            this.m_mapAtomToNumber.remove(a_enumAM);
        }
        if (t_nAtom != 0) {
            this.m_mapAtomToNumber.put(a_enumAM, t_nAtom);
        }
    }

    public void addComposition(ChemicalComposition a_ChemComp) {
        Map<IMass, Integer> t_mapAtomToNumber = a_ChemComp.getNumberOfElements();
        for (IMass t_enumAM : t_mapAtomToNumber.keySet()) {
            this.addNumberOfElements(t_enumAM, t_mapAtomToNumber.get(t_enumAM));
        }
    }

    public void addSubstituents(String a_strType, int a_nSubst) {
        if (a_strType == null) {
            return;
        }
        if (a_strType.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED)) {
            this.addNumberOfElements(AtomicMass.C, a_nSubst);
            this.addNumberOfElements(AtomicMass.H, a_nSubst * 2);
        } else if (a_strType.equals(GlycanPreDefinedOptions.DERIVITIZATION_HEAVYPERMETHYLATION)) {
            this.addNumberOfElements(AtomicMass.C13, a_nSubst);
            this.addNumberOfElements(AtomicMass.H, a_nSubst * 2);
        } else if (a_strType.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDMETHYLATED)) {
            this.addNumberOfElements(AtomicMass.H, -a_nSubst);
            this.addNumberOfElements(AtomicMass.C, a_nSubst);
            this.addNumberOfElements(AtomicMass.D, a_nSubst * 3);
        } else if (a_strType.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERACETYLATED)) {
            this.addNumberOfElements(AtomicMass.C, a_nSubst * 2);
            this.addNumberOfElements(AtomicMass.H, a_nSubst * 2);
            this.addNumberOfElements(AtomicMass.O, a_nSubst);
        } else if (a_strType.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDACETYLATED)) {
            this.addNumberOfElements(AtomicMass.H, -a_nSubst);
            this.addNumberOfElements(AtomicMass.C, a_nSubst * 2);
            this.addNumberOfElements(AtomicMass.D, a_nSubst * 3);
            this.addNumberOfElements(AtomicMass.O, a_nSubst);
        }
    }

    public void removeComposition(ChemicalComposition a_ChemComp) {
        Map<IMass, Integer> t_mapAtomToNumber = a_ChemComp.getNumberOfElements();
        for (IMass t_enumAM : t_mapAtomToNumber.keySet()) {
            this.addNumberOfElements(t_enumAM, -t_mapAtomToNumber.get(t_enumAM).intValue());
        }
    }

    public String getFormula() {
        String t_strFormula = "";
        String t_strFormulaMinus = "";
        int t_iCharge = 0;
        if (this.m_mapAtomToNumber.containsKey(AtomicMass.C)) {
            int t_nC = this.m_mapAtomToNumber.get(AtomicMass.C);
            if (t_nC > 0) {
                t_strFormula = String.valueOf(t_strFormula) + this.getAtomicFormula(AtomicMass.C);
            }
            if (t_nC < 0) {
                t_strFormulaMinus = String.valueOf(t_strFormulaMinus) + this.getAtomicFormula(AtomicMass.C);
            }
        }
        int t_nH = 0;
        int t_nMH = 0;
        if (this.m_mapAtomToNumber.containsKey(AtomicMass.H)) {
            if (this.m_mapAtomToNumber.get(AtomicMass.H) > 0) {
                t_nH += this.m_mapAtomToNumber.get(AtomicMass.H).intValue();
            } else {
                t_nMH -= this.m_mapAtomToNumber.get(AtomicMass.H).intValue();
            }
        }
        if (this.m_mapAtomToNumber.containsKey(QuantumMass.p)) {
            t_iCharge += this.m_mapAtomToNumber.get(QuantumMass.p).intValue();
            if (this.m_mapAtomToNumber.get(QuantumMass.p) > 0) {
                t_nH += this.m_mapAtomToNumber.get(QuantumMass.p).intValue();
            } else {
                t_nMH -= this.m_mapAtomToNumber.get(QuantumMass.p).intValue();
            }
        }
        if (t_nH > 0) {
            t_strFormula = String.valueOf(t_strFormula) + "H";
            if (t_nH > 1) {
                t_strFormula = String.valueOf(t_strFormula) + t_nH;
            }
        }
        if (t_nMH > 0) {
            t_strFormulaMinus = String.valueOf(t_strFormulaMinus) + "H";
            if (t_nMH > 1) {
                t_strFormulaMinus = String.valueOf(t_strFormulaMinus) + t_nMH;
            }
        }
        if (this.m_mapAtomToNumber.containsKey(QuantumMass.e) && this.m_mapAtomToNumber.get(QuantumMass.e) != 0) {
            t_iCharge -= this.m_mapAtomToNumber.get(QuantumMass.e).intValue();
        }
        TreeSet<String> t_aSymbols = new TreeSet<String>();
        for (IMass t_enumAM : this.m_mapAtomToNumber.keySet()) {
            if (t_enumAM == AtomicMass.C || t_enumAM == AtomicMass.H || t_enumAM == QuantumMass.p || t_enumAM == QuantumMass.e) continue;
            t_aSymbols.add(t_enumAM.getSymbol());
        }
        for (String t_strSymbol : t_aSymbols) {
            AtomicMass t_atom = AtomicMass.forSymbol(t_strSymbol);
            int t_nAtom = this.m_mapAtomToNumber.get(t_atom);
            if (t_nAtom > 0) {
                t_strFormula = String.valueOf(t_strFormula) + this.getAtomicFormula(t_atom);
            }
            if (t_nAtom >= 0) continue;
            t_strFormulaMinus = String.valueOf(t_strFormulaMinus) + this.getAtomicFormula(t_atom);
        }
        if (!t_strFormulaMinus.isEmpty()) {
            t_strFormula = "(" + t_strFormula + " - " + t_strFormulaMinus + ")";
        }
        if (t_iCharge != 0) {
            t_strFormula = String.valueOf(t_strFormula) + (Math.abs(t_iCharge) == 1 ? "" : "[" + Math.abs(t_iCharge) + (t_iCharge > 0 ? "+" : "-") + "]");
        }
        return t_strFormula;
    }

    private String getAtomicFormula(IMass a_atom) {
        String t_strFormula = "";
        int t_nAtom = Math.abs(this.m_mapAtomToNumber.get(a_atom));
        if (t_nAtom > 0) {
            t_strFormula = String.valueOf(t_strFormula) + a_atom.getSymbol();
            if (t_nAtom > 1) {
                t_strFormula = String.valueOf(t_strFormula) + t_nAtom;
            }
        }
        return t_strFormula;
    }

    public static ChemicalComposition parseFormula(String a_strFormula) {
        String t_strFormula = a_strFormula;
        if (a_strFormula.startsWith("-")) {
            t_strFormula = a_strFormula.substring(1);
        }
        ChemicalComposition t_ChemComp = new ChemicalComposition();
        int t_iSize = t_strFormula.length();
        int i = 0;
        while (i < t_iSize) {
            char t_cX = t_strFormula.charAt(i);
            Enum t_iMass = null;
            int t_nAtom = 1;
            if (Character.isAlphabetic(t_cX)) {
                char t_cNext;
                String t_strAtom = "" + t_cX;
                if (i + 1 < t_iSize && Character.isLowerCase(t_cNext = t_strFormula.charAt(i + 1))) {
                    t_strAtom = String.valueOf(t_strAtom) + t_cNext;
                    ++i;
                }
                t_iMass = AtomicMass.forSymbol(t_strAtom);
            }
            if (t_cX == '+' || t_cX == '-') {
                t_iMass = QuantumMass.e;
                if (t_cX == '+') {
                    t_nAtom = -1;
                }
            }
            if (t_iMass == null) {
                return null;
            }
            String t_strNum = "";
            while (i + 1 < t_iSize && Character.isDigit(t_strFormula.charAt(i + 1))) {
                t_strNum = String.valueOf(t_strNum) + t_strFormula.charAt(i + 1);
                ++i;
            }
            if (!t_strNum.isEmpty()) {
                t_nAtom *= Integer.valueOf(t_strNum).intValue();
            }
            t_ChemComp.addNumberOfElements((IMass)((Object)t_iMass), t_nAtom);
            ++i;
        }
        return t_ChemComp;
    }

    public String getMonoisotopicMass() {
        BigDecimal t_bdMass = new BigDecimal("0");
        for (IMass t_enumAM : this.m_mapAtomToNumber.keySet()) {
            BigDecimal t_bdAtomMass = new BigDecimal(t_enumAM.getExactMass());
            int t_nAtom = this.m_mapAtomToNumber.get(t_enumAM);
            t_bdMass = t_bdMass.add(t_bdAtomMass.multiply(new BigDecimal(t_nAtom)));
        }
        return t_bdMass.toPlainString();
    }

    public String getMonoisotopicMass(IonizationType a_type) {
        return this.getIonizedComposition(a_type).getMonoisotopicMass();
    }

    public String getFormula(IonizationType a_type) {
        return this.getIonizedComposition(a_type).getFormula();
    }

    private ChemicalComposition getIonizedComposition(IonizationType a_type) {
        ChemicalComposition t_calcMass = null;
        switch (a_type) {
            case PH: {
                t_calcMass = this.getCustomIonizedComposition(AtomicMass.H, 1, false);
                break;
            }
            case MH: {
                t_calcMass = this.getCustomIonizedComposition(AtomicMass.H, -1, false);
                break;
            }
            case PNA: {
                t_calcMass = this.getCustomIonizedComposition(AtomicMass.Na, 1, false);
                break;
            }
            case PHMH2O: {
                t_calcMass = this.getCustomIonizedComposition(AtomicMass.H, 1, true);
                break;
            }
            case NOIONMH2O: {
                t_calcMass = this.getCustomIonizedComposition(AtomicMass.H, 0, true);
                break;
            }
            default: {
                t_calcMass = this.copy();
            }
        }
        return t_calcMass;
    }

    public ChemicalComposition getCustomIonizedComposition(AtomicMass a_atom, int a_iCount, boolean a_bMH2O) {
        ChemicalComposition t_calcMass = this.copy();
        t_calcMass.addNumberOfElements(a_atom, a_iCount);
        t_calcMass.addNumberOfElements(QuantumMass.e, -a_iCount);
        if (a_bMH2O) {
            t_calcMass.addNumberOfElements(AtomicMass.H, -2);
            t_calcMass.addNumberOfElements(AtomicMass.O, -1);
            if (this.m_bIsPermethylated) {
                t_calcMass.addNumberOfElements(AtomicMass.C, -1);
                t_calcMass.addNumberOfElements(AtomicMass.H, -2);
            }
        }
        return t_calcMass;
    }

    public ChemicalComposition copy() {
        ChemicalComposition t_copy = new ChemicalComposition();
        t_copy.m_strDerivatizationType = this.m_strDerivatizationType;
        t_copy.m_bIsPermethylated = this.m_bIsPermethylated;
        for (IMass t_enumAM : this.m_mapAtomToNumber.keySet()) {
            t_copy.m_mapAtomToNumber.put(t_enumAM, this.m_mapAtomToNumber.get(t_enumAM));
        }
        return t_copy;
    }
}

