/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.BaseWorkspace;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanDocument;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.Annotation;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.MassUnit;
import org.eurocarbdb.application.glycoworkbench.NotesDocument;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationMultiple;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.SpectraDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Scan
implements BaseDocument.DocumentChangeListener {
    protected String name = "Scan";
    protected Double precursor_mz = null;
    private boolean is_msms = true;
    protected GlycanDocument theStructures = null;
    protected FragmentDocument theFragments = null;
    protected SpectraDocument theSpectra = null;
    protected PeakList thePeakList = null;
    protected AnnotatedPeakList theAnnotatedPeakList = null;
    protected NotesDocument theNotes = null;
    protected Vector<AnnotationReportDocument> theAnnotationReports = new Vector();
    protected Scan parent = null;
    protected Vector<Scan> children = new Vector();

    public Scan(GlycanWorkspace ws) {
        this.theStructures = new GlycanDocument((BaseWorkspace)ws);
        this.theFragments = new FragmentDocument();
        this.theSpectra = new SpectraDocument(this);
        this.thePeakList = new PeakList();
        this.theAnnotatedPeakList = new AnnotatedPeakList();
        this.theNotes = new NotesDocument();
        this.theAnnotationReports = new Vector();
        this.theSpectra.addDocumentChangeListener(this);
    }

    public void initData() {
        this.name = "Scan";
        this.precursor_mz = null;
        this.is_msms = true;
        this.theStructures.initData();
        this.theFragments.initData();
        this.theSpectra.initData();
        this.thePeakList.initData();
        this.theAnnotatedPeakList.initData();
        this.theNotes.initData();
        this.theAnnotationReports = new Vector();
        this.parent = null;
        this.children = new Vector();
    }

    public Scan getParent() {
        return this.parent;
    }

    public void setParent(Scan s) {
        this.parent = s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public Double getPrecursorMZ() {
        return this.precursor_mz;
    }

    public void setPrecursorMZ(Double value) {
        this.precursor_mz = value;
    }

    public boolean isMsMs() {
        return this.is_msms;
    }

    public void setMsMs(boolean f) {
        this.is_msms = f;
    }

    public GlycanDocument getStructures() {
        return this.theStructures;
    }

    public FragmentDocument getFragments() {
        return this.theFragments;
    }

    public SpectraDocument getSpectra() {
        return this.theSpectra;
    }

    public PeakList getPeakList() {
        return this.thePeakList;
    }

    public AnnotatedPeakList getAnnotatedPeakList() {
        return this.theAnnotatedPeakList;
    }

    public NotesDocument getNotes() {
        return this.theNotes;
    }

    public Vector<AnnotationReportDocument> getAnnotationReports() {
        return this.theAnnotationReports;
    }

    public int getNoChildren() {
        return this.children.size();
    }

    public Vector<Scan> getChildren() {
        return this.children;
    }

    public Iterator<Scan> iterator() {
        return this.children.iterator();
    }

    public Scan childAt(int index) {
        return this.children.elementAt(index);
    }

    public int indexOf(Scan child) {
        return this.children.indexOf(child);
    }

    public boolean add(Scan toadd) {
        if (toadd != null) {
            this.children.add(toadd);
            toadd.setParent(this);
            return true;
        }
        return false;
    }

    public boolean remove(Scan toremove) {
        if (toremove != null && this.children.contains(toremove)) {
            this.children.remove(toremove);
            toremove.setParent(null);
            return true;
        }
        return false;
    }

    public boolean canRemove(Scan toremove) {
        return toremove != null && this.children.contains(toremove);
    }

    public boolean containsSubTree(Scan s) {
        if (s == null) {
            return false;
        }
        if (this == s) {
            return true;
        }
        for (Scan c : this.children) {
            if (!c.containsSubTree(s)) continue;
            return true;
        }
        return false;
    }

    public Scan findInternalDocument(BaseDocument doc) {
        if (doc == null) {
            return null;
        }
        if (doc == this.theStructures || doc == this.theFragments || doc == this.theSpectra || doc == this.thePeakList || doc == this.theAnnotatedPeakList || doc == this.theNotes || this.theAnnotationReports.contains(doc)) {
            return this;
        }
        for (Scan c : this.children) {
            Scan ret = c.findInternalDocument(doc);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public void documentInit(BaseDocument.DocumentChangeEvent e) {
        if (e.getSource() == this.theSpectra) {
            this.is_msms = this.theSpectra.getNoScans() > 0 ? this.theSpectra.getScanDataAt(0).getMSLevel() > 1 : this.is_msms;
        }
    }

    public void documentChanged(BaseDocument.DocumentChangeEvent e) {
        if (e.getSource() == this.theSpectra) {
            this.is_msms = this.theSpectra.getNoScans() > 0 ? this.theSpectra.getScanDataAt(0).getMSLevel() > 1 : this.is_msms;
        }
    }

    public static Scan fromXML(GlycanWorkspace ws, Node scan_node) throws Exception {
        Node n_node;
        Node apl_node;
        Node pl_node;
        Node sd_node;
        Node f_node;
        Node c_node;
        String msms;
        String mz;
        Scan ret = new Scan(ws);
        String n = XMLUtils.getAttribute((Node)scan_node, (String)"name");
        if (n != null && n.length() > 0) {
            ret.name = n;
        }
        if ((mz = XMLUtils.getAttribute((Node)scan_node, (String)"precursor_mz")) != null && mz.length() > 0) {
            ret.precursor_mz = Double.valueOf(mz);
        }
        if ((msms = XMLUtils.getAttribute((Node)scan_node, (String)"is_msm")) != null) {
            ret.is_msms = Boolean.valueOf(msms);
        }
        if ((c_node = XMLUtils.findChild((Node)scan_node, (String)"Structures")) != null) {
            ret.theStructures.fromXML(c_node, false);
        }
        if ((f_node = XMLUtils.findChild((Node)scan_node, (String)"Fragments")) != null) {
            ret.theFragments.fromXML(f_node, false);
        }
        if ((sd_node = XMLUtils.findChild((Node)scan_node, (String)"SpectraDocument")) != null) {
            ret.theSpectra.fromXML(sd_node, false);
        }
        if ((pl_node = XMLUtils.findChild((Node)scan_node, (String)"PeakList")) != null) {
            ret.thePeakList.fromXML(pl_node, false);
        }
        if ((apl_node = XMLUtils.findChild((Node)scan_node, (String)"AnnotatedPeakList")) != null) {
            ret.theAnnotatedPeakList.fromXML(apl_node, false);
        }
        if ((n_node = XMLUtils.findChild((Node)scan_node, (String)"Notes")) != null) {
            ret.theNotes.fromXML(n_node, false);
        }
        Vector ard_nodes = XMLUtils.findAllChildren((Node)scan_node, (String)"AnnotationReportDocument");
        for (Node ard_node : ard_nodes) {
            AnnotationReportDocument toadd = new AnnotationReportDocument();
            toadd.fromXML(ard_node);
            ret.theAnnotationReports.add(toadd);
        }
        Vector child_nodes = XMLUtils.findAllChildren((Node)scan_node, (String)"Scan");
        for (Node s_node : child_nodes) {
            ret.add(Scan.fromXML(ws, s_node));
        }
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element scan_node = document.createElement("Scan");
        if (this.name != null) {
            scan_node.setAttribute("name", "" + this.name);
        }
        if (this.precursor_mz != null) {
            scan_node.setAttribute("precursor_mz", "" + this.precursor_mz);
        }
        scan_node.setAttribute("is_msms", "" + this.is_msms);
        scan_node.appendChild(this.theStructures.toXML(document));
        scan_node.appendChild(this.theFragments.toXML(document));
        scan_node.appendChild(this.theSpectra.toXML(document));
        scan_node.appendChild(this.thePeakList.toXML(document));
        scan_node.appendChild(this.theAnnotatedPeakList.toXML(document));
        scan_node.appendChild(this.theNotes.toXML(document));
        for (AnnotationReportDocument ard : this.theAnnotationReports) {
            scan_node.appendChild(ard.toXML(document));
        }
        for (Scan c : this.children) {
            scan_node.appendChild(c.toXML(document));
        }
        return scan_node;
    }

    public void write(TransformerHandler th) throws SAXException {
        this.write(th, false);
    }

    public void write(TransformerHandler th, boolean includeSpectra) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        if (this.name != null) {
            atts.addAttribute("", "", "name", "CDATA", "" + this.name);
        }
        if (this.precursor_mz != null) {
            atts.addAttribute("", "", "precursor_mz", "CDATA", "" + this.precursor_mz);
        }
        atts.addAttribute("", "", "is_msms", "CDATA", "" + this.is_msms);
        th.startElement("", "", "Scan", atts);
        this.theStructures.write(th);
        this.theFragments.write(th);
        if (includeSpectra) {
            this.theSpectra.write(th);
        }
        this.thePeakList.write(th);
        this.theAnnotatedPeakList.write(th);
        this.theNotes.write(th);
        for (AnnotationReportDocument ard : this.theAnnotationReports) {
            ard.write(th);
        }
        for (Scan c : this.children) {
            c.write(th, includeSpectra);
        }
        th.endElement("", "", "Scan");
    }

    public boolean sync(AnnotationOptions ann_opts) {
        return this.sync(this.getParent().getAnnotatedPeakList(), ann_opts);
    }

    public boolean sync(AnnotatedPeakList annotatedPeakList, AnnotationOptions ann_opts) {
        if (this.getPrecursorMZ() == null) {
            return false;
        }
        boolean matchFound = false;
        Scan parentScan = this.getParent();
        if (parentScan != null) {
            this.getStructures().clear();
            List<PeakAnnotationMultiple> peakAnnotationsList = annotatedPeakList.getAnnotationList(new Peak(this.getPrecursorMZ(), 0.0), ann_opts.getMassAccuracy(), MassUnit.valueOfCompat(ann_opts.getMassAccuracyUnit()));
            if (peakAnnotationsList != null) {
                HashMap<String, Glycan> structures = new HashMap<String, Glycan>();
                for (PeakAnnotationMultiple peakAnnotations : peakAnnotationsList) {
                    for (Vector<Annotation> structureToAnnotations : peakAnnotations.getAnnotations()) {
                        for (Annotation annotation : structureToAnnotations) {
                            Glycan fragment = annotation.getFragmentEntry().fragment;
                            String gws = fragment.toStringOrdered(true);
                            if (structures.containsKey(gws)) continue;
                            structures.put(gws, fragment);
                        }
                    }
                }
                for (Glycan glycan : structures.values()) {
                    this.getStructures().addStructure(glycan.clone(false));
                }
                if (structures.size() > 0) {
                    matchFound = true;
                }
            }
        }
        return matchFound;
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private GlycanWorkspace theWorkspace;

        public SAXHandler(GlycanWorkspace ws) {
            this.theWorkspace = ws;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Scan";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(GlycanDocument.SAXHandler.getNodeElementName())) {
                return new GlycanDocument.SAXHandler(new GlycanDocument((BaseWorkspace)this.theWorkspace), false);
            }
            if (qName.equals(FragmentDocument.SAXHandler.getNodeElementName())) {
                return new FragmentDocument.SAXHandler(new FragmentDocument(), false);
            }
            if (qName.equals(SpectraDocument.SAXHandler.getNodeElementName())) {
                return new SpectraDocument.SAXHandler(new SpectraDocument(null), false);
            }
            if (qName.equals(PeakList.SAXHandler.getNodeElementName())) {
                return new PeakList.SAXHandler(new PeakList(), false);
            }
            if (qName.equals(AnnotatedPeakList.SAXHandler.getNodeElementName())) {
                return new AnnotatedPeakList.SAXHandler(new AnnotatedPeakList(), false);
            }
            if (qName.equals(NotesDocument.SAXHandler.getNodeElementName())) {
                return new NotesDocument.SAXHandler(new NotesDocument(), false);
            }
            if (qName.equals(AnnotationReportDocument.SAXHandler.getNodeElementName())) {
                return new AnnotationReportDocument.SAXHandler(new AnnotationReportDocument());
            }
            if (qName.equals(SAXHandler.getNodeElementName())) {
                return new SAXHandler(this.theWorkspace);
            }
            return null;
        }

        protected void initContent(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            Scan ret = new Scan(this.theWorkspace);
            ret.name = this.stringAttribute(atts, "name", ret.name);
            ret.precursor_mz = this.doubleAttribute(atts, "precursor_mz", ret.precursor_mz);
            ret.is_msms = this.booleanAttribute(atts, "is_msms", ret.is_msms);
            this.object = ret;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            Scan ret = (Scan)this.object;
            ret.theStructures = (GlycanDocument)this.getSubObject(GlycanDocument.SAXHandler.getNodeElementName(), ret.theStructures);
            ret.theFragments = (FragmentDocument)this.getSubObject(FragmentDocument.SAXHandler.getNodeElementName(), ret.theFragments);
            ret.theSpectra = (SpectraDocument)((Object)this.getSubObject(SpectraDocument.SAXHandler.getNodeElementName(), (Object)ret.theSpectra));
            ret.thePeakList = (PeakList)((Object)this.getSubObject(PeakList.SAXHandler.getNodeElementName(), (Object)ret.thePeakList));
            ret.theAnnotatedPeakList = (AnnotatedPeakList)((Object)this.getSubObject(AnnotatedPeakList.SAXHandler.getNodeElementName(), (Object)ret.theAnnotatedPeakList));
            ret.theNotes = (NotesDocument)((Object)this.getSubObject(NotesDocument.SAXHandler.getNodeElementName(), (Object)ret.theNotes));
            ret.theSpectra.setScan(ret);
            for (Object o : this.getSubObjects(AnnotationReportDocument.SAXHandler.getNodeElementName())) {
                ret.theAnnotationReports.add((AnnotationReportDocument)((Object)o));
            }
            for (Object o : this.getSubObjects(SAXHandler.getNodeElementName())) {
                ret.add((Scan)o);
            }
            return ret;
        }
    }
}

