/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.dialog;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.entry.ms.annotation.glycan.dialog.MSGlycanAnnotationAnnotationModifyDialog;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanAnnotationCustomAnnotationsPreferenceUI;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.MSGlycanCustomAnnotationPreference;
import org.grits.toolbox.entry.ms.annotation.glycan.property.datamodel.MSGlycanAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.dialog.MassSpecCustomAnnotationDialog;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecPeaksView;

public class MSGlycanAnnotationCustomAnnotationDialog
extends MassSpecCustomAnnotationDialog {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationCustomAnnotationDialog.class);

    public MSGlycanAnnotationCustomAnnotationDialog(Shell parentShell, MassSpecMultiPageViewer curView) {
        super(parentShell, curView);
        this.setShellStyle(18544);
        this.initStoredAnnotations();
    }

    public void initStoredAnnotations() {
        this.storedAnnotations = MSGlycanAnnotationCustomAnnotationsPreferenceUI.loadWorkspacePreferences();
    }

    protected void initLocalAnnotations() {
        this.localAnnotations = new MSGlycanCustomAnnotationPreference();
        MSGlycanAnnotationCustomAnnotationsPreferenceUI.initAnnotationFromEntry(this.getMassSpecEntry(), this.localAnnotations);
        this.entryAnnotations = new MSGlycanCustomAnnotationPreference();
        MSGlycanAnnotationCustomAnnotationsPreferenceUI.initAnnotationFromEntry(this.getMassSpecEntry(), this.entryAnnotations);
    }

    protected void setCurrentAnnotationValues(String selAnnotName) {
        super.setCurrentAnnotationValues(selAnnotName);
    }

    public MassSpecMultiPageViewer getCurrentViewer() {
        try {
            EPartService partService = this.getContextViewer().getPartService();
            for (MPart mPart : partService.getParts()) {
                MSGlycanAnnotationMultiPageViewer viewer;
                if (!(mPart.getObject() instanceof MSGlycanAnnotationMultiPageViewer) || !mPart.equals(mPart.getParent().getSelectedElement()) || (viewer = (MSGlycanAnnotationMultiPageViewer)((Object)mPart.getObject())) == null || viewer.getEntry().getProperty() == null || !(viewer.getEntry().getProperty() instanceof MSAnnotationEntityProperty)) continue;
                return viewer;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected void clearAnnotation() {
        MSAnnotationEntityProperty ep = (MSAnnotationEntityProperty)this.getMassSpecEntry().getProperty();
        MSAnnotationProperty prop = (MSAnnotationProperty)ep.getParentProperty();
        MSGlycanAnnotationMetaData msSettings = null;
        if (!(prop.getMSAnnotationMetaData() instanceof MSGlycanAnnotationMetaData)) {
            msSettings = new MSGlycanAnnotationMetaData();
            msSettings.clone(prop.getMSAnnotationMetaData());
            prop.setMSAnnotationMetaData((MSAnnotationMetaData)msSettings);
        } else {
            msSettings = (MSGlycanAnnotationMetaData)prop.getMSAnnotationMetaData();
        }
        this.setCurrentAnnotationValues(this.cmbSelectAnnotation.getText().trim());
        try {
            String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
            if (msSettings.getCustomAnnotations().contains(this.selAnnot)) {
                msSettings.getCustomAnnotations().remove(this.selAnnot);
            }
            msSettings.updateCustomAnotationData();
            MSAnnotationProperty.updateMSSettings((MSAnnotationMetaData)msSettings, (String)sFileName);
            this.initLocalAnnotations();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        MSGlycanAnnotationMultiPageViewer viewer = (MSGlycanAnnotationMultiPageViewer)this.getCurrentViewer();
        try {
            MSAnnotationTableDataProcessor proc = (MSAnnotationTableDataProcessor)((MassSpecPeaksView)viewer.getPeaksView().get(0)).getTableDataProcessor();
            proc.writeArchive();
            this.updateViewer(null);
            this.initStoredAnnotationsList();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    protected void performAnnotation() {
        MSAnnotationEntityProperty ep = (MSAnnotationEntityProperty)this.getMassSpecEntry().getProperty();
        MSAnnotationProperty prop = (MSAnnotationProperty)ep.getParentProperty();
        MSGlycanAnnotationMetaData msSettings = null;
        if (!(prop.getMSAnnotationMetaData() instanceof MSGlycanAnnotationMetaData)) {
            msSettings = new MSGlycanAnnotationMetaData();
            msSettings.clone(prop.getMSAnnotationMetaData());
            prop.setMSAnnotationMetaData((MSAnnotationMetaData)msSettings);
        } else {
            msSettings = (MSGlycanAnnotationMetaData)prop.getMSAnnotationMetaData();
        }
        this.setCurrentAnnotationValues(this.cmbSelectAnnotation.getText().trim());
        try {
            if (msSettings.getCustomAnnotations().contains(this.selAnnot)) {
                msSettings.getCustomAnnotations().remove(this.selAnnot);
            }
            if (this.selAnnot != null) {
                msSettings.getCustomAnnotations().add(this.selAnnot);
            }
            String sFileName = prop.getFullyQualifiedMetaDataFileName(this.getMassSpecEntry());
            msSettings.updateCustomAnotationData();
            MSAnnotationProperty.updateMSSettings((MSAnnotationMetaData)msSettings, (String)sFileName);
            this.initLocalAnnotations();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            List sKeyVals = this.getColumnKeyLabels();
            this.updateViewer(sKeyVals);
            this.initStoredAnnotationsList();
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    protected void updateViewer(List<String> sKeyVals) {
        try {
            MSGlycanAnnotationMultiPageViewer viewer = (MSGlycanAnnotationMultiPageViewer)this.getCurrentViewer();
            viewer.reLoadStructureAnnotationTab(sKeyVals);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void modifyAnnotations() {
        MSGlycanAnnotationMultiPageViewer curView = (MSGlycanAnnotationMultiPageViewer)this.getCurrentViewer();
        if (curView == null) {
            return;
        }
        Entry msEntry = curView.getEntry();
        if (msEntry == null) {
            return;
        }
        Property msProp = msEntry.getProperty();
        if (msProp instanceof MSAnnotationEntityProperty) {
            if (this.win == null) {
                this.win = new MSGlycanAnnotationAnnotationModifyDialog(this.getShell(), (MassSpecMultiPageViewer)curView);
                this.win.setLocalAnnotations(this.getLocalAnnotations());
                this.win.setEntryAnnotations(this.getEntryAnnotations());
                this.win.setSelectedAnnotation(this.cmbSelectAnnotation.getText());
                this.win.addListener((IPropertyChangeListener)this);
                this.win.open();
                return;
            }
            this.win.getShell().forceActive();
        }
    }

    protected String getFormTitle() {
        return "Modify MS Glycan Custom Annotations";
    }
}

