/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.property.WorkspaceProperty;
import org.grits.toolbox.core.utils.ProjectEntry;
import org.grits.toolbox.core.workspace.WorkspaceHistoryFileHandler;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public class WorkspaceXMLHandler {
    private static final Logger logger = Logger.getLogger(WorkspaceHistoryFileHandler.class);

    public static ProjectEntry[] getProjectFolders() throws Exception {
        boolean exist;
        ProjectEntry[] resultFiles = new ProjectEntry[]{};
        String lastActiveHistory = null;
        try {
            lastActiveHistory = WorkspaceHistoryFileHandler.getLastActiveHistory();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            exist = WorkspaceXMLHandler.CheckWorkspaceXMLExist();
        }
        catch (Exception e1) {
            logger.fatal((Object)e1.getMessage(), (Throwable)e1);
            throw e1;
        }
        if (!exist) {
            logger.fatal((Object)("workspace.xml does not exist: " + lastActiveHistory + "/.workspace.xml"));
            throw new Exception("workspace.xml does not exist: " + lastActiveHistory + "/.workspace.xml");
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build(new File(String.valueOf(lastActiveHistory) + "/.workspace.xml"));
            XPath xpath = null;
            xpath = XPath.newInstance((String)"//project");
            List resultList = xpath.selectNodes((Object)document);
            resultFiles = new ProjectEntry[resultList.size()];
            Iterator b = resultList.iterator();
            int i = 0;
            while (b.hasNext()) {
                Element oNode = (Element)b.next();
                Attribute openAttr = oNode.getAttribute("open");
                Boolean open = true;
                if (openAttr != null) {
                    open = oNode.getAttribute("open").getValue().equals("yes");
                }
                resultFiles[i] = new ProjectEntry(oNode.getAttribute("folder").getValue(), open);
                ++i;
            }
        }
        catch (JDOMException e) {
            logger.fatal((Object)e);
            throw new JDOMException("Error occured while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml", (Throwable)e);
        }
        catch (IOException e) {
            logger.fatal((Object)e);
            throw new IOException("Error occured while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml", e);
        }
        return resultFiles;
    }

    public static void createNewWorkspaceXMLFile() throws Exception {
        Element workspaceList = new Element("workspace");
        Document doc = new Document(workspaceList);
        doc.setRootElement(workspaceList);
        try {
            String lastActiveHistory = WorkspaceHistoryFileHandler.getLastActiveHistory();
            try {
                WorkspaceXMLHandler.writeXmlFile(doc, new File(String.valueOf(lastActiveHistory) + File.separator + ".workspace.xml"));
            }
            catch (IOException e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
                throw new IOException("Error occurred while writing to workspace xml file: " + lastActiveHistory + "/.workspace.xml", e);
            }
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static boolean CheckWorkspaceXMLExist() throws Exception {
        File workspaceXML;
        String lastActiveHistory = null;
        try {
            lastActiveHistory = WorkspaceHistoryFileHandler.getLastActiveHistory();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            workspaceXML = new File(String.valueOf(lastActiveHistory) + "/.workspace.xml");
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return workspaceXML.exists();
    }

    public static boolean getOpen(Entry projectEntry) throws Exception {
        String open = null;
        SAXBuilder builder = new SAXBuilder();
        String lastActiveHistory = null;
        try {
            lastActiveHistory = WorkspaceHistoryFileHandler.getLastActiveHistory();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            File xmlFile = new File(String.valueOf(lastActiveHistory) + "/.workspace.xml");
            if (!xmlFile.exists()) {
                logger.fatal((Object)("workspace xml file does not exist: " + lastActiveHistory + "/.workspace.xml"));
                throw new Exception("workspace xml file does not exist: " + lastActiveHistory + "/.workspace.xml");
            }
            Document doc = builder.build(xmlFile);
            XPath xpath = null;
            xpath = XPath.newInstance((String)("//project[@folder='" + projectEntry.getDisplayName() + "']"));
            List resultList = xpath.selectNodes((Object)doc);
            for (Element oNode : resultList) {
                open = oNode.getAttribute("open").getValue();
            }
        }
        catch (JDOMException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return open.equals("yes");
    }

    public static void removeEntry(String entry) throws Exception {
        List resultList;
        Document doc;
        String lastActiveHistory = null;
        try {
            lastActiveHistory = WorkspaceHistoryFileHandler.getLastActiveHistory();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        SAXBuilder builder = new SAXBuilder();
        File xmlFile = new File(String.valueOf(lastActiveHistory) + "/.workspace.xml");
        try {
            if (!xmlFile.exists()) {
                logger.fatal((Object)("workspace xml file does not exist: " + lastActiveHistory + "/.workspace.xml"));
                throw new Exception("workspace xml file does not exist: " + lastActiveHistory + "/.workspace.xml");
            }
        }
        catch (Exception e) {
            logger.fatal((Object)("workspace xml file does not exist: " + lastActiveHistory + "/.workspace.xml"));
            throw e;
        }
        try {
            doc = builder.build(xmlFile);
        }
        catch (JDOMException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        try {
            XPath xpath = null;
            xpath = XPath.newInstance((String)("//project[@folder='" + entry + "']"));
            resultList = xpath.selectNodes((Object)doc);
        }
        catch (JDOMException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        for (Element oNode : resultList) {
            oNode.detach();
        }
        try {
            WorkspaceXMLHandler.writeXmlFile(doc, new File(String.valueOf(lastActiveHistory) + File.separator + ".workspace.xml"));
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while writing to workspace xml file: " + lastActiveHistory + File.separator + ".workspace.xml"), (Throwable)e);
            throw e;
        }
    }

    public static void setOpenClosed(Entry projectEntry) throws Exception {
        Iterator b;
        Document doc;
        String lastActiveHistory = null;
        try {
            lastActiveHistory = WorkspaceHistoryFileHandler.getLastActiveHistory();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        SAXBuilder builder = new SAXBuilder();
        File xmlFile = new File(String.valueOf(lastActiveHistory) + "/.workspace.xml");
        if (!xmlFile.exists()) {
            logger.fatal((Object)("workspace xml file does not exist: " + lastActiveHistory + "/.workspace.xml"));
            throw new Exception("workspace xml file does not exist: " + lastActiveHistory + "/.workspace.xml");
        }
        try {
            doc = builder.build(xmlFile);
        }
        catch (JDOMException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        try {
            XPath xpath = null;
            xpath = XPath.newInstance((String)("//project[@folder='" + projectEntry.getDisplayName() + "']"));
            List resultList = xpath.selectNodes((Object)doc);
            b = resultList.iterator();
        }
        catch (JDOMException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        ProjectProperty pp = (ProjectProperty)projectEntry.getProperty();
        while (b.hasNext()) {
            Element oNode = (Element)b.next();
            if (pp.getOpen()) {
                oNode.getAttribute("open").setValue("yes");
                continue;
            }
            oNode.getAttribute("open").setValue("no");
        }
        try {
            WorkspaceXMLHandler.writeXmlFile(doc, new File(String.valueOf(lastActiveHistory) + File.separator + ".workspace.xml"));
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while writing to workspace xml file: " + lastActiveHistory + File.separator + ".workspace.xml"), (Throwable)e);
            throw e;
        }
    }

    public static void updateWorkspaceXMLFile(Entry projectEntry) throws FileNotFoundException, IOException, Exception {
        Document doc;
        SAXBuilder builder = new SAXBuilder();
        String lastActiveHistory = null;
        try {
            lastActiveHistory = WorkspaceHistoryFileHandler.getLastActiveHistory();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        File xmlFile = new File(String.valueOf(lastActiveHistory) + "/.workspace.xml");
        if (!xmlFile.exists()) {
            logger.fatal((Object)("workspace xml file does not exist: " + lastActiveHistory + "/.workspace.xml"));
            throw new FileNotFoundException("workspace xml file does not exist: " + lastActiveHistory + "/.workspace.xml");
        }
        try {
            doc = builder.build(xmlFile);
        }
        catch (JDOMException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        List resultList = null;
        XPath xpath = null;
        try {
            xpath = XPath.newInstance((String)("//project[@folder='" + projectEntry.getDisplayName() + "']"));
            resultList = xpath.selectNodes((Object)doc);
        }
        catch (JDOMException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
        if (resultList.size() == 0) {
            Element workspace = new Element("project");
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(new Attribute("folder", projectEntry.getDisplayName()));
            atts.add(new Attribute("open", "yes"));
            workspace.setAttributes(atts);
            doc.getRootElement().addContent((Content)workspace);
        }
        try {
            WorkspaceXMLHandler.writeXmlFile(doc, new File(String.valueOf(lastActiveHistory) + File.separator + ".workspace.xml"));
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while writing to workspace xml file: " + lastActiveHistory + File.separator + ".workspace.xml"), (Throwable)e);
            throw e;
        }
    }

    public static void checkWorkspaceXMLfile() throws Exception {
        SAXBuilder builder = new SAXBuilder();
        String lastActiveHistory = null;
        try {
            lastActiveHistory = WorkspaceHistoryFileHandler.getLastActiveHistory();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        File xmlFile = new File(String.valueOf(lastActiveHistory) + "/.workspace.xml");
        Document doc = null;
        try {
            doc = builder.build(xmlFile);
        }
        catch (JDOMException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while reading workspace xml file: " + lastActiveHistory + "/.workspace.xml"), (Throwable)e);
            throw e;
        }
        Element rootNode = doc.getRootElement();
        if (!rootNode.getName().equals("workspace")) {
            logger.fatal((Object)("Workspace file does not start with workspace tag: " + lastActiveHistory + "/.workspace.xml"));
            throw new IOException("Workspace file does not start with workspace tag: " + lastActiveHistory + "/.workspace.xml");
        }
        List children = rootNode.getChildren();
        for (Element child : children) {
            if (child.getName().equals("project")) continue;
            logger.fatal((Object)("Child tag in Workspace file does not start with project tag: " + lastActiveHistory + "/.workspace.xml"));
            throw new IOException("Child tag Workspace file does not start with project tag: " + lastActiveHistory + "/.workspace.xml");
        }
        xmlFile.delete();
        try {
            WorkspaceXMLHandler.writeXmlFile(doc, new File(String.valueOf(lastActiveHistory) + File.separator + ".workspace.xml"));
        }
        catch (IOException e) {
            logger.fatal((Object)("Error occurred while writing to workspace xml file: " + lastActiveHistory + File.separator + ".workspace.xml"), (Throwable)e);
            throw e;
        }
    }

    public static void renameEntry(Entry entry, String newName) throws Exception {
        block8: {
            String workspaceLocation = ((WorkspaceProperty)DataModelHandler.instance().getRoot().getProperty()).getLocation();
            logger.debug((Object)("Workspace location is : " + workspaceLocation));
            File workspaceXmlFile = new File(String.valueOf(workspaceLocation.substring(0, workspaceLocation.length() - 1)) + File.separator + ".workspace.xml");
            if (!workspaceXmlFile.exists()) {
                logger.fatal((Object)("workspace xml file does not exist: " + workspaceXmlFile.getAbsolutePath()));
                throw new Exception("workspace xml file does not exist: " + workspaceXmlFile.getAbsolutePath());
            }
            SAXBuilder builder = new SAXBuilder();
            Document document = null;
            try {
                document = builder.build(workspaceXmlFile);
            }
            catch (JDOMException e) {
                logger.fatal((Object)("Error occurred while reading workspace xml file: " + workspaceXmlFile.getAbsolutePath()), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                logger.fatal((Object)("Error occurred while reading workspace xml file: " + workspaceXmlFile.getAbsolutePath()), (Throwable)e);
                throw e;
            }
            try {
                Element element;
                XPath xpath = XPath.newInstance((String)("//project[@folder='" + entry.getDisplayName() + "']"));
                List resultList = xpath.selectNodes((Object)document);
                if (resultList.size() == 0 || (element = (Element)resultList.get(0)) == null) break block8;
                element.setAttribute("folder", newName);
                try {
                    WorkspaceXMLHandler.writeXmlFile(document, workspaceXmlFile);
                }
                catch (IOException e) {
                    logger.fatal((Object)("Error occurred while writing to workspace xml file: " + workspaceXmlFile.getAbsolutePath()), (Throwable)e);
                    throw e;
                }
            }
            catch (JDOMException e) {
                logger.fatal((Object)("Error occurred while reading workspace xml file: " + workspaceXmlFile.getAbsolutePath()), (Throwable)e);
                throw e;
            }
        }
    }

    public void removeProject(String projectName) throws Exception {
        try {
            WorkspaceXMLHandler.removeEntry(projectName);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static void removeProjectEntry(String projectName) {
        if (projectName != null) {
            try {
                String workspaceFolder = PropertyHandler.getVariable("workspace_location");
                workspaceFolder = workspaceFolder.substring(0, workspaceFolder.length() - 1);
                File workspaceFile = new File(String.valueOf(workspaceFolder) + File.separator + ".workspace.xml");
                if (workspaceFile.exists()) {
                    SAXBuilder builder = new SAXBuilder();
                    Document doc = builder.build(workspaceFile);
                    Element workspace = doc.getRootElement();
                    ArrayList<Element> nonExistentElements = new ArrayList<Element>();
                    Element childElement = null;
                    if (workspace.getName().equals("workspace")) {
                        List children = workspace.getChildren("project");
                        for (Object child : children) {
                            if (!(child instanceof Element) || (childElement = (Element)child).getAttribute("folder") == null || !childElement.getAttribute("folder").getValue().equals(projectName)) continue;
                            nonExistentElements.add(childElement);
                        }
                        for (Element nEE : nonExistentElements) {
                            children.remove(nEE);
                        }
                        WorkspaceXMLHandler.writeXmlFile(doc, new File(workspaceFolder, ".workspace.xml"));
                    }
                } else {
                    logger.error((Object)"Unable to read workspace file.");
                }
            }
            catch (Exception e) {
                logger.error((Object)("Something went wrong while reading workspace file." + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void closeProject(String projectName) {
        if (projectName != null) {
            try {
                String workspaceFolder = PropertyHandler.getVariable("workspace_location");
                workspaceFolder = workspaceFolder.substring(0, workspaceFolder.length() - 1);
                File workspaceFile = new File(String.valueOf(workspaceFolder) + File.separator + ".workspace.xml");
                if (workspaceFile.exists()) {
                    SAXBuilder builder = new SAXBuilder();
                    Document doc = builder.build(workspaceFile);
                    Element workspace = doc.getRootElement();
                    Element childElement = null;
                    if (workspace.getName().equals("workspace")) {
                        List children = workspace.getChildren("project");
                        for (Object child : children) {
                            if (!(child instanceof Element) || (childElement = (Element)child).getAttribute("folder") == null || !childElement.getAttribute("folder").getValue().equals(projectName)) continue;
                            childElement.setAttribute("open", "no");
                            break;
                        }
                        WorkspaceXMLHandler.writeXmlFile(doc, new File(workspaceFolder, ".workspace.xml"));
                    }
                } else {
                    logger.error((Object)"Unable to locate workspace file.");
                }
            }
            catch (Exception e) {
                logger.error((Object)("Something went wrong while modifying workspace file." + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void writeXmlFile(Document doc, File file) throws IOException {
        FileWriter fileWriter = null;
        try {
            try {
                XMLOutputter xmlOutput = new XMLOutputter();
                xmlOutput.setFormat(Format.getPrettyFormat());
                logger.debug((Object)("Operating System is " + System.getProperty("os.name")));
                if (file.exists() && file.isHidden() && System.getProperty("os.name").startsWith("Windows")) {
                    Files.setAttribute(file.toPath(), "dos:hidden", false, new LinkOption[0]);
                }
                fileWriter = new FileWriter(file);
                xmlOutput.output(doc, (Writer)fileWriter);
                fileWriter.close();
            }
            catch (IOException e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fileWriter);
    }
}

