/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.file.reader.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.file.reader.IMSAnnotationFileReader;
import org.grits.toolbox.ms.file.scan.data.ScanView;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.widgets.tools.NotifyingProcess;
import org.systemsbiology.jrap.grits.stax.MSXMLParser;
import org.systemsbiology.jrap.grits.stax.Scan;
import org.systemsbiology.jrap.grits.stax.ScanHeader;

public class MzXmlReader
extends NotifyingProcess
implements IMSAnnotationFileReader {
    private static final Logger logger = Logger.getLogger(MzXmlReader.class);

    @Override
    public List<org.grits.toolbox.ms.om.data.Scan> readMSFile(MSFile file) {
        if (file.getExperimentType().equals("Direct Infusion")) {
            return this.readMzXmlFileForDirectInfusion(file.getFileName());
        }
        if (file.getExperimentType().equals("Total Ion Mapping (TIM)")) {
            return this.readMzXmlFileForTIM(file.getFileName());
        }
        return null;
    }

    @Override
    public List<org.grits.toolbox.ms.om.data.Scan> readMSFile(MSFile file, int scanNumber) {
        if (file.getExperimentType().equals("LC-MS/MS")) {
            return this.readMzXmlFileForLCMSMS(file.getFileName(), scanNumber);
        }
        if (file.getExperimentType().equals("MS Profile")) {
            return this.readMzXmlFileForMSProfile(file.getFileName(), scanNumber);
        }
        if (file.getExperimentType().equals("Direct Infusion")) {
            return this.readMzXmlFileForDirectInfusion(file.getFileName());
        }
        if (file.getExperimentType().equals("Total Ion Mapping (TIM)")) {
            return this.readMzXmlFileForTIM(file.getFileName());
        }
        return null;
    }

    @Override
    public List<Integer> getScanList(MSFile file, int scanNumber) {
        return this.getScanList(file.getFileName(), scanNumber);
    }

    @Override
    public Integer getMaxScanNumber(MSFile file) {
        return MzXmlReader.getMaxScanNumber(file.getFileName());
    }

    @Override
    public org.grits.toolbox.ms.om.data.Scan getFirstMS1Scan(MSFile file) {
        org.grits.toolbox.ms.om.data.Scan firstScan = null;
        File mzXMLFile = new File(file.getFileName());
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            if (parser != null) {
                for (int i = 1; firstScan == null && i < parser.getMaxScanNumber() + 1; ++i) {
                    Scan s;
                    ScanHeader header = parser.rapHeader(i);
                    if (header == null || header.getMsLevel() != 1 || (s = parser.rap(i)).getMassIntensityList() == null || s.getMassIntensityList()[0].length <= 0) continue;
                    firstScan = this.getScan(s, -1);
                    return firstScan;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public static int getMaxScanNumber(String fileName) {
        File mzXMLFile = new File(fileName);
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            return parser.getMaxScanNumber();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return -1;
        }
    }

    public List<org.grits.toolbox.ms.om.data.Scan> readMzXmlFile(String fileName, int msLevel, int parentScanNum, int scanNum) {
        File mzXMLFile = new File(fileName);
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            this.updateListeners("Reading XML file", -1);
            List<org.grits.toolbox.ms.om.data.Scan> scans = this.getScanData(parser, msLevel, parentScanNum, scanNum);
            if (scans != null) {
                Collections.sort(scans);
            }
            if (scans.isEmpty() && !this.isCanceled()) {
                this.updateErrorListener("Warning: no scan data read from MS file. The file may be invalid or incorrect type.");
            }
            return scans;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public List<org.grits.toolbox.ms.om.data.Scan> readMzXmlFileForTIM(String fileName) {
        File mzXMLFile = new File(fileName);
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            this.updateListeners("Reading XML file", -1);
            List<org.grits.toolbox.ms.om.data.Scan> scans = this.addAllScansTIM(parser);
            if (scans != null) {
                Collections.sort(scans);
            }
            if (scans.isEmpty() && !this.isCanceled()) {
                this.updateErrorListener("Warning: no scan data read from MS file. The file may be invalid or incorrect type.");
            }
            return scans;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public List<org.grits.toolbox.ms.om.data.Scan> readMzXmlFileForDirectInfusion(String fileName) {
        File mzXMLFile = new File(fileName);
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            this.updateListeners("Reading XML file", -1);
            List<org.grits.toolbox.ms.om.data.Scan> scans = this.addAllScansDirectInfusion(parser);
            if (scans != null) {
                Collections.sort(scans);
            }
            if (scans.isEmpty() && !this.isCanceled()) {
                this.updateErrorListener("Warning: no scan data read from MS file. The file may be invalid or incorrect type.");
            }
            return scans;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public List<org.grits.toolbox.ms.om.data.Scan> readMzXmlFileForLCMSMS(String fileName, int iScanNumber) {
        File mzXMLFile = new File(fileName);
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            this.updateListeners("Reading XML file", -1);
            List<org.grits.toolbox.ms.om.data.Scan> scans = this.addAllScansLCMSMS(parser, iScanNumber);
            if (scans != null) {
                Collections.sort(scans);
            }
            if (scans.isEmpty() && !this.isCanceled()) {
                this.updateErrorListener("Warning: no scan data read from MS file. The file may be invalid or incorrect type.");
            }
            return scans;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public List<org.grits.toolbox.ms.om.data.Scan> readMzXmlFileForMSProfile(String fileName, int parentScanNum) {
        File mzXMLFile = new File(fileName);
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            this.updateListeners("Reading XML file", -1);
            List<org.grits.toolbox.ms.om.data.Scan> scans = this.addAllScansMSProfile(parser, parentScanNum);
            if (scans != null) {
                Collections.sort(scans);
            }
            if (scans.isEmpty() && !this.isCanceled()) {
                this.updateErrorListener("Warning: no scan data read from MS file. The file may be invalid or incorrect type.");
            }
            return scans;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public boolean isValidMzXmlFile(String fileName) {
        try {
            MSXMLParser parser = new MSXMLParser(fileName, false);
            int t_info = parser.getScanCount();
            return t_info != 0 || (t_info = (parser = new MSXMLParser(fileName, true)).getScanCount()) != 0;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private Peak getNewPrecursorPeak(ScanHeader _scanHeader, boolean _bUseTIC) {
        double dMz = _scanHeader.getPrecursorMz();
        Peak peak = new Peak();
        if (_scanHeader.getPrecursorCharge() == -1) {
            peak.setPrecursorCharge(null);
        } else {
            peak.setPrecursorCharge(Integer.valueOf(_scanHeader.getPrecursorCharge()));
        }
        peak.setMz(Double.valueOf(dMz));
        peak.setId(Integer.valueOf(-1));
        if (_bUseTIC) {
            peak.setIntensity(Double.valueOf(_scanHeader.getTotIonCurrent()));
        } else {
            peak.setIntensity(Double.valueOf(_scanHeader.getPrecursorIntensity()));
        }
        peak.setPrecursorIntensity(Double.valueOf(_scanHeader.getPrecursorIntensity()));
        peak.setIsPrecursor(true);
        return peak;
    }

    private Peak findPeakInPeakList(List<Peak> _alPeaks, double _dPrecursorMz) {
        double dMinDelta = Double.MAX_VALUE;
        Peak matchedPeak = null;
        for (Peak peak : _alPeaks) {
            double delta = Math.abs(peak.getMz() - _dPrecursorMz);
            if (!(delta < 0.5) || !(delta < dMinDelta)) continue;
            dMinDelta = delta;
            matchedPeak = peak;
        }
        return matchedPeak;
    }

    private double getMostAbundantPeak(Scan _scan) {
        if (_scan.getMassIntensityList() == null || _scan.getMassIntensityList().length == 0) {
            return 0.0;
        }
        double[][] scanPeaks = _scan.getMassIntensityList();
        double dMaxInt = Double.MIN_VALUE;
        for (int j = 0; j < scanPeaks[0].length; ++j) {
            if (!(scanPeaks[1][j] > dMaxInt)) continue;
            dMaxInt = scanPeaks[1][j];
        }
        return dMaxInt;
    }

    private List<org.grits.toolbox.ms.om.data.Scan> addAllScansTIM(MSXMLParser parser) {
        int iStartScan = MzXmlReader.getFirstScanNumber(parser);
        if (iStartScan == -1) {
            return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
        }
        int iEndScan = parser.getMaxScanNumber();
        int iMinMSLevel = parser.rapHeader(iStartScan).getMsLevel();
        if (iMinMSLevel == 1) {
            return this.addAllScansDirectInfusion(parser);
        }
        org.grits.toolbox.ms.om.data.Scan fullMSScan = null;
        org.grits.toolbox.ms.om.data.Scan msScan = null;
        try {
            boolean flag = true;
            int precursorScanNum = 0;
            ArrayList<org.grits.toolbox.ms.om.data.Scan> scans = new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
            HashMap<Integer, Integer> lastParentOfEachLevel = new HashMap<Integer, Integer>();
            HashMap<Integer, org.grits.toolbox.ms.om.data.Scan> msScanMap = new HashMap<Integer, org.grits.toolbox.ms.om.data.Scan>();
            HashMap<Double, Peak> ms1 = new HashMap<Double, Peak>();
            ArrayList<Peak> ms1Peaks = new ArrayList<Peak>();
            fullMSScan = new org.grits.toolbox.ms.om.data.Scan();
            lastParentOfEachLevel.put(1, 0);
            fullMSScan.setMsLevel(Integer.valueOf(1));
            fullMSScan.setPolarity(null);
            fullMSScan.setScanStart(Double.valueOf(-1.0));
            fullMSScan.setScanEnd(Double.valueOf(-1.0));
            fullMSScan.setScanNo(Integer.valueOf(0));
            fullMSScan.setActivationMethode(null);
            fullMSScan.setRetentionTime(Double.valueOf(0.0));
            msScanMap.put(fullMSScan.getScanNo(), fullMSScan);
            lastParentOfEachLevel.put(1, 0);
            double dLowMz = Double.MAX_VALUE;
            double dHighMz = Double.MIN_VALUE;
            for (int i = iStartScan; i <= iEndScan; ++i) {
                Scan jrapScan;
                if (this.isCanceled()) {
                    return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                }
                if (i % 10 == 0 && !this.isCanceled()) {
                    this.updateListeners("Reading XML file. Scan: " + i + " of " + iEndScan, i);
                }
                if ((jrapScan = parser.rap(i)) == null) {
                    logger.debug((Object)("Call to getJrapScan for scan number " + i + " returned null. Skipping."));
                    continue;
                }
                ScanHeader jrapScanHeader = jrapScan.getHeader();
                if (jrapScan.getMassIntensityList() == null || jrapScan.getMassIntensityList().length == 0) {
                    logger.warn((Object)("Scan: " + i + " has empty peak list."));
                }
                msScan = new org.grits.toolbox.ms.om.data.Scan();
                double maxIntensity = this.getMostAbundantPeak(jrapScan);
                msScan.setMsLevel(Integer.valueOf(jrapScanHeader.getMsLevel()));
                lastParentOfEachLevel.put(jrapScanHeader.getMsLevel(), jrapScanHeader.getNum());
                String temp = jrapScanHeader.getPolarity();
                msScan.setPolarity(null);
                msScan.setIsCentroided(Boolean.valueOf(jrapScanHeader.getCentroided() == 1));
                if (temp != null && !temp.equals("")) {
                    flag = temp.equals("+");
                    msScan.setPolarity(Boolean.valueOf(flag));
                    if (fullMSScan.getPolarity() == null) {
                        fullMSScan.setPolarity(Boolean.valueOf(flag));
                    }
                }
                msScan.setMostAbundantPeak(Double.valueOf(maxIntensity));
                msScan.setScanStart(Double.valueOf(jrapScanHeader.getLowMz()));
                msScan.setScanEnd(Double.valueOf(jrapScanHeader.getHighMz()));
                msScan.setScanNo(Integer.valueOf(jrapScanHeader.getNum()));
                msScan.setActivationMethode(jrapScanHeader.getActivationMethod());
                msScan.setIsCentroided(Boolean.valueOf(jrapScanHeader.getCentroided() == 1));
                try {
                    msScan.setRetentionTime(Double.valueOf(jrapScanHeader.getDoubleRetentionTime()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                precursorScanNum = -1;
                if (jrapScanHeader.getPrecursorScanNum() != -1) {
                    precursorScanNum = jrapScanHeader.getPrecursorScanNum();
                } else if (lastParentOfEachLevel.containsKey(msScan.getMsLevel() - 1)) {
                    precursorScanNum = (Integer)lastParentOfEachLevel.get(msScan.getMsLevel() - 1);
                }
                msScan.setParentScan(Integer.valueOf(precursorScanNum));
                Peak peak = null;
                if (msScan.getMsLevel() == 2) {
                    double dMz = jrapScanHeader.getPrecursorMz();
                    if (ms1.containsKey(dMz)) {
                        peak = (Peak)ms1.get(dMz);
                    } else {
                        peak = this.getNewPrecursorPeak(jrapScanHeader, true);
                        ms1.put(dMz, peak);
                    }
                    peak.setIsPrecursor(true);
                    peak.setPrecursorIntensity(Double.valueOf(jrapScanHeader.getPrecursorIntensity()));
                    peak.setPrecursorCharge(Integer.valueOf(jrapScanHeader.getPrecursorCharge()));
                    peak.setPrecursorMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
                } else {
                    org.grits.toolbox.ms.om.data.Scan parentScan = (org.grits.toolbox.ms.om.data.Scan)msScanMap.get(msScan.getParentScan());
                    List lPeaks = parentScan.getPeaklist();
                    peak = this.findPeakInPeakList(lPeaks, jrapScanHeader.getPrecursorMz());
                    if (peak == null) {
                        peak = new Peak();
                        peak.setId(Integer.valueOf(parentScan.getPeaklist().size() + 1));
                        peak.setMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
                        peak.setIntensity(Double.valueOf(0.0));
                        peak.setCharge(Integer.valueOf(jrapScanHeader.getPrecursorCharge()));
                        parentScan.getPeaklist().add(peak);
                    }
                    peak.setIsPrecursor(true);
                    peak.setPrecursorIntensity(Double.valueOf(jrapScanHeader.getPrecursorIntensity()));
                    peak.setPrecursorCharge(Integer.valueOf(jrapScanHeader.getPrecursorCharge()));
                    peak.setPrecursorMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
                }
                msScan.setPrecursor(peak);
                double dMinDelta = Double.MAX_VALUE;
                double dBackupPrecursorIntensity = 1.0;
                double[][] scanPeaks = jrapScan.getMassIntensityList();
                double dTotalIntensity = 0.0;
                if (scanPeaks != null) {
                    for (int j = 0; j < scanPeaks[0].length; ++j) {
                        double dDelta;
                        if (scanPeaks[1][j] <= 0.0) continue;
                        peak = new Peak();
                        peak.setId(Integer.valueOf(j + 1));
                        peak.setMz(Double.valueOf(scanPeaks[0][j]));
                        peak.setIntensity(Double.valueOf(scanPeaks[1][j]));
                        dTotalIntensity += peak.getIntensity().doubleValue();
                        double dRelInt = peak.getIntensity() / msScan.getMostAbundantPeak();
                        peak.setRelativeIntensity(Double.valueOf(dRelInt));
                        msScan.getPeaklist().add(peak);
                        if (!(msScan.getPrecursor().getIntensity() <= 0.0) || !((dDelta = Math.abs(msScan.getPrecursor().getMz() - peak.getMz())) < 0.5) || !(dDelta < dMinDelta)) continue;
                        dBackupPrecursorIntensity = peak.getIntensity();
                    }
                    if (msScan.getPrecursor().getIntensity() <= 0.0) {
                        msScan.getPrecursor().setIntensity(Double.valueOf(dBackupPrecursorIntensity));
                    }
                    msScan.setTotalNumPeaks(Integer.valueOf(scanPeaks[0].length));
                    msScan.setTotalIntensity(Double.valueOf(dTotalIntensity));
                }
                msScanMap.put(msScan.getScanNo(), msScan);
                ((org.grits.toolbox.ms.om.data.Scan)msScanMap.get(msScan.getParentScan())).getSubScans().add(msScan.getScanNo());
                if (msScan.getScanStart() > 0.0 && msScan.getScanStart() < dLowMz) {
                    dLowMz = msScan.getScanStart();
                }
                if (!(msScan.getScanEnd() > dHighMz)) continue;
                dHighMz = msScan.getScanEnd();
            }
            fullMSScan.setScanStart(Double.valueOf(dLowMz));
            fullMSScan.setScanEnd(Double.valueOf(dHighMz));
            int ms1PeakIndex = 1;
            for (Peak peak : ms1.values()) {
                if (this.isCanceled()) {
                    return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                }
                peak.setId(Integer.valueOf(ms1PeakIndex++));
                ms1Peaks.add(peak);
            }
            for (org.grits.toolbox.ms.om.data.Scan scan : msScanMap.values()) {
                if (this.isCanceled()) {
                    return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                }
                if (scan.getMsLevel() == 1) {
                    scan.setPeaklist(ms1Peaks);
                }
                scans.add(scan);
            }
            return scans;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<org.grits.toolbox.ms.om.data.Scan> addAllScansDirectInfusion(MSXMLParser parser) {
        org.grits.toolbox.ms.om.data.Scan msScan = new org.grits.toolbox.ms.om.data.Scan();
        try {
            int iStartScan = MzXmlReader.getFirstScanNumber(parser);
            if (iStartScan == -1) {
                return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
            }
            int iEndScan = parser.getMaxScanNumber();
            int iMinMSLevel = parser.rapHeader(iStartScan).getMsLevel();
            if (iMinMSLevel != 1) {
                return this.addAllScansTIM(parser);
            }
            boolean flag = true;
            int precursorScanNum = 0;
            ArrayList<org.grits.toolbox.ms.om.data.Scan> scans = new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
            HashMap<Integer, Integer> lastParentOfEachLevel = new HashMap<Integer, Integer>();
            HashMap<Integer, Scan> originalScanMap = new HashMap<Integer, Scan>();
            HashMap<Integer, org.grits.toolbox.ms.om.data.Scan> msScanMap = new HashMap<Integer, org.grits.toolbox.ms.om.data.Scan>();
            HashMap<Double, Peak> ms1 = new HashMap<Double, Peak>();
            org.grits.toolbox.ms.om.data.Scan prevParentScan = null;
            ArrayList<Peak> ms1Peaks = new ArrayList<Peak>();
            for (int i = iStartScan; i <= iEndScan; ++i) {
                double[][] scanPeaks;
                Scan jrapScan;
                if (this.isCanceled()) {
                    return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                }
                if (i % 10 == 0 && !this.isCanceled()) {
                    this.updateListeners("Reading XML file. Scan: " + i + " of " + iEndScan, i);
                }
                if ((jrapScan = parser.rap(i)) == null) {
                    logger.debug((Object)("Call to getJrapScan for scan number " + i + " returned null. Skipping."));
                    continue;
                }
                ScanHeader jrapScanHeader = jrapScan.getHeader();
                if (jrapScan.getMassIntensityList() == null || jrapScan.getMassIntensityList().length == 0) {
                    logger.warn((Object)("Scan: " + i + " has empty peak list."));
                }
                double maxIntensity = this.getMostAbundantPeak(jrapScan);
                msScan = new org.grits.toolbox.ms.om.data.Scan();
                msScan.setMostAbundantPeak(Double.valueOf(maxIntensity));
                msScan.setMsLevel(Integer.valueOf(jrapScanHeader.getMsLevel()));
                String temp = jrapScanHeader.getPolarity();
                msScan.setPolarity(null);
                msScan.setIsCentroided(Boolean.valueOf(jrapScanHeader.getCentroided() == 1));
                if (temp != null && !temp.equals("")) {
                    flag = temp.equals("+");
                    msScan.setPolarity(Boolean.valueOf(flag));
                }
                msScan.setScanStart(Double.valueOf(jrapScanHeader.getLowMz()));
                msScan.setScanEnd(Double.valueOf(jrapScanHeader.getHighMz()));
                msScan.setScanNo(Integer.valueOf(jrapScanHeader.getNum()));
                msScan.setActivationMethode(jrapScanHeader.getActivationMethod());
                try {
                    msScan.setRetentionTime(Double.valueOf(jrapScanHeader.getDoubleRetentionTime()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                lastParentOfEachLevel.put(jrapScanHeader.getMsLevel(), jrapScanHeader.getNum());
                originalScanMap.put(jrapScanHeader.getMsLevel(), jrapScan);
                msScanMap.put(msScan.getScanNo(), msScan);
                if (jrapScanHeader.getMsLevel() > 1) {
                    precursorScanNum = -1;
                    if (jrapScanHeader.getPrecursorScanNum() != -1) {
                        precursorScanNum = jrapScanHeader.getPrecursorScanNum();
                    } else {
                        int iParentLevel;
                        for (iParentLevel = msScan.getMsLevel() - 1; iParentLevel > 1 && !lastParentOfEachLevel.containsKey(iParentLevel); --iParentLevel) {
                        }
                        precursorScanNum = (Integer)lastParentOfEachLevel.get(iParentLevel);
                    }
                    msScan.setParentScan(Integer.valueOf(precursorScanNum));
                    org.grits.toolbox.ms.om.data.Scan parentScan = (org.grits.toolbox.ms.om.data.Scan)msScanMap.get(msScan.getParentScan());
                    if (parentScan.getMsLevel() == 1) {
                        if (prevParentScan != null && prevParentScan.getScanNo() != parentScan.getScanNo()) {
                            prevParentScan.getPeaklist().clear();
                        }
                        prevParentScan = parentScan;
                    }
                    msScan.setMsLevel(Integer.valueOf(parentScan.getMsLevel() + 1));
                    Peak peak = null;
                    List lPeaks = parentScan.getPeaklist();
                    peak = this.findPeakInPeakList(lPeaks, jrapScanHeader.getPrecursorMz());
                    if (peak == null) {
                        peak = new Peak();
                        peak.setId(Integer.valueOf(parentScan.getPeaklist().size() + 1));
                        peak.setMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
                        peak.setIntensity(Double.valueOf(0.0));
                        peak.setCharge(Integer.valueOf(jrapScanHeader.getPrecursorCharge()));
                        parentScan.getPeaklist().add(peak);
                    }
                    if (jrapScanHeader.getMsLevel() == 2) {
                        ms1.put(Double.valueOf(jrapScanHeader.getPrecursorMz()), peak);
                    }
                    peak.setIsPrecursor(true);
                    peak.setPrecursorIntensity(Double.valueOf(jrapScanHeader.getPrecursorIntensity()));
                    peak.setPrecursorCharge(Integer.valueOf(jrapScanHeader.getPrecursorCharge()));
                    peak.setPrecursorMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
                    msScan.setPrecursor(peak);
                    parentScan.getSubScans().add(msScan.getScanNo());
                }
                if ((scanPeaks = jrapScan.getMassIntensityList()) == null) continue;
                double dLowMz = Double.MAX_VALUE;
                double dHighMz = Double.MIN_VALUE;
                double dTotalIntensity = 0.0;
                for (int j = 0; j < scanPeaks[0].length; ++j) {
                    if (scanPeaks[1][j] <= 0.0) continue;
                    Peak peak = new Peak();
                    peak.setId(Integer.valueOf(j + 1));
                    peak.setMz(Double.valueOf(scanPeaks[0][j]));
                    if (dLowMz > peak.getMz()) {
                        dLowMz = peak.getMz();
                    }
                    if (dHighMz < peak.getMz()) {
                        dHighMz = peak.getMz();
                    }
                    peak.setIntensity(Double.valueOf(scanPeaks[1][j]));
                    dTotalIntensity += peak.getIntensity().doubleValue();
                    double dRelInt = peak.getIntensity() / msScan.getMostAbundantPeak();
                    peak.setRelativeIntensity(Double.valueOf(dRelInt));
                    msScan.getPeaklist().add(peak);
                }
                if (msScan.getScanStart() <= 0.0) {
                    msScan.setScanStart(Double.valueOf(dLowMz));
                }
                if (msScan.getScanEnd() <= 0.0) {
                    msScan.setScanEnd(Double.valueOf(dHighMz));
                }
                msScan.setTotalNumPeaks(Integer.valueOf(scanPeaks[0].length));
                msScan.setTotalIntensity(Double.valueOf(dTotalIntensity));
            }
            int ms1PeakIndex = 1;
            for (Double dMz : ms1.keySet()) {
                if (this.isCanceled()) {
                    return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                }
                Peak peak = (Peak)ms1.get(dMz);
                if (!peak.getIsPrecursor() || peak.getPrecursorIntensity() == null) continue;
                peak.setId(Integer.valueOf(ms1PeakIndex++));
                ms1Peaks.add(peak);
            }
            for (org.grits.toolbox.ms.om.data.Scan scan : msScanMap.values()) {
                if (this.isCanceled()) {
                    return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                }
                if (scan.getMsLevel() == 1) {
                    scan.setPeaklist(ms1Peaks);
                }
                scans.add(scan);
            }
            return scans;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<org.grits.toolbox.ms.om.data.Scan> addAllScansMSProfile(MSXMLParser parser, int parentScanNum) {
        org.grits.toolbox.ms.om.data.Scan msScan = new org.grits.toolbox.ms.om.data.Scan();
        try {
            boolean flag = true;
            ArrayList<org.grits.toolbox.ms.om.data.Scan> scans = new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
            Scan jrapScan = parser.rap(parentScanNum);
            if (jrapScan == null) {
                if (!this.isCanceled()) {
                    this.updateErrorListener("Call to parser.rap for scan number " + parentScanNum + " returned null. Returning empty list.");
                }
                return scans;
            }
            ScanHeader jrapScanHeader = jrapScan.getHeader();
            if (jrapScan.getMassIntensityList() == null || jrapScan.getMassIntensityList().length == 0) {
                logger.warn((Object)("Scan: " + parentScanNum + " has empty peak list."));
                return scans;
            }
            double maxIntensity = this.getMostAbundantPeak(jrapScan);
            msScan = new org.grits.toolbox.ms.om.data.Scan();
            msScan.setMostAbundantPeak(Double.valueOf(maxIntensity));
            msScan.setMsLevel(Integer.valueOf(jrapScanHeader.getMsLevel()));
            String temp = jrapScanHeader.getPolarity();
            msScan.setPolarity(null);
            msScan.setIsCentroided(Boolean.valueOf(jrapScanHeader.getCentroided() == 1));
            if (temp != null && !temp.equals("")) {
                flag = temp.equals("+");
                msScan.setPolarity(Boolean.valueOf(flag));
            }
            msScan.setScanStart(Double.valueOf(jrapScanHeader.getLowMz()));
            msScan.setScanEnd(Double.valueOf(jrapScanHeader.getHighMz()));
            msScan.setScanNo(Integer.valueOf(jrapScanHeader.getNum()));
            msScan.setActivationMethode(jrapScanHeader.getActivationMethod());
            try {
                msScan.setRetentionTime(Double.valueOf(jrapScanHeader.getDoubleRetentionTime()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            double[][] scanPeaks = jrapScan.getMassIntensityList();
            if (scanPeaks != null) {
                double dLowMz = Double.MAX_VALUE;
                double dHighMz = Double.MIN_VALUE;
                double dTotalIntensity = 0.0;
                for (int j = 0; j < scanPeaks[0].length; ++j) {
                    if (this.isCanceled()) {
                        return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                    }
                    if (scanPeaks[1][j] <= 0.0) continue;
                    Peak peak = new Peak();
                    peak.setId(Integer.valueOf(j + 1));
                    peak.setMz(Double.valueOf(scanPeaks[0][j]));
                    if (dLowMz > peak.getMz()) {
                        dLowMz = peak.getMz();
                    }
                    if (dHighMz < peak.getMz()) {
                        dHighMz = peak.getMz();
                    }
                    peak.setIntensity(Double.valueOf(scanPeaks[1][j]));
                    dTotalIntensity += peak.getIntensity().doubleValue();
                    double dRelInt = peak.getIntensity() / msScan.getMostAbundantPeak();
                    peak.setRelativeIntensity(Double.valueOf(dRelInt));
                    msScan.getPeaklist().add(peak);
                }
                if (msScan.getScanStart() <= 0.0) {
                    msScan.setScanStart(Double.valueOf(dLowMz));
                }
                if (msScan.getScanEnd() <= 0.0) {
                    msScan.setScanEnd(Double.valueOf(dHighMz));
                }
                msScan.setTotalNumPeaks(Integer.valueOf(scanPeaks[0].length));
                msScan.setTotalIntensity(Double.valueOf(dTotalIntensity));
            }
            scans.add(msScan);
            return scans;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<org.grits.toolbox.ms.om.data.Scan> addAllScansLCMSMS(MSXMLParser parser, int parentScanNum) {
        org.grits.toolbox.ms.om.data.Scan msScan = new org.grits.toolbox.ms.om.data.Scan();
        try {
            boolean flag = true;
            int precursorScanNum = 0;
            ArrayList<org.grits.toolbox.ms.om.data.Scan> scans = new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
            HashMap<Integer, Integer> lastParentOfEachLevel = new HashMap<Integer, Integer>();
            HashMap<Integer, Scan> originalScanMap = new HashMap<Integer, Scan>();
            HashMap<Integer, org.grits.toolbox.ms.om.data.Scan> msScanMap = new HashMap<Integer, org.grits.toolbox.ms.om.data.Scan>();
            HashMap<Double, Peak> ms1 = new HashMap<Double, Peak>();
            ArrayList<Peak> ms1Peaks = new ArrayList<Peak>();
            int iParentMSLevel = parser.rapHeader(parentScanNum).getMsLevel();
            boolean bFoundParent = false;
            int iStartScan = MzXmlReader.getFirstScanNumber(parser);
            if (iStartScan == -1) {
                return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
            }
            int iEndScan = parser.getMaxScanNumber();
            for (int i = iStartScan; i <= iEndScan; ++i) {
                if (this.isCanceled()) {
                    return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                }
                if (i % 10 == 0 && !this.isCanceled()) {
                    this.updateListeners("Reading XML file. Scan: " + i + " of " + iEndScan, i);
                }
                if (i == parentScanNum) {
                    bFoundParent = true;
                }
                if (!bFoundParent) continue;
                Scan jrapScan = parser.rap(i);
                if (jrapScan == null) {
                    logger.debug((Object)("Call to getJrapScan for scan number " + i + " returned null. Skipping."));
                    continue;
                }
                ScanHeader jrapScanHeader = jrapScan.getHeader();
                if (jrapScanHeader == null) {
                    logger.debug((Object)("Call to jrapScan.getHeader() for scan number " + i + " returned null. Skipping."));
                    continue;
                }
                if (jrapScan.getMassIntensityList() == null || jrapScan.getMassIntensityList().length == 0) {
                    logger.warn((Object)("Scan: " + i + " has empty peak list."));
                }
                double maxIntensity = this.getMostAbundantPeak(jrapScan);
                msScan = new org.grits.toolbox.ms.om.data.Scan();
                msScan.setMostAbundantPeak(Double.valueOf(maxIntensity));
                msScan.setMsLevel(Integer.valueOf(jrapScanHeader.getMsLevel()));
                String temp = jrapScanHeader.getPolarity();
                msScan.setPolarity(null);
                msScan.setIsCentroided(Boolean.valueOf(jrapScanHeader.getCentroided() == 1));
                if (temp != null && !temp.equals("")) {
                    flag = temp.equals("+");
                    msScan.setPolarity(Boolean.valueOf(flag));
                }
                msScan.setScanStart(Double.valueOf(jrapScanHeader.getLowMz()));
                msScan.setScanEnd(Double.valueOf(jrapScanHeader.getHighMz()));
                msScan.setScanNo(Integer.valueOf(jrapScanHeader.getNum()));
                msScan.setActivationMethode(jrapScanHeader.getActivationMethod());
                try {
                    msScan.setRetentionTime(Double.valueOf(jrapScanHeader.getDoubleRetentionTime()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                lastParentOfEachLevel.put(jrapScanHeader.getMsLevel(), jrapScanHeader.getNum());
                originalScanMap.put(jrapScanHeader.getMsLevel(), jrapScan);
                precursorScanNum = -1;
                if (jrapScanHeader.getMsLevel() > iParentMSLevel) {
                    precursorScanNum = -1;
                    if (jrapScanHeader.getPrecursorScanNum() != -1) {
                        precursorScanNum = jrapScanHeader.getPrecursorScanNum();
                    } else {
                        int iParentLevel;
                        for (iParentLevel = msScan.getMsLevel() - 1; iParentLevel > 1 && !lastParentOfEachLevel.containsKey(iParentLevel); --iParentLevel) {
                        }
                        precursorScanNum = (Integer)lastParentOfEachLevel.get(iParentLevel);
                    }
                    msScan.setParentScan(Integer.valueOf(precursorScanNum));
                    org.grits.toolbox.ms.om.data.Scan parentScan = (org.grits.toolbox.ms.om.data.Scan)msScanMap.get(msScan.getParentScan());
                    if (parentScan == null || parentScan.getMsLevel() == null) continue;
                    msScan.setMsLevel(Integer.valueOf(parentScan.getMsLevel() + 1));
                    Peak peak = null;
                    List lPeaks = parentScan.getPeaklist();
                    peak = this.findPeakInPeakList(lPeaks, jrapScanHeader.getPrecursorMz());
                    if (peak == null) {
                        peak = new Peak();
                        peak.setId(Integer.valueOf(parentScan.getPeaklist().size() + 1));
                        peak.setMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
                        peak.setIntensity(Double.valueOf(0.0));
                        peak.setCharge(Integer.valueOf(jrapScanHeader.getPrecursorCharge()));
                        parentScan.getPeaklist().add(peak);
                    }
                    if (jrapScanHeader.getMsLevel() == 2) {
                        ms1.put(Double.valueOf(jrapScanHeader.getPrecursorMz()), peak);
                    }
                    peak.setIsPrecursor(true);
                    peak.setPrecursorIntensity(Double.valueOf(jrapScanHeader.getPrecursorIntensity()));
                    peak.setPrecursorCharge(Integer.valueOf(jrapScanHeader.getPrecursorCharge()));
                    peak.setPrecursorMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
                    msScan.setPrecursor(peak);
                    parentScan.getSubScans().add(msScan.getScanNo());
                }
                if (i != parentScanNum && precursorScanNum != parentScanNum && msScan.getMsLevel() == iParentMSLevel) break;
                msScanMap.put(msScan.getScanNo(), msScan);
                double[][] scanPeaks = jrapScan.getMassIntensityList();
                if (scanPeaks == null) continue;
                double dLowMz = Double.MAX_VALUE;
                double dHighMz = Double.MIN_VALUE;
                double dTotalIntensity = 0.0;
                for (int j = 0; j < scanPeaks[0].length; ++j) {
                    if (this.isCanceled()) {
                        return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                    }
                    if (scanPeaks[1][j] <= 0.0) continue;
                    Peak peak = new Peak();
                    peak.setId(Integer.valueOf(j + 1));
                    peak.setMz(Double.valueOf(scanPeaks[0][j]));
                    if (dLowMz > peak.getMz()) {
                        dLowMz = peak.getMz();
                    }
                    if (dHighMz < peak.getMz()) {
                        dHighMz = peak.getMz();
                    }
                    peak.setIntensity(Double.valueOf(scanPeaks[1][j]));
                    dTotalIntensity += peak.getIntensity().doubleValue();
                    double dRelInt = peak.getIntensity() / msScan.getMostAbundantPeak();
                    peak.setRelativeIntensity(Double.valueOf(dRelInt));
                    msScan.getPeaklist().add(peak);
                }
                if (msScan.getScanStart() <= 0.0) {
                    msScan.setScanStart(Double.valueOf(dLowMz));
                }
                if (msScan.getScanEnd() <= 0.0) {
                    msScan.setScanEnd(Double.valueOf(dHighMz));
                }
                msScan.setTotalNumPeaks(Integer.valueOf(scanPeaks[0].length));
                msScan.setTotalIntensity(Double.valueOf(dTotalIntensity));
            }
            int ms1PeakIndex = 1;
            for (Peak peak : ms1.values()) {
                if (this.isCanceled()) {
                    return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                }
                if (!peak.getIsPrecursor() || peak.getPrecursorIntensity() == null) continue;
                peak.setId(Integer.valueOf(ms1PeakIndex++));
                ms1Peaks.add(peak);
            }
            for (org.grits.toolbox.ms.om.data.Scan scan : msScanMap.values()) {
                if (this.isCanceled()) {
                    return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                }
                if (scan.getMsLevel() == 1) {
                    scan.setPeaklist(ms1Peaks);
                }
                scans.add(scan);
            }
            return scans;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<Integer> getScanList(String fileName, int parentScanNum) {
        File mzXMLFile = new File(fileName);
        ArrayList<Integer> lScans = new ArrayList<Integer>();
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            int iMinMSLevel = MzXmlReader.getMinMSLevel(parser);
            int iStartScan = MzXmlReader.getFirstScanNumber(parser);
            if (iStartScan == -1) {
                return new ArrayList<Integer>();
            }
            int iEndScan = parser.getMaxScanNumber();
            boolean bFoundParent = false;
            int iParentMSLevel = -1;
            for (int i = iStartScan; i <= iEndScan; ++i) {
                ScanHeader jrapScanHeader;
                if (this.isCanceled()) {
                    return new ArrayList<Integer>();
                }
                if (i % 10 == 0 && !this.isCanceled()) {
                    this.updateListeners("Reading XML file. Scan: " + i + " of " + iEndScan, i);
                }
                if ((jrapScanHeader = parser.rapHeader(i)) == null) {
                    logger.debug((Object)("Call to parser.rapHeader() for scan number " + i + " returned null. Skipping."));
                    continue;
                }
                if (parentScanNum < 0) {
                    if (jrapScanHeader.getMsLevel() != iMinMSLevel) continue;
                    lScans.add(i);
                    continue;
                }
                if (!bFoundParent) {
                    if (jrapScanHeader.getNum() != parentScanNum) continue;
                    bFoundParent = true;
                    iParentMSLevel = jrapScanHeader.getMsLevel();
                    continue;
                }
                if (jrapScanHeader.getMsLevel() == iParentMSLevel - 1) {
                    lScans.add(i);
                    continue;
                }
                if (jrapScanHeader.getMsLevel() != iParentMSLevel) continue;
                bFoundParent = false;
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
        return lScans;
    }

    @Override
    public Integer getMinMSLevel(MSFile file) {
        return MzXmlReader.getMinMSLevel(file.getFileName());
    }

    public static int getMinMSLevel(String fileName) {
        File mzXMLFile = new File(fileName);
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            return MzXmlReader.getMinMSLevel(parser);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return -1;
        }
    }

    private static int getMinMSLevel(MSXMLParser parser) {
        try {
            int iStartScan = MzXmlReader.getFirstScanNumber(parser);
            if (iStartScan == -1) {
                return -1;
            }
            int iEndScan = parser.getMaxScanNumber();
            int iMinMSLevel = Integer.MAX_VALUE;
            for (int i = iStartScan; i <= iEndScan; ++i) {
                try {
                    ScanHeader jrapScanHeader = parser.rapHeader(i);
                    if (jrapScanHeader == null || jrapScanHeader.getMsLevel() >= iMinMSLevel) continue;
                    iMinMSLevel = jrapScanHeader.getMsLevel();
                    continue;
                }
                catch (Exception ex) {
                    logger.debug((Object)"Error parsing scan: i");
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            return iMinMSLevel;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    private int countScansByMSLevel(MSXMLParser parser, int iMSLevel) {
        try {
            int iStartScan = MzXmlReader.getFirstScanNumber(parser);
            if (iStartScan == -1) {
                return -1;
            }
            int iEndScan = parser.getMaxScanNumber();
            int iNumScans = 0;
            for (int i = iStartScan; i <= iEndScan; ++i) {
                try {
                    ScanHeader jrapScanHeader = parser.rapHeader(i);
                    if (jrapScanHeader == null || jrapScanHeader.getNum() <= 0 || jrapScanHeader.getMsLevel() != iMSLevel) continue;
                    ++iNumScans;
                    continue;
                }
                catch (Exception ex) {
                    logger.debug((Object)"Error parsing scan: i");
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            return iNumScans;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public int getNumMS1Scans(MSFile file) {
        File mzXMLFile = new File(file.getFileName());
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            return this.countScansByMSLevel(parser, 1);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int getNumMS2Scans(MSFile file) {
        File mzXMLFile = new File(file.getFileName());
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            return this.countScansByMSLevel(parser, 2);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    private static int getFirstScanNumber(MSXMLParser parser) {
        int count = parser.getMaxScanNumber();
        for (int i = 1; i <= count; ++i) {
            Scan jrapScan = parser.rap(i);
            if (jrapScan == null) continue;
            return i;
        }
        return -1;
    }

    private List<org.grits.toolbox.ms.om.data.Scan> getScanData(MSXMLParser parser, int msLevel, int parentScanNum, int scanNum) {
        try {
            int iLastPossiblePrecursorMSLevel;
            int precursorScanNum = 0;
            ArrayList<org.grits.toolbox.ms.om.data.Scan> scans = new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
            HashMap<Integer, Integer> lastParentOfEachLevel = new HashMap<Integer, Integer>();
            HashMap<Integer, org.grits.toolbox.ms.om.data.Scan> msScanMap = new HashMap<Integer, org.grits.toolbox.ms.om.data.Scan>();
            int iStartScan = MzXmlReader.getFirstScanNumber(parser);
            if (iStartScan == -1) {
                return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
            }
            int iEndScan = parser.getMaxScanNumber();
            int iMinMSLevel = iLastPossiblePrecursorMSLevel = parser.rapHeader(iStartScan).getMsLevel();
            org.grits.toolbox.ms.om.data.Scan firstParentScan = null;
            double dMinMz = Double.MAX_VALUE;
            double dMaxMz = Double.MIN_VALUE;
            if (iLastPossiblePrecursorMSLevel > 1) {
                firstParentScan = new org.grits.toolbox.ms.om.data.Scan();
                firstParentScan.setScanNo(Integer.valueOf(0));
                firstParentScan.setMsLevel(Integer.valueOf(1));
                firstParentScan.setPolarity(null);
                firstParentScan.setRetentionTime(Double.valueOf(0.0));
                msScanMap.put(firstParentScan.getScanNo(), firstParentScan);
                iLastPossiblePrecursorMSLevel = 1;
                lastParentOfEachLevel.put(1, 0);
                scans.add(firstParentScan);
            }
            org.grits.toolbox.ms.om.data.Scan msScan = null;
            org.grits.toolbox.ms.om.data.Scan parentScan = null;
            ArrayList<Integer> skippedScans = new ArrayList<Integer>();
            for (int i = iStartScan; i <= iEndScan; ++i) {
                try {
                    if (this.isCanceled()) {
                        return new ArrayList<org.grits.toolbox.ms.om.data.Scan>();
                    }
                    if (i % 10 == 0 && !this.isCanceled()) {
                        this.updateListeners("Reading XML file. Scan: " + i + " of " + iEndScan, i);
                    }
                    if (scanNum != -1 && i != scanNum || parentScanNum != -1 && (i < parentScanNum || i > parentScanNum + 1000)) continue;
                    Scan jrapScan = this.getJrapScan(parser, i);
                    if (jrapScan == null) {
                        skippedScans.add(i);
                        continue;
                    }
                    ScanHeader jrapScanHeader = jrapScan.getHeader();
                    int iCurMSLevel = jrapScanHeader.getMsLevel();
                    if (iLastPossiblePrecursorMSLevel < iCurMSLevel - 1) {
                        iLastPossiblePrecursorMSLevel = iCurMSLevel - 1;
                    } else if (iLastPossiblePrecursorMSLevel == iCurMSLevel && iCurMSLevel - 1 >= iMinMSLevel) {
                        iLastPossiblePrecursorMSLevel = iCurMSLevel - 1;
                    }
                    precursorScanNum = -1;
                    if (jrapScanHeader.getPrecursorScanNum() != -1) {
                        precursorScanNum = jrapScanHeader.getPrecursorScanNum();
                    } else if (iCurMSLevel > iLastPossiblePrecursorMSLevel && lastParentOfEachLevel.containsKey(iCurMSLevel - 1)) {
                        precursorScanNum = (Integer)lastParentOfEachLevel.get(iCurMSLevel - 1);
                    } else if (parentScanNum != -1 && iCurMSLevel > 1) {
                        precursorScanNum = parentScanNum;
                    }
                    msScan = this.getScan(jrapScan, precursorScanNum);
                    int iParentScanNum = msScan.getParentScan();
                    if (iParentScanNum != -1) {
                        if (msScanMap.containsKey(iParentScanNum)) {
                            parentScan = (org.grits.toolbox.ms.om.data.Scan)msScanMap.get(iParentScanNum);
                        } else {
                            Scan jrapParentScan = this.getJrapScan(parser, iParentScanNum);
                            parentScan = this.getScan(jrapParentScan, -1);
                            if (parentScan == null) {
                                parentScan = firstParentScan;
                                iLastPossiblePrecursorMSLevel = firstParentScan.getMsLevel();
                            }
                            msScanMap.put(parentScan.getScanNo(), parentScan);
                        }
                    }
                    lastParentOfEachLevel.put(iCurMSLevel, i);
                    msScanMap.put(msScan.getScanNo(), msScan);
                    Peak peak = null;
                    if (msScan.getMsLevel() > iLastPossiblePrecursorMSLevel && parentScan != null) {
                        peak = this.getPrecursorPeak(parentScan, jrapScanHeader);
                        msScan.setPrecursor(peak);
                        parentScan.getSubScans().add(i);
                        if (peak.getMz() > dMaxMz) {
                            dMaxMz = peak.getMz();
                        }
                        if (peak.getMz() < dMinMz) {
                            dMinMz = peak.getMz();
                        }
                        if (firstParentScan != null && firstParentScan.getPolarity() == null && msScan.getPolarity() != null) {
                            firstParentScan.setPolarity(msScan.getPolarity());
                        }
                    }
                    if (i == scanNum || i == parentScanNum || precursorScanNum != -1 && precursorScanNum == parentScanNum || scanNum == -1 && parentScanNum == -1 && iCurMSLevel == msLevel) {
                        this.setPeakList(jrapScan.getMassIntensityList(), msScan, scanNum != -1 || parentScanNum != -1);
                        scans.add(msScan);
                    }
                    if (iCurMSLevel >= iMinMSLevel) continue;
                    iMinMSLevel = iCurMSLevel;
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    this.updateErrorListener("Error parsing scan number: " + i, ex);
                }
            }
            if (firstParentScan != null) {
                firstParentScan.setScanStart(Double.valueOf(dMinMz));
                firstParentScan.setScanEnd(Double.valueOf(dMaxMz));
            }
            if (!this.isCanceled && !skippedScans.isEmpty()) {
                this.updateErrorListener("Several scans are skipped due to being null. Check the log for details");
                logger.info((Object)("The following scans are skipped: " + ((Object)skippedScans).toString()));
            }
            return scans;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Scan getJrapScan(MSXMLParser parser, int iScanNumber) {
        Scan jrapScan = parser.rap(iScanNumber);
        if (jrapScan == null) {
            return null;
        }
        return jrapScan;
    }

    private org.grits.toolbox.ms.om.data.Scan getScan(Scan jrapScan, int iLastPrecursorScanNum) {
        if (jrapScan == null) {
            return null;
        }
        ScanHeader jrapScanHeader = jrapScan.getHeader();
        double maxIntensity = this.getMostAbundantPeak(jrapScan);
        org.grits.toolbox.ms.om.data.Scan msScan = new org.grits.toolbox.ms.om.data.Scan();
        msScan.setMostAbundantPeak(Double.valueOf(maxIntensity));
        int precursorScanNum = -1;
        precursorScanNum = jrapScanHeader.getPrecursorScanNum() != -1 ? jrapScanHeader.getPrecursorScanNum() : iLastPrecursorScanNum;
        msScan.setParentScan(Integer.valueOf(precursorScanNum));
        msScan.setMsLevel(Integer.valueOf(jrapScanHeader.getMsLevel()));
        String temp = jrapScanHeader.getPolarity();
        msScan.setPolarity(null);
        if (temp != null && !temp.equals("")) {
            boolean flag = temp.equals("+");
            msScan.setPolarity(Boolean.valueOf(flag));
        }
        msScan.setScanStart(Double.valueOf(jrapScanHeader.getLowMz()));
        msScan.setScanEnd(Double.valueOf(jrapScanHeader.getHighMz()));
        msScan.setScanNo(Integer.valueOf(jrapScanHeader.getNum()));
        msScan.setActivationMethode(jrapScanHeader.getActivationMethod());
        try {
            msScan.setRetentionTime(Double.valueOf(jrapScanHeader.getDoubleRetentionTime()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        msScan.setIsCentroided(Boolean.valueOf(jrapScanHeader.getCentroided() == 1));
        return msScan;
    }

    private Peak getPrecursorPeak(org.grits.toolbox.ms.om.data.Scan parentScan, ScanHeader jrapScanHeader) {
        if (parentScan == null) {
            return null;
        }
        Peak peak = null;
        List lPeaks = parentScan.getPeaklist();
        peak = this.findPeakInPeakList(lPeaks, jrapScanHeader.getPrecursorMz());
        if (peak == null) {
            peak = new Peak();
            peak.setId(Integer.valueOf(parentScan.getPeaklist().size() + 1));
            peak.setMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
            peak.setIntensity(Double.valueOf(0.0));
            peak.setCharge(Integer.valueOf(jrapScanHeader.getPrecursorCharge()));
            parentScan.getPeaklist().add(peak);
        }
        peak.setIsPrecursor(true);
        peak.setPrecursorIntensity(Double.valueOf(jrapScanHeader.getPrecursorIntensity()));
        peak.setPrecursorCharge(Integer.valueOf(jrapScanHeader.getPrecursorCharge()));
        peak.setPrecursorMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
        return peak;
    }

    private void setPeakList(double[][] scanPeaks, org.grits.toolbox.ms.om.data.Scan msScan, boolean bAddPeak) {
        if (scanPeaks != null) {
            double dLowMz = Double.MAX_VALUE;
            double dHighMz = Double.MIN_VALUE;
            double dTotalIntensity = 0.0;
            for (int j = 0; j < scanPeaks[0].length; ++j) {
                if (this.isCanceled()) {
                    return;
                }
                if (scanPeaks[1][j] <= 0.0) continue;
                Peak peak = new Peak();
                peak.setId(Integer.valueOf(j + 1));
                peak.setMz(Double.valueOf(scanPeaks[0][j]));
                if (dLowMz > peak.getMz()) {
                    dLowMz = peak.getMz();
                }
                if (dHighMz < peak.getMz()) {
                    dHighMz = peak.getMz();
                }
                peak.setIntensity(Double.valueOf(scanPeaks[1][j]));
                dTotalIntensity += peak.getIntensity().doubleValue();
                double dRelInt = peak.getIntensity() / msScan.getMostAbundantPeak();
                peak.setRelativeIntensity(Double.valueOf(dRelInt));
                if (!bAddPeak) continue;
                msScan.getPeaklist().add(peak);
            }
            if (msScan.getScanStart() <= 0.0) {
                msScan.setScanStart(Double.valueOf(dLowMz));
            }
            if (msScan.getScanEnd() <= 0.0) {
                msScan.setScanEnd(Double.valueOf(dHighMz));
            }
            msScan.setTotalNumPeaks(Integer.valueOf(scanPeaks[0].length));
            msScan.setTotalIntensity(Double.valueOf(dTotalIntensity));
        }
    }

    @Override
    public boolean isValid(MSFile file) {
        return this.isValidMzXmlFile(file.getFileName());
    }

    @Override
    public Integer getMinScanNumber(MSFile file) {
        MSXMLParser parser = new MSXMLParser(file.getFileName());
        return MzXmlReader.getFirstScanNumber(parser);
    }

    @Override
    public List<org.grits.toolbox.ms.om.data.Scan> readMSFile(MSFile file, int msLevel, int parentScanNum, int scanNum) {
        return this.readMzXmlFile(file.getFileName(), msLevel, parentScanNum, scanNum);
    }

    @Override
    public boolean hasMS1Scan(MSFile file) {
        MSXMLParser m_parser = new MSXMLParser(file.getFileName());
        Scan firstScan = null;
        if (m_parser != null) {
            for (int i = 1; firstScan == null && i < m_parser.getMaxScanNumber() + 1; ++i) {
                Scan s;
                ScanHeader header = m_parser.rapHeader(i);
                if (header == null || header.getMsLevel() != 1 || (s = m_parser.rap(i)).getMassIntensityList() == null || s.getMassIntensityList()[0].length <= 0 || (firstScan = m_parser.rap(i)) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ScanView> readMSFileForView(MSFile file, int msLevel, int parentScanNum, int scanNum) {
        File mzXMLFile = new File(file.getFileName());
        try {
            MSXMLParser parser = new MSXMLParser(mzXMLFile.getAbsolutePath());
            this.updateListeners("Reading XML file", -1);
            List<ScanView> scans = this.getScanViewData(parser, msLevel, parentScanNum, scanNum);
            if (scans != null) {
                Collections.sort(scans);
            }
            if (scans.isEmpty() && !this.isCanceled()) {
                this.updateErrorListener("Warning: no scan data read from MS file. The file may be invalid or incorrect type.");
            }
            return scans;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private List<ScanView> getScanViewData(MSXMLParser parser, int msLevel, int parentScanNum, int scanNum) {
        try {
            int iLastPossiblePrecursorMSLevel;
            int precursorScanNum = 0;
            ArrayList<ScanView> scans = new ArrayList<ScanView>();
            HashMap<Integer, Integer> lastParentOfEachLevel = new HashMap<Integer, Integer>();
            HashMap<Integer, ScanView> msScanMap = new HashMap<Integer, ScanView>();
            int iStartScan = MzXmlReader.getFirstScanNumber(parser);
            if (iStartScan == -1) {
                return new ArrayList<ScanView>();
            }
            int iEndScan = parser.getMaxScanNumber();
            int iMinMSLevel = iLastPossiblePrecursorMSLevel = parser.rapHeader(iStartScan).getMsLevel();
            ScanView firstParentScan = null;
            if (iLastPossiblePrecursorMSLevel > 1) {
                firstParentScan = new ScanView();
                firstParentScan.setScanNo(0);
                firstParentScan.setMsLevel(1);
                firstParentScan.setRetentionTime(0.0);
                msScanMap.put(firstParentScan.getScanNo(), firstParentScan);
                iLastPossiblePrecursorMSLevel = 1;
                lastParentOfEachLevel.put(1, 0);
                scans.add(firstParentScan);
            }
            ScanView msScan = null;
            ScanView parentScan = null;
            for (int i = iStartScan; i <= iEndScan; ++i) {
                try {
                    Scan jrapScan;
                    if (this.isCanceled()) {
                        return new ArrayList<ScanView>();
                    }
                    if (i % 10 == 0 && !this.isCanceled()) {
                        this.updateListeners("Reading XML file. Scan: " + i + " of " + iEndScan, i);
                    }
                    if (parentScanNum != -1 && (i < parentScanNum || i > parentScanNum + 1000) || (jrapScan = this.getJrapScan(parser, i)) == null) continue;
                    ScanHeader jrapScanHeader = jrapScan.getHeader();
                    int iCurMSLevel = jrapScanHeader.getMsLevel();
                    if (iLastPossiblePrecursorMSLevel < iCurMSLevel - 1) {
                        iLastPossiblePrecursorMSLevel = iCurMSLevel - 1;
                    } else if (iLastPossiblePrecursorMSLevel == iCurMSLevel && iCurMSLevel - 1 >= iMinMSLevel) {
                        iLastPossiblePrecursorMSLevel = iCurMSLevel - 1;
                    }
                    precursorScanNum = -1;
                    if (jrapScanHeader.getPrecursorScanNum() != -1) {
                        precursorScanNum = jrapScanHeader.getPrecursorScanNum();
                    } else if (iCurMSLevel > iLastPossiblePrecursorMSLevel && lastParentOfEachLevel.containsKey(iCurMSLevel - 1)) {
                        precursorScanNum = (Integer)lastParentOfEachLevel.get(iCurMSLevel - 1);
                    } else if (parentScanNum != -1 && iCurMSLevel > 1) {
                        precursorScanNum = parentScanNum;
                    }
                    msScan = this.getScanView(jrapScan, precursorScanNum);
                    int iParentScanNum = msScan.getParentScan();
                    if (iParentScanNum != -1) {
                        if (msScanMap.containsKey(iParentScanNum)) {
                            parentScan = (ScanView)msScanMap.get(iParentScanNum);
                        } else {
                            Scan jrapParentScan = this.getJrapScan(parser, iParentScanNum);
                            parentScan = this.getScanView(jrapParentScan, -1);
                            if (parentScan == null) continue;
                            msScanMap.put(parentScan.getScanNo(), parentScan);
                        }
                    }
                    lastParentOfEachLevel.put(iCurMSLevel, i);
                    msScanMap.put(msScan.getScanNo(), msScan);
                    if (msScan.getMsLevel() > iLastPossiblePrecursorMSLevel && parentScan != null) {
                        parentScan.getSubScans().add(msScan);
                    }
                    if ((i == scanNum || i == parentScanNum || precursorScanNum != -1 && precursorScanNum == parentScanNum || scanNum == -1 && parentScanNum == -1 && iCurMSLevel == msLevel) && (scanNum == -1 || i == scanNum || scanNum == msScan.getParentScan())) {
                        scans.add(msScan);
                    }
                    if (iCurMSLevel >= iMinMSLevel) continue;
                    iMinMSLevel = iCurMSLevel;
                    continue;
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    this.updateErrorListener("Error parsing scan number: " + i, ex);
                }
            }
            return scans;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private ScanView getScanView(Scan jrapScan, int iLastPrecursorScanNum) {
        if (jrapScan == null) {
            return null;
        }
        ScanHeader jrapScanHeader = jrapScan.getHeader();
        ScanView msScan = new ScanView();
        int precursorScanNum = -1;
        precursorScanNum = jrapScanHeader.getPrecursorScanNum() != -1 ? jrapScanHeader.getPrecursorScanNum() : iLastPrecursorScanNum;
        msScan.setPreCursorMz(Double.valueOf(jrapScanHeader.getPrecursorMz()));
        msScan.setPreCursorIntensity(Double.valueOf(jrapScanHeader.getPrecursorIntensity()));
        msScan.setParentScan(precursorScanNum);
        msScan.setMsLevel(jrapScanHeader.getMsLevel());
        msScan.setScanNo(jrapScanHeader.getNum());
        try {
            msScan.setRetentionTime(jrapScanHeader.getDoubleRetentionTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msScan;
    }
}

