/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.tools.gsl.database.IonizationType;
import org.grits.toolbox.tools.gsl.structure.LipidFragmentInfo;
import org.grits.toolbox.tools.gsl.structure.LipidNameParser;
import org.grits.toolbox.tools.gsl.structure.lipid.Ceramide;
import org.grits.toolbox.tools.gsl.structure.lipid.FattyAcid;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Lipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Sphingosine;
import org.grits.toolbox.tools.gsl.util.generator.structure.LipidFragmenter;
import org.grits.toolbox.tools.gsl.util.mass.AtomicMass;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalCompositionProvider;

public class LipidCalculatorDialog
extends TitleAreaDialog {
    private Text m_txtLipidName;
    private List<Label> m_lLblLipidNames;
    private List<Label> m_lLblNumC;
    private List<Label> m_lLblNumOHs;
    private List<Label> m_lLblNumDBs;
    private String m_strLipidName;
    private ILipid m_iLipid;
    private Text m_txtMassValue;
    private Text m_txtFormula;
    private Button m_btnPerMe;
    private Button m_btnM;
    private Button m_btnMmH2O;
    private Button m_btnMpH;
    private Button m_btnMmH;
    private Button m_btnMpNa;
    private Button m_btnMpHmH2O;
    private Button m_btnIonCustom;
    private Button m_btnIonCustomH2O;
    private Combo m_cmbCustomIonType;
    private Spinner m_spnCustomIonCount;
    private Button m_btnCustomIonNegative;
    private Table m_tblFragmentation;

    public LipidCalculatorDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Lipid Mass Calculator");
        this.setMessage("Calculate lipid information and masses.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLipidName(container);
        this.createLipidInformation(container);
        this.createMassInformation(container);
        return area;
    }

    private void createLipidName(Composite container) {
        Label lbtFirstName = new Label(container, 0);
        lbtFirstName.setText("Lipid name");
        this.m_txtLipidName = new Text(container, 2048);
        this.m_txtLipidName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.parseLipidName();
        this.m_txtLipidName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LipidCalculatorDialog.this.m_iLipid = LipidCalculatorDialog.this.parseLipidName();
                if (LipidCalculatorDialog.this.m_iLipid == null) {
                    LipidCalculatorDialog.this.initLipidInformations();
                    LipidCalculatorDialog.this.initMassInformation();
                    return;
                }
                LipidCalculatorDialog.this.showStructureInformation(LipidCalculatorDialog.this.m_iLipid);
                LipidCalculatorDialog.this.showCalculatedMasses(LipidCalculatorDialog.this.m_iLipid);
            }
        });
        new Label(container, 0);
        Label lblExample = new Label(container, 0);
        lblExample.setText("*Conforming to LIPID MAPS abbreviation.\n e.g. Cer(d18:1/16:0), Sp(d18:1), FA(16:0)");
    }

    private void createLipidInformation(Composite container) {
        Group grpInformation = new Group(container, 0);
        grpInformation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpInformation.setText("Lipid information");
        grpInformation.setLayout((Layout)new GridLayout(4, true));
        new Label((Composite)grpInformation, 0);
        this.m_lLblLipidNames = new ArrayList<Label>();
        int i = 0;
        while (i < 3) {
            Label lblName = new Label((Composite)grpInformation, 0);
            lblName.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
            this.m_lLblLipidNames.add(lblName);
            ++i;
        }
        Label lblNumC = new Label((Composite)grpInformation, 0);
        lblNumC.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNumC.setText("Carbon chain length");
        this.m_lLblNumC = new ArrayList<Label>();
        int i2 = 0;
        while (i2 < 3) {
            Label lblNum = new Label((Composite)grpInformation, 0);
            lblNum.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
            this.m_lLblNumC.add(lblNum);
            ++i2;
        }
        Label lblNumOH = new Label((Composite)grpInformation, 0);
        lblNumOH.setText("# of hydroxyl groups");
        this.m_lLblNumOHs = new ArrayList<Label>();
        int i3 = 0;
        while (i3 < 3) {
            Label lblNum = new Label((Composite)grpInformation, 0);
            lblNum.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
            this.m_lLblNumOHs.add(lblNum);
            ++i3;
        }
        Label lblNumDB = new Label((Composite)grpInformation, 0);
        lblNumDB.setText("# of double bonds");
        this.m_lLblNumDBs = new ArrayList<Label>();
        int i4 = 0;
        while (i4 < 3) {
            Label lblNum = new Label((Composite)grpInformation, 0);
            lblNum.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
            this.m_lLblNumDBs.add(lblNum);
            ++i4;
        }
        this.initLipidInformations();
    }

    private void createMassInformation(Composite container) {
        Group grpMass = new Group(container, 0);
        grpMass.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpMass.setText("Mass information");
        grpMass.setLayout((Layout)new GridLayout(4, false));
        Label lblComposition = new Label((Composite)grpMass, 0);
        lblComposition.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblComposition.setText("Chemical Formula");
        this.m_txtFormula = new Text((Composite)grpMass, 2048);
        this.m_txtFormula.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.m_txtFormula.setEditable(false);
        Label lblMassValue = new Label((Composite)grpMass, 0);
        lblMassValue.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblMassValue.setText("Monoisotopic Mass Value");
        this.m_txtMassValue = new Text((Composite)grpMass, 2048);
        this.m_txtMassValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.m_txtMassValue.setEditable(false);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LipidCalculatorDialog.this.updateLabels();
                if (LipidCalculatorDialog.this.m_iLipid == null) {
                    return;
                }
                LipidCalculatorDialog.this.showCalculatedMasses(LipidCalculatorDialog.this.m_iLipid);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LipidCalculatorDialog.this.updateLabels();
                if (LipidCalculatorDialog.this.m_iLipid == null) {
                    return;
                }
                LipidCalculatorDialog.this.showCalculatedMasses(LipidCalculatorDialog.this.m_iLipid);
            }
        };
        new Label((Composite)grpMass, 0);
        Button btn = new Button((Composite)grpMass, 32);
        btn.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        btn.setText("Permethylation");
        btn.addSelectionListener(listener);
        this.m_btnPerMe = btn;
        Label lbl = new Label((Composite)grpMass, 0);
        lbl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lbl.setText("Ionization");
        this.m_btnM = this.createRadioButton(grpMass, "M", listener);
        this.m_btnMmH2O = this.createRadioButton(grpMass, "M - H2O", listener);
        new Label((Composite)grpMass, 0);
        new Label((Composite)grpMass, 0);
        this.m_btnMpH = this.createRadioButton(grpMass, "[M + H]+", listener);
        this.m_btnMmH = this.createRadioButton(grpMass, "[M - H]-", listener);
        new Label((Composite)grpMass, 0);
        new Label((Composite)grpMass, 0);
        this.m_btnMpNa = this.createRadioButton(grpMass, "[M + Na]+", listener);
        this.m_btnMpHmH2O = this.createRadioButton(grpMass, "[M + H - H2O]+", listener);
        new Label((Composite)grpMass, 0);
        lbl = new Label((Composite)grpMass, 0);
        lbl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lbl.setText("Custom ion");
        SelectionListener listenerCustom = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    LipidCalculatorDialog.this.m_spnCustomIonCount.setEnabled(true);
                    LipidCalculatorDialog.this.m_cmbCustomIonType.setEnabled(true);
                    LipidCalculatorDialog.this.m_btnCustomIonNegative.setEnabled(true);
                } else {
                    LipidCalculatorDialog.this.m_spnCustomIonCount.setEnabled(false);
                    LipidCalculatorDialog.this.m_cmbCustomIonType.setEnabled(false);
                    LipidCalculatorDialog.this.m_btnCustomIonNegative.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    LipidCalculatorDialog.this.m_spnCustomIonCount.setEnabled(true);
                    LipidCalculatorDialog.this.m_cmbCustomIonType.setEnabled(true);
                    LipidCalculatorDialog.this.m_btnCustomIonNegative.setEnabled(true);
                } else {
                    LipidCalculatorDialog.this.m_spnCustomIonCount.setEnabled(false);
                    LipidCalculatorDialog.this.m_cmbCustomIonType.setEnabled(false);
                    LipidCalculatorDialog.this.m_btnCustomIonNegative.setEnabled(false);
                }
            }
        };
        this.m_btnIonCustom = this.createRadioButton(grpMass, "[M + H]+", listener);
        this.m_btnIonCustom.addSelectionListener(listenerCustom);
        this.m_btnIonCustomH2O = this.createRadioButton(grpMass, "[M + H - H2O]+", listener);
        this.m_btnIonCustomH2O.addSelectionListener(listenerCustom);
        new Label((Composite)grpMass, 0);
        new Label((Composite)grpMass, 0);
        this.m_spnCustomIonCount = new Spinner((Composite)grpMass, 2048);
        this.m_spnCustomIonCount.setMinimum(1);
        this.m_spnCustomIonCount.setMaximum(10);
        this.m_spnCustomIonCount.setSelection(1);
        this.m_spnCustomIonCount.addSelectionListener(listener);
        this.m_spnCustomIonCount.setEnabled(false);
        this.m_cmbCustomIonType = new Combo((Composite)grpMass, 0);
        this.m_cmbCustomIonType.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.m_cmbCustomIonType.setItems(new String[]{"H", "Na", "Li", "K"});
        this.m_cmbCustomIonType.select(0);
        this.m_cmbCustomIonType.addSelectionListener(listener);
        this.m_cmbCustomIonType.setEnabled(false);
        this.m_btnCustomIonNegative = new Button((Composite)grpMass, 32);
        this.m_btnCustomIonNegative.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.m_btnCustomIonNegative.setText("Negative mode");
        this.m_btnCustomIonNegative.addSelectionListener(listener);
        this.m_btnCustomIonNegative.setEnabled(false);
        this.m_btnM.setSelection(true);
        new Label((Composite)grpMass, 0);
        new Label((Composite)grpMass, 0);
    }

    private Button createRadioButton(Group a_grp, String a_strLabel, SelectionListener a_listener) {
        Button t_btn = new Button((Composite)a_grp, 16);
        t_btn.setText(a_strLabel);
        t_btn.addSelectionListener(a_listener);
        return t_btn;
    }

    private void updateCustomIonLabel() {
        String strLabel = "[M ";
        String strCharge = this.m_btnCustomIonNegative.getSelection() ? "-" : "+";
        strLabel = String.valueOf(strLabel) + strCharge + " ";
        int n = this.m_spnCustomIonCount.getSelection();
        if (n > 1) {
            strLabel = String.valueOf(strLabel) + n;
            strCharge = String.valueOf(n) + strCharge;
        }
        strLabel = String.valueOf(strLabel) + this.m_cmbCustomIonType.getText() + "]" + strCharge;
        String t_strOLoss = this.m_btnPerMe.getSelection() ? "MeOH" : "H2O";
        String strLabelH2O = strLabel.replace("]", " - " + t_strOLoss + "]");
        this.m_btnIonCustom.setText(strLabel);
        this.m_btnIonCustomH2O.setText(strLabelH2O);
    }

    private void createFragmentation(Composite container) {
        Group grpAbundanceTable = new Group(container, 0);
        grpAbundanceTable.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        grpAbundanceTable.setText("Fragments");
        grpAbundanceTable.setLayout((Layout)new GridLayout(1, true));
        this.m_tblFragmentation = new Table((Composite)grpAbundanceTable, 67586);
        GridData gData = new GridData(4, 4, true, true);
        gData.heightHint = 200;
        this.m_tblFragmentation.setLayoutData((Object)gData);
        this.m_tblFragmentation.setLinesVisible(true);
        this.m_tblFragmentation.setHeaderVisible(true);
        String[] t_aHeaders = new String[]{"Name", "Type", "Composition", "M", "[M + H]+"};
        int i = 0;
        while (i < t_aHeaders.length) {
            TableColumn t_col = new TableColumn(this.m_tblFragmentation, 0);
            t_col.setText(t_aHeaders[i]);
            t_col.setMoveable(true);
            this.m_tblFragmentation.getColumn(i).pack();
            ++i;
        }
        this.updateFragmentTable(null);
        this.m_tblFragmentation.setSize(this.m_tblFragmentation.computeSize(-1, 200));
        grpAbundanceTable.pack();
    }

    private void initFragmentTable() {
        this.m_tblFragmentation.removeAll();
    }

    private void updateFragmentTable(ILipid a_lipid) {
        this.initFragmentTable();
        if (a_lipid == null) {
            return;
        }
        LipidFragmenter t_lipFrag = new LipidFragmenter();
        List<LipidFragmentInfo> t_lFragInfo = t_lipFrag.fragment(a_lipid);
        for (LipidFragmentInfo t_lipFragInfo : t_lFragInfo) {
            TableItem t_item = new TableItem(this.m_tblFragmentation, 0);
            t_item.setText(0, t_lipFragInfo.getFragment().getName());
            t_item.setText(1, t_lipFragInfo.getFragmentType());
            ChemicalComposition t_calcMass = ChemicalCompositionProvider.getChemicalComposition(t_lipFragInfo.getFragment());
            t_item.setText(2, t_calcMass.getFormula());
            t_item.setText(3, t_calcMass.getMonoisotopicMass());
            t_item.setText(4, t_calcMass.getMonoisotopicMass(IonizationType.PH));
        }
        int i = 0;
        while (i < this.m_tblFragmentation.getColumnCount()) {
            this.m_tblFragmentation.getColumn(i).pack();
            ++i;
        }
    }

    private ILipid parseLipidName() {
        String t_strLipid = this.m_txtLipidName.getText().trim();
        if (t_strLipid.isEmpty()) {
            this.setErrorMessage("Please enter a lipid name.");
            return null;
        }
        ILipid t_iLip = LipidNameParser.parseLipidName(t_strLipid);
        if (t_iLip == null) {
            this.setErrorMessage("Lipid name is not valid.");
            return null;
        }
        this.setErrorMessage(null);
        return t_iLip;
    }

    private void initLipidInformations() {
        for (Label t_lbl : this.m_lLblLipidNames) {
            t_lbl.setText("-");
        }
        for (Label t_lbl : this.m_lLblNumC) {
            t_lbl.setText("-");
        }
        for (Label t_lbl : this.m_lLblNumOHs) {
            t_lbl.setText("-");
        }
        for (Label t_lbl : this.m_lLblNumDBs) {
            t_lbl.setText("-");
        }
        this.m_lLblNumC.get(0).getParent().layout();
    }

    private void showStructureInformation(ILipid a_iLip) {
        this.initLipidInformations();
        if (a_iLip instanceof Ceramide) {
            this.m_lLblLipidNames.get(0).setText("Sphingosine");
            this.m_lLblLipidNames.get(1).setText("Fatty Acid");
            Ceramide t_cer = (Ceramide)a_iLip;
            this.m_lLblNumC.get(0).setText("" + t_cer.getSphingosine().getCarbonLength());
            this.m_lLblNumC.get(1).setText("" + t_cer.getFattyAcid().getCarbonLength());
            this.m_lLblNumOHs.get(0).setText("" + t_cer.getSphingosine().getNumberOfHydroxylGroups());
            this.m_lLblNumOHs.get(1).setText("" + t_cer.getFattyAcid().getNumberOfHydroxylGroups());
            this.m_lLblNumDBs.get(0).setText("" + t_cer.getSphingosine().getNumberOfDoubleBonds());
            this.m_lLblNumDBs.get(1).setText("" + t_cer.getFattyAcid().getNumberOfDoubleBonds());
        }
        if (a_iLip instanceof Sphingosine) {
            this.m_lLblLipidNames.get(0).setText("Sphingosine");
            Sphingosine t_sph = (Sphingosine)a_iLip;
            this.m_lLblNumC.get(0).setText("" + t_sph.getCarbonLength());
            this.m_lLblNumOHs.get(0).setText("" + t_sph.getNumberOfHydroxylGroups());
            this.m_lLblNumDBs.get(0).setText("" + t_sph.getNumberOfDoubleBonds());
        } else if (a_iLip instanceof FattyAcid) {
            this.m_lLblLipidNames.get(0).setText("Fatty Acid");
            FattyAcid t_fa = (FattyAcid)a_iLip;
            this.m_lLblNumC.get(0).setText("" + t_fa.getCarbonLength());
            this.m_lLblNumOHs.get(0).setText("" + t_fa.getNumberOfHydroxylGroups());
            this.m_lLblNumDBs.get(0).setText("" + t_fa.getNumberOfDoubleBonds());
        } else if (a_iLip instanceof Lipid) {
            this.setErrorMessage("Lipid name is not valid.");
            return;
        }
        this.m_lLblLipidNames.get(0).getParent().layout();
    }

    private void initMassInformation() {
        this.m_txtFormula.setText("");
        this.m_txtMassValue.setText("");
    }

    private void updateLabels() {
        String t_strOLoss = "H2O";
        if (this.m_btnPerMe.getSelection()) {
            t_strOLoss = "MeOH";
        }
        this.m_btnMmH2O.setText("M - " + t_strOLoss);
        this.m_btnMpHmH2O.setText("[M + H - " + t_strOLoss + "]+");
        this.updateCustomIonLabel();
        this.m_btnMmH2O.getParent().layout();
    }

    private void showCalculatedMasses(ILipid a_iLip) {
        this.initMassInformation();
        ChemicalComposition t_calcMass = ChemicalCompositionProvider.getChemicalComposition(a_iLip);
        if (this.m_btnPerMe.getSelection()) {
            t_calcMass.derivatize();
        }
        IonizationType t_ion = null;
        if (this.m_btnM.getSelection()) {
            t_ion = IonizationType.NOION;
        }
        if (this.m_btnMmH2O.getSelection()) {
            t_ion = IonizationType.NOIONMH2O;
        }
        if (this.m_btnMpH.getSelection()) {
            t_ion = IonizationType.PH;
        }
        if (this.m_btnMmH.getSelection()) {
            t_ion = IonizationType.MH;
        }
        if (this.m_btnMpNa.getSelection()) {
            t_ion = IonizationType.PNA;
        }
        if (this.m_btnMpHmH2O.getSelection()) {
            t_ion = IonizationType.PHMH2O;
        }
        if (t_ion != null) {
            this.m_txtMassValue.setText(t_calcMass.getMonoisotopicMass(t_ion));
            this.m_txtFormula.setText(t_calcMass.getFormula(t_ion));
        } else {
            int nIon = this.m_spnCustomIonCount.getSelection();
            if (this.m_btnCustomIonNegative.getSelection()) {
                nIon *= -1;
            }
            t_calcMass = t_calcMass.getCustomIonizedComposition(AtomicMass.forSymbol(this.m_cmbCustomIonType.getText()), nIon, this.m_btnIonCustomH2O.getSelection());
            this.m_txtMassValue.setText(t_calcMass.getMonoisotopicMass());
            this.m_txtFormula.setText(t_calcMass.getFormula());
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        this.m_strLipidName = this.m_txtLipidName.getText();
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public String getLipidName() {
        return this.m_strLipidName;
    }
}

