/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.series;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.swtchart.IErrorBar;
import org.swtchart.internal.axis.Axis;

public class ErrorBar
implements IErrorBar {
    private static final int DEFAULT_LINE_WIDTH = 1;
    private static final double DEFAULT_ERROR = 1.0;
    private static final int DEFAULT_COLOR = 16;
    private static final IErrorBar.ErrorBarType DEFAULT_TYPE = IErrorBar.ErrorBarType.BOTH;
    private Color color = Display.getDefault().getSystemColor(16);
    private int lineWidth = 1;
    private double error = 1.0;
    private double[] plusErrors;
    private double[] minusErrors;
    private IErrorBar.ErrorBarType type = IErrorBar.ErrorBarType.BOTH;
    private boolean isVisible = false;

    public ErrorBar() {
        this.plusErrors = new double[0];
        this.minusErrors = new double[0];
    }

    @Override
    public IErrorBar.ErrorBarType getType() {
        return this.type;
    }

    @Override
    public void setType(IErrorBar.ErrorBarType type) {
        this.type = type == null ? DEFAULT_TYPE : type;
    }

    @Override
    public Color getColor() {
        if (this.color.isDisposed()) {
            this.color = Display.getDefault().getSystemColor(16);
        }
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.color = color == null ? Display.getDefault().getSystemColor(16) : color;
    }

    @Override
    public int getLineWidth() {
        return this.lineWidth;
    }

    @Override
    public void setLineWidth(int width) {
        this.lineWidth = width <= 0 ? 1 : width;
    }

    @Override
    public double getError() {
        return this.error;
    }

    @Override
    public void setError(double error) {
        if (error < 0.0) {
            throw new IllegalArgumentException("positive value must be given for error.");
        }
        this.error = error;
    }

    @Override
    public double[] getPlusErrors() {
        double[] copiedSeries = new double[this.plusErrors.length];
        System.arraycopy(this.plusErrors, 0, copiedSeries, 0, this.plusErrors.length);
        return copiedSeries;
    }

    @Override
    public void setPlusErrors(double[] errors) {
        if (errors == null) {
            SWT.error((int)4);
            return;
        }
        this.plusErrors = new double[errors.length];
        System.arraycopy(errors, 0, this.plusErrors, 0, errors.length);
    }

    @Override
    public double[] getMinusErrors() {
        double[] copiedSeries = new double[this.minusErrors.length];
        System.arraycopy(this.minusErrors, 0, copiedSeries, 0, this.minusErrors.length);
        return copiedSeries;
    }

    @Override
    public void setMinusErrors(double[] errors) {
        if (errors == null) {
            SWT.error((int)4);
            return;
        }
        this.minusErrors = new double[errors.length];
        System.arraycopy(errors, 0, this.minusErrors, 0, errors.length);
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    protected void draw(GC gc, int h, int v, Axis axis, int seriesIndex) {
        if (!this.isVisible) {
            return;
        }
        int oldLineWidth = gc.getLineWidth();
        gc.setLineWidth(this.lineWidth);
        gc.setLineStyle(1);
        Color oldForeground = gc.getForeground();
        gc.setForeground(this.getColor());
        double plusError = this.error;
        double minusError = this.error;
        if (this.plusErrors.length > seriesIndex) {
            plusError = this.plusErrors[seriesIndex];
        }
        if (this.minusErrors.length > seriesIndex) {
            minusError = this.minusErrors[seriesIndex];
        }
        this.draw(gc, h, v, axis, plusError, minusError);
        gc.setLineWidth(oldLineWidth);
        gc.setForeground(oldForeground);
    }

    private void draw(GC gc, int h, int v, Axis axis, double plusError, double minusError) {
        if (axis.isHorizontalAxis()) {
            double dataCoordinate = axis.getDataCoordinate(h);
            int plusErrorInPixels = axis.getPixelCoordinate(dataCoordinate + plusError) - h;
            int miusErrorInPixels = h - axis.getPixelCoordinate(dataCoordinate - minusError);
            if (axis.isLogScaleEnabled() && dataCoordinate - plusError < 0.0) {
                miusErrorInPixels = h - axis.getPixelCoordinate(axis.getRange().lower);
            }
            if (this.type != IErrorBar.ErrorBarType.MINUS) {
                gc.drawLine(h, v, h + plusErrorInPixels, v);
                gc.drawLine(h + plusErrorInPixels, v + 1 + this.lineWidth, h + plusErrorInPixels, v - 1 - this.lineWidth);
            }
            if (this.type != IErrorBar.ErrorBarType.PLUS) {
                gc.drawLine(h - miusErrorInPixels, v, h, v);
                gc.drawLine(h - miusErrorInPixels, v + 1 + this.lineWidth, h - miusErrorInPixels, v - 1 - this.lineWidth);
            }
        } else {
            double dataCoordinate = axis.getDataCoordinate(v);
            int plusErrorInPixels = v - axis.getPixelCoordinate(dataCoordinate + plusError);
            int miusErrorInPixels = axis.getPixelCoordinate(dataCoordinate - minusError) - v;
            if (axis.isLogScaleEnabled() && dataCoordinate - plusError < 0.0) {
                miusErrorInPixels = axis.getPixelCoordinate(axis.getRange().lower) - v;
            }
            if (this.type != IErrorBar.ErrorBarType.MINUS) {
                gc.drawLine(h, v - plusErrorInPixels, h, v);
                gc.drawLine(h + 1 + this.lineWidth, v - plusErrorInPixels, h - 1 - this.lineWidth, v - plusErrorInPixels);
            }
            if (this.type != IErrorBar.ErrorBarType.PLUS) {
                gc.drawLine(h, v, h, v + miusErrorInPixels);
                gc.drawLine(h + 1 + this.lineWidth, v + miusErrorInPixels, h - 1 - this.lineWidth, v + miusErrorInPixels);
            }
        }
    }
}

