/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor.pages.archivedfile.actions;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.archive.config.ImageRegistry;
import org.grits.toolbox.entry.archive.dialog.uploadfile.DownloadFileDialog;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.FileArchivePage;
import org.grits.toolbox.entry.archive.model.ArchivedFile;

public class DownloadFile
extends Action {
    private static Logger logger = Logger.getLogger(DownloadFile.class);
    private FileArchivePage page = null;

    public DownloadFile(FileArchivePage fileArchivePage) {
        this.page = fileArchivePage;
        this.setText("Download");
        this.setToolTipText("Download the File");
        this.setImageDescriptor(ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.archive", ImageRegistry.ArchiveImage.DOWNLOAD_FILE_ICON));
    }

    public void run() {
        logger.debug((Object)"Start - Downloading  Archive File");
        TreeViewer treeViewer = this.page.getLeftSideTreeViewer();
        if (!treeViewer.getSelection().isEmpty()) {
            ArchivedFile selectedArchivedFile = (ArchivedFile)((TreeSelection)treeViewer.getSelection()).getFirstElement();
            DownloadFileDialog downloadDialog = new DownloadFileDialog(this.page, selectedArchivedFile);
            if (downloadDialog.open() == 0) {
                treeViewer.setSelection(treeViewer.getSelection());
                logger.debug((Object)("Downloaded successfully : " + selectedArchivedFile.getTypicalArchivedFile().getFileName()));
            }
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No File Selected", (String)"Please select a file to download.");
        }
    }
}

