/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.forms;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.MultiPageFormAbstract;

public abstract class FormAbstract {
    private MultiPageFormAbstract parent;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private String tabText;
    private ExpandableComposite expCurrent;

    public FormAbstract(MultiPageFormAbstract parent, String tabText) {
        this.parent = parent;
        this.toolkit = parent.getToolkit();
        this.form = this.toolkit.createScrolledForm((Composite)parent.getFolder());
        ColumnLayout layout = new ColumnLayout();
        layout.maxNumColumns = 1;
        this.form.getBody().setLayout((Layout)layout);
        this.tabText = tabText;
    }

    public MultiPageFormAbstract getParent() {
        return this.parent;
    }

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public ScrolledForm getForm() {
        return this.form;
    }

    public String getTabText() {
        return this.tabText;
    }

    protected Composite createNewSection(String title) {
        return this.createNewSection(this.form.getBody(), title);
    }

    protected Composite createNewSection(Composite parent, String title) {
        Section section = this.toolkit.createSection(parent, 354);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                FormAbstract.this.form.reflow(true);
            }
        });
        section.setText(title);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        ColumnLayout layout = new ColumnLayout();
        layout.maxNumColumns = 1;
        sectionClient.setLayout((Layout)layout);
        section.setClient((Control)sectionClient);
        return sectionClient;
    }

    protected ExpandableComposite createExpandableComposite(Composite parent) {
        final ExpandableComposite exp = this.toolkit.createExpandableComposite(parent, 36);
        Composite client = this.toolkit.createComposite((Composite)exp);
        ColumnLayout layout = new ColumnLayout();
        layout.maxNumColumns = 10;
        client.setLayout((Layout)layout);
        exp.setClient((Control)client);
        exp.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    if (FormAbstract.this.expCurrent != null) {
                        FormAbstract.this.expCurrent.setExpanded(false);
                    }
                    FormAbstract.this.expCurrent = exp;
                } else {
                    FormAbstract.this.expCurrent = null;
                }
                FormAbstract.this.form.reflow(true);
            }
        });
        return exp;
    }
}

