/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.partdescriptor;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.tools.glycanbuilder.core.config.GraphicOptionsSWT;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.GlycanDocument;
import org.grits.toolbox.tools.glycanbuilder.core.workspace.BuilderWorkspaceSWT;
import org.grits.toolbox.tools.glycanbuilder.preference.GraphicOptionsPreference;
import org.grits.toolbox.tools.glycanbuilder.widgets.GlycanBuilder;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.GlycanIconProvider;
import org.osgi.service.event.Event;

public class GlycanBuilderPart {
    public static String ID = "org.grits.toolbox.tools.glycanbuilder";
    private static final Logger logger = Logger.getLogger(GlycanBuilderPart.class);
    private GlycanBuilder builder;
    private BuilderWorkspaceSWT bws;
    @Inject
    private MDirtyable dirtyable;
    private MPart part;

    @PostConstruct
    public void postConstruct(Composite parent, MPart part) {
        logger.info((Object)"Create GlycanBuilder");
        this.part = part;
        this.dirtyable.setDirty(false);
        this.builder = new GlycanBuilder(parent);
        this.bws = this.builder.getGlycanCanvasWithToolBar().getGlycanCanvas().getBuilderWorkspace();
        GraphicOptionsSWT preference = GraphicOptionsPreference.readPreference().getPreference();
        this.bws.getGraphicOptions().copy(preference);
        this.bws.setNotation(this.bws.getGraphicOptions().NOTATION);
        GlycanIconProvider.setNotation(this.bws.getGraphicOptions().NOTATION);
        this.builder.getBuilderMultiForm().getViewSettingsForm().loadSettingsFromWorkspace(this.bws);
        this.builder.getGlycanCanvasWithToolBar().getShortcutToolBar().updateOrientationIcon();
        this.bws.getGlycanDocument().addListener(new GlycanDocument.Listener(){

            @Override
            public void stateSaved() {
                GlycanBuilderPart.this.dirtyable.setDirty(true);
            }

            @Override
            public void stateLoaded() {
                GlycanBuilderPart.this.dirtyable.setDirty(true);
            }

            @Override
            public void fileSaved() {
                GlycanBuilderPart.this.dirtyable.setDirty(false);
            }

            @Override
            public void fileOpened() {
                GlycanBuilderPart.this.dirtyable.setDirty(false);
            }
        });
        part.getContext().set(GlycanBuilder.class, (Object)this.builder);
    }

    @PreDestroy
    public void preDestroy() {
        logger.info((Object)"Save preference of GlycanBuilder");
        GraphicOptionsPreference preference = new GraphicOptionsPreference();
        preference.setPreference(this.bws.getGraphicOptions());
        preference.writePreference();
    }

    @Inject
    @Optional
    public void handleBringToTop(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event, IGritsUIService gritsUiService) {
        if (this.part == event.getProperty("ChangedElement")) {
            gritsUiService.selectPerspective("org.grits.toolbox.core.perspective.projectexplorer.<Default Perspective>");
        }
    }

    @Persist
    public void doSave() {
        this.bws.getGlycanDocument().save();
    }
}

