/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.importer.ms.wizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.grits.toolbox.entry.ms.dialog.MassSpecFileAddDialog;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecOverviewPage;
import org.grits.toolbox.entry.ms.views.tabbed.content.MassSpecFileListTableComposite;
import org.grits.toolbox.importer.ms.wizard.NewMSWizard;
import org.grits.toolbox.ms.file.FileCategory;

public class FileUploadPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(FileUploadPage.class);
    List<MSPropertyDataFile> fileList;
    private Tree fileTree;
    private TreeViewer fileTreeViewer;

    protected FileUploadPage() {
        super("New MS Experiment");
        this.setTitle("Add files to MS Experiment");
        this.setDescription("Add files to MS Experiment");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 10;
        container.setLayout((Layout)gridLayout);
        MassSpecFileListTableComposite comp = new MassSpecFileListTableComposite(container, 64, false);
        this.fileList = ((NewMSWizard)this.getWizard()).getAllFiles();
        if (this.fileList == null) {
            this.fileList = new ArrayList<MSPropertyDataFile>();
        }
        comp.setFileList(this.fileList);
        comp.initComponents();
        comp.setLayoutData((Object)new GridData(4, 4, true, true, 3, 3));
        this.fileTreeViewer = comp.getFileTableViewer();
        this.fileTree = this.fileTreeViewer.getTree();
        new Label(container, 0);
        Button addButton = new Button(container, 8);
        addButton.setText("Add");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = FileUploadPage.this.fileTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    if (selected.getParentItem() == null) {
                        MSPropertyDataFile parentFile = (MSPropertyDataFile)selected.getData();
                        FileUploadPage.this.addFile(Display.getCurrent().getActiveShell(), parentFile);
                    } else {
                        FileUploadPage.this.addFile(Display.getCurrent().getActiveShell(), null);
                    }
                } else {
                    FileUploadPage.this.addFile(Display.getCurrent().getActiveShell(), null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button deleteButton = new Button(container, 8);
        deleteButton.setText("Remove");
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] items = FileUploadPage.this.fileTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    MSPropertyDataFile dataFile = (MSPropertyDataFile)selected.getData();
                    FileUploadPage.this.deleteFile(Display.getCurrent().getActiveShell(), dataFile);
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No selection", (String)"Please select a file entry below to delete");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void deleteFile(Shell activeShell, MSPropertyDataFile dataFile) {
        if (dataFile == null) {
            return;
        }
        if (dataFile.getIsParent().booleanValue() && dataFile.getChildren() != null && !dataFile.getChildren().isEmpty()) {
            logger.debug((Object)(dataFile + " cannot be deleted since it has children. Delete them first then try to delete this entry again!"));
            MessageDialog.openInformation((Shell)activeShell, (String)"Parent", (String)(String.valueOf(dataFile.getOriginalFileName()) + " cannot be deleted since it has children. Delete them first then try to delete this entry again!"));
            return;
        }
        if (dataFile.getName().equals(((NewMSWizard)this.getWizard()).getOne().getRawFileName())) {
            ((NewMSWizard)this.getWizard()).getOne().setRawFileNameText("");
        }
        if (dataFile.getName().equals(((NewMSWizard)this.getWizard()).getOne().getMzxmlFileName())) {
            ((NewMSWizard)this.getWizard()).getOne().setMsMsMzXMLText("");
        }
        if (dataFile.getIsParent().booleanValue()) {
            this.fileList.remove(dataFile);
            this.fileTreeViewer.refresh();
            this.fileTreeViewer.expandAll();
        } else if (!dataFile.getIsParent().booleanValue()) {
            for (MSPropertyDataFile msPropertyDataFile : this.fileList) {
                if (msPropertyDataFile.getChildren() == null || !msPropertyDataFile.getChildren().contains(dataFile)) continue;
                msPropertyDataFile.getChildren().remove(dataFile);
            }
            this.fileTreeViewer.refresh();
            this.fileTreeViewer.expandAll();
        }
    }

    private void addFile(Shell shell, MSPropertyDataFile parentFile) {
        MassSpecFileAddDialog dialog = new MassSpecFileAddDialog(shell, this.fileList, parentFile);
        if (dialog.open() == 0) {
            String file = dialog.getFileName();
            String fileFormat = "";
            if (file != null && !file.isEmpty()) {
                fileFormat = MassSpecOverviewPage.findFileFormatType((FileCategory)dialog.getFileCategory(), (String)file);
            }
            String originalFileName = file == null || file.isEmpty() ? "" : file.substring(file.lastIndexOf(File.separator) + 1);
            MSPropertyDataFile newDataFile = new MSPropertyDataFile(file, "1.3", fileFormat, dialog.getFileCategory(), MassSpecOverviewPage.findMSFileType((String)fileFormat), originalFileName, Arrays.asList(dialog.getFileCategory().getLabel()));
            MSPropertyDataFile selectedParentFile = dialog.getParentFile();
            if (selectedParentFile != null) {
                if (!file.isEmpty()) {
                    selectedParentFile.addChild(newDataFile);
                } else {
                    MessageDialog.openError((Shell)shell, (String)"Error", (String)"File name cannot be empty. Not adding the new entry!");
                }
            } else if (dialog.isInstrumentFile()) {
                newDataFile.setIsParent(Boolean.valueOf(true));
                this.fileList.add(newDataFile);
            } else {
                List<String> purpose = dialog.getFileCategory().equals((Object)FileCategory.ANNOTATION_CATEGORY) ? Arrays.asList(FileCategory.ANNOTATION_CATEGORY.getLabel()) : Arrays.asList(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY.getLabel());
                MSPropertyDataFile newParent = new MSPropertyDataFile("", "1.3", "raw", dialog.getFileCategory(), "Instrument", "", purpose);
                newParent.setIsParent(Boolean.valueOf(true));
                newParent.addChild(newDataFile);
                this.fileList.add(newParent);
            }
            this.fileTreeViewer.refresh();
            this.fileTreeViewer.expandAll();
            if (!this.fileList.isEmpty()) {
                this.setPageComplete(true);
            }
        }
    }

    public List<MSPropertyDataFile> getFileList() {
        return this.fileList;
    }

    public void setFileList(List<MSPropertyDataFile> fileList) {
        this.fileList = fileList;
    }

    public void refresh() {
        this.fileTreeViewer.refresh();
        this.fileTreeViewer.expandAll();
    }
}

